/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.filter;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.ui.IActionFilter;

public class OamMenuActionFilter
implements IActionFilter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/filter/OamMenuActionFilter.java";
    private DmQueueManager dmQueueManager = null;

    public boolean testAttribute(Object target, String name, String value) {
        Trace t = Trace.getDefault();
        boolean result = false;
        if (name.compareTo("OamTreeNode") == 0) {
            result = this.filterTreeNode(t, target);
        } else if (name.compareTo("OamContentPageObject") == 0) {
            result = this.filterContentPage(t, target);
        }
        return result;
    }

    private boolean filterTreeNode(Trace t, Object target) {
        boolean result = false;
        try {
            String[] list;
            TreeNode selectedTreeNode = (TreeNode)target;
            if (selectedTreeNode.getId().startsWith("com.ibm.mq.explorer.treenode.qm.")) {
                Object treeNodeObj = selectedTreeNode.getObject();
                if (treeNodeObj instanceof MQExtObject) {
                    MQExtObject selectedMQExtObject = (MQExtObject)treeNodeObj;
                    this.dmQueueManager = this.getMQQmgrExtObject(t, selectedMQExtObject);
                    if (Trace.isTracing) {
                        t.data(66, "OamMenuActionFilter.filterTreeNode", 300, "Selected MQ object id " + selectedMQExtObject.getObjectId());
                    }
                }
            } else {
                this.dmQueueManager = this.getMQQmgrExtObject(t, (MQExtObject)selectedTreeNode.getObject());
            }
            if (this.dmQueueManager != null && (list = this.dmQueueManager.getOamListOfServices()) != null && list.length > 0) {
                result = true;
            }
        }
        catch (ClassCastException classCastException) {}
        return result;
    }

    private boolean filterContentPage(Trace t, Object target) {
        String[] list;
        boolean result = false;
        MQExtObject selectedMQExtObject = (MQExtObject)target;
        if (Trace.isTracing) {
            t.data(66, "OamMenuActionFilter.filterContentPage", 300, "Selected MQ object id " + selectedMQExtObject.getObjectId());
        }
        this.dmQueueManager = this.getMQQmgrExtObject(t, selectedMQExtObject);
        if (this.dmQueueManager != null && (list = this.dmQueueManager.getOamListOfServices()) != null && list.length > 0) {
            result = true;
        }
        return result;
    }

    private DmQueueManager getMQQmgrExtObject(Trace t, MQExtObject mqExtObject) {
        MQQmgrExtObject mqQmgrExtObject = null;
        DmQueueManager dmQueueManager = null;
        DmObject cfr_ignored_0 = (DmObject)((UiMQObject)mqExtObject.getInternalObject()).getDmObject();
        MQExtObject testObject = mqExtObject;
        do {
            if (!(testObject instanceof MQQmgrExtObject)) continue;
            mqQmgrExtObject = (MQQmgrExtObject)testObject;
            break;
        } while ((testObject = testObject.getParent()) != null);
        if (mqQmgrExtObject != null) {
            UiQueueManager uiQueueManager = (UiQueueManager)mqQmgrExtObject.getInternalObject();
            dmQueueManager = (DmQueueManager)uiQueueManager.getDmObject();
        }
        return dmQueueManager;
    }
}

