/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.filter;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmObjectLink;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObjectLink;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.filter.OamViewerFilter;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import java.util.ArrayList;

public class OamExplorerTreeViewerFilter
extends OamViewerFilter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/filter/OamExplorerTreeViewerFilter.java";
    private ArrayList<String> objects = new ArrayList(9);

    @Override
    public boolean addObject(Trace t, IDmObject object) {
        boolean add;
        block6: {
            add = false;
            boolean addToCache = false;
            try {
                DmObjectLink objectLink = (DmObjectLink)object;
                if (this.genericProfileTreeNode != null && this.genericProfileTreeNode.getDmObject().equals((Object)object) || this.specificProfileTreeNode != null && this.specificProfileTreeNode.getDmObject().equals((Object)object)) {
                    add = true;
                } else {
                    String profileName = ((DmAuthorityRecord)object).getProfileName(t);
                    if (!this.objects.contains(profileName)) {
                        addToCache = true;
                        this.objects.add(profileName);
                    }
                    if (!profileName.equalsIgnoreCase(OamCommon.getClassProfileName(object.getQueueManager().getPlatform()))) {
                        add = OamCommon.isGenericName(profileName) ? this.addProfile(t, this.genericProfileTreeNode, objectLink, addToCache) : this.addProfile(t, this.specificProfileTreeNode, objectLink, addToCache);
                    }
                }
            }
            catch (ClassCastException cce) {
                if (!Trace.isTracing) break block6;
                t.data(66, "OamExplorerTreeViewerFilter.addObject", 900, "Invalid object " + object + "\n" + cce);
            }
        }
        return add;
    }

    private boolean addProfile(Trace t, UiAuthorityRecord profileTreeNode, DmObjectLink object, boolean addedToCache) {
        boolean add;
        block6: {
            add = false;
            if (profileTreeNode != null) {
                try {
                    if (addedToCache) {
                        DmObjectLink parentObject = (DmObjectLink)profileTreeNode.getDmObject();
                        parentObject.addChild(t, (IDmObjectLink)object);
                    } else if (object.getParent(t) != null) {
                        add = true;
                    }
                }
                catch (ClassCastException cce) {
                    if (!Trace.isTracing) break block6;
                    t.data(66, "OamExplorerTreeViewerFilter.addProfile", 900, "Error adding object " + object + "\n" + cce);
                }
            }
        }
        return add;
    }
}

