/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.dialog;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.oam.internal.attribute.OamAttributeDetails;
import com.ibm.mq.explorer.oam.internal.attribute.OamProfileNameCombo;
import com.ibm.mq.explorer.oam.internal.attribute.OamSelectExplorerTableAttributeDetails;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.dialog.OamDialog;
import com.ibm.mq.explorer.oam.internal.filter.OamSelectGenericViewerFilter;
import com.ibm.mq.explorer.oam.internal.filter.OamSelectSpecificViewerFilter;
import com.ibm.mq.explorer.oam.internal.filter.OamViewerFilter;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecordFactory;
import com.ibm.mq.explorer.oam.internal.table.OamExplorerTable;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OamSelectDialog
extends OamDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/dialog/OamSelectDialog.java";
    private OamAttributeDetails attrDetails = null;
    private String attrOrderId = "com.ibm.mq.explorer.oam.select.table.AttributeOrder";
    private UiAuthorityRecordFactory factory = null;
    private boolean isGenericProfile = false;
    private OamProfileNameCombo profileNameCombo = null;
    private OamViewerFilter explorerViewFilter = null;
    private static final int TABLE_WIDTH_HINT = 300;
    private static final int TABLE_HEIGHT_HINT = 360;

    public OamSelectDialog(Trace t, Shell _parent) {
        super(t, _parent, true);
        this.parentShell = _parent;
        this.helpId = "com.ibm.mq.explorer.oam.infopop.OAM_SelectProfileDialog";
    }

    private void createContent(Trace t, Composite parentComposite) {
        FillLayout fillLayout = null;
        this.init(t);
        Text label = new Text(parentComposite, 64);
        if (this.isGenericProfile) {
            label.setText(OamPlugin.oamMessages.getMessage("OAM.Select.Generic.Profile"));
        } else {
            label.setText(OamPlugin.oamMessages.getMessage("OAM.Select.Specific.Profile"));
        }
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)label, (boolean)false);
        Composite explorerTableComposite = new Composite(parentComposite, 0);
        fillLayout = new FillLayout(768);
        explorerTableComposite.setLayout((Layout)fillLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        this.gridData.widthHint = 300;
        this.gridData.heightHint = 360;
        this.gridData.horizontalSpan = 1;
        explorerTableComposite.setLayoutData((Object)this.gridData);
        this.explorerTable = new OamExplorerTable(t, this, explorerTableComposite);
        this.explorerTable.setSorting(true);
        this.factory = new UiAuthorityRecordFactory(this.getUiQueueManager());
        this.dmObjectFilter = new DmObjectFilter(t, 87, this.oamObject.getOamObjectType(t));
        this.dmObjectFilter.setAuthorityOptions(t, OamCommon.AUTH_OPTIONS_WILDCARD);
        this.attrDetails = new OamSelectExplorerTableAttributeDetails(this.oamObject.getObjectAuthorities(t));
        this.explorerViewFilter = this.isGenericProfile ? new OamSelectGenericViewerFilter() : new OamSelectSpecificViewerFilter();
        this.explorerTable.init(t, "com.ibm.mq.explorer.oam.authorityRecord", (UiMQObjectFactory)this.factory, this.attrOrderId, this.attrDetails, this.explorerViewFilter, true, false);
        this.startListening(t);
    }

    @Override
    public void close(Trace t) {
        this.stopListening(t);
    }

    @Override
    public void addContent(Trace t, Composite composite) {
        this.createContent(t, composite);
    }

    @Override
    public void init(Trace t) {
    }

    private UiAuthorityRecord getSelectedUiObject(Trace t) {
        UiAuthorityRecord o = null;
        o = (UiAuthorityRecord)this.explorerTable.getSelection(t);
        if (Trace.isTracing) {
            t.data(66, "OamSelectDialog.getSelectedUiObject", 300, "Select object : " + (Object)((Object)o));
        }
        return o;
    }

    private void startListening(Trace t) {
        if (this.explorerTable != null && this.dmObjectFilter != null) {
            this.explorerTable.startListening(t, this.dmObjectFilter);
        }
    }

    public void stopListening(Trace t) {
        if (this.explorerTable != null) {
            this.explorerTable.stopListening(t);
        }
    }

    @Override
    public void refreshTables(Trace t) {
        if (this.explorerTable != null) {
            this.explorerTable.refreshTable(t);
        }
    }

    public void setGenericProfile(boolean b) {
        this.isGenericProfile = b;
    }

    public void setProfileNameCombo(OamProfileNameCombo combo) {
        this.profileNameCombo = combo;
    }

    @Override
    public void performOk(Trace t) {
        UiAuthorityRecord auth = this.getSelectedUiObject(t);
        if (auth != null) {
            String name = auth.toFormattedString();
            this.profileNameCombo.setSelectedName(name);
            if (Trace.isTracing) {
                t.data(66, "OamSelectDialog.performOk", 300, "Setting name " + name);
            }
        }
    }

    @Override
    public void enableButtons(Trace t) {
        if (this.explorerTable != null) {
            UiAuthorityRecord auth = (UiAuthorityRecord)this.explorerTable.getSelection(t);
            if (auth != null) {
                if (this.okButton != null) {
                    this.okButton.setEnabled(true);
                }
                if (Trace.isTracing) {
                    t.data(66, "OamSelectDialog.enableButtons", 300, "Enabling OK button");
                }
            } else {
                if (this.okButton != null) {
                    this.okButton.setEnabled(false);
                }
                if (Trace.isTracing) {
                    t.data(66, "OamSelectDialog.enableButtons", 300, "Disabling OK button");
                }
            }
        }
    }
}

