/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.dialog;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmObjectFactory;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.oam.internal.attribute.OamEntityTypeField;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.dialog.IOamPropertyDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamAuthorityRecordPropertyDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamQueueManagerPropertyDialog;
import com.ibm.mq.explorer.oam.internal.object.OamAuthorityButton;
import com.ibm.mq.explorer.oam.internal.object.OamObject;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.pcf.OamCommonPCF;
import com.ibm.mq.explorer.oam.internal.pcf.OamSetAuthority;
import com.ibm.mq.explorer.oam.internal.pcf.OamSetCreateAuthority;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class OamPropertyDialog
extends OamDialog
implements IOamPropertyDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/dialog/OamPropertyDialog.java";
    private static final int DIALOG_MINIMUM_WIDTH = 400;
    private String entityTypeFlag = "";
    protected ArrayList<Integer> addedList = new ArrayList();
    protected Button selectAllButton = null;
    protected Button deselectAllButton = null;
    protected Text commandsTextBox = null;
    protected String queueManager = "[not_defined]";
    protected String objectType = "[not_defined]";
    protected String profileName = "[not_defined]";
    protected String groupBoxTitle = "[not_defined]";
    protected UiAuthorityRecord uiAuthorityRecord = null;
    protected ArrayList<OamAuthorityButton> listOfButtons = new ArrayList();
    private boolean addAuthority = false;
    private boolean addGenericProfile = false;
    private boolean addSpecificProfile = false;
    private boolean addCrtAuthority = false;
    protected Text entityNameText = null;
    private OamEntityTypeField userOrGroupRadioButton = null;
    protected Text profileNameText = null;
    private int entityTypeStyle = 1;
    private SelectionListener buttonListener = null;
    Boolean isIseries = false;
    private String authoritiesAdded = "";
    private String authoritiesRemoved = "";

    protected OamPropertyDialog(Trace t, Shell _parent, UiAuthorityRecord _authRecord) {
        super(t, _parent, false);
        this.parentShell = _parent;
        this.uiAuthorityRecord = _authRecord;
    }

    private void createContent(Trace t) {
        FillLayout fillLayout = null;
        this.init(t);
        this.createButtonListener(t);
        fillLayout = new FillLayout();
        this.myShell.setLayout((Layout)fillLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        this.myShell.setLayoutData((Object)this.gridData);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.myShell, 768);
        Composite mainComposite = new Composite((Composite)scrolledComposite, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 1;
        this.gridLayout.makeColumnsEqualWidth = false;
        mainComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        mainComposite.setLayoutData((Object)this.gridData);
        Composite objectInfoComposite = new Composite(mainComposite, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = false;
        objectInfoComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        objectInfoComposite.setLayoutData((Object)this.gridData);
        Label label = new Label(objectInfoComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Entity.Type"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.userOrGroupRadioButton = new OamEntityTypeField(t, objectInfoComposite, 1, this.selectGroup, this.getDmQueueManager().isOamUseridsSupported(), this.entityTypeStyle);
        if (this.userOrGroupRadioButton.isInRadioButtonMode()) {
            this.userOrGroupRadioButton.addRadioButtonListeners((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t1 = Trace.getDefault();
                    if (OamPropertyDialog.this.okButton.isEnabled()) {
                        OamPropertyDialog.this.commandsTextBox.setText(OamPropertyDialog.this.getCommands(t1));
                    } else {
                        OamPropertyDialog.this.commandsTextBox.setText("");
                    }
                }
            });
        }
        label = new Label(objectInfoComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Entity.Name"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.entityNameText = new Text(objectInfoComposite, 2048);
        if (!this.addAuthority) {
            this.entityNameText.setText(this.entityName);
        }
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = true;
        this.entityNameText.setLayoutData((Object)this.gridData);
        if (this.addAuthority) {
            this.entityNameText.setEditable(true);
        } else {
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.entityNameText, (boolean)true);
        }
        this.entityNameText.setFocus();
        this.entityNameText.setTextLimit(this.getGuiEntityLength(this.selectGroup));
        this.entityNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t1 = Trace.getDefault();
                OamPropertyDialog.this.enableOkButton(t1);
                if (OamPropertyDialog.this.okButton.isEnabled()) {
                    OamPropertyDialog.this.commandsTextBox.setText(OamPropertyDialog.this.getCommands(t1));
                } else {
                    OamPropertyDialog.this.commandsTextBox.setText("");
                }
            }
        });
        this.addInformationContent(t, objectInfoComposite);
        if (this.isAddGenericProfile() || this.isAddSpecificProfile()) {
            this.profileNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Trace t1 = Trace.getDefault();
                    OamPropertyDialog.this.enableOkButton(t1);
                    if (OamPropertyDialog.this.okButton.isEnabled()) {
                        OamPropertyDialog.this.commandsTextBox.setText(OamPropertyDialog.this.getCommands(t1));
                    } else {
                        OamPropertyDialog.this.commandsTextBox.setText("");
                    }
                }
            });
        }
        label = new Label(objectInfoComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Queue.Manager.Name"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        Text text = new Text(objectInfoComposite, 2048);
        text.setText(this.queueManager);
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)this.gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)text, (boolean)true);
        Composite authorityInfoComposite = new Composite(mainComposite, 0);
        this.gridLayout = new GridLayout();
        authorityInfoComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        authorityInfoComposite.setLayoutData((Object)this.gridData);
        Group group = new Group(authorityInfoComposite, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 2;
        group.setLayout((Layout)this.gridLayout);
        group.setText(this.groupBoxTitle);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = false;
        group.setLayoutData((Object)this.gridData);
        Composite authorityContentComposite = new Composite((Composite)group, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 1;
        authorityContentComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        authorityContentComposite.setLayoutData((Object)this.gridData);
        this.addAuthoritiesContent(t, authorityContentComposite);
        Composite buttonComposite = new Composite(authorityContentComposite, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 3;
        buttonComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        buttonComposite.setLayoutData((Object)this.gridData);
        label = new Label(buttonComposite, 0);
        this.gridData = new GridData();
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)this.gridData);
        this.selectAllButton = new Button(buttonComposite, 8);
        this.selectAllButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.SelectAll.Text"));
        this.gridData = new GridData();
        this.selectAllButton.setLayoutData((Object)this.gridData);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                OamPropertyDialog.this.selectAll(t1);
                OamPropertyDialog.this.enableOkButton(t1);
                if (!OamPropertyDialog.this.entityNameText.getText().equals("")) {
                    OamPropertyDialog.this.commandsTextBox.setText(OamPropertyDialog.this.getCommands(t1));
                } else {
                    OamPropertyDialog.this.commandsTextBox.setText("");
                }
            }
        });
        this.deselectAllButton = new Button(buttonComposite, 8);
        this.deselectAllButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.DeselectAll.Text"));
        this.gridData = new GridData();
        this.gridData.horizontalAlignment = 3;
        this.deselectAllButton.setLayoutData((Object)this.gridData);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                OamPropertyDialog.this.deselectAll(t1);
                OamPropertyDialog.this.enableOkButton(t1);
                if (!OamPropertyDialog.this.entityNameText.getText().equals("")) {
                    OamPropertyDialog.this.commandsTextBox.setText(OamPropertyDialog.this.getCommands(t1));
                } else {
                    OamPropertyDialog.this.commandsTextBox.setText("");
                }
            }
        });
        Group group2 = new Group(authorityInfoComposite, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 2;
        group2.setLayout((Layout)this.gridLayout);
        group2.setText(OamPlugin.oamMessages.getMessage("OAM.Cmd.Preview"));
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        group2.setLayoutData((Object)this.gridData);
        this.commandsTextBox = new Text((Composite)group2, 2882);
        this.gridData = new GridData(1808);
        this.gridData.minimumHeight = 50;
        this.commandsTextBox.setLayoutData((Object)this.gridData);
        this.commandsTextBox.setEditable(false);
        buttonComposite = new Composite(mainComposite, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 3;
        buttonComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = false;
        buttonComposite.setLayoutData((Object)this.gridData);
        label = new Label(buttonComposite, 0);
        this.gridData = new GridData();
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)this.gridData);
        this.okButton = new Button(buttonComposite, 8);
        this.okButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Ok.Text"));
        this.gridData = new GridData();
        this.okButton.setLayoutData((Object)this.gridData);
        if (this.isAddAuthorities()) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                OamPropertyDialog.this.performOk(t1);
            }
        });
        this.cancelButton = new Button(buttonComposite, 8);
        this.cancelButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Cancel.Text"));
        this.gridData = new GridData();
        this.gridData.horizontalAlignment = 3;
        this.cancelButton.setLayoutData((Object)this.gridData);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OamPropertyDialog.this.myShell.close();
            }
        });
        this.myShell.setDefaultButton(this.cancelButton);
        ButtonTools.makeEqualWidthGridData((Trace)t, (Button[])new Button[]{this.cancelButton, this.okButton});
        ButtonTools.makeEqualWidthGridData((Trace)t, (Button[])new Button[]{this.selectAllButton, this.deselectAllButton});
        this.initialiseScrollable(t, scrolledComposite, mainComposite);
        this.enableSelectButtons(t);
    }

    @Override
    public int open(Trace t) {
        int shellOptions = 67680;
        this.myShell = new Shell(this.parentShell, shellOptions);
        this.myShell.setText(this.title);
        this.myShell.setImage(Icons.get((String)Icons.iconkeyEntityName));
        this.display = this.parentShell.getDisplay();
        this.createContent(t);
        this.helpId = this.isAddAuthorities() ? "com.ibm.mq.explorer.oam.infopop.OAM_AddAuthoritiesDialog" : "com.ibm.mq.explorer.oam.infopop.OAM_EditAuthoritiesDialog";
        UiPlugin.getHelpSystem().setHelp((Control)this.myShell, this.helpId);
        this.myShell.pack();
        Rectangle bounds = this.parentShell.getBounds();
        this.myShell.setLocation(bounds.x + (bounds.width - this.myShell.getSize().x) / 2, bounds.y + (bounds.height - this.myShell.getSize().y) / 2);
        Point size = this.myShell.getSize();
        if (size.x < 400) {
            this.myShell.setSize(400, size.y);
        }
        this.myShell.open();
        while (!this.myShell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.openRc;
    }

    @Override
    public void addAuthoritiesContent(Trace t, Composite composite) {
        Hashtable<DisplayGroup, ArrayList<OamAuthorityButton>> listOfGroups = this.getListOfGroups(t);
        ArrayList<DisplayGroup> sortedListOfGroups = new ArrayList<DisplayGroup>();
        Enumeration<DisplayGroup> e = listOfGroups.keys();
        while (e.hasMoreElements()) {
            DisplayGroup displayGroup = e.nextElement();
            sortedListOfGroups.add(displayGroup);
        }
        Collections.sort(sortedListOfGroups);
        Composite contentComposite = new Composite(composite, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = listOfGroups.size();
        this.gridLayout.makeColumnsEqualWidth = true;
        contentComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        contentComposite.setLayoutData((Object)this.gridData);
        int i = 0;
        while (i < sortedListOfGroups.size()) {
            DisplayGroup dg = (DisplayGroup)sortedListOfGroups.get(i);
            Group group = new Group(contentComposite, 0);
            this.gridLayout = new GridLayout();
            this.gridLayout.numColumns = 1;
            group.setLayout((Layout)this.gridLayout);
            if (this.addCrtAuthority) {
                group.setText(DmQueueManager.getAttributeTitle((Trace)t, (int)12004));
            } else {
                group.setText(dg.getTitle());
            }
            this.gridData = new GridData(1808);
            this.gridData.grabExcessHorizontalSpace = true;
            this.gridData.grabExcessVerticalSpace = true;
            group.setLayoutData((Object)this.gridData);
            Composite buttonComposite = new Composite((Composite)group, 0);
            this.gridLayout = new GridLayout();
            this.gridLayout.numColumns = 1;
            buttonComposite.setLayout((Layout)this.gridLayout);
            this.gridData = new GridData(1808);
            this.gridData.grabExcessHorizontalSpace = true;
            this.gridData.grabExcessVerticalSpace = true;
            buttonComposite.setLayoutData((Object)this.gridData);
            ArrayList<OamAuthorityButton> listOfAttributes = listOfGroups.get(dg);
            if (listOfAttributes != null) {
                this.addGroupOfAuthorities(t, buttonComposite, listOfAttributes);
            }
            ++i;
        }
    }

    private Hashtable<DisplayGroup, ArrayList<OamAuthorityButton>> getListOfGroups(Trace t) {
        int[] authority = null;
        ArrayList<OamAuthorityButton> listOfAttributes = null;
        Hashtable<DisplayGroup, ArrayList<OamAuthorityButton>> listOfGroups = new Hashtable<DisplayGroup, ArrayList<OamAuthorityButton>>();
        authority = this.addCrtAuthority ? this.oamObject.getDmQueueManager().getValidCrtAuthorities(t) : this.oamObject.getDmQueueManager().getValidAuthorities(t, this.oamObject.getOamObjectType(t));
        if (Trace.isTracing) {
            t.data(66, "OamPropertyDialog.getListOfGroups", 300, "Authorities : " + authority);
        }
        int i = 0;
        while (i < authority.length) {
            Attr attr;
            String displayTitle = DmAuthorityRecord.getAttributeTitle((Trace)t, (int)authority[i]);
            DisplayGroup displayG = DmAuthorityRecord.getAttributeType((Trace)t, (int)authority[i]).getDisplayGroup();
            int displaySequence = DmAuthorityRecord.getAttributeType((Trace)t, (int)authority[i]).getDisplayGroupSequence();
            boolean b = false;
            if (this.uiAuthorityRecord != null && !this.addAuthority && (attr = this.uiAuthorityRecord.getDmObject().getAttribute(t, authority[i], 0)) != null) {
                Boolean bb = (Boolean)attr.getValue(t);
                b = bb;
            }
            OamAuthorityButton oamButton = new OamAuthorityButton(t, authority[i], displayTitle, displaySequence, b);
            if (listOfGroups.containsKey(displayG)) {
                listOfAttributes = listOfGroups.get(displayG);
                listOfAttributes.add(oamButton);
            } else {
                listOfAttributes = new ArrayList();
                listOfAttributes.add(oamButton);
                listOfGroups.put(displayG, listOfAttributes);
            }
            ++i;
        }
        Enumeration e = listOfGroups.keys();
        while (e.hasMoreElements()) {
            DisplayGroup dg = (DisplayGroup)e.nextElement();
            listOfAttributes = listOfGroups.get(dg);
            if (listOfAttributes == null) continue;
            Collections.sort(listOfAttributes);
        }
        return listOfGroups;
    }

    private void addGroupOfAuthorities(Trace t, Composite composite, ArrayList<OamAuthorityButton> list) {
        if (Trace.isTracing) {
            t.data(66, "OamPropertyDialog.addGroupOfAuthorities", 300, "Number of attributes: " + list.size());
        }
        int i = 0;
        while (i < list.size()) {
            OamAuthorityButton oamButton = list.get(i);
            if (oamButton != null) {
                String displayTitle = oamButton.getDisplayTitle();
                Button b = new Button(composite, 32);
                b.setText(displayTitle);
                this.gridData = new GridData();
                b.setLayoutData((Object)this.gridData);
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Trace tr = Trace.getDefault();
                        if (OamPropertyDialog.this.isCrtAuthorities()) {
                            if (OamPropertyDialog.this.getTextString(OamPropertyDialog.this.entityNameText).length() > 0) {
                                OamPropertyDialog.this.commandsTextBox.setText(OamPropertyDialog.this.getCommands(tr));
                            } else {
                                OamPropertyDialog.this.commandsTextBox.setText("");
                            }
                        } else if (OamPropertyDialog.this.okButton.isEnabled()) {
                            OamPropertyDialog.this.commandsTextBox.setText(OamPropertyDialog.this.getCommands(tr));
                        }
                    }
                });
                b.setSelection(oamButton.isSelected(t));
                b.addSelectionListener(this.buttonListener);
                oamButton.setButton(b);
                this.listOfButtons.add(oamButton);
            }
            ++i;
        }
    }

    public String getCommands(Trace t) {
        String commandStandard = "";
        String speechMark = "\"";
        String additionalCommandOneQmgr = "";
        String additionalCommandOneObjects = "";
        String additionalCommandTwo = "";
        String objectTypeIseries = "";
        String profileFlag = " -n ";
        switch (this.oamObject.getOamObjectType(t)) {
            case 3: {
                if (this.isIseries.booleanValue()) {
                    objectTypeIseries = "PRC";
                    break;
                }
                this.objectType = "process";
                break;
            }
            case 7: {
                if (this.isIseries.booleanValue()) {
                    objectTypeIseries = "authinfo".toUpperCase();
                    break;
                }
                this.objectType = "authinfo";
                break;
            }
            case 1014: {
                if (this.isIseries.booleanValue()) {
                    objectTypeIseries = "CLTCN";
                    break;
                }
                this.objectType = "clntconn";
                break;
            }
            case 1: {
                if (this.isIseries.booleanValue()) {
                    objectTypeIseries = "q".toUpperCase();
                    break;
                }
                this.objectType = "q";
                break;
            }
            case 8: {
                if (this.isIseries.booleanValue()) {
                    objectTypeIseries = "topic".toUpperCase();
                    break;
                }
                this.objectType = "topic";
                break;
            }
            case 6: {
                if (this.isIseries.booleanValue()) {
                    objectTypeIseries = "chl".toUpperCase();
                    break;
                }
                this.objectType = "chl";
                break;
            }
            case 11: {
                if (this.isIseries.booleanValue()) {
                    objectTypeIseries = "LSR";
                    break;
                }
                this.objectType = "listener";
                break;
            }
            case 12: {
                if (this.isIseries.booleanValue()) {
                    objectTypeIseries = "SVC";
                    break;
                }
                this.objectType = "service";
                break;
            }
            case 2: {
                if (this.isIseries.booleanValue()) {
                    objectTypeIseries = "NMLIST";
                    break;
                }
                this.objectType = "namelist";
                break;
            }
            case 9: {
                if (this.isIseries.booleanValue()) {
                    objectTypeIseries = "comminfo".toUpperCase();
                    break;
                }
                this.objectType = "comminfo";
                break;
            }
            case 1017: {
                if (this.isIseries.booleanValue()) {
                    objectTypeIseries = "rqmname".toUpperCase();
                    break;
                }
                this.objectType = "rqmname";
                break;
            }
            case 5: {
                if (this.isCrtAuthorities()) break;
                if (this.isIseries.booleanValue()) {
                    objectTypeIseries = "MQM";
                    this.profileName = this.queueManager;
                    break;
                }
                this.objectType = "qmgr";
                this.profileName = "";
                profileFlag = "";
                speechMark = "";
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(66, "OamPropertyDialog.getCommands", 1000, "Error getting object type");
            }
        }
        this.entityTypeFlag = this.userOrGroupRadioButton.isUserSelected(t) ? " -p " : " -g ";
        if (this.isAddGenericProfile() || this.isAddSpecificProfile()) {
            this.profileName = this.profileNameText.getText();
        }
        StringBuffer sb = new StringBuffer();
        String listOfAuthorities = this.whichIsSelected(t);
        sb.append(listOfAuthorities);
        if (!this.isCrtAuthorities()) {
            boolean buttonSelected = false;
            for (OamAuthorityButton b : this.listOfButtons) {
                if (!b.isAddAuthority(t) && !b.isRemoveAuthority(t)) continue;
                buttonSelected = true;
            }
            boolean qmgrNewAuthorities = false;
            if (this.uiAuthorityRecord == null && !this.isAddGenericProfile() && !this.isAddSpecificProfile()) {
                qmgrNewAuthorities = true;
            }
            if (qmgrNewAuthorities) {
                if (this.isIseries.booleanValue()) {
                    additionalCommandOneQmgr = "RVKMQMAUT OBJ(" + this.queueManager + ") OBJTYPE(*MQM) USER(" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + ") AUT(" + "*ALL" + ")" + " MQMNAME(" + this.queueManager + ")" + OamCommon.NEWLINE_CHAR;
                    additionalCommandTwo = "GRTMQMAUT OBJ(" + this.queueManager + ") OBJTYPE(*MQM) USER(" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + ") AUT(" + "*NONE)" + " MQMNAME(" + this.queueManager + ")" + OamCommon.NEWLINE_CHAR;
                } else {
                    additionalCommandOneQmgr = "setmqaut -m " + this.queueManager + profileFlag + this.profileName + " -t " + this.objectType + this.entityTypeFlag + "\"" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + "\"" + " -" + "all" + OamCommon.NEWLINE_CHAR;
                    additionalCommandTwo = "setmqaut -m " + this.queueManager + profileFlag + this.profileName + " -t " + this.objectType + this.entityTypeFlag + "\"" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + "\"" + " +" + "none" + OamCommon.NEWLINE_CHAR;
                }
            }
            if (this.addAuthority && !qmgrNewAuthorities || this.isAddGenericProfile() || this.isAddSpecificProfile()) {
                if (this.isIseries.booleanValue()) {
                    additionalCommandOneObjects = "RVKMQMAUT OBJ(" + this.profileName + ") OBJTYPE(*" + objectTypeIseries + ") USER(" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + ") AUT(" + "*REMOVE" + ")" + " MQMNAME(" + this.queueManager + ")" + OamCommon.NEWLINE_CHAR;
                    additionalCommandTwo = "GRTMQMAUT OBJ(" + this.profileName + ") OBJTYPE(*" + objectTypeIseries + ") USER(" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + ") AUT(" + "*NONE)" + " MQMNAME(" + this.queueManager + ")" + OamCommon.NEWLINE_CHAR;
                } else {
                    additionalCommandOneObjects = "setmqaut -m " + this.queueManager + profileFlag + "\"" + this.profileName + "\"" + " -t " + this.objectType + this.entityTypeFlag + "\"" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + "\"" + " -" + "remove" + OamCommon.NEWLINE_CHAR;
                    additionalCommandTwo = "setmqaut -m " + this.queueManager + profileFlag + "\"" + this.profileName + "\"" + " -t " + this.objectType + this.entityTypeFlag + "\"" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + "\"" + " +" + "none" + OamCommon.NEWLINE_CHAR;
                }
            }
            if (buttonSelected) {
                additionalCommandTwo = "";
                String grantIseriesCommand = "";
                String revokeIseriesCommand = "";
                if (this.isIseries.booleanValue()) {
                    if (!this.authoritiesAdded.equals("")) {
                        grantIseriesCommand = "GRTMQMAUT OBJ(" + this.profileName + ") OBJTYPE(*" + objectTypeIseries + ") USER(" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + ") AUT(" + this.authoritiesAdded.toUpperCase() + ")" + " MQMNAME(" + this.queueManager + ")" + OamCommon.NEWLINE_CHAR;
                    }
                    if (!this.authoritiesRemoved.equals("")) {
                        revokeIseriesCommand = "RVKMQMAUT OBJ(" + this.profileName + ") OBJTYPE(*" + objectTypeIseries + ") USER(" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + ") AUT(" + this.authoritiesRemoved.toUpperCase() + ")" + " MQMNAME(" + this.queueManager + ")";
                    }
                    commandStandard = String.valueOf(grantIseriesCommand) + revokeIseriesCommand;
                } else {
                    commandStandard = "setmqaut -m " + this.queueManager + profileFlag + speechMark + this.profileName + speechMark + " -t " + this.objectType + this.entityTypeFlag + "\"" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + "\"" + sb;
                }
            }
        } else {
            for (OamAuthorityButton button : this.listOfButtons) {
                String commandStandards;
                this.objectType = this.getObjTypeForCrtAuthority(button);
                if (button.isSelected(t) && button.isAddAuthority(t)) {
                    commandStandards = "";
                    commandStandards = this.isIseries != false ? "GRTMQMAUT OBJ(*ALL) OBJTYPE(*" + this.objectType + ") USER(" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + ") AUT(" + "*ADMCRT" + ")" + " MQMNAME(" + this.queueManager + ")" + OamCommon.NEWLINE_CHAR : "setmqaut -m " + this.queueManager + " -n " + "\"**\"" + " -t " + this.objectType + this.entityTypeFlag + "\"" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + "\"" + " +" + "crt" + OamCommon.NEWLINE_CHAR;
                    commandStandard = String.valueOf(commandStandard) + commandStandards;
                    continue;
                }
                if (button.isSelected(t) || !button.isRemoveAuthority(t)) continue;
                commandStandards = "";
                commandStandards = this.isIseries != false ? "RVKMQMAUT OBJ(*ALL) OBJTYPE(*" + this.objectType + ") USER(" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + ") AUT(" + "*ADMCRT" + ")" + " MQMNAME(" + this.queueManager + ")" + OamCommon.NEWLINE_CHAR : "setmqaut -m " + this.queueManager + " -n " + "\"**\"" + " -t " + this.objectType + this.entityTypeFlag + "\"" + this.extractGroupOrUserName(t, this.entityNameText.getText()) + "\"" + " -" + "crt" + OamCommon.NEWLINE_CHAR;
                commandStandard = String.valueOf(commandStandard) + commandStandards;
            }
        }
        return String.valueOf(additionalCommandOneObjects) + additionalCommandOneQmgr + additionalCommandTwo + commandStandard;
    }

    @Override
    public void selectAll(Trace t) {
        int i = 0;
        while (i < this.listOfButtons.size()) {
            OamAuthorityButton b = this.listOfButtons.get(i);
            b.getButton().setSelection(true);
            ++i;
        }
        if (this.selectAllButton != null) {
            this.selectAllButton.setEnabled(false);
        }
        if (this.deselectAllButton != null) {
            this.deselectAllButton.setEnabled(true);
        }
    }

    private String whichIsSelected(Trace t) {
        this.authoritiesAdded = "";
        this.authoritiesRemoved = "";
        for (OamAuthorityButton b : this.listOfButtons) {
            String authority = "";
            String authorityAddedOrRemoved = "";
            String addOrRemove = this.addOrRemoveAuthority(b);
            if (b.isAddAuthority(t) || b.isRemoveAuthority(t)) {
                switch (b.getAttributeId()) {
                    case 14004: {
                        if (this.isIseries.booleanValue()) {
                            authority = "ADMCHG";
                            break;
                        }
                        authority = "chg";
                        break;
                    }
                    case 14008: {
                        if (this.isIseries.booleanValue()) {
                            authority = "ADMDLT";
                            break;
                        }
                        authority = "dlt";
                        break;
                    }
                    case 14003: {
                        authority = "browse";
                        break;
                    }
                    case 14009: {
                        if (this.isIseries.booleanValue()) {
                            authority = "ADMDSP";
                            break;
                        }
                        authority = "dsp";
                        break;
                    }
                    case 14005: {
                        if (this.isIseries.booleanValue()) {
                            authority = "ADMCLR";
                            break;
                        }
                        authority = "clr";
                        break;
                    }
                    case 14018: {
                        authority = "ctrl";
                        break;
                    }
                    case 14019: {
                        authority = "ctrlx";
                        break;
                    }
                    case 14016: {
                        authority = "setall";
                        break;
                    }
                    case 14017: {
                        authority = "setid";
                        break;
                    }
                    case 14013: {
                        authority = "passall";
                        break;
                    }
                    case 14014: {
                        authority = "passid";
                        break;
                    }
                    case 14002: {
                        authority = "altusr";
                        break;
                    }
                    case 14006: {
                        authority = "connect";
                        break;
                    }
                    case 14011: {
                        authority = "inq";
                        break;
                    }
                    case 14015: {
                        authority = "set";
                        break;
                    }
                    case 14034: {
                        authority = "system";
                        break;
                    }
                    case 14010: {
                        authority = "get";
                        break;
                    }
                    case 14031: {
                        authority = "pub";
                        break;
                    }
                    case 14032: {
                        authority = "sub";
                        break;
                    }
                    case 14012: {
                        authority = "put";
                        break;
                    }
                    case 14033: {
                        authority = "resume";
                        break;
                    }
                }
                authorityAddedOrRemoved = String.valueOf(addOrRemove) + authority;
            }
            if (this.isIseries.booleanValue()) {
                if (authority.equals("")) continue;
                if (b.isAddAuthority(t)) {
                    this.authoritiesAdded = String.valueOf(this.authoritiesAdded) + " *" + authority;
                    continue;
                }
                this.authoritiesRemoved = String.valueOf(this.authoritiesRemoved) + " *" + authority;
                continue;
            }
            this.authoritiesAdded = String.valueOf(this.authoritiesAdded) + authorityAddedOrRemoved;
        }
        return String.valueOf(this.authoritiesAdded) + this.authoritiesRemoved;
    }

    private String getObjTypeForCrtAuthority(OamAuthorityButton button) {
        String objType = "";
        int id = button.getAttributeId();
        switch (id) {
            case 14021: {
                if (this.isIseries.booleanValue()) {
                    objType = "q".toUpperCase();
                    break;
                }
                objType = "q";
                break;
            }
            case 14027: {
                if (this.isIseries.booleanValue()) {
                    objType = "authinfo".toUpperCase();
                    break;
                }
                objType = "authinfo";
                break;
            }
            case 14025: {
                if (this.isIseries.booleanValue()) {
                    objType = "chl".toUpperCase();
                    break;
                }
                objType = "chl";
                break;
            }
            case 14026: {
                if (this.isIseries.booleanValue()) {
                    objType = "CLTCN";
                    break;
                }
                objType = "clntconn";
                break;
            }
            case 14028: {
                if (this.isIseries.booleanValue()) {
                    objType = "LSR";
                    break;
                }
                objType = "listener";
                break;
            }
            case 14022: {
                if (this.isIseries.booleanValue()) {
                    objType = "NMLIST";
                    break;
                }
                objType = "namelist";
                break;
            }
            case 14023: {
                if (this.isIseries.booleanValue()) {
                    objType = "PRC";
                    break;
                }
                objType = "process";
                break;
            }
            case 14029: {
                if (this.isIseries.booleanValue()) {
                    objType = "SVC";
                    break;
                }
                objType = "service";
                break;
            }
            case 14030: {
                if (this.isIseries.booleanValue()) {
                    objType = "topic".toUpperCase();
                    break;
                }
                objType = "topic";
                break;
            }
            case 14035: {
                objType = this.isIseries != false ? "comminfo".toUpperCase() : "comminfo";
            }
        }
        return objType;
    }

    @Override
    public void deselectAll(Trace t) {
        int i = 0;
        while (i < this.listOfButtons.size()) {
            OamAuthorityButton b = this.listOfButtons.get(i);
            b.getButton().setSelection(false);
            ++i;
        }
        if (this.selectAllButton != null) {
            this.selectAllButton.setEnabled(true);
        }
        if (this.deselectAllButton != null) {
            this.deselectAllButton.setEnabled(false);
        }
    }

    @Override
    public void close(Trace t) {
        if (this.listOfButtons != null) {
            this.listOfButtons.clear();
        }
    }

    public boolean isAddAuthorities() {
        return this.addAuthority;
    }

    public boolean isCrtAuthorities() {
        return this.addCrtAuthority;
    }

    public boolean isAddGenericProfile() {
        return this.addGenericProfile;
    }

    public boolean isAddSpecificProfile() {
        return this.addSpecificProfile;
    }

    public void setCreate(boolean b) {
        this.addAuthority = b;
    }

    public void setAddGenericProfile(boolean b) {
        this.addGenericProfile = b;
    }

    public void setAddSpecificProfile(boolean b) {
        this.addSpecificProfile = b;
    }

    public void setEntityTypeStyle(int i) {
        this.entityTypeStyle = i;
    }

    public ArrayList<OamAuthorityButton> getListOfButtons() {
        return this.listOfButtons;
    }

    public void setEntityType(boolean b) {
        this.selectGroup = b;
    }

    public void setCrtAuthorities(boolean b) {
        this.addCrtAuthority = b;
    }

    public String getEntityName() {
        return this.getTextString(this.entityNameText);
    }

    public boolean isUserSelected(Trace t) {
        return this.userOrGroupRadioButton.isUserSelected(t);
    }

    public boolean isGroupSelected(Trace t) {
        return this.userOrGroupRadioButton.isGroupSelected(t);
    }

    @Override
    public void init(Trace t) {
        if (this.uiAuthorityRecord == null && this.oamObject != null && this.oamObject.getUiAuthorityRecord() != null && !this.oamObject.getUiAuthorityRecord().isGenericProfilesTreeNode() && !this.oamObject.getUiAuthorityRecord().isSpecificProfilesTreeNode()) {
            this.uiAuthorityRecord = this.oamObject.getUiAuthorityRecord();
        }
        if (this.uiAuthorityRecord != null) {
            this.entityName = this.uiAuthorityRecord.getDmObject().getAttributeValue(t, 3068, 0);
            this.objectType = this.oamObject != null ? this.oamObject.getMQObjectType(t) : this.uiAuthorityRecord.getDmObject().getAttributeValue(t, 1016, 0);
            this.profileName = this.uiAuthorityRecord.getDmObject().getAttributeValue(t, 3067, 0);
            if (this.entityType.equals("[not_defined]")) {
                this.entityType = this.uiAuthorityRecord.getDmObject().getAttributeValue(t, 1118, 0);
            }
            if (this.uiAuthorityRecord.getDmObject().getQueueManager() != null) {
                this.queueManager = this.uiAuthorityRecord.getDmObject().getQueueManager().getTitle();
            }
        }
        if (this.uiAuthorityRecord == null && this.oamObject != null) {
            this.entityName = this.oamObject.getMqObjectName();
            this.objectType = this.oamObject.getMQObjectType(t);
            this.profileName = "";
            if (this.entityType.equals("[not_defined]")) {
                this.entityType = this.oamObject.getMQObjectType(t);
            }
            this.queueManager = this.oamObject.getDmQueueManager().getTitle();
        }
        this.groupBoxTitle = OamPlugin.oamMessages.getMessage("OAM.Authorities");
        if (Trace.isTracing) {
            t.data(66, "OamPropertyDialog.init", 300, "Group box title : " + this.groupBoxTitle);
            t.data(66, "OamPropertyDialog.init", 300, "Entity name : " + this.entityName);
            t.data(66, "OamPropertyDialog.init", 300, "Entity type : " + this.entityType);
            t.data(66, "OamPropertyDialog.init", 300, "Object type : " + this.objectType);
            t.data(66, "OamPropertyDialog.init", 300, "QM name     : " + this.queueManager);
        }
        this.isIseries = this.isIseries();
    }

    @Override
    public void performOk(Trace t) {
        OamCommonPCF setCommand = null;
        String message = null;
        if (!this.isAddGenericProfile() && !this.isAddSpecificProfile() || this.isAddSpecificProfile() && this.validateSpecificName(t) || this.isAddGenericProfile() && this.validateGenericName(t)) {
            setCommand = this.addCrtAuthority ? new OamSetCreateAuthority(t, this.myShell, this.getNewDmAuthorityRecord(t), this.isAddAuthorities()) : new OamSetAuthority(t, this.myShell, this.getNewDmAuthorityRecord(t), this.isAddAuthorities());
            message = this.isAddAuthorities() ? OamPlugin.oamMessages.getMessage("OAM.Adding.Authority") : OamPlugin.oamMessages.getMessage("OAM.Changing.Authority");
            if (Trace.isTracing) {
                t.data(66, "OamPropertyDialog.performOk", 300, "Message : " + message);
            }
            setCommand.setListOfButtons(this.listOfButtons);
            if (this.getNewDmAuthorityRecord(t).getProfileType(t) != 5) {
                if (this.profileNameText != null) {
                    setCommand.setProfileName(t, this.getTextString(this.profileNameText));
                } else {
                    setCommand.setProfileName(t, this.getDmQueueManager().getTitle());
                }
            }
            int reasonCode = setCommand.apply(t, message);
            if (Trace.isTracing) {
                t.data(66, "OamPropertyDialog.performOk", 300, "Set command reason code : " + reasonCode);
            }
            if (reasonCode == 0) {
                if (this.isAddAuthorities()) {
                    MessageBox.showSystemMessageById((Trace)t, (Shell)this.myShell, (String)"AMQ4811", null, (Image)Icons.get((String)Icons.iconkeyEntityName));
                }
                this.close(t);
                this.openRc = -2;
                this.myShell.close();
            } else {
                this.openRc = -1;
            }
        }
    }

    private DmAuthorityRecord getNewDmAuthorityRecord(Trace t) {
        DmAuthorityRecord newDmAuthorityRecord = null;
        DmAuthorityRecord currentDmAuthorityRecord = null;
        String name = null;
        name = this.addCrtAuthority ? OamCommon.getClassProfileName(this.oamObject.getDmQueueManager().getPlatform()) : this.queueManager;
        if (this.profileNameText != null) {
            name = this.getTextString(this.profileNameText);
        }
        if (Trace.isTracing) {
            t.data(66, "OamPropertyDialog.getNewDmAuthorityRecord", 300, "Name of new object : " + name);
        }
        if (this.uiAuthorityRecord != null && !this.isAddAuthorities()) {
            currentDmAuthorityRecord = (DmAuthorityRecord)this.uiAuthorityRecord.getDmObject();
            newDmAuthorityRecord = (DmAuthorityRecord)DmObjectFactory.create((Trace)t, (DmObject)currentDmAuthorityRecord, (String)name);
            newDmAuthorityRecord.addAttr(t, 3068, 0, (Object)this.getEntityName());
        } else {
            newDmAuthorityRecord = (DmAuthorityRecord)DmObjectFactory.create((Trace)t, (DmQueueManager)this.oamObject.getDmQueueManager(), (int)87, (String)name);
            newDmAuthorityRecord.addAttr(t, 3068, 0, (Object)this.getEntityName());
            newDmAuthorityRecord.addAttr(t, 1016, 0, (Object)this.oamObject.getOamObjectType(t));
            if (this.isGroupSelected(t)) {
                newDmAuthorityRecord.addAttr(t, 1118, 0, (Object)2);
            } else {
                newDmAuthorityRecord.addAttr(t, 1118, 0, (Object)1);
            }
        }
        return newDmAuthorityRecord;
    }

    public static IOamPropertyDialog create(Trace t, Shell parent, UiAuthorityRecord authRecord, OamObject oamObject) {
        OamPropertyDialog dialog = null;
        int objectType = oamObject.getOamObjectType(t);
        dialog = objectType == 5 ? new OamQueueManagerPropertyDialog(t, parent, authRecord) : new OamAuthorityRecordPropertyDialog(t, parent, authRecord);
        return dialog;
    }

    private boolean validateGenericName(Trace t) {
        boolean valid = false;
        String name = this.getTextString(this.profileNameText);
        if (!name.equals("") && OamCommon.isGenericName(name)) {
            valid = true;
        } else {
            String title1 = OamPlugin.oamMessages.getMessage("OAM.Add.Authorities.Title");
            String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4815", (String)name);
            int reply = MessageBox.showYesNoMessage((Trace)t, (Shell)this.myShell, (String)title1, (Image)Icons.get((String)Icons.iconkeyEntityName), (String)msg, (int)1, null);
            if (Trace.isTracing) {
                t.data(66, "OamPropertyDialog.validateGenericName", 300, "Prompt reply : " + reply);
            }
            if (reply == 0) {
                valid = true;
            }
        }
        return valid;
    }

    private boolean validateSpecificName(Trace t) {
        boolean valid = false;
        String name = this.getTextString(this.profileNameText);
        if (!name.equals("") && !OamCommon.isGenericName(name)) {
            valid = true;
        } else {
            String title1 = OamPlugin.oamMessages.getMessage("OAM.Add.Authorities.Title");
            String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4830", (String)name);
            int reply = MessageBox.showYesNoMessage((Trace)t, (Shell)this.myShell, (String)title1, (Image)Icons.get((String)Icons.iconkeyEntityName), (String)msg, (int)1, null);
            if (Trace.isTracing) {
                t.data(66, "OamPropertyDialog.validateSpecificName", 300, "Prompt reply : " + reply);
            }
            if (reply == 0) {
                valid = true;
            }
        }
        return valid;
    }

    @Override
    public void enableOkButton(Trace t) {
        if (this.entityNameText != null) {
            if (this.isCrtAuthorities() && this.addAuthority) {
                if (this.getTextString(this.entityNameText).length() > 0) {
                    boolean authoritySelected = false;
                    for (OamAuthorityButton b : this.listOfButtons) {
                        if (!b.isAddAuthority(t)) continue;
                        authoritySelected = true;
                    }
                    if (authoritySelected) {
                        if (this.okButton != null) {
                            this.okButton.setEnabled(true);
                        }
                        this.myShell.setDefaultButton(this.okButton);
                    } else {
                        if (this.okButton != null) {
                            this.okButton.setEnabled(false);
                        }
                        this.myShell.setDefaultButton(this.cancelButton);
                    }
                } else {
                    if (this.okButton != null) {
                        this.okButton.setEnabled(false);
                    }
                    this.myShell.setDefaultButton(this.cancelButton);
                }
            } else if (this.getTextString(this.entityNameText).length() > 0) {
                if (this.okButton != null) {
                    this.okButton.setEnabled(true);
                }
                this.myShell.setDefaultButton(this.okButton);
            } else {
                if (this.okButton != null) {
                    this.okButton.setEnabled(false);
                }
                this.myShell.setDefaultButton(this.cancelButton);
            }
        }
    }

    private void createButtonListener(Trace t) {
        this.buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                OamPropertyDialog.this.enableSelectButtons(t1);
                OamPropertyDialog.this.enableOkButton(t1);
            }
        };
    }

    public void enableSelectButtons(Trace t) {
        boolean allSelected = true;
        boolean noneSelected = true;
        if (this.selectAllButton != null && this.deselectAllButton != null) {
            OamAuthorityButton b;
            int i = 0;
            while (i < this.listOfButtons.size()) {
                b = this.listOfButtons.get(i);
                if (!b.getButton().getSelection()) {
                    allSelected = false;
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < this.listOfButtons.size()) {
                b = this.listOfButtons.get(i);
                if (b.getButton().getSelection()) {
                    noneSelected = false;
                    break;
                }
                ++i;
            }
            if (allSelected) {
                this.selectAllButton.setEnabled(false);
                this.deselectAllButton.setEnabled(true);
            } else if (noneSelected) {
                this.selectAllButton.setEnabled(true);
                this.deselectAllButton.setEnabled(false);
            } else {
                this.selectAllButton.setEnabled(true);
                this.deselectAllButton.setEnabled(true);
            }
        }
    }

    protected String extractGroupOrUserName(Trace t, String name) {
        String userOrGroupName = name;
        int i = name.lastIndexOf("@");
        if (i != -1) {
            userOrGroupName = name.substring(0, i);
        }
        if (Trace.isTracing) {
            t.data(66, "OamPropertyDialog.extractGroupOrUserName", 300, "Group name : " + userOrGroupName);
        }
        return userOrGroupName;
    }

    private boolean isIseries() {
        Boolean iSeriesPlatform = false;
        int platform = this.oamObject.getDmQueueManager().getPlatform();
        if (platform == 4) {
            iSeriesPlatform = true;
        }
        return iSeriesPlatform;
    }

    private String addOrRemoveAuthority(OamAuthorityButton b) {
        String addOrRemove = "";
        addOrRemove = b.isAddAuthority(Trace.getDefault()) ? " +" : " -";
        return addOrRemove;
    }
}

