/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.dialog;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.attribute.OamEntityTypeField;
import com.ibm.mq.explorer.oam.internal.attribute.OamGenericProfileCombo;
import com.ibm.mq.explorer.oam.internal.attribute.OamProfileNameCombo;
import com.ibm.mq.explorer.oam.internal.attribute.OamProfileTypeCombo;
import com.ibm.mq.explorer.oam.internal.attribute.OamRecordTypeField;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.dialog.OamCompareCumulativeDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamCompareDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamPropertyDialog;
import com.ibm.mq.explorer.oam.internal.object.OamObject;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.pcf.OamDeleteAuthority;
import com.ibm.mq.explorer.oam.internal.pcf.OamGetFindObjects;
import com.ibm.mq.explorer.oam.internal.table.OamTable;
import com.ibm.mq.explorer.oam.internal.table.OamTableFactory;
import com.ibm.mq.explorer.oam.internal.utils.OamWriteTableToDisk;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OamFindDialog
extends OamDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/dialog/OamFindDialog.java";
    private String queueManager = "[not_defined]";
    private OamEntityTypeField entityTypeField = null;
    private Button findButton = null;
    private Text entityNameText = null;
    private OamProfileNameCombo profileNameCombo = null;
    private OamProfileTypeCombo profileTypeCombo = null;
    private Button removeButton = null;
    private Button editButton = null;
    private Button compareButton = null;
    private Button saveButton = null;
    private StackLayout stackLayout = null;
    private Composite stackedComposite = null;
    private Composite mainComposite = null;
    private ScrolledComposite scrolledComposite = null;
    private OamRecordTypeField recordTypeField = null;
    private Hashtable<OamObject, OamTable> listOfExplorerTables = new Hashtable(10);
    private OamGenericProfileCombo genericProfileCombo = null;
    private boolean tableUpdated = false;
    private static final int TABLE_WIDTH_HINT = 600;
    private static final int TABLE_HEIGHT_HINT = 200;

    public OamFindDialog(Trace t, Shell _parent) {
        super(t, _parent, false);
        this.parentShell = _parent;
        this.helpId = "com.ibm.mq.explorer.oam.infopop.OAM_FindAuthoritiesDialog";
    }

    private void createContent(final Trace t, Composite parentComposite) {
        FillLayout fillLayout = null;
        this.init(t);
        fillLayout = new FillLayout();
        parentComposite.setLayout((Layout)fillLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        parentComposite.setLayoutData((Object)this.gridData);
        this.scrolledComposite = new ScrolledComposite(parentComposite, 768);
        this.mainComposite = new Composite((Composite)this.scrolledComposite, 2048);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 3;
        this.gridLayout.makeColumnsEqualWidth = false;
        this.mainComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        this.mainComposite.setLayoutData((Object)this.gridData);
        Label label = new Label(this.mainComposite, 0);
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.recordTypeField = new OamRecordTypeField(t, this, this.mainComposite, 2);
        label = new Label(this.mainComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Entity.Type"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.entityTypeField = new OamEntityTypeField(t, this, this.mainComposite, 2, true, this.getDmQueueManager().isOamUseridsSupported(), 3);
        this.entityTypeField.setRecordTypeField(this.recordTypeField);
        this.entityTypeField.populateComboList(t);
        label = new Label(this.mainComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Entity.Name"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.entityNameText = new Text(this.mainComposite, 2048);
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.horizontalSpan = 2;
        this.entityNameText.setLayoutData((Object)this.gridData);
        this.entityNameText.setEditable(true);
        this.entityNameText.setFocus();
        this.entityNameText.setTextLimit(this.getGuiEntityLength(true));
        this.entityNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OamFindDialog.this.enableFindButton(t);
            }
        });
        label = new Label(this.mainComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Object.Type"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.profileTypeCombo = new OamProfileTypeCombo(t, this, this.mainComposite, this.oamObject, true, true);
        this.genericProfileCombo = new OamGenericProfileCombo(t, this.mainComposite, true);
        this.enableGenericSelection(t);
        label = new Label(this.mainComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Profile.Name"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.profileNameCombo = new OamProfileNameCombo(t, this, this.getMyShell(), this.mainComposite, null, this.oamObject, true);
        this.profileNameCombo.setProfileTypeCombo(this.profileTypeCombo);
        this.profileNameCombo.setGenericProfileCombo(this.genericProfileCombo);
        label = new Label(this.mainComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Queue.Manager.Name"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        Composite qmComposite = new Composite(this.mainComposite, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = false;
        this.gridLayout.marginWidth = 0;
        this.gridLayout.marginHeight = 0;
        qmComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(768);
        this.gridData.horizontalSpan = 2;
        this.gridData.grabExcessHorizontalSpace = true;
        qmComposite.setLayoutData((Object)this.gridData);
        Text text = new Text(qmComposite, 2048);
        text.setText(this.queueManager);
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.horizontalSpan = 1;
        text.setLayoutData((Object)this.gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)text, (boolean)true);
        this.findButton = new Button(qmComposite, 8);
        this.findButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Find.Text"));
        this.gridData = new GridData();
        this.gridData.horizontalAlignment = 3;
        this.findButton.setLayoutData((Object)this.gridData);
        this.findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OamFindDialog.this.performFind(Trace.getDefault());
            }
        });
        this.enableFindButton(t);
        Composite tableAndButtonsComposite = new Composite(this.mainComposite, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 1;
        tableAndButtonsComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.horizontalSpan = 3;
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        tableAndButtonsComposite.setLayoutData((Object)this.gridData);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginWidth = 0;
        this.stackedComposite = new Composite(tableAndButtonsComposite, 0);
        this.stackedComposite.setLayout((Layout)this.stackLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        this.gridData.widthHint = 600;
        this.gridData.heightHint = 200;
        this.stackedComposite.setLayoutData((Object)this.gridData);
        this.displayExplorerTable(t, this.oamObject);
        Composite buttonComposite = new Composite(tableAndButtonsComposite, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 5;
        buttonComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = false;
        this.gridData.horizontalSpan = 3;
        buttonComposite.setLayoutData((Object)this.gridData);
        this.saveButton = new Button(buttonComposite, 8);
        this.saveButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Save.Text"));
        this.gridData = new GridData();
        this.gridData.horizontalAlignment = 1;
        this.saveButton.setLayoutData((Object)this.gridData);
        this.saveButton.setEnabled(false);
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OamFindDialog.this.performSave(Trace.getDefault());
            }
        });
        label = new Label(buttonComposite, 0);
        this.gridData = new GridData();
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)this.gridData);
        this.compareButton = new Button(buttonComposite, 8);
        this.compareButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Compare.Dialog.Text"));
        this.gridData = new GridData();
        this.compareButton.setLayoutData((Object)this.gridData);
        this.compareButton.setEnabled(false);
        this.compareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OamFindDialog.this.launchCompareDialog(Trace.getDefault());
            }
        });
        this.editButton = new Button(buttonComposite, 8);
        this.editButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Edit.Text"));
        this.gridData = new GridData();
        this.editButton.setLayoutData((Object)this.gridData);
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OamFindDialog.this.launchEditDialog(Trace.getDefault());
            }
        });
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Remove.Text"));
        this.gridData = new GridData();
        this.gridData.horizontalAlignment = 3;
        this.removeButton.setLayoutData((Object)this.gridData);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OamFindDialog.this.launchRemoveDialog(Trace.getDefault());
            }
        });
        ButtonTools.makeEqualWidthGridData((Trace)t, (Button[])new Button[]{this.saveButton, this.compareButton, this.editButton, this.removeButton});
        ButtonTools.makeEqualWidthGridData((Trace)t, (Button[])new Button[]{this.profileNameCombo.getSelectButton(), this.findButton});
        this.initialiseScrollable(t, this.scrolledComposite, this.mainComposite);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.myShell.setDefaultButton(this.findButton);
    }

    @Override
    public void close(Trace t) {
        this.listOfExplorerTables.clear();
    }

    @Override
    public void addContent(Trace t, Composite composite) {
        this.createContent(t, composite);
    }

    @Override
    public void init(Trace t) {
        if (this.oamObject != null) {
            this.queueManager = this.oamObject.getDmQueueManager().getTitle();
        }
    }

    private void performFind(Trace t) {
        this.tableUpdated = false;
        this.displayExplorerTable(t, this.profileTypeCombo.getOamObject(t));
        OamGetFindObjects get = new OamGetFindObjects(t, this.getMyShell(), this.getDmQueueManager(), this, this.genericProfileCombo.isGenericProfile(t), this.explorerTable.getFactoryClass());
        int rc = get.apply(t, OamPlugin.oamMessages.getMessage("OAM.Get.List.Of.Authorities", this.getDmQueueManager().getTitle()));
        ArrayList objects = get.getObjects();
        if (objects.size() > 0) {
            this.addObjectsToExplorerTable(t, objects);
            if (this.recordTypeField.isAccumulatedAuthority(t)) {
                this.explorerTable.expandAll(t);
            }
        } else if (Trace.isTracing) {
            t.data(66, "OamFindDialog.performFind", 300, "No objects shown");
        }
        if (!this.tableUpdated && rc == 0) {
            MessageBox.showSystemMessageById((Trace)t, (Shell)this.myShell, (String)"AMQ4818", null, null, (Image)Icons.get((String)Icons.iconkeyEntityName));
        }
        this.enableButtons(t);
    }

    @Override
    public void refreshTables(Trace t) {
        this.performFind(t);
    }

    private void displayExplorerTable(Trace t, OamObject oObject) {
        OamTable oamTable = null;
        oamTable = this.listOfExplorerTables.get(oObject);
        if (oamTable == null) {
            oamTable = OamTableFactory.createFindExplorerTable(t, this, this.stackedComposite, oObject, true, true);
            this.listOfExplorerTables.put(oObject, oamTable);
        }
        this.explorerTable = oamTable.getOamExplorerTable();
        this.explorerTable.clearTable(t);
        this.stackLayout.topControl = oamTable.getOamExplorerTableComposite();
        this.stackedComposite.layout();
    }

    private void addObjectsToExplorerTable(Trace t, ArrayList objects) {
        this.explorerTable.beginUpdate(t);
        if (objects.size() > 0) {
            int i = 0;
            while (i < objects.size()) {
                UiAuthorityRecord uiAuthRecord = (UiAuthorityRecord)((Object)objects.get(i));
                this.explorerTable.addItem(t, uiAuthRecord);
                ++i;
            }
            this.tableUpdated = true;
        }
        this.explorerTable.endUpdate(t);
    }

    public String getEntityName(Trace t) {
        String name = "";
        if (this.entityNameText != null && this.entityNameText.isEnabled()) {
            name = this.getTextString(this.entityNameText);
        }
        return name;
    }

    public int getEntityType(Trace t) {
        int type = -1;
        if (this.entityTypeField != null) {
            type = this.entityTypeField.getEntityType(t);
        }
        return type;
    }

    public String getProfileName(Trace t) {
        String name = "[not_defined]";
        if (this.profileNameCombo != null) {
            name = this.profileNameCombo.getSelectedName();
        }
        return name;
    }

    public boolean isRecordTypeAccumulated(Trace t) {
        boolean accumulated = false;
        if (this.recordTypeField != null) {
            accumulated = this.recordTypeField.isAccumulatedAuthority(t);
        }
        return accumulated;
    }

    public int getProfileType(Trace t) {
        OamObject oa;
        int type = -1;
        if (this.profileTypeCombo != null && (oa = this.profileTypeCombo.getOamObject(t)) != null) {
            type = oa.getOamObjectType(t);
        }
        return type;
    }

    private void launchEditDialog(Trace t) {
        OamPropertyDialog dialog = null;
        UiAuthorityRecord authRecord = this.getSelectedUiObject(t);
        if (authRecord != null) {
            OamObject oa = this.profileTypeCombo.getOamObject(t);
            oa.setDmQueueManager(this.oamObject.getDmQueueManager());
            oa.setUiQueueManager(this.oamObject.getUiQueueManager());
            dialog = (OamPropertyDialog)OamPropertyDialog.create(t, this.getMyShell(), authRecord, oa);
            dialog.setOamObject(oa);
            dialog.setEntityType(authRecord.isEntityTypeGroup(t));
            dialog.setTitle(OamPlugin.oamMessages.getMessage("OAM.Edit.Authorities.Title"));
            this.openRc = dialog.open(t);
            if (this.openRc == -2) {
                this.refreshTables(t);
            }
        } else if (Trace.isTracing) {
            t.data(66, "OamFindDialog.launchEditDialog", 300, "No record selected");
        }
    }

    private UiAuthorityRecord getSelectedUiObject(Trace t) {
        UiAuthorityRecord o = null;
        o = (UiAuthorityRecord)this.explorerTable.getSelection(t);
        return o;
    }

    private void launchRemoveDialog(Trace t) {
        UiAuthorityRecord authRecord = this.getSelectedUiObject(t);
        if (authRecord != null) {
            OamDeleteAuthority delete = null;
            DmAuthorityRecord dmAuthorityRecord = (DmAuthorityRecord)authRecord.getDmObject();
            delete = new OamDeleteAuthority(t, this.getMyShell(), dmAuthorityRecord);
            int reasonCode = delete.apply(t, OamPlugin.oamMessages.getMessage("OAM.Deleting.Authority"));
            if (reasonCode == 0) {
                this.refreshTables(t);
            }
        } else if (Trace.isTracing) {
            t.data(66, "OamFindDialog.launchRemoveDialog", 300, "No record selected");
        }
    }

    private void launchCompareDialog(Trace t) {
        OamDialog dialog = null;
        UiAuthorityRecord authRecord = this.getSelectedUiObject(t);
        if (authRecord != null) {
            OamObject oa = this.profileTypeCombo.getOamObject(t);
            oa.setDmQueueManager(this.oamObject.getDmQueueManager());
            oa.setUiQueueManager(this.oamObject.getUiQueueManager());
            dialog = authRecord.isAccumulated() ? new OamCompareCumulativeDialog(t, this.getMyShell(), this.getItems(t), authRecord.isEntityTypeGroup(t)) : new OamCompareDialog(t, this.getMyShell(), authRecord, authRecord.isEntityTypeGroup(t));
            dialog.setOamObject(oa);
            dialog.open(t);
        } else if (Trace.isTracing) {
            t.data(66, "OamFindDialog.launchCompareDialog", 300, "No record selected");
        }
    }

    @Override
    public void enableButtons(Trace t) {
        if (this.explorerTable != null) {
            UiAuthorityRecord auth = (UiAuthorityRecord)this.explorerTable.getSelection(t);
            if (auth != null) {
                if (this.editButton != null) {
                    this.editButton.setEnabled(true);
                }
                if (this.compareButton != null) {
                    this.compareButton.setEnabled(true);
                }
                if (this.removeButton != null) {
                    this.removeButton.setEnabled(true);
                }
            } else {
                if (this.editButton != null) {
                    this.editButton.setEnabled(false);
                }
                if (this.compareButton != null) {
                    this.compareButton.setEnabled(false);
                }
                if (this.removeButton != null) {
                    this.removeButton.setEnabled(false);
                }
            }
        }
        if (this.saveButton != null) {
            if (this.explorerTable != null && this.tableUpdated) {
                this.saveButton.setEnabled(true);
            } else {
                this.saveButton.setEnabled(false);
            }
        }
    }

    public void enableFindButton(Trace t) {
        if (this.findButton != null) {
            if (this.entityTypeField.isMultiEntity(t) || this.getTextString(this.entityNameText).length() > 0) {
                if (this.entityTypeField.isUserSelected(t) && !this.getDmQueueManager().isOamUseridsSupported() && this.profileNameCombo.getSelectedName().length() < 1) {
                    this.findButton.setEnabled(false);
                    this.enableRefreshButton(false);
                } else {
                    this.findButton.setEnabled(true);
                    this.enableRefreshButton(true);
                }
            } else {
                this.findButton.setEnabled(false);
                this.enableRefreshButton(false);
            }
        }
    }

    public void enableGenericSelection(Trace t) {
        if (this.recordTypeField.isAccumulatedAuthority(t)) {
            this.genericProfileCombo.setSelect(0);
            this.genericProfileCombo.setEnabled(false);
        } else {
            this.genericProfileCombo.setEnabled(true);
        }
    }

    public void enableEntityField(Trace t) {
        if (this.entityNameText != null && this.entityTypeField != null) {
            if (this.entityTypeField.isMultiEntity(t)) {
                this.entityNameText.setEnabled(false);
            } else {
                this.entityNameText.setEnabled(true);
            }
        }
    }

    public void populateEntityTypeField(Trace t) {
        this.entityTypeField.populateComboList(t);
    }

    private void performSave(Trace t) {
        OamWriteTableToDisk write = new OamWriteTableToDisk(t, this.myShell, this.explorerTable, false);
        int rc = write.promptForFilename(t);
        if (rc == 0) {
            write.writeToDisk(t);
        }
    }

    private UiAuthorityRecord[] getItems(Trace t) {
        ArrayList<UiAuthorityRecord> tempList = new ArrayList<UiAuthorityRecord>();
        UiAuthorityRecord[] uiAuthRecords = null;
        UiAuthorityRecord ua = (UiAuthorityRecord)this.explorerTable.getSelection(t);
        if (ua.isAccumulated()) {
            ArrayList<MQExtObject> authRecordsFromTable = this.explorerTable.getObjects(t);
            if (authRecordsFromTable != null && authRecordsFromTable.size() > 0) {
                int i = 0;
                block0: while (i < authRecordsFromTable.size()) {
                    MQExtObject mqObject = authRecordsFromTable.get(i);
                    UiAuthorityRecord uiObject = (UiAuthorityRecord)((Object)mqObject.getInternalObject());
                    if (((Object)((Object)ua)).equals((Object)uiObject)) {
                        tempList.add(uiObject);
                        int j = i + 1;
                        while (j < authRecordsFromTable.size()) {
                            mqObject = authRecordsFromTable.get(j);
                            uiObject = (UiAuthorityRecord)((Object)mqObject.getInternalObject());
                            if (uiObject.isAccumulated()) break block0;
                            tempList.add(uiObject);
                            ++j;
                        }
                    }
                    ++i;
                }
                if (tempList.size() > 0) {
                    uiAuthRecords = new UiAuthorityRecord[tempList.size()];
                    i = 0;
                    while (i < tempList.size()) {
                        uiAuthRecords[i] = (UiAuthorityRecord)((Object)tempList.get(i));
                        ++i;
                    }
                }
            } else if (Trace.isTracing) {
                t.data(66, "OamFindDialog.getItems", 900, "No records in table");
            }
        }
        if (uiAuthRecords == null || tempList.size() < 1) {
            uiAuthRecords = new UiAuthorityRecord[]{ua};
            if (Trace.isTracing) {
                t.data(66, "OamFindDialog.getItems", 900, "Only returning selected record");
            }
        }
        if (Trace.isTracing) {
            t.data(66, "OamFindDialog.getItems", 300, "Returning : " + uiAuthRecords);
        }
        return uiAuthRecords;
    }

    public void enableProfileName(Trace t) {
        if (this.getProfileType(t) == 5) {
            this.profileNameCombo.setEnabled(false);
        } else {
            this.profileNameCombo.setEnabled(true);
        }
    }
}

