/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.dialog;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmObjectFactory;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObjectLink;
import com.ibm.mq.explorer.oam.internal.attribute.OamAttributeDetails;
import com.ibm.mq.explorer.oam.internal.attribute.OamEntityTypeField;
import com.ibm.mq.explorer.oam.internal.attribute.OamExplorerTableTreeAttributeDetails;
import com.ibm.mq.explorer.oam.internal.attribute.OamProfileNameCombo;
import com.ibm.mq.explorer.oam.internal.attribute.OamProfileTypeCombo;
import com.ibm.mq.explorer.oam.internal.attribute.OamStatusInformation;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.dialog.OamCompareCumulativeDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamCompareDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamPropertyDialog;
import com.ibm.mq.explorer.oam.internal.object.OamObject;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecordFactory;
import com.ibm.mq.explorer.oam.internal.pcf.OamDeleteAuthority;
import com.ibm.mq.explorer.oam.internal.pcf.OamGetCumulativeObjects;
import com.ibm.mq.explorer.oam.internal.table.OamExplorerTable;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OamFindCumulativeDialog
extends OamDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/dialog/OamFindCumulativeDialog.java";
    private int MIN_SCROLLABLE_WIDTH = 400;
    private int MIN_SCROLLABLE_HEIGHT = 300;
    private String queueManager = "[not_defined]";
    private String profileName = "[not_defined]";
    private UiAuthorityRecord uiAuthorityRecord = null;
    private OamEntityTypeField userOrGroupRadioButton = null;
    private Button findButton = null;
    private Button compareButton = null;
    private boolean clearEntityName = false;
    private boolean enableProfile = false;
    private Text entityNameText = null;
    private OamProfileNameCombo profileNameCombo = null;
    private OamProfileTypeCombo profileTypeCombo = null;
    private Button removeButton = null;
    private Button editButton = null;
    private UiMQObjectFactory uiFactoryClass = null;
    private String attrOrderId = null;
    private OamAttributeDetails attrDetails = null;
    private OamGetCumulativeObjects cumulativeAuthorities = null;
    private UiAuthorityRecord uiCumulativeAuthority = null;
    private DmAuthorityRecord dmCumulativeAuthority = null;
    private ScrolledComposite scrolledComposite = null;
    private static final int TABLE_WIDTH_HINT = 600;
    private static final int TABLE_HEIGHT_HINT = 200;

    public OamFindCumulativeDialog(Trace t, Shell _parent, UiAuthorityRecord _authRecord, boolean _group, boolean _noName, boolean _enableProfile) {
        super(t, _parent, true);
        this.parentShell = _parent;
        this.uiAuthorityRecord = _authRecord;
        this.selectGroup = _group;
        this.clearEntityName = _noName;
        this.enableProfile = _enableProfile;
        this.title = OamPlugin.oamMessages.getMessage("OAM.Find.Cumulative.Authorities.Title");
        this.helpId = "com.ibm.mq.explorer.oam.infopop.OAM_FindCumulativeAuthoritiesDialog";
    }

    private void createContent(Trace t, Composite parentComposite) {
        FillLayout fillLayout = null;
        this.init(t);
        this.gridLayout = new GridLayout(1, false);
        parentComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        parentComposite.setLayoutData((Object)this.gridData);
        this.scrolledComposite = new ScrolledComposite(parentComposite, 768);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        this.scrolledComposite.setLayoutData((Object)this.gridData);
        Composite mainComposite = new Composite((Composite)this.scrolledComposite, 2048);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 3;
        this.gridLayout.makeColumnsEqualWidth = false;
        mainComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        mainComposite.setLayoutData((Object)this.gridData);
        Label label = new Label(mainComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Entity.Type"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.userOrGroupRadioButton = new OamEntityTypeField(t, mainComposite, 2, this.selectGroup, this.getDmQueueManager().isOamUseridsSupported(), 2);
        label = new Label(mainComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Entity.Name"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.entityNameText = new Text(mainComposite, 2048);
        if (!this.clearEntityName) {
            this.entityNameText.setText(this.entityName);
        }
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.horizontalSpan = 2;
        this.entityNameText.setLayoutData((Object)this.gridData);
        this.entityNameText.setEditable(true);
        this.entityNameText.setFocus();
        this.entityNameText.setTextLimit(this.getGuiEntityLength(this.userOrGroupRadioButton.isGroupSelected(t)));
        this.entityNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OamFindCumulativeDialog.this.getTextString(OamFindCumulativeDialog.this.entityNameText).length() > 0) {
                    OamFindCumulativeDialog.this.findButton.setEnabled(true);
                } else {
                    OamFindCumulativeDialog.this.findButton.setEnabled(false);
                }
            }
        });
        label = new Label(mainComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Object.Type"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.profileTypeCombo = new OamProfileTypeCombo(t, null, mainComposite, this.oamObject, false, false);
        label = new Label(mainComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Profile.Name"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.profileNameCombo = new OamProfileNameCombo(t, this, this.getMyShell(), mainComposite, this.profileName, this.oamObject, this.enableProfile);
        this.profileNameCombo.setProfileTypeCombo(this.profileTypeCombo);
        label = new Label(mainComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Queue.Manager.Name"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        Composite qmComposite = new Composite(mainComposite, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = false;
        this.gridLayout.marginWidth = 0;
        this.gridLayout.marginHeight = 0;
        qmComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(768);
        this.gridData.horizontalSpan = 2;
        this.gridData.grabExcessHorizontalSpace = true;
        qmComposite.setLayoutData((Object)this.gridData);
        Text text = new Text(qmComposite, 2048);
        text.setText(this.queueManager);
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.horizontalSpan = 1;
        text.setLayoutData((Object)this.gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)text, (boolean)true);
        this.findButton = new Button(qmComposite, 8);
        this.findButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Find.Text"));
        this.gridData = new GridData();
        this.gridData.horizontalAlignment = 3;
        this.findButton.setLayoutData((Object)this.gridData);
        this.findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OamFindCumulativeDialog.this.performFind(Trace.getDefault());
            }
        });
        if (this.getTextString(this.entityNameText).length() > 0) {
            this.findButton.setEnabled(true);
        } else {
            this.findButton.setEnabled(false);
        }
        Composite explorerTableTreeComposite = new Composite(mainComposite, 0);
        fillLayout = new FillLayout(768);
        explorerTableTreeComposite.setLayout((Layout)fillLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        this.gridData.horizontalSpan = 3;
        this.gridData.widthHint = 600;
        this.gridData.heightHint = 200;
        explorerTableTreeComposite.setLayoutData((Object)this.gridData);
        this.explorerTable = new OamExplorerTable(t, this, explorerTableTreeComposite);
        this.explorerTable.setSorting(false);
        this.uiFactoryClass = new UiAuthorityRecordFactory(this.getUiQueueManager());
        this.attrOrderId = this.oamObject.getExplorerTableTreeAttributeOrderId(t);
        this.attrDetails = new OamExplorerTableTreeAttributeDetails(this.oamObject.getObjectAuthorities(t));
        this.explorerTable.init(t, "com.ibm.mq.explorer.oam.authorityRecord", this.uiFactoryClass, this.attrOrderId, this.attrDetails, false, false, true);
        Composite buttonComposite = new Composite(mainComposite, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 4;
        buttonComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = false;
        this.gridData.horizontalSpan = 3;
        buttonComposite.setLayoutData((Object)this.gridData);
        label = new Label(buttonComposite, 0);
        this.gridData = new GridData();
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)this.gridData);
        this.compareButton = new Button(buttonComposite, 8);
        this.compareButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Compare.Dialog.Text"));
        this.gridData = new GridData();
        this.compareButton.setLayoutData((Object)this.gridData);
        this.compareButton.setEnabled(false);
        this.compareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OamFindCumulativeDialog.this.launchCompareDialog(Trace.getDefault());
            }
        });
        this.editButton = new Button(buttonComposite, 8);
        this.editButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Edit.Text"));
        this.gridData = new GridData();
        this.editButton.setLayoutData((Object)this.gridData);
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OamFindCumulativeDialog.this.launchEditDialog(Trace.getDefault());
            }
        });
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Remove.Text"));
        this.gridData = new GridData();
        this.gridData.horizontalAlignment = 3;
        this.removeButton.setLayoutData((Object)this.gridData);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OamFindCumulativeDialog.this.launchRemoveDialog(Trace.getDefault());
            }
        });
        ButtonTools.makeEqualWidthGridData((Trace)t, (Button[])new Button[]{this.compareButton, this.editButton, this.removeButton});
        ButtonTools.makeEqualWidthGridData((Trace)t, (Button[])new Button[]{this.profileNameCombo.getSelectButton(), this.findButton});
        this.initialiseScrollable(t, this.scrolledComposite, mainComposite, this.MIN_SCROLLABLE_WIDTH, this.MIN_SCROLLABLE_HEIGHT);
        Composite statusComposite = new Composite(parentComposite, 0);
        this.gridLayout = new GridLayout(1, false);
        this.gridLayout.marginHeight = 0;
        statusComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = false;
        statusComposite.setLayoutData((Object)this.gridData);
        this.statusInfo = new OamStatusInformation(t, statusComposite);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.myShell.setDefaultButton(this.findButton);
    }

    @Override
    public void close(Trace t) {
        if (this.explorerTable != null) {
            this.explorerTable.clearTable(t);
        }
    }

    @Override
    public void addContent(Trace t, Composite composite) {
        this.createContent(t, composite);
    }

    @Override
    public void init(Trace t) {
        if (this.uiAuthorityRecord == null && this.oamObject != null) {
            this.uiAuthorityRecord = this.oamObject.getUiAuthorityRecord();
        }
        if (this.uiAuthorityRecord != null) {
            this.entityName = this.uiAuthorityRecord.getDmObject().getAttributeValue(t, 3068, 0);
            this.profileName = this.uiAuthorityRecord.getDmObject().getAttributeValue(t, 3067, 0);
            if (this.profileName.equals("[not_found]") && this.oamObject != null) {
                this.profileName = this.oamObject.getMqObjectName();
            }
            if (this.entityType.equals("[not_defined]")) {
                this.entityType = this.uiAuthorityRecord.getDmObject().getAttributeValue(t, 1118, 0);
            }
            if (this.uiAuthorityRecord.getDmObject().getQueueManager() != null) {
                this.queueManager = this.uiAuthorityRecord.getDmObject().getQueueManager().getTitle();
            }
        }
        if (this.uiAuthorityRecord == null && this.oamObject != null) {
            this.entityName = "";
            this.profileName = this.oamObject.getMqObjectName();
            if (this.entityType.equals("[not_defined]")) {
                this.entityType = this.oamObject.getMQObjectType(t);
            }
            this.queueManager = this.oamObject.getDmQueueManager().getTitle();
        }
    }

    private void performFind(Trace t) {
        int rc = 0;
        if (!this.getTextString(this.entityNameText).equals("")) {
            if (this.userOrGroupRadioButton.isGroupSelected(t)) {
                String groupName = this.extractGroupName(t, this.getTextString(this.entityNameText));
                rc = this.populateExplorerTableTree(t, this.profileNameCombo.getSelectedName(), this.profileTypeCombo.getSelectedType(t), groupName, 2);
                if (rc == 0) {
                    this.showStatusMessage(t, groupName, this.queueManager);
                } else {
                    this.statusInfo.showMessage(t, false, "");
                }
            } else {
                rc = this.populateExplorerTableTree(t, this.profileNameCombo.getSelectedName(), this.profileTypeCombo.getSelectedType(t), this.getTextString(this.entityNameText), 1);
                if (rc == 0) {
                    this.showStatusMessage(t, this.getTextString(this.entityNameText), this.queueManager);
                } else {
                    this.statusInfo.showMessage(t, false, "");
                }
            }
            this.explorerTable.expandAll(t);
            this.enableButtons(t);
        }
    }

    @Override
    public void refreshTables(Trace t) {
        if (this.getTextString(this.entityNameText).length() > 0) {
            this.performFind(t);
        }
    }

    @Override
    public void performDefaultAction(Trace t) {
        this.performFind(t);
    }

    private int populateExplorerTableTree(Trace t, String pName, int pType, String eName, int eType) {
        int rc = 0;
        if (this.explorerTable != null) {
            this.explorerTable.clearTable(t);
            if (!eName.equals("")) {
                this.dmObjectFilter = new DmObjectFilter(t, pName, 87, pType);
                this.dmObjectFilter.setEntity(t, eName, eType, OamCommon.AUTH_OPTIONS_E);
                this.cumulativeAuthorities = new OamGetCumulativeObjects(t, this.getMyShell(), this.getDmQueueManager(), this.dmObjectFilter, eName, eType);
                rc = this.cumulativeAuthorities.apply(t, OamPlugin.oamMessages.getMessage("OAM.Get.List.Of.Authorities", this.getDmQueueManager().getTitle()));
                ArrayList objects = this.cumulativeAuthorities.getObjects();
                if (objects.size() > 0) {
                    this.createCumulativeObject(t, objects, pType, eName, eType);
                } else if (rc == 0) {
                    MessageBox.showSystemMessageById((Trace)t, (Shell)this.getMyShell(), (String)"AMQ4818", null, null, (Image)Icons.get((String)Icons.iconkeyEntityName));
                }
            }
        }
        return rc;
    }

    private void createCumulativeObject(Trace t, ArrayList objects, int profileType, String entityName, int eType) {
        ArrayList<Integer> cumulative = new ArrayList<Integer>();
        this.dmCumulativeAuthority = (DmAuthorityRecord)DmObjectFactory.create((Trace)t, (DmQueueManager)this.getDmQueueManager(), (int)87, (String)"Parent");
        this.explorerTable.beginUpdate(t);
        int i = 0;
        while (i < objects.size()) {
            IDmObject dmAuthRecord = (IDmObject)objects.get(i);
            String s = dmAuthRecord.getAttributeValue(t, 3067, 0);
            if (s.equalsIgnoreCase(OamCommon.getClassProfileName(dmAuthRecord.getQueueManager().getPlatform()))) {
                if (Trace.isTracing) {
                    t.data(66, "OamFindCumulativeDialog.createCumulativeObject", 300, "Ignoring @CLASS record : " + dmAuthRecord.toString(t));
                }
            } else {
                Attr authListAttr = dmAuthRecord.getAttribute(t, 1115, 0);
                ArrayList listOfAuthorities = (ArrayList)authListAttr.getValue(t);
                int j = 0;
                while (j < listOfAuthorities.size()) {
                    Integer value = (Integer)listOfAuthorities.get(j);
                    if (!cumulative.contains(value)) {
                        if (Trace.isTracing) {
                            t.data(66, "OamFindCumulativeDialog.createCumulativeObject", 300, "Adding authority to accumulated list : " + value);
                        }
                        cumulative.add(value);
                    }
                    ++j;
                }
                UiAuthorityRecord uiAuthRecord = (UiAuthorityRecord)this.uiFactoryClass.create(t, dmAuthRecord, null);
                this.dmCumulativeAuthority.addChild(t, (IDmObjectLink)dmAuthRecord);
                this.explorerTable.addItem(t, uiAuthRecord);
            }
            ++i;
        }
        int[] authList = new int[cumulative.size()];
        int i2 = 0;
        while (i2 < cumulative.size()) {
            authList[i2] = (Integer)cumulative.get(i2);
            ++i2;
        }
        this.dmCumulativeAuthority.addAttr(t, 1115, 0, (Object)authList);
        this.dmCumulativeAuthority.addAttr(t, 1016, 0, (Object)profileType);
        this.dmCumulativeAuthority.addAttr(t, 3068, 0, (Object)entityName);
        this.dmCumulativeAuthority.addAttr(t, 1118, 0, (Object)eType);
        this.dmCumulativeAuthority.addAttr(t, 3067, 0, (Object)OamPlugin.oamMessages.getMessage("OAM.Cumulative.Authorities"));
        this.dmCumulativeAuthority.initialize(t);
        this.uiCumulativeAuthority = (UiAuthorityRecord)this.uiFactoryClass.create(t, (DmObject)this.dmCumulativeAuthority, null);
        this.uiCumulativeAuthority.setAccumulated(true);
        this.explorerTable.addItem(t, this.uiCumulativeAuthority);
        this.explorerTable.endUpdate(t);
    }

    public boolean hasConnectAuthority() {
        if (this.cumulativeAuthorities != null) {
            return this.cumulativeAuthorities.hasConnectAuthority();
        }
        return false;
    }

    private void launchEditDialog(Trace t) {
        OamPropertyDialog dialog = null;
        UiAuthorityRecord authRecord = this.getSelectedUiObject(t);
        if (authRecord != null) {
            OamObject oa = this.profileTypeCombo.getOamObject(t);
            oa.setDmQueueManager(this.oamObject.getDmQueueManager());
            oa.setUiQueueManager(this.oamObject.getUiQueueManager());
            dialog = (OamPropertyDialog)OamPropertyDialog.create(t, this.getMyShell(), authRecord, oa);
            dialog.setOamObject(oa);
            dialog.setEntityType(authRecord.isEntityTypeGroup(t));
            dialog.setTitle(OamPlugin.oamMessages.getMessage("OAM.Edit.Authorities.Title"));
            this.openRc = dialog.open(t);
            if (this.openRc == -2) {
                this.refreshTables(t);
            }
        } else if (Trace.isTracing) {
            t.data(66, "OamFindCumulativeDialog.launchEditDialog", 300, "No record selected");
        }
    }

    private void launchRemoveDialog(Trace t) {
        UiAuthorityRecord authRecord = this.getSelectedUiObject(t);
        if (authRecord != null) {
            OamDeleteAuthority delete = null;
            DmAuthorityRecord dmAuthorityRecord = (DmAuthorityRecord)authRecord.getDmObject();
            delete = new OamDeleteAuthority(t, this.getMyShell(), dmAuthorityRecord);
            int reasonCode = delete.apply(t, OamPlugin.oamMessages.getMessage("OAM.Deleting.Authority"));
            if (reasonCode == 0) {
                this.refreshTables(t);
            }
        } else if (Trace.isTracing) {
            t.data(66, "OamFindCumulativeDialog.launchRemoveDialog", 300, "No record selected");
        }
    }

    private UiAuthorityRecord getSelectedUiObject(Trace t) {
        UiAuthorityRecord authRecord = null;
        authRecord = (UiAuthorityRecord)this.explorerTable.getSelection(t);
        return authRecord;
    }

    @Override
    public void enableButtons(Trace t) {
        if (this.explorerTable != null) {
            UiAuthorityRecord auth = (UiAuthorityRecord)this.explorerTable.getSelection(t);
            if (auth != null) {
                if (auth.isAccumulated()) {
                    if (this.editButton != null) {
                        this.editButton.setEnabled(false);
                    }
                    if (this.removeButton != null) {
                        this.removeButton.setEnabled(false);
                    }
                    if (this.compareButton != null) {
                        this.compareButton.setEnabled(true);
                    }
                } else {
                    if (this.editButton != null) {
                        this.editButton.setEnabled(true);
                    }
                    if (this.removeButton != null) {
                        this.removeButton.setEnabled(true);
                    }
                    if (this.compareButton != null) {
                        this.compareButton.setEnabled(true);
                    }
                }
            } else {
                if (this.compareButton != null) {
                    this.compareButton.setEnabled(false);
                }
                if (this.editButton != null) {
                    this.editButton.setEnabled(false);
                }
                if (this.removeButton != null) {
                    this.removeButton.setEnabled(false);
                }
            }
        }
    }

    private void showStatusMessage(Trace t, String eName, String qmName) {
        String msg = null;
        if (this.cumulativeAuthorities.isConnectAuthorityProblem()) {
            msg = OamPlugin.oamMessages.getMessage("OAM.Connect.Authority.Problem", eName, qmName);
            this.statusInfo.showMessage(t, true, msg);
        } else {
            msg = OamPlugin.oamMessages.getMessage("OAM.Connect.Authority.Warning", eName, qmName);
            if (!this.hasConnectAuthority()) {
                this.statusInfo.showMessage(t, true, msg);
            } else {
                this.statusInfo.showMessage(t, false, msg);
            }
        }
    }

    private void launchCompareDialog(Trace t) {
        OamDialog compare = null;
        UiAuthorityRecord authRecord = this.getSelectedUiObject(t);
        if (authRecord != null) {
            compare = authRecord.isAccumulated() ? new OamCompareCumulativeDialog(t, this.getMyShell(), this.getItems(t), authRecord.isEntityTypeGroup(t)) : new OamCompareDialog(t, this.getMyShell(), authRecord, authRecord.isEntityTypeGroup(t));
            compare.setOamObject(this.oamObject);
            compare.open(t);
        } else if (Trace.isTracing) {
            t.data(66, "OamFindCumulativeDialog.launchCompareDialog", 900, "No authority record selected");
        }
    }

    private UiAuthorityRecord[] getItems(Trace t) {
        ArrayList<MQExtObject> auths;
        UiAuthorityRecord[] uiAuthRecords = new UiAuthorityRecord[this.explorerTable.getItemCount(t)];
        if (Trace.isTracing) {
            t.data(66, "OamFindCumulativeDialog.getItems", 300, "Created return list size : " + uiAuthRecords.length);
        }
        if ((auths = this.explorerTable.getObjects(t)) != null && uiAuthRecords.length > 0) {
            int i = 0;
            while (i < uiAuthRecords.length) {
                UiAuthorityRecord uiObject;
                MQExtObject mqObject = auths.get(i);
                uiAuthRecords[i] = uiObject = (UiAuthorityRecord)((Object)mqObject.getInternalObject());
                ++i;
            }
        } else if (Trace.isTracing) {
            t.data(66, "OamFindCumulativeDialog.getItems", 900, "No records in table");
        }
        return uiAuthRecords;
    }
}

