/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.dialog;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.dialog.OamCreateAuthorityDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamExplorerDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamFindDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamQueueManagerDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamSelectDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamSimpleRoleBasedAuthoritiesDialog;
import com.ibm.mq.explorer.oam.internal.object.OamObject;
import java.util.HashMap;
import org.eclipse.swt.widgets.Shell;

public class OamDialogFactory {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/dialog/OamDialogFactory.java";
    private static HashMap<String, OamDialog> tableOfDialogs = new HashMap();

    private OamDialogFactory() {
    }

    public static OamDialog create(Trace t, Shell parent, OamObject oamObject, int dialogType, int style) {
        OamDialog dialog;
        String uuid = oamObject.getDmQueueManager().getUUID();
        int type = oamObject.getOamObjectType(t);
        String key = String.valueOf(uuid) + "/" + type + "/" + oamObject.getName(t) + "/" + dialogType;
        if (Trace.isTracing) {
            t.data(66, "OamDialogFactory.create", 300, "Using key = " + key);
        }
        if ((dialog = tableOfDialogs.get(key)) == null || dialog.getMyShell().isDisposed()) {
            dialog = OamDialogFactory.createDialog(t, parent, oamObject, dialogType);
            if (dialog != null) {
                if (Trace.isTracing) {
                    t.data(66, "OamDialogFactory.create", 300, "Created dialog with key " + key);
                }
                dialog.setCompositeStyle(style);
                tableOfDialogs.put(key, dialog);
                if (dialog.open(t) != 0) {
                    tableOfDialogs.remove(key);
                    if (Trace.isTracing) {
                        t.data(66, "OamDialogFactory.create", 900, "Error on open - removing dialog with key " + key);
                    }
                }
            } else if (Trace.isTracing) {
                t.data(66, "OamDialogFactory.create", 900, "Error creating dialog with key " + key);
            }
        } else {
            if (Trace.isTracing) {
                t.data(66, "OamDialogFactory.create", 300, "Re-displaying dialog with key " + key);
            }
            dialog.getMyShell().setActive();
        }
        return dialog;
    }

    private static OamDialog createDialog(Trace t, Shell parent, OamObject oamObject, int dialogType) {
        OamDialog dialog = null;
        switch (dialogType) {
            case 3: {
                dialog = new OamExplorerDialog(t, parent);
                dialog.setTitle(OamPlugin.oamMessages.getMessage("OAM.Manage.Authority.Records.Title", oamObject.getUiQueueManager().toFormattedString(), oamObject.getMqObjectName()));
                break;
            }
            case 0: {
                dialog = new OamFindDialog(t, parent);
                dialog.setTitle(OamPlugin.oamMessages.getMessage("OAM.Find.Authorities.Title", oamObject.getUiQueueManager().toFormattedString()));
                break;
            }
            case 5: {
                dialog = new OamQueueManagerDialog(t, parent);
                dialog.setTitle(OamPlugin.oamMessages.getMessage("OAM.Manage.QM.Authority.Records.Title", oamObject.getUiQueueManager().toFormattedString()));
                break;
            }
            case 6: {
                dialog = new OamCreateAuthorityDialog(t, parent);
                dialog.setTitle(OamPlugin.oamMessages.getMessage("OAM.Manage.Create.Authorities.Title", oamObject.getUiQueueManager().toFormattedString()));
                break;
            }
            case 8: {
                dialog = new OamSelectDialog(t, parent);
                dialog.setTitle(OamPlugin.oamMessages.getMessage("OAM.Select.Title", oamObject.getUiQueueManager().toFormattedString()));
                break;
            }
            case 9: {
                dialog = new OamSimpleRoleBasedAuthoritiesDialog(t, parent);
                dialog.setTitle(OamPlugin.oamMessages.getMessage("New.Role.Based.Authorities.Title", oamObject.getUiQueueManager().toFormattedString()));
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(66, "OamDialogFactory.createDialog", 900, "Unknown dialog type " + dialogType);
            }
        }
        if (dialog != null) {
            dialog.setOamObject(oamObject);
        }
        return dialog;
    }
}

