/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.dialog;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.oam.internal.attribute.OamStatusInformation;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.dialog.IOamDialog;
import com.ibm.mq.explorer.oam.internal.object.OamObject;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.table.OamExplorerTable;
import com.ibm.mq.explorer.oam.internal.utils.OamCompareAuthorityRecords;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.event.PCFFilter;
import com.ibm.mq.pcf.event.PCFQuery;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class OamDialog
extends TrayDialog
implements IOamDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/dialog/OamDialog.java";
    protected Shell myShell = null;
    protected Button okButton = null;
    protected Button cancelButton = null;
    protected Button closeButton = null;
    protected Button refreshButton = null;
    protected boolean addRefreshButton = true;
    protected boolean removeFocus = false;
    protected Shell parentShell = null;
    protected String title = "[not_defined]";
    protected Display display = null;
    protected OamObject oamObject = null;
    protected int openRc = 0;
    private int compositeStyle = 0;
    protected OamStatusInformation statusInfo = null;
    protected OamExplorerTable explorerTable = null;
    protected String entityType = "";
    protected String entityName = "";
    protected GridLayout gridLayout = null;
    protected GridData gridData = null;
    protected boolean selectGroup = false;
    protected DmObjectFilter dmObjectFilter = null;
    protected PCFFilter pcfFilter = null;
    private boolean addOkButton = false;
    protected String helpId = null;
    private boolean enableRefreshButton = true;
    private static final int REFRESH_BUTTON_ID = 1025;

    public OamDialog(Trace t, Shell _parent, boolean modal) {
        super(_parent);
        this.parentShell = _parent;
        this.setShellStyle(this.getShellStyle() | 0x10);
        if (!modal) {
            this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        if (this.helpId != null) {
            UiPlugin.getHelpSystem().setHelp((Control)newShell, this.helpId);
        }
        newShell.setImage(Icons.get((String)Icons.iconkeyEntityName));
        this.myShell = newShell;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.addRefreshButton) {
            this.refreshButton = this.createButton(parent, 1025, OamPlugin.oamMessages.getMessage("OAM.Button.Refresh.Text"), false);
            this.refreshButton.setEnabled(this.enableRefreshButton);
        }
        if (this.addOkButton) {
            this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.okButton.setEnabled(false);
            this.cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            if (!this.removeFocus) {
                this.cancelButton.setFocus();
            }
        } else {
            this.closeButton = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
            this.closeButton.setFocus();
        }
    }

    protected void buttonPressed(int buttonId) {
        Trace t = Trace.getDefault();
        if (buttonId == 12) {
            this.close(t);
            this.okPressed();
        } else if (buttonId == 0) {
            this.performOk(t);
            this.okPressed();
        } else if (buttonId == 1) {
            this.cancelPressed();
        } else if (buttonId == 1025) {
            this.performRefresh(t);
        }
    }

    public Control createDialogArea(Composite parent) {
        Trace t = Trace.getDefault();
        Composite maincomposite = (Composite)super.createDialogArea(parent);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 1;
        Composite composite = new Composite(maincomposite, this.compositeStyle);
        this.gridLayout = new GridLayout();
        composite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)this.gridData);
        this.addContent(t, composite);
        return composite;
    }

    public int open(Trace t) {
        if (this.openRc == 0) {
            this.performDefaultAction(t);
            this.open();
        }
        return this.openRc;
    }

    public void setTitle(String name) {
        this.title = name;
    }

    public void setCompositeStyle(int style) {
        this.compositeStyle = style;
    }

    public void setOamObject(OamObject o) {
        this.oamObject = o;
    }

    public DmQueueManager getDmQueueManager() {
        return this.oamObject.getDmQueueManager();
    }

    public OamObject getOamObject() {
        return this.oamObject;
    }

    public UiQueueManager getUiQueueManager() {
        return this.oamObject.getUiQueueManager();
    }

    public DmObject getDmObject() {
        return this.oamObject.getDmObject();
    }

    public UiAuthorityRecord getUiAuthorityRecord() {
        return this.oamObject.getUiAuthorityRecord();
    }

    public Shell getMyShell() {
        return this.myShell;
    }

    @Override
    public void populateTables(Trace t) {
    }

    @Override
    public void addContent(Trace t, Composite composite) {
    }

    @Override
    public void close(Trace t) {
    }

    @Override
    public void init(Trace t) {
    }

    protected void performClose(Trace t) {
        this.close(t);
    }

    protected void performRefresh(Trace t) {
        this.refreshTables(t);
    }

    @Override
    public void refreshTables(Trace t) {
    }

    @Override
    public void performDefaultAction(Trace t) {
    }

    @Override
    public void enableButtons(Trace t) {
    }

    protected String extractGroupName(Trace t, String name) {
        String groupName = name;
        int i = name.lastIndexOf("@");
        if (i != -1) {
            groupName = name.substring(0, i);
        }
        if (Trace.isTracing) {
            t.data(66, "OamDialog.extractGroupName", 300, "Input name = " + name + ", output name = " + groupName);
        }
        return groupName;
    }

    @Override
    public void performOk(Trace t) {
    }

    @Override
    public void enableOkButton(Trace t) {
    }

    public void setAddOkButton(boolean b) {
        this.addOkButton = b;
    }

    public void enableRefreshButton(boolean b) {
        this.enableRefreshButton = b;
        if (this.refreshButton != null) {
            this.refreshButton.setEnabled(b);
        }
    }

    protected void initialiseScrollable(Trace t, ScrolledComposite scroll, Composite content) {
        int x = content.computeSize((int)-1, (int)-1, (boolean)true).x;
        int y = content.computeSize((int)-1, (int)-1, (boolean)true).y;
        this.initialiseScrollable(t, scroll, content, x, y);
    }

    protected void initialiseScrollable(Trace t, ScrolledComposite scroll, Composite content, int x, int y) {
        scroll.setContent((Control)content);
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        scroll.setMinWidth(x);
        scroll.setMinHeight(y);
    }

    public String getTextString(Text text) {
        if (text != null && text.getText() != null) {
            return text.getText().trim();
        }
        return "";
    }

    @Override
    public String getExplorerTableInstanceId(Trace t) {
        return "com.ibm.mq.explorer.oam.explorerTable";
    }

    protected void showDifferences(Trace t, OamCompareAuthorityRecords compareAuthRecords, boolean showDifferences) {
        int[] listOfAuthorities = new int[]{};
        if (compareAuthRecords != null) {
            int i;
            listOfAuthorities = compareAuthRecords.getAuthorities(t);
            if (Trace.isTracing) {
                t.data(66, "OamDialog.showDifferences", 300, "Show these columns : " + listOfAuthorities);
            }
            if (listOfAuthorities.length > 0) {
                this.explorerTable.beginColumnUpdate(t);
                i = 0;
                while (i < listOfAuthorities.length) {
                    this.explorerTable.showColumn(t, listOfAuthorities[i], true);
                    ++i;
                }
                this.explorerTable.endColumnUpdate(t);
            }
            if (showDifferences) {
                listOfAuthorities = compareAuthRecords.getSameAuthorities(t);
                if (Trace.isTracing) {
                    t.data(66, "OamDialog.showDifferences", 300, "Hide these columns : " + listOfAuthorities);
                }
                if (listOfAuthorities.length > 0) {
                    this.explorerTable.beginColumnUpdate(t);
                    i = 0;
                    while (i < listOfAuthorities.length) {
                        this.explorerTable.showColumn(t, listOfAuthorities[i], false);
                        ++i;
                    }
                    this.explorerTable.endColumnUpdate(t);
                }
            }
        }
    }

    public void setRemoveRefreshButton() {
        this.addRefreshButton = false;
    }

    public void removeFocus() {
        this.removeFocus = true;
    }

    public int getGuiEntityLength(boolean isGroup) {
        int platform = this.getDmQueueManager().getPlatform();
        int guiEntityLength = 0;
        Trace t = Trace.getDefault();
        int commandLevel = this.getDmQueueManager().getCommandLevel();
        if (isGroup && (commandLevel >= 801 && (platform == 3 || platform == 4) || commandLevel >= 900 && (platform == 5 || platform == 11))) {
            PCFMessage request = new PCFMessage(161);
            try {
                PCFMessage[] response = this.getDmQueueManager().sendCommand(t, request);
                int result = (Integer)response[0].getParameterValue(1409);
                if (result == 1) {
                    guiEntityLength = 1024;
                    return guiEntityLength;
                }
            }
            catch (MQException mqe) {
                PCFQuery.traceMQRequest((Trace)t, (PCFMessage)request);
                PCFQuery.traceMQException((Trace)t, (MQException)mqe);
            }
        }
        switch (platform) {
            case 5: 
            case 11: {
                guiEntityLength = 64;
                break;
            }
            case 3: 
            case 4: 
            case 28: {
                guiEntityLength = 12;
            }
        }
        return guiEntityLength;
    }
}

