/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.dialog;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.utils.ConvertReasonCode;
import com.ibm.mq.explorer.oam.internal.attribute.OamExplorerTableCreateAttributeDetails;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.content.OamExplorerTableContentPage;
import com.ibm.mq.explorer.oam.internal.dialog.OamDialog;
import com.ibm.mq.explorer.oam.internal.table.OamExplorerTable;
import com.ibm.mq.explorer.oam.internal.utils.OamCreateCumulativeAuthorityRecord;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.pcf.event.PCFFilter;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class OamCreateAuthorityDialog
extends OamDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/dialog/OamCreateAuthorityDialog.java";
    private OamExplorerTableContentPage contentPage = null;
    private OamExplorerTable usersExplorerTable = null;
    private OamExplorerTable groupsExplorerTable = null;
    private OamExplorerTableCreateAttributeDetails attrDetails = null;
    private String attrOrderId = "com.ibm.mq.explorer.oam.queuemanager.table.create.AttributeOrder";
    private OamCreateCumulativeAuthorityRecord processCumulative = null;
    private static final int WIDTH_HINT = 600;
    private static final int HEIGHT_HINT = 300;

    public OamCreateAuthorityDialog(Trace t, Shell _parent) {
        super(t, _parent, false);
        this.parentShell = _parent;
        this.processCumulative = new OamCreateCumulativeAuthorityRecord();
        this.helpId = "com.ibm.mq.explorer.oam.infopop.OAM_ManageCrtAuthorityRecords";
    }

    @Override
    public void addContent(Trace t, Composite composite) {
        this.setTitle(OamPlugin.oamMessages.getMessage("OAM.Manage.Create.Authorities.Title", this.oamObject.getMqObjectName()));
        AttrTypeEnum attrType = (AttrTypeEnum)DmQueueManager.getAttributeType((Trace)t, (int)12004);
        this.attrDetails = new OamExplorerTableCreateAttributeDetails(attrType);
        this.contentPage = new OamExplorerTableContentPage(t, this, composite, this.attrOrderId, this.attrDetails, false, false, true, true);
        this.groupsExplorerTable = this.contentPage.getGroupsExplorerTable();
        this.usersExplorerTable = this.contentPage.getUsersExplorerTable();
        this.populateTables(t);
        this.showHideColumns(t);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        this.gridData.widthHint = 600;
        this.gridData.heightHint = 300;
        composite.setLayoutData((Object)this.gridData);
    }

    @Override
    public void populateTables(Trace t) {
        if (this.groupsExplorerTable != null) {
            block6: {
                this.groupsExplorerTable.clearTable(t);
                this.pcfFilter = PCFFilter.getFilter((int)1115, (PCFFilter.Operation)PCFFilter.CONTAINS, (int)6);
                this.dmObjectFilter = new DmObjectFilter(t, 87, 1001, this.pcfFilter);
                this.dmObjectFilter.setAuthorityOptions(t, OamCommon.AUTH_OPTIONS_WILDCARD);
                ArrayList objects = null;
                try {
                    objects = this.getDmQueueManager().getObjects(t, this.dmObjectFilter, false);
                    if (objects.size() > 0) {
                        this.processCumulative.processAllResponses(t, objects, this.groupsExplorerTable, this.usersExplorerTable);
                        this.contentPage.enableSaveButton(t, true);
                    } else if (Trace.isTracing) {
                        t.data(66, "OamCreateAuthorityDialog.populateTables", 300, "No objects found");
                    }
                }
                catch (DmCoreException e) {
                    String msg = ConvertReasonCode.getSystemMessage((Trace)t, (DmObject)this.getDmQueueManager(), (int)87, (int)e.getReasonCode(), (int)e.getCompCode());
                    MessageBox.showMessageFailure((Trace)t, (Shell)this.getMyShell(), (String)msg, (Image)Icons.get((String)Icons.iconkeyEntityName));
                    this.openRc = e.getReasonCode();
                    if (!Trace.isTracing) break block6;
                    t.data(66, "OamCreateAuthorityDialog.populateTables", 900, "Error getting authorities, rc=" + this.openRc);
                }
            }
            this.refreshStatusInfo(t);
            this.enableButtons(t);
        }
    }

    @Override
    public void refreshTables(Trace t) {
        this.populateTables(t);
    }

    private void refreshStatusInfo(Trace t) {
        if (this.groupsExplorerTable != null) {
            this.groupsExplorerTable.updateLastRefreshText(t);
        }
        if (this.usersExplorerTable != null) {
            this.usersExplorerTable.updateLastRefreshText(t);
        }
    }

    @Override
    public void enableButtons(Trace t) {
        this.contentPage.enableButtons(t);
    }

    private void showHideColumns(Trace t) {
        AttrTypeEnum attrType = (AttrTypeEnum)DmQueueManager.getAttributeType((Trace)t, (int)12004);
        Integer[] allAttrIds = attrType.getEnumerationIds(t);
        int[] intAllAttrIds = new int[allAttrIds.length];
        int i = 0;
        while (i < allAttrIds.length) {
            intAllAttrIds[i] = allAttrIds[i];
            ++i;
        }
        int[] validAttrIds = this.getDmQueueManager().getValidCrtAuthorities(t);
        this.showHideColumns(t, this.groupsExplorerTable, intAllAttrIds, validAttrIds);
        this.showHideColumns(t, this.usersExplorerTable, intAllAttrIds, validAttrIds);
    }

    private void showHideColumns(Trace t, OamExplorerTable table, int[] allAttrIds, int[] attrIds) {
        if (table != null) {
            table.beginColumnUpdate(t);
            int i = 0;
            while (i < allAttrIds.length) {
                table.showColumn(t, allAttrIds[i], false);
                ++i;
            }
            i = 0;
            while (i < attrIds.length) {
                table.showColumn(t, attrIds[i], true);
                ++i;
            }
            table.endColumnUpdate(t);
        }
    }
}

