/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.dialog;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.oam.internal.attribute.OamAttributeDetails;
import com.ibm.mq.explorer.oam.internal.attribute.OamEntityTypeField;
import com.ibm.mq.explorer.oam.internal.attribute.OamExplorerTableAttributeDetails;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.dialog.OamDialog;
import com.ibm.mq.explorer.oam.internal.object.OamObject;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecordFactory;
import com.ibm.mq.explorer.oam.internal.pcf.OamGetObjects;
import com.ibm.mq.explorer.oam.internal.table.OamExplorerTable;
import com.ibm.mq.explorer.oam.internal.utils.OamCompareAuthorityRecords;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OamCompareDialog
extends OamDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/dialog/OamCompareDialog.java";
    private int MIN_SCROLLABLE_WIDTH = 400;
    private int MIN_SCROLLABLE_HEIGHT = 250;
    private static final int TABLE_WIDTH_HINT = 500;
    private static final int TABLE_HEIGHT_HINT = 200;
    private Text compareNameText = null;
    private UiAuthorityRecord compareUiAuthorityRecord = null;
    private UiAuthorityRecord compareWithUiAuthorityRecord = null;
    private OamEntityTypeField userOrGroupRadioButton = null;
    private Button compareButton = null;
    private Button showDifferencesButton = null;
    private OamAttributeDetails attrDetails = null;
    private String attrOrderId = null;
    private UiAuthorityRecordFactory factory = null;
    private OamCompareAuthorityRecords compareAuthRecords = null;
    private ScrolledComposite scrolledComposite = null;

    public OamCompareDialog(Trace t, Shell _parent, UiAuthorityRecord _authRecord, boolean _group) {
        super(t, _parent, true);
        this.parentShell = _parent;
        this.compareUiAuthorityRecord = _authRecord;
        this.compareUiAuthorityRecord.setOamObject(this.oamObject);
        this.selectGroup = _group;
        this.title = OamPlugin.oamMessages.getMessage("OAM.Compare.Title");
        this.helpId = "com.ibm.mq.explorer.oam.infopop.OAM_CompareDialog";
    }

    private void createContent(Trace t, Composite parentComposite) {
        String compareText = null;
        int entityTypeFieldStyle = 0;
        FillLayout fillLayout = null;
        this.init(t);
        fillLayout = new FillLayout();
        parentComposite.setLayout((Layout)fillLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        parentComposite.setLayoutData((Object)this.gridData);
        this.scrolledComposite = new ScrolledComposite(parentComposite, 768);
        compareText = this.selectGroup ? OamPlugin.oamMessages.getMessage("OAM.Compare.Group") : OamPlugin.oamMessages.getMessage("OAM.Compare.User");
        entityTypeFieldStyle = this.getDmQueueManager().isOamUseridsSupported() ? 2 : 1;
        Composite mainComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 3;
        this.gridLayout.makeColumnsEqualWidth = false;
        mainComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        mainComposite.setLayoutData((Object)this.gridData);
        Label label = new Label(mainComposite, 0);
        label.setText(compareText);
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        Text text = new Text(mainComposite, 2048);
        text.setText(this.entityName);
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.horizontalSpan = 2;
        text.setLayoutData((Object)this.gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)text, (boolean)true);
        label = new Label(mainComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.With.The"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.userOrGroupRadioButton = new OamEntityTypeField(t, mainComposite, 2, this.selectGroup, this.getDmQueueManager().isOamUseridsSupported(), entityTypeFieldStyle);
        label = new Label(mainComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Called"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.compareNameText = new Text(mainComposite, 2048);
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.horizontalSpan = 1;
        this.compareNameText.setLayoutData((Object)this.gridData);
        this.compareNameText.setEditable(true);
        this.compareNameText.setFocus();
        this.compareNameText.setTextLimit(this.getGuiEntityLength(this.selectGroup));
        this.compareNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OamCompareDialog.this.getTextString(OamCompareDialog.this.compareNameText).length() > 0) {
                    OamCompareDialog.this.compareButton.setEnabled(true);
                } else {
                    OamCompareDialog.this.compareButton.setEnabled(false);
                }
            }
        });
        this.compareButton = new Button(mainComposite, 8);
        this.compareButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Compare.Text"));
        this.gridData = new GridData();
        this.gridData.horizontalAlignment = 3;
        this.compareButton.setLayoutData((Object)this.gridData);
        this.compareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                OamCompareDialog.this.performCompare(t1);
            }
        });
        if (this.getTextString(this.compareNameText).length() > 0) {
            this.compareButton.setEnabled(true);
        } else {
            this.compareButton.setEnabled(false);
        }
        this.showDifferencesButton = new Button(mainComposite, 32);
        this.showDifferencesButton.setText(OamPlugin.oamMessages.getMessage("OAM.Show.Differences"));
        this.gridData = new GridData();
        this.gridData.horizontalSpan = 3;
        this.showDifferencesButton.setLayoutData((Object)this.gridData);
        this.showDifferencesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                OamCompareDialog.this.showDifferences(t1, OamCompareDialog.this.compareAuthRecords, OamCompareDialog.this.showDifferencesButton.getSelection());
            }
        });
        Composite explorerTableComposite = new Composite(mainComposite, 0);
        fillLayout = new FillLayout(768);
        explorerTableComposite.setLayout((Layout)fillLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        this.gridData.horizontalSpan = 3;
        this.gridData.widthHint = 500;
        this.gridData.heightHint = 200;
        explorerTableComposite.setLayoutData((Object)this.gridData);
        this.explorerTable = new OamExplorerTable(t, this, explorerTableComposite);
        this.explorerTable.setSorting(false);
        this.factory = new UiAuthorityRecordFactory(this.getUiQueueManager());
        this.attrOrderId = this.oamObject.getExplorerTableAttributeOrderId(t);
        this.attrDetails = new OamExplorerTableAttributeDetails(this.oamObject.getObjectAuthorities(t));
        this.explorerTable.init(t, "com.ibm.mq.explorer.oam.authorityRecord", (UiMQObjectFactory)this.factory, this.attrOrderId, this.attrDetails, false, false, false);
        this.scrolledComposite.setContent((Control)mainComposite);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.initialiseScrollable(t, this.scrolledComposite, mainComposite, this.MIN_SCROLLABLE_WIDTH, this.MIN_SCROLLABLE_HEIGHT);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.myShell.setDefaultButton(this.compareButton);
    }

    @Override
    public void close(Trace t) {
        if (this.explorerTable != null) {
            this.explorerTable.clearTable(t);
        }
    }

    @Override
    public void addContent(Trace t, Composite composite) {
        this.createContent(t, composite);
    }

    @Override
    public void init(Trace t) {
        if (this.compareUiAuthorityRecord == null && this.oamObject != null) {
            this.compareUiAuthorityRecord = this.oamObject.getUiAuthorityRecord();
        }
        if (this.compareUiAuthorityRecord != null) {
            this.entityName = this.compareUiAuthorityRecord.getDmObject().getAttributeValue(t, 3068, 0);
            if (this.entityType.equals("[not_defined]")) {
                this.entityType = this.compareUiAuthorityRecord.getDmObject().getAttributeValue(t, 1118, 0);
            }
        }
        if (this.compareUiAuthorityRecord == null && this.oamObject != null) {
            this.entityName = "";
            if (this.entityType.equals("[not_defined]")) {
                this.entityType = this.oamObject.getMQObjectType(t);
            }
        }
        this.entityType = this.selectGroup ? OamPlugin.oamMessages.getMessage("OAM.Group.Text") : OamPlugin.oamMessages.getMessage("OAM.User.Text");
    }

    protected void performCompare(Trace t) {
        this.compareButton.setEnabled(false);
        this.explorerTable.clearTable(t);
        OamObject oa = this.getOamObject();
        boolean selection = this.userOrGroupRadioButton.isGroupSelected(t);
        int eType = 0;
        eType = selection ? 2 : 1;
        this.dmObjectFilter = new DmObjectFilter(t, this.compareUiAuthorityRecord.getDmObject().getTitle(), 87, oa.getOamObjectType(t), null);
        this.dmObjectFilter.setEntity(t, this.getTextString(this.compareNameText), eType, 17);
        OamGetObjects getQuery = new OamGetObjects(t, this.getMyShell(), this.getDmQueueManager(), this.dmObjectFilter);
        getQuery.setEntityName(t, this.getTextString(this.compareNameText));
        getQuery.setEntityType(t, eType);
        int rc = getQuery.apply(t, OamPlugin.oamMessages.getMessage("OAM.Get.List.Of.Authorities", this.getDmQueueManager().getTitle()));
        ArrayList objects = getQuery.getObjects();
        if (objects.size() > 0) {
            this.explorerTable.addItem(t, this.compareUiAuthorityRecord);
            this.createUiObject(t, objects);
            this.showDifferences(t, this.compareAuthRecords, this.showDifferencesButton.getSelection());
        } else if (rc == 0) {
            String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4818");
            MessageBox.showMessageFailure((Trace)t, (Shell)this.myShell, (String)msg, (String)"AMQ4818", (Image)Icons.get((String)Icons.iconkeyEntityName));
        }
        this.compareButton.setEnabled(true);
    }

    private void createUiObject(Trace t, ArrayList objects) {
        this.explorerTable.beginUpdate(t);
        int i = 0;
        while (i < objects.size()) {
            IDmObject dmAuthRecord = (IDmObject)objects.get(i);
            if (Trace.isTracing) {
                t.data(66, "OamCompareDialog.createUiObject", 300, "Dm object = " + dmAuthRecord.toString(t));
            }
            if (dmAuthRecord instanceof DmAuthorityRecord) {
                UiAuthorityRecord uiAuthRecord;
                this.compareWithUiAuthorityRecord = uiAuthRecord = (UiAuthorityRecord)this.explorerTable.getFactoryClass().create(t, dmAuthRecord, null);
                AttrTypeEnum attrType = this.oamObject.getObjectAuthorities(t);
                this.compareAuthRecords = new OamCompareAuthorityRecords(t, this.compareUiAuthorityRecord, this.compareWithUiAuthorityRecord, attrType);
                this.explorerTable.addItem(t, uiAuthRecord);
            }
            ++i;
        }
        this.explorerTable.endUpdate(t);
    }

    @Override
    public void refreshTables(Trace t) {
        if (this.getTextString(this.compareNameText).length() > 0) {
            this.performCompare(t);
        }
    }

    @Override
    public String getExplorerTableInstanceId(Trace t) {
        return "com.ibm.mq.explorer.oam.compare.explorerTable";
    }
}

