/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.dialog;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmObjectFactory;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObjectLink;
import com.ibm.mq.explorer.oam.internal.attribute.OamAttributeDetails;
import com.ibm.mq.explorer.oam.internal.attribute.OamEntityTypeField;
import com.ibm.mq.explorer.oam.internal.attribute.OamExplorerTableAttributeDetails;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.dialog.OamDialog;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecordFactory;
import com.ibm.mq.explorer.oam.internal.pcf.OamGetCumulativeObjects;
import com.ibm.mq.explorer.oam.internal.table.OamExplorerTable;
import com.ibm.mq.explorer.oam.internal.utils.OamCompareAuthorityRecords;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OamCompareCumulativeDialog
extends OamDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/dialog/OamCompareCumulativeDialog.java";
    private int MIN_SCROLLABLE_WIDTH = 400;
    private int MIN_SCROLLABLE_HEIGHT = 250;
    private Text compareNameText = null;
    private UiAuthorityRecord[] uiAuthorityRecordsFromCaller = null;
    private OamEntityTypeField userOrGroupRadioButton = null;
    private Button compareButton = null;
    private Button showDifferencesButton = null;
    private Button showAuthoritiesButton = null;
    private OamAttributeDetails attrDetails = null;
    private String attrOrderId = null;
    private UiAuthorityRecordFactory factory = null;
    private OamCompareAuthorityRecords compare2AuthorityRecords = null;
    private OamGetCumulativeObjects getAccumulatedAuthorities = null;
    private UiAuthorityRecord uiCumulativeAuthority = null;
    private DmAuthorityRecord dmCumulativeAuthority = null;
    private ScrolledComposite scrolledComposite = null;
    private static final int TABLE_WIDTH_HINT = 500;
    private static final int TABLE_HEIGHT_HINT = 200;

    public OamCompareCumulativeDialog(Trace t, Shell _parent, UiAuthorityRecord[] _authRecords, boolean _group) {
        super(t, _parent, true);
        this.parentShell = _parent;
        this.uiAuthorityRecordsFromCaller = _authRecords;
        this.selectGroup = _group;
        this.title = OamPlugin.oamMessages.getMessage("OAM.Compare.Cumulative.Title");
        this.helpId = "com.ibm.mq.explorer.oam.infopop.OAM_CompareCumulativeDialog";
    }

    private void createContent(Trace t, Composite parentComposite) {
        String compareText = null;
        FillLayout fillLayout = null;
        this.init(t);
        fillLayout = new FillLayout();
        parentComposite.setLayout((Layout)fillLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        parentComposite.setLayoutData((Object)this.gridData);
        this.scrolledComposite = new ScrolledComposite(parentComposite, 768);
        compareText = this.selectGroup ? OamPlugin.oamMessages.getMessage("OAM.Compare.Group") : OamPlugin.oamMessages.getMessage("OAM.Compare.User");
        Composite mainComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 3;
        this.gridLayout.makeColumnsEqualWidth = false;
        mainComposite.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        mainComposite.setLayoutData((Object)this.gridData);
        Label label = new Label(mainComposite, 0);
        label.setText(compareText);
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        Text text = new Text(mainComposite, 2048);
        text.setText(this.entityName);
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.horizontalSpan = 2;
        text.setLayoutData((Object)this.gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)text, (boolean)true);
        label = new Label(mainComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.With.The"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.userOrGroupRadioButton = new OamEntityTypeField(t, mainComposite, 2, this.selectGroup, this.getDmQueueManager().isOamUseridsSupported(), 2);
        label = new Label(mainComposite, 0);
        label.setText(OamPlugin.oamMessages.getMessage("OAM.Called"));
        this.gridData = new GridData();
        label.setLayoutData((Object)this.gridData);
        this.compareNameText = new Text(mainComposite, 2048);
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.horizontalSpan = 1;
        this.compareNameText.setLayoutData((Object)this.gridData);
        this.compareNameText.setEditable(true);
        this.compareNameText.setFocus();
        this.compareNameText.setTextLimit(this.getGuiEntityLength(this.userOrGroupRadioButton.isGroupSelected(t)));
        this.compareNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OamCompareCumulativeDialog.this.getTextString(OamCompareCumulativeDialog.this.compareNameText).length() > 0) {
                    OamCompareCumulativeDialog.this.compareButton.setEnabled(true);
                } else {
                    OamCompareCumulativeDialog.this.compareButton.setEnabled(false);
                }
            }
        });
        this.compareButton = new Button(mainComposite, 8);
        this.compareButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Compare.Text"));
        this.gridData = new GridData();
        this.gridData.horizontalAlignment = 3;
        this.compareButton.setLayoutData((Object)this.gridData);
        this.compareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                OamCompareCumulativeDialog.this.performCompare(t1);
            }
        });
        if (this.getTextString(this.compareNameText).length() > 0) {
            this.compareButton.setEnabled(true);
        } else {
            this.compareButton.setEnabled(false);
        }
        this.showDifferencesButton = new Button(mainComposite, 32);
        this.showDifferencesButton.setText(OamPlugin.oamMessages.getMessage("OAM.Show.Cumulative.Differences"));
        this.gridData = new GridData();
        this.gridData.horizontalSpan = 3;
        this.showDifferencesButton.setLayoutData((Object)this.gridData);
        this.showDifferencesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                OamCompareCumulativeDialog.this.showDifferences(t1, OamCompareCumulativeDialog.this.compare2AuthorityRecords, OamCompareCumulativeDialog.this.showDifferencesButton.getSelection());
            }
        });
        this.showAuthoritiesButton = new Button(mainComposite, 32);
        this.showAuthoritiesButton.setText(OamPlugin.oamMessages.getMessage("OAM.Show.Cumulative.Authorities"));
        this.gridData = new GridData();
        this.gridData.horizontalSpan = 3;
        this.showAuthoritiesButton.setLayoutData((Object)this.gridData);
        this.showAuthoritiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                OamCompareCumulativeDialog.this.showAuthorityRecords(t1);
            }
        });
        Composite explorerTableComposite = new Composite(mainComposite, 0);
        fillLayout = new FillLayout(768);
        explorerTableComposite.setLayout((Layout)fillLayout);
        this.gridData = new GridData(1808);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.grabExcessVerticalSpace = true;
        this.gridData.horizontalSpan = 3;
        this.gridData.widthHint = 500;
        this.gridData.heightHint = 200;
        explorerTableComposite.setLayoutData((Object)this.gridData);
        this.explorerTable = new OamExplorerTable(t, this, explorerTableComposite);
        this.explorerTable.setSorting(false);
        this.factory = new UiAuthorityRecordFactory(this.getUiQueueManager());
        this.attrOrderId = this.oamObject.getExplorerTableAttributeOrderId(t);
        this.attrDetails = new OamExplorerTableAttributeDetails(this.oamObject.getObjectAuthorities(t));
        this.explorerTable.init(t, "com.ibm.mq.explorer.oam.authorityRecord", (UiMQObjectFactory)this.factory, this.attrOrderId, this.attrDetails, false, false, true);
        this.initialiseScrollable(t, this.scrolledComposite, mainComposite, this.MIN_SCROLLABLE_WIDTH, this.MIN_SCROLLABLE_HEIGHT);
    }

    @Override
    public void close(Trace t) {
        if (this.explorerTable != null) {
            this.explorerTable.clearTable(t);
        }
    }

    @Override
    public void addContent(Trace t, Composite composite) {
        this.createContent(t, composite);
    }

    @Override
    public void init(Trace t) {
        if (this.uiAuthorityRecordsFromCaller != null) {
            this.entityName = this.uiAuthorityRecordsFromCaller[0].getDmObject().getAttributeValue(t, 3068, 0);
            if (this.entityType.equals("[not_defined]")) {
                this.entityType = this.uiAuthorityRecordsFromCaller[0].getDmObject().getAttributeValue(t, 1118, 0);
            }
        }
        if (this.uiAuthorityRecordsFromCaller == null && this.oamObject != null) {
            this.entityName = "";
            if (this.entityType.equals("[not_defined]")) {
                this.entityType = this.oamObject.getMQObjectType(t);
            }
        }
        this.entityType = this.selectGroup ? OamPlugin.oamMessages.getMessage("OAM.Group.Text") : OamPlugin.oamMessages.getMessage("OAM.User.Text");
    }

    protected void performCompare(Trace t) {
        int rc = 0;
        if (this.explorerTable != null) {
            this.compareButton.setEnabled(false);
            boolean selection = this.userOrGroupRadioButton.isGroupSelected(t);
            int eType = 0;
            eType = selection ? 2 : 1;
            String eName = this.getTextString(this.compareNameText);
            String pName = this.uiAuthorityRecordsFromCaller[1].getDmObject().getTitle();
            int pType = this.oamObject.getOamObjectType(t);
            this.explorerTable.clearTable(t);
            if (!eName.equals("")) {
                this.dmObjectFilter = new DmObjectFilter(t, pName, 87, pType);
                this.dmObjectFilter.setEntity(t, eName, eType, OamCommon.AUTH_OPTIONS_E);
                this.getAccumulatedAuthorities = new OamGetCumulativeObjects(t, this.getMyShell(), this.getDmQueueManager(), this.dmObjectFilter, eName, eType);
                rc = this.getAccumulatedAuthorities.apply(t, OamPlugin.oamMessages.getMessage("OAM.Get.List.Of.Authorities", this.getDmQueueManager().getTitle()));
                ArrayList objects = this.getAccumulatedAuthorities.getObjects();
                if (objects.size() > 0) {
                    this.addAccumulatedToTable(t);
                    this.createCumulativeObject(t, objects, pType, eName);
                    AttrTypeEnum attrType = this.oamObject.getObjectAuthorities(t);
                    this.compare2AuthorityRecords = new OamCompareAuthorityRecords(t, this.uiCumulativeAuthority, this.uiAuthorityRecordsFromCaller[0], attrType);
                    this.showDifferences(t, this.compare2AuthorityRecords, this.showDifferencesButton.getSelection());
                    this.showAuthorityRecords(t);
                } else if (rc == 0) {
                    MessageBox.showSystemMessageById((Trace)t, (Shell)this.getMyShell(), (String)"AMQ4818", null, null, (Image)Icons.get((String)Icons.iconkeyEntityName));
                }
            }
            this.compareButton.setEnabled(true);
        }
    }

    public void setDefaultButton(Trace t) {
        this.myShell.setDefaultButton(this.compareButton);
    }

    @Override
    public void refreshTables(Trace t) {
        if (this.getTextString(this.compareNameText).length() > 0) {
            this.performCompare(t);
        }
    }

    private void createCumulativeObject(Trace t, ArrayList objects, int profileType, String eName) {
        ArrayList<Integer> cumulative = new ArrayList<Integer>();
        this.dmCumulativeAuthority = (DmAuthorityRecord)DmObjectFactory.create((Trace)t, (DmQueueManager)this.getDmQueueManager(), (int)87, (String)"Parent");
        this.explorerTable.beginUpdate(t);
        int i = 0;
        while (i < objects.size()) {
            IDmObject dmAuthRecord = (IDmObject)objects.get(i);
            String pName = dmAuthRecord.getAttributeValue(t, 3067, 0);
            if (pName.equalsIgnoreCase(OamCommon.getClassProfileName(this.getDmQueueManager().getPlatform()))) {
                if (Trace.isTracing) {
                    t.data(66, "OamCompareCumulativeDialog.createCumulativeObject", 300, "Ignoring @CLASS record : " + dmAuthRecord.toString(t));
                }
            } else {
                Attr authListAttr = dmAuthRecord.getAttribute(t, 1115, 0);
                ArrayList listOfAuthorities = (ArrayList)authListAttr.getValue(t);
                int j = 0;
                while (j < listOfAuthorities.size()) {
                    Integer value = (Integer)listOfAuthorities.get(j);
                    if (!cumulative.contains(value)) {
                        if (Trace.isTracing) {
                            t.data(66, "OamCompareCumulativeDialog.createCumulativeObject", 300, "Adding authority to accumulated list : " + value);
                        }
                        cumulative.add(value);
                    }
                    ++j;
                }
                UiAuthorityRecord uiAuthRecord = (UiAuthorityRecord)this.factory.create(t, dmAuthRecord, null);
                this.dmCumulativeAuthority.addChild(t, (IDmObjectLink)dmAuthRecord);
                this.explorerTable.addItem(t, uiAuthRecord);
            }
            ++i;
        }
        int[] authList = new int[cumulative.size()];
        int i2 = 0;
        while (i2 < cumulative.size()) {
            authList[i2] = (Integer)cumulative.get(i2);
            ++i2;
        }
        this.dmCumulativeAuthority.addAttr(t, 1115, 0, (Object)authList);
        this.dmCumulativeAuthority.addAttr(t, 1016, 0, (Object)profileType);
        this.dmCumulativeAuthority.addAttr(t, 3068, 0, (Object)eName);
        this.dmCumulativeAuthority.addAttr(t, 3067, 0, (Object)OamPlugin.oamMessages.getMessage("OAM.Cumulative.Authorities"));
        this.dmCumulativeAuthority.initialize(t);
        this.uiCumulativeAuthority = (UiAuthorityRecord)this.factory.create(t, (DmObject)this.dmCumulativeAuthority, null);
        this.uiCumulativeAuthority.setAccumulated(true);
        this.explorerTable.addItem(t, this.uiCumulativeAuthority);
        this.explorerTable.endUpdate(t);
    }

    protected void showAuthorityRecords(Trace t) {
        if (this.explorerTable != null) {
            if (this.showAuthoritiesButton.getSelection()) {
                this.explorerTable.expandAll(t);
            } else {
                this.explorerTable.collapseAll(t);
            }
        }
    }

    private void addAccumulatedToTable(Trace t) {
        if (this.explorerTable != null) {
            this.explorerTable.beginUpdate(t);
            int i = 0;
            while (i < this.uiAuthorityRecordsFromCaller.length) {
                UiAuthorityRecord ui = this.uiAuthorityRecordsFromCaller[i];
                this.explorerTable.addItem(t, ui);
                ++i;
            }
            this.explorerTable.endUpdate(t);
        }
    }

    @Override
    public String getExplorerTableInstanceId(Trace t) {
        return "com.ibm.mq.explorer.oam.compare.cumulative.explorerTable";
    }
}

