/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class OamProfilesContentPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/content/OamProfilesContentPage.java";
    private static int MIN_SCROLLABLE_WIDTH = 300;
    private static int MIN_SCROLLABLE_HEIGHT = 400;
    protected Composite composite = null;
    protected GridLayout mainLayout = null;
    private ScrolledComposite scrolledComposite = null;

    public OamProfilesContentPage(Trace t, Composite parent, int style) {
        this(t, parent, style, MIN_SCROLLABLE_WIDTH, MIN_SCROLLABLE_HEIGHT);
    }

    public OamProfilesContentPage(Trace t, Composite parent, int style, int width, int height) {
        FillLayout fillLayout = new FillLayout();
        parent.setLayout((Layout)fillLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        parent.setLayoutData((Object)gridData);
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.composite = new Composite((Composite)this.scrolledComposite, 0);
        this.mainLayout = new GridLayout();
        this.mainLayout.numColumns = 1;
        this.mainLayout.makeColumnsEqualWidth = false;
        this.composite.setLayout((Layout)this.mainLayout);
        gridData = new GridData();
        this.composite.setLayoutData((Object)gridData);
        this.scrolledComposite.setContent((Control)this.composite);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setMinWidth(width);
        this.scrolledComposite.setMinHeight(height);
    }

    protected void createLineOfText(Trace t, String text) {
        this.createLine(t, text, false);
    }

    protected void createParagraphHeaderLine(Trace t, String text) {
        this.createLine(t, text, true);
    }

    private void createLine(Trace t, String text, boolean header) {
        final Text label = new Text(this.composite, 64);
        label.setText(text);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)label, (boolean)false);
        if (header) {
            label.setFont(JFaceResources.getHeaderFont());
        }
        final GridData gridData = new GridData(4, 128, false, false);
        label.setLayoutData((Object)gridData);
        this.composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle rect = OamProfilesContentPage.this.composite.getClientArea();
                int width = rect.width - 20 - 2 * OamProfilesContentPage.this.mainLayout.marginWidth;
                Point ptLabel = label.computeSize(width, -1);
                gridData.widthHint = ptLabel.x;
                gridData.heightHint = ptLabel.y;
                OamProfilesContentPage.this.composite.layout(true);
                OamProfilesContentPage.this.scrolledComposite.setMinHeight(OamProfilesContentPage.this.composite.computeSize((int)-1, (int)-1, (boolean)true).y);
            }
        });
    }

    protected void createPadLine(Trace t) {
        Label padding = new Label(this.composite, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        padding.setLayoutData((Object)gridData);
    }
}

