/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.attribute.OamAttributeDetails;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.dialog.OamCompareCreateAuthorityDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamCompareDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamFindCumulativeDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamPropertyDialog;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecordFactory;
import com.ibm.mq.explorer.oam.internal.pcf.OamCommonPCF;
import com.ibm.mq.explorer.oam.internal.pcf.OamDeleteAuthority;
import com.ibm.mq.explorer.oam.internal.pcf.OamDeleteCreateAuthority;
import com.ibm.mq.explorer.oam.internal.table.OamExplorerTable;
import com.ibm.mq.explorer.oam.internal.utils.OamWriteTableToDisk;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class OamExplorerTableContentPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/content/OamExplorerTableContentPage.java";
    private Button removeButton = null;
    private Button editButton = null;
    private Button addButton = null;
    private Button compareButton = null;
    private Button findCumulativeButton = null;
    private Button saveButton = null;
    private TabFolder tabFolder = null;
    private TabItem groupTab = null;
    private TabItem userTab = null;
    private OamExplorerTable usersExplorerTable = null;
    private OamExplorerTable groupsExplorerTable = null;
    private OamDialog parentDialog = null;
    private Composite parentComposite = null;
    private Composite mainComposite = null;
    private Composite explorerTableComposite = null;
    private ScrolledComposite scrolledComposite = null;
    private String attrOrderId = null;
    private OamAttributeDetails attrOrderDetails = null;
    private boolean addFindButton = true;
    private boolean addSaveButton = true;
    private boolean viewerFilter = false;
    private boolean crtAuthorities = false;
    private int openRc = 0;
    private boolean isGroupTabSelected = true;
    private static boolean defaultShowTabGroup = true;

    public OamExplorerTableContentPage(Trace t, OamDialog _dialog, Composite _composite, String _orderId, OamAttributeDetails _aDetails, boolean _viewer, boolean _find, boolean _crt, boolean _save) {
        this.parentDialog = _dialog;
        this.parentComposite = _composite;
        this.attrOrderId = _orderId;
        this.attrOrderDetails = _aDetails;
        this.viewerFilter = _viewer;
        this.addFindButton = _find;
        this.crtAuthorities = _crt;
        this.addSaveButton = _save;
        this.init(t);
    }

    private void init(Trace t) {
        GridData gridData = null;
        FillLayout fillLayout = null;
        int columnSpan = 2;
        GridLayout gridLayout = new GridLayout();
        this.mainComposite = new Composite(this.parentComposite, 0);
        fillLayout = new FillLayout();
        this.mainComposite.setLayout((Layout)fillLayout);
        if (this.parentComposite.getLayout() instanceof GridLayout) {
            gridData = new GridData(1808);
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            this.mainComposite.setLayoutData((Object)gridData);
        }
        this.scrolledComposite = new ScrolledComposite(this.mainComposite, 256);
        this.explorerTableComposite = new Composite((Composite)this.scrolledComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.explorerTableComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.explorerTableComposite.setLayoutData((Object)gridData);
        this.tabFolder = new TabFolder(this.explorerTableComposite, 0);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.tabFolder.setLayoutData((Object)gridData);
        Composite groupComposite = new Composite((Composite)this.tabFolder, 0);
        fillLayout = new FillLayout();
        groupComposite.setLayout((Layout)fillLayout);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        groupComposite.setLayoutData((Object)gridData);
        this.groupTab = new TabItem(this.tabFolder, 0);
        this.groupTab.setControl((Control)groupComposite);
        this.groupTab.setText(OamPlugin.oamMessages.getMessage("OAM.Tab.Groups.Text"));
        this.groupsExplorerTable = new OamExplorerTable(t, this.parentDialog, groupComposite);
        this.groupsExplorerTable.init(t, "com.ibm.mq.explorer.oam.authorityRecord", (UiMQObjectFactory)new UiAuthorityRecordFactory(this.parentDialog.getUiQueueManager()), this.attrOrderId, this.attrOrderDetails, this.viewerFilter, true, false);
        this.groupsExplorerTable.setOwner(this);
        if (this.parentDialog.getDmQueueManager().isOamUseridsSupported()) {
            Composite userComposite = new Composite((Composite)this.tabFolder, 0);
            fillLayout = new FillLayout();
            userComposite.setLayout((Layout)fillLayout);
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            userComposite.setLayoutData((Object)gridData);
            this.userTab = new TabItem(this.tabFolder, 0);
            this.userTab.setControl((Control)userComposite);
            this.userTab.setText(OamPlugin.oamMessages.getMessage("OAM.Tab.Users.Text"));
            this.usersExplorerTable = new OamExplorerTable(t, this.parentDialog, userComposite);
            this.usersExplorerTable.init(t, "com.ibm.mq.explorer.oam.authorityRecord", (UiMQObjectFactory)new UiAuthorityRecordFactory(this.parentDialog.getUiQueueManager()), this.attrOrderId, this.attrOrderDetails, this.viewerFilter, true, false);
            this.usersExplorerTable.setOwner(this);
            if (!defaultShowTabGroup) {
                this.tabFolder.setSelection(new TabItem[]{this.userTab});
            }
        }
        this.setSelectedTab(t);
        this.tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Trace t1 = Trace.getDefault();
                OamExplorerTableContentPage.this.setSelectedTab(t1);
            }
        });
        Composite buttonComposite = new Composite(this.explorerTableComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        gridLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        buttonComposite.setLayoutData((Object)gridData);
        if (this.addSaveButton) {
            this.saveButton = new Button(buttonComposite, 8);
            this.saveButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Save.Text"));
            gridData = new GridData();
            gridData.horizontalAlignment = 1;
            this.saveButton.setLayoutData((Object)gridData);
            this.saveButton.setEnabled(false);
            this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t1 = Trace.getDefault();
                    OamExplorerTableContentPage.this.performSave(t1);
                }
            });
        } else {
            columnSpan = 3;
        }
        if (this.addFindButton) {
            this.findCumulativeButton = new Button(buttonComposite, 8);
            this.findCumulativeButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Find.Cumulative.Text"));
            gridData = new GridData();
            this.findCumulativeButton.setLayoutData((Object)gridData);
            this.findCumulativeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t1 = Trace.getDefault();
                    OamExplorerTableContentPage.this.launchFindDialog(t1);
                    OamExplorerTableContentPage.this.parentDialog.getMyShell().setFocus();
                }
            });
            Label label = new Label(buttonComposite, 0);
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalSpan = columnSpan - 1;
            label.setLayoutData((Object)gridData);
        } else {
            Label label = new Label(buttonComposite, 0);
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalSpan = columnSpan;
            label.setLayoutData((Object)gridData);
        }
        this.compareButton = new Button(buttonComposite, 8);
        this.compareButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Compare.Dialog.Text"));
        gridData = new GridData();
        this.compareButton.setLayoutData((Object)gridData);
        this.compareButton.setEnabled(false);
        this.compareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                OamExplorerTableContentPage.this.launchCompareDialog(t1);
                OamExplorerTableContentPage.this.parentDialog.getMyShell().setFocus();
            }
        });
        this.addButton = new Button(buttonComposite, 8);
        this.addButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Add.Text"));
        gridData = new GridData();
        this.addButton.setLayoutData((Object)gridData);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                OamExplorerTableContentPage.this.launchAddDialog(t1);
            }
        });
        this.editButton = new Button(buttonComposite, 8);
        this.editButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Edit.Text"));
        gridData = new GridData();
        this.editButton.setLayoutData((Object)gridData);
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                OamExplorerTableContentPage.this.launchEditDialog(t1);
            }
        });
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Remove.Text"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                OamExplorerTableContentPage.this.launchRemoveDialog(t1);
                OamExplorerTableContentPage.this.parentDialog.getMyShell().setFocus();
            }
        });
        this.resizeButtons(t);
        this.scrolledComposite.setContent((Control)this.explorerTableComposite);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setMinWidth(buttonComposite.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    private void launchAddDialog(Trace t) {
        UiAuthorityRecord authRecord = this.parentDialog.getUiAuthorityRecord();
        OamPropertyDialog ad = (OamPropertyDialog)OamPropertyDialog.create(t, this.parentDialog.getMyShell(), authRecord, this.parentDialog.getOamObject());
        ad.setCreate(true);
        ad.setOamObject(this.parentDialog.getOamObject());
        ad.setTitle(OamPlugin.oamMessages.getMessage("OAM.Add.Authorities.Title"));
        ad.setEntityType(this.isGroupTabSelected);
        ad.setCrtAuthorities(this.crtAuthorities);
        if (!this.parentDialog.getDmQueueManager().isOamUseridsSupported()) {
            ad.setEntityTypeStyle(2);
        }
        this.openRc = ad.open(t);
        if (this.openRc == -2) {
            this.parentDialog.refreshTables(t);
        }
        this.enableButtons(t);
    }

    private void launchEditDialog(Trace t) {
        UiAuthorityRecord authRecord = this.getSelectedUiObject(t);
        if (authRecord != null) {
            OamPropertyDialog ad = (OamPropertyDialog)OamPropertyDialog.create(t, this.parentDialog.getMyShell(), authRecord, this.parentDialog.getOamObject());
            ad.setCreate(false);
            ad.setOamObject(this.parentDialog.getOamObject());
            ad.setEntityType(this.isGroupTabSelected);
            ad.setTitle(OamPlugin.oamMessages.getMessage("OAM.Edit.Authorities.Title"));
            ad.setCrtAuthorities(this.crtAuthorities);
            this.openRc = ad.open(t);
            if (this.openRc == -2) {
                this.parentDialog.refreshTables(t);
            }
            this.enableButtons(t);
        } else if (Trace.isTracing) {
            t.data(66, "OamExplorerTableContentPage.launchEditDialog", 900, "No authority record selected");
        }
    }

    private void launchFindDialog(Trace t) {
        boolean clearEntityName = false;
        UiAuthorityRecord authRecord = this.getSelectedUiObject(t);
        if (authRecord == null) {
            clearEntityName = true;
            if (Trace.isTracing) {
                t.data(66, "OamExplorerTableContentPage.launchFindDialog", 300, "No authority record selected");
            }
        }
        OamFindCumulativeDialog findDialog = new OamFindCumulativeDialog(t, this.parentDialog.getMyShell(), authRecord, this.isGroupTabSelected, clearEntityName, false);
        findDialog.setOamObject(this.parentDialog.getOamObject());
        findDialog.open(t);
        this.enableButtons(t);
    }

    private void launchCompareDialog(Trace t) {
        OamDialog compare = null;
        UiAuthorityRecord authRecord = this.getSelectedUiObject(t);
        if (authRecord != null) {
            compare = this.crtAuthorities ? new OamCompareCreateAuthorityDialog(t, this.parentDialog.getMyShell(), authRecord, this.isGroupTabSelected) : new OamCompareDialog(t, this.parentDialog.getMyShell(), authRecord, this.isGroupTabSelected);
            compare.setOamObject(this.parentDialog.getOamObject());
            compare.open(t);
            this.enableButtons(t);
        } else if (Trace.isTracing) {
            t.data(66, "OamExplorerTableContentPage.launchCompareDialog", 900, "No authority record selected");
        }
    }

    private void launchRemoveDialog(Trace t) {
        UiAuthorityRecord authRecord = this.getSelectedUiObject(t);
        if (authRecord != null) {
            OamCommonPCF delete = null;
            DmAuthorityRecord dmAuthorityRecord = (DmAuthorityRecord)authRecord.getDmObject();
            delete = this.crtAuthorities ? new OamDeleteCreateAuthority(t, this.parentDialog.getMyShell(), dmAuthorityRecord) : new OamDeleteAuthority(t, this.parentDialog.getMyShell(), dmAuthorityRecord);
            int reasonCode = delete.apply(t, OamPlugin.oamMessages.getMessage("OAM.Deleting.Authority"));
            if (reasonCode == 0) {
                this.parentDialog.refreshTables(t);
            }
            this.enableButtons(t);
        } else if (Trace.isTracing) {
            t.data(66, "OamExplorerTableContentPage.launchRemoveDialog", 900, "No authority record selected");
        }
    }

    private UiAuthorityRecord getSelectedUiObject(Trace t) {
        UiAuthorityRecord authRecord = null;
        if (this.isGroupTabSelected) {
            authRecord = (UiAuthorityRecord)this.groupsExplorerTable.getSelection(t);
        } else if (this.usersExplorerTable != null) {
            authRecord = (UiAuthorityRecord)this.usersExplorerTable.getSelection(t);
        }
        return authRecord;
    }

    public OamExplorerTable getGroupsExplorerTable() {
        return this.groupsExplorerTable;
    }

    public OamExplorerTable getUsersExplorerTable() {
        return this.usersExplorerTable;
    }

    public void enableButtons(Trace t) {
        TabItem[] ti = this.tabFolder.getSelection();
        if (this.groupTab == null || ti[0].equals(this.groupTab)) {
            if (this.groupsExplorerTable != null && this.groupsExplorerTable.getSelection(t) != null) {
                if (this.editButton != null) {
                    this.editButton.setEnabled(true);
                }
                if (this.removeButton != null) {
                    this.removeButton.setEnabled(true);
                }
                if (this.compareButton != null) {
                    this.compareButton.setEnabled(true);
                }
                if (Trace.isTracing) {
                    t.data(66, "OamExplorerTableContentPage.enableButtons", 300, "Enabling buttons on Group tab");
                }
            } else {
                if (this.editButton != null) {
                    this.editButton.setEnabled(false);
                }
                if (this.removeButton != null) {
                    this.removeButton.setEnabled(false);
                }
                if (this.compareButton != null) {
                    this.compareButton.setEnabled(false);
                }
                if (Trace.isTracing) {
                    t.data(66, "OamExplorerTableContentPage.enableButtons", 300, "Disabling buttons on Group tab");
                }
            }
        } else if (this.usersExplorerTable != null && this.usersExplorerTable.getSelection(t) != null) {
            if (this.editButton != null) {
                this.editButton.setEnabled(true);
            }
            if (this.removeButton != null) {
                this.removeButton.setEnabled(true);
            }
            if (this.compareButton != null) {
                this.compareButton.setEnabled(true);
            }
            if (Trace.isTracing) {
                t.data(66, "OamExplorerTableContentPage.enableButtons", 300, "Enabling buttons on User tab");
            }
        } else {
            if (this.editButton != null) {
                this.editButton.setEnabled(false);
            }
            if (this.removeButton != null) {
                this.removeButton.setEnabled(false);
            }
            if (this.compareButton != null) {
                this.compareButton.setEnabled(false);
            }
            if (Trace.isTracing) {
                t.data(66, "OamExplorerTableContentPage.enableButtons", 300, "Enabling buttons on User tab");
            }
        }
    }

    public void enableFindButton(Trace t, boolean b) {
        if (this.findCumulativeButton != null) {
            this.findCumulativeButton.setEnabled(b);
        }
    }

    public TabFolder getTabFolder() {
        return this.tabFolder;
    }

    public TabItem getGroupTab() {
        return this.groupTab;
    }

    public TabItem getUserTab() {
        return this.userTab;
    }

    private void setSelectedTab(Trace t) {
        TabItem[] ti = this.tabFolder.getSelection();
        if (this.groupTab == null || ti[0].equals(this.groupTab)) {
            this.isGroupTabSelected = true;
            defaultShowTabGroup = true;
            if (Trace.isTracing) {
                t.data(66, "OamExplorerTableContentPage.setSelectedTab", 300, "Group tab selected");
            }
        } else {
            this.isGroupTabSelected = false;
            defaultShowTabGroup = false;
            if (Trace.isTracing) {
                t.data(66, "OamExplorerTableContentPage.setSelectedTab", 300, "User tab selected");
            }
        }
        this.enableButtons(t);
    }

    private void performSave(Trace t) {
        OamExplorerTable table = null;
        if (this.isGroupTabSelected) {
            table = this.groupsExplorerTable;
            if (Trace.isTracing) {
                t.data(66, "OamExplorerTableContentPage.performSave", 300, "Write from group table");
            }
        } else {
            table = this.usersExplorerTable;
            if (Trace.isTracing) {
                t.data(66, "OamExplorerTableContentPage.performSave", 300, "Write from user table");
            }
        }
        OamWriteTableToDisk write = new OamWriteTableToDisk(t, this.parentDialog.getMyShell(), table, this.crtAuthorities);
        int rc = write.promptForFilename(t);
        if (Trace.isTracing) {
            t.data(66, "OamExplorerTableContentPage.performSave", 300, "Prompt to write rc = " + rc);
        }
        if (rc == 0) {
            write.writeToDisk(t);
        }
    }

    private void resizeButtons(Trace t) {
        if (this.addSaveButton && this.addFindButton) {
            ButtonTools.makeEqualWidthGridData((Trace)t, (Button[])new Button[]{this.saveButton, this.findCumulativeButton});
        }
        ButtonTools.makeEqualWidthGridData((Trace)t, (Button[])new Button[]{this.compareButton, this.addButton, this.editButton, this.removeButton});
    }

    public void enableSaveButton(Trace t, boolean b) {
        if (this.saveButton != null) {
            this.saveButton.setEnabled(b);
        }
    }
}

