/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.oam.internal.attribute.OamExplorerTableAttributeDetails;
import com.ibm.mq.explorer.oam.internal.content.OamExplorerTableContentPage;
import com.ibm.mq.explorer.oam.internal.content.OamGenericProfilesContentPage;
import com.ibm.mq.explorer.oam.internal.content.OamSpecificProfilesContentPage;
import com.ibm.mq.explorer.oam.internal.dialog.OamExplorerDialog;
import com.ibm.mq.explorer.oam.internal.object.OamObject;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.table.OamExplorerTree;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class OamExplorerDialogContentPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/content/OamExplorerDialogContentPage.java";
    private OamExplorerDialog parentDialog = null;
    private OamExplorerTree oamExplorerTree = null;
    private OamExplorerTableContentPage oamExplorerTableContentPage = null;
    private OamSpecificProfilesContentPage specificProfilesContentPage = null;
    private OamGenericProfilesContentPage genericProfilesContentPage = null;
    private Composite specificProfilesComposite = null;
    private Composite genericProfilesComposite = null;
    private Composite explorerTableComposite = null;
    private StackLayout stackLayout = null;
    private Composite stackedComposite = null;
    private int[] WEIGHTS = new int[]{30, 70};

    public OamExplorerDialogContentPage(Trace t, OamExplorerDialog _dialog, Composite _composite) {
        this.parentDialog = _dialog;
        this.init(t, _composite);
    }

    private void init(Trace t, Composite composite) {
        GridData gridData = null;
        FillLayout fillLayout = null;
        GridLayout gridLayout = null;
        Composite explorerComposite = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        explorerComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        explorerComposite.setLayoutData((Object)gridData);
        SashForm sashForm = new SashForm(explorerComposite, 256);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        sashForm.setLayoutData((Object)gridData);
        sashForm.setEnabled(true);
        Composite leftComposite = new Composite((Composite)sashForm, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        leftComposite.setLayoutData((Object)gridData);
        this.oamExplorerTree = new OamExplorerTree(t, this.parentDialog, leftComposite);
        this.oamExplorerTree.init(t);
        this.stackLayout = new StackLayout();
        this.stackedComposite = new Composite((Composite)sashForm, 2048);
        this.stackedComposite.setLayout((Layout)this.stackLayout);
        gridData = new GridData(1808);
        this.stackedComposite.setLayoutData((Object)gridData);
        this.explorerTableComposite = new Composite(this.stackedComposite, 0);
        fillLayout = new FillLayout();
        this.explorerTableComposite.setLayout((Layout)fillLayout);
        this.specificProfilesComposite = new Composite(this.stackedComposite, 0);
        this.specificProfilesContentPage = new OamSpecificProfilesContentPage(t, this.specificProfilesComposite, 0);
        this.specificProfilesContentPage.init(t, this.parentDialog.getOamObject().getMQObjectType(t));
        this.genericProfilesComposite = new Composite(this.stackedComposite, 0);
        this.genericProfilesContentPage = new OamGenericProfilesContentPage(t, this.genericProfilesComposite, 0);
        this.genericProfilesContentPage.init(t, this.parentDialog.getOamObject().getMQObjectType(t));
        OamObject oObject = this.parentDialog.getOamObject();
        String attrOrderId = oObject.getExplorerTableAttributeOrderId(t);
        AttrTypeEnum attrType = oObject.getObjectAuthorities(t);
        if (attrType != null) {
            OamExplorerTableAttributeDetails attrDetails = new OamExplorerTableAttributeDetails(attrType);
            this.oamExplorerTableContentPage = new OamExplorerTableContentPage(t, this.parentDialog, this.explorerTableComposite, attrOrderId, attrDetails, true, true, false, false);
            this.stackLayout.topControl = this.specificProfilesComposite;
            this.stackedComposite.layout();
            this.oamExplorerTree.setGroupsExplorerTable(this.oamExplorerTableContentPage.getGroupsExplorerTable());
            this.oamExplorerTree.setUsersExplorerTable(this.oamExplorerTableContentPage.getUsersExplorerTable());
        } else if (Trace.isTracing) {
            t.data(66, "OamExplorerDialogContentPage.init", 900, "Error getting authorities attribute for " + oObject.toString(t));
        }
        sashForm.setWeights(this.WEIGHTS);
    }

    public OamExplorerTree getOamExplorerTree() {
        return this.oamExplorerTree;
    }

    public void displayContentPage(Trace t) {
        UiAuthorityRecord authRecord = this.parentDialog.getUiAuthorityRecord();
        if (Trace.isTracing) {
            t.data(66, "OamExplorerDialogContentPage.displayContentPage", 300, "Displaying UiAuthorityRecord=" + (Object)((Object)authRecord));
        }
        if (authRecord.isGenericProfilesTreeNode()) {
            this.stackLayout.topControl = this.genericProfilesComposite;
            if (Trace.isTracing) {
                t.data(66, "OamExplorerDialogContentPage.displayContentPage", 300, "Show generics content page");
            }
        } else if (authRecord.isSpecificProfilesTreeNode()) {
            this.stackLayout.topControl = this.specificProfilesComposite;
            if (Trace.isTracing) {
                t.data(66, "OamExplorerDialogContentPage.displayContentPage", 300, "Show specifics content page");
            }
        } else {
            this.stackLayout.topControl = this.explorerTableComposite;
            if (Trace.isTracing) {
                t.data(66, "OamExplorerDialogContentPage.displayContentPage", 300, "Show tabbed explorer table content page");
            }
        }
        if (this.oamExplorerTableContentPage != null) {
            if (authRecord.isGenericProfile()) {
                this.oamExplorerTableContentPage.enableFindButton(t, false);
            } else {
                this.oamExplorerTableContentPage.enableFindButton(t, true);
            }
        }
        this.stackedComposite.layout();
    }
}

