/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.attribute;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.dialog.OamFindDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class OamRecordTypeField {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/attribute/OamRecordTypeField.java";
    private Button authorityRecordsButton = null;
    private Button accumulatedAuthorityButton = null;
    private Listener listener = null;
    private Composite buttonComposite = null;
    private Composite parentComposite = null;
    private OamFindDialog parentDialog = null;
    private int spanColumns = 0;
    private static boolean defaultAccumulated = true;

    public OamRecordTypeField(Trace t, OamFindDialog _dialog, Composite _composite, int _span) {
        this.parentDialog = _dialog;
        this.parentComposite = _composite;
        this.spanColumns = _span;
        this.createRadioButtons(t);
    }

    private void createRadioButtons(Trace t) {
        this.createListener(t);
        this.buttonComposite = new Composite(this.parentComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        this.buttonComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = this.spanColumns;
        gridData.grabExcessHorizontalSpace = true;
        this.buttonComposite.setLayoutData((Object)gridData);
        this.authorityRecordsButton = new Button(this.buttonComposite, 16);
        this.authorityRecordsButton.setText(OamPlugin.oamMessages.getMessage("OAM.Authority.Records"));
        this.authorityRecordsButton.addListener(13, this.listener);
        this.accumulatedAuthorityButton = new Button(this.buttonComposite, 16);
        this.accumulatedAuthorityButton.setText(OamPlugin.oamMessages.getMessage("OAM.Accumulated.Authorities"));
        this.accumulatedAuthorityButton.addListener(13, this.listener);
        if (defaultAccumulated) {
            this.accumulatedAuthorityButton.setSelection(true);
        } else {
            this.authorityRecordsButton.setSelection(true);
        }
    }

    private void createListener(final Trace t) {
        this.listener = new Listener(){

            public void handleEvent(Event e) {
                Control[] children = OamRecordTypeField.this.buttonComposite.getChildren();
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    if (child instanceof Button) {
                        ((Button)child).setSelection(false);
                    }
                    ++i;
                }
                ((Button)e.widget).setSelection(true);
                OamRecordTypeField.this.parentDialog.enableGenericSelection(t);
                OamRecordTypeField.this.parentDialog.enableEntityField(t);
                OamRecordTypeField.this.parentDialog.populateEntityTypeField(t);
                OamRecordTypeField.this.parentDialog.enableFindButton(t);
                defaultAccumulated = OamRecordTypeField.this.accumulatedAuthorityButton.getSelection();
            }
        };
    }

    public boolean isAuthorityRecords(Trace t) {
        if (this.authorityRecordsButton != null) {
            return this.authorityRecordsButton.getSelection();
        }
        return true;
    }

    public boolean isAccumulatedAuthority(Trace t) {
        if (this.accumulatedAuthorityButton != null) {
            return this.accumulatedAuthorityButton.getSelection();
        }
        return false;
    }
}

