/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.attribute;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.dialog.OamDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamFindDialog;
import com.ibm.mq.explorer.oam.internal.object.OamObject;
import com.ibm.mq.explorer.oam.internal.object.OamObjectFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class OamProfileTypeCombo {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/attribute/OamProfileTypeCombo.java";
    private Combo objectTypeCombo = null;
    private OamObject oamObject = null;
    private OamDialog parentDialog = null;

    public OamProfileTypeCombo(Trace t, OamDialog _dialog, Composite _composite, OamObject _oamObject, boolean _enable, boolean _default) {
        this.parentDialog = _dialog;
        this.oamObject = _oamObject;
        this.objectTypeCombo = new Combo(_composite, 8);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.objectTypeCombo.setLayoutData((Object)gridData);
        this.objectTypeCombo.setEnabled(_enable);
        this.addListOfTypes(t);
        if (this.oamObject != null && !_default) {
            this.setSelectedType(t);
        } else {
            this.objectTypeCombo.select(0);
            if (Trace.isTracing) {
                t.data(66, "OamProfileTypeCombo.OamProfileTypeCombo", 300, "Showing first entry in list");
            }
        }
        this.objectTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t1 = Trace.getDefault();
                if (OamProfileTypeCombo.this.parentDialog != null && OamProfileTypeCombo.this.parentDialog instanceof OamFindDialog) {
                    ((OamFindDialog)OamProfileTypeCombo.this.parentDialog).enableProfileName(t1);
                }
            }
        });
    }

    public String getSelectedName() {
        return this.objectTypeCombo.getText();
    }

    private void addListOfTypes(Trace t) {
        OamObject oo = null;
        int[] types = this.oamObject.getDmQueueManager().getValidCrtAuthorities(t);
        if (this.isObjectSupported(types, 14021)) {
            oo = OamObjectFactory.createTempOamObject(t, OamPlugin.oamMessages.getMessage("OAM.Object.Name.Queue"), "com.ibm.mq.explorer.queue");
            this.objectTypeCombo.add(oo.getName(t));
            this.objectTypeCombo.setData(oo.getName(t), (Object)oo);
        }
        if (this.isObjectSupported(types, 14030)) {
            oo = OamObjectFactory.createTempOamObject(t, OamPlugin.oamMessages.getMessage("OAM.Object.Name.Topic"), "com.ibm.mq.explorer.topic");
            this.objectTypeCombo.add(oo.getName(t));
            this.objectTypeCombo.setData(oo.getName(t), (Object)oo);
        }
        if (this.isObjectSupported(types, 14024)) {
            oo = OamObjectFactory.createTempOamObject(t, OamPlugin.oamMessages.getMessage("OAM.Object.Name.QueueManager"), "com.ibm.mq.explorer.queuemanager");
            this.objectTypeCombo.add(oo.getName(t));
            this.objectTypeCombo.setData(oo.getName(t), (Object)oo);
        }
        if (this.isObjectSupported(types, 14025)) {
            oo = OamObjectFactory.createTempOamObject(t, OamPlugin.oamMessages.getMessage("OAM.Object.Name.Channel"), "com.ibm.mq.explorer.channel");
            this.objectTypeCombo.add(oo.getName(t));
            this.objectTypeCombo.setData(oo.getName(t), (Object)oo);
        }
        if (this.isObjectSupported(types, 14026)) {
            oo = OamObjectFactory.createTempOamObject(t, OamPlugin.oamMessages.getMessage("OAM.Object.Name.ClientConn.Channel"), "com.ibm.mq.explorer.clientconn");
            this.objectTypeCombo.add(oo.getName(t));
            this.objectTypeCombo.setData(oo.getName(t), (Object)oo);
        }
        if (this.isObjectSupported(types, 14028)) {
            oo = OamObjectFactory.createTempOamObject(t, OamPlugin.oamMessages.getMessage("OAM.Object.Name.Listener"), "com.ibm.mq.explorer.listener");
            this.objectTypeCombo.add(oo.getName(t));
            this.objectTypeCombo.setData(oo.getName(t), (Object)oo);
        }
        if (this.isObjectSupported(types, 14027)) {
            oo = OamObjectFactory.createTempOamObject(t, OamPlugin.oamMessages.getMessage("OAM.Object.Name.AuthInfo"), "com.ibm.mq.explorer.authinfo");
            this.objectTypeCombo.add(oo.getName(t));
            this.objectTypeCombo.setData(oo.getName(t), (Object)oo);
        }
        if (this.isObjectSupported(types, 14035)) {
            oo = OamObjectFactory.createTempOamObject(t, OamPlugin.oamMessages.getMessage("OAM.Object.Name.CommInfo"), "com.ibm.mq.explorer.comminfo");
            this.objectTypeCombo.add(oo.getName(t));
            this.objectTypeCombo.setData(oo.getName(t), (Object)oo);
        }
        if (this.isObjectSupported(types, 14022)) {
            oo = OamObjectFactory.createTempOamObject(t, OamPlugin.oamMessages.getMessage("OAM.Object.Name.Namelist"), "com.ibm.mq.explorer.namelist");
            this.objectTypeCombo.add(oo.getName(t));
            this.objectTypeCombo.setData(oo.getName(t), (Object)oo);
        }
        if (this.isObjectSupported(types, 14023)) {
            oo = OamObjectFactory.createTempOamObject(t, OamPlugin.oamMessages.getMessage("OAM.Object.Name.Process"), "com.ibm.mq.explorer.proc");
            this.objectTypeCombo.add(oo.getName(t));
            this.objectTypeCombo.setData(oo.getName(t), (Object)oo);
        }
        if (this.isObjectSupported(types, 14029)) {
            oo = OamObjectFactory.createTempOamObject(t, OamPlugin.oamMessages.getMessage("OAM.Object.Name.Service"), "com.ibm.mq.explorer.service");
            this.objectTypeCombo.add(oo.getName(t));
            this.objectTypeCombo.setData(oo.getName(t), (Object)oo);
        }
        if (this.isObjectSupported(types, 14036)) {
            oo = OamObjectFactory.createTempOamObject(t, OamPlugin.oamMessages.getMessage("OAM.Object.Name.RemoteQueueManagerName"), "com.ibm.mq.explorer.rqmname");
            this.objectTypeCombo.add(oo.getName(t));
            this.objectTypeCombo.setData(oo.getName(t), (Object)oo);
        }
    }

    public int getSelectedType(Trace t) {
        int selectedType = 0;
        OamObject o = null;
        if (this.objectTypeCombo != null && (o = (OamObject)this.objectTypeCombo.getData(this.objectTypeCombo.getText())) != null) {
            selectedType = o.getOamObjectType(t);
        }
        return selectedType;
    }

    public OamObject getOamObject(Trace t) {
        OamObject o = null;
        if (this.objectTypeCombo != null) {
            o = (OamObject)this.objectTypeCombo.getData(this.objectTypeCombo.getText());
        }
        return o;
    }

    private void setSelectedType(Trace t) {
        if (this.objectTypeCombo != null && this.oamObject != null) {
            int i = 0;
            while (i < this.objectTypeCombo.getItemCount()) {
                int type;
                String key = this.objectTypeCombo.getItem(i);
                OamObject o = (OamObject)this.objectTypeCombo.getData(key);
                if (o != null && (type = o.getOamObjectType(t)) == this.oamObject.getOamObjectType(t)) {
                    if (Trace.isTracing) {
                        t.data(66, "OamProfileTypeCombo.setSelectedType", 300, "Selected object type : " + type);
                    }
                    this.objectTypeCombo.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    private boolean isObjectSupported(int[] list, int type) {
        boolean valid = false;
        int i = 0;
        while (i < list.length) {
            if (list[i] == type) {
                valid = true;
                break;
            }
            ++i;
        }
        return valid;
    }
}

