/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.attribute;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.oam.internal.attribute.OamGenericProfileCombo;
import com.ibm.mq.explorer.oam.internal.attribute.OamProfileTypeCombo;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.dialog.OamDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamFindDialog;
import com.ibm.mq.explorer.oam.internal.dialog.OamSelectDialog;
import com.ibm.mq.explorer.oam.internal.object.OamObject;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OamProfileNameCombo {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/attribute/OamProfileNameCombo.java";
    private Text selectedName = null;
    private Button selectButton = null;
    private Composite parentComposite = null;
    private Composite composite = null;
    private OamProfileTypeCombo profileTypeCombo = null;
    private OamGenericProfileCombo genericProfileCombo = null;
    private OamDialog parentDialog = null;
    private OamObject oamObject = null;
    private Shell parentShell = null;

    public OamProfileNameCombo(Trace t, OamDialog _dialog, Shell _shell, Composite _composite, String _profileName, OamObject _oamObject, boolean _enable) {
        this.parentDialog = _dialog;
        this.parentComposite = _composite;
        this.oamObject = _oamObject;
        this.parentShell = _shell;
        this.composite = new Composite(this.parentComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.composite.setLayoutData((Object)gridData);
        this.selectedName = new Text(this.composite, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.selectedName.setLayoutData((Object)gridData);
        if (_enable) {
            this.selectedName.setEditable(_enable);
        } else {
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.selectedName, (boolean)true);
        }
        this.selectedName.setTextLimit(48);
        this.selectedName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t2 = Trace.getDefault();
                if (OamProfileNameCombo.this.parentDialog != null && OamProfileNameCombo.this.parentDialog instanceof OamFindDialog) {
                    ((OamFindDialog)OamProfileNameCombo.this.parentDialog).enableFindButton(t2);
                }
            }
        });
        if (_profileName != null) {
            this.selectedName.setText(_profileName);
        }
        this.selectButton = new Button(this.composite, 8);
        this.selectButton.setText(OamPlugin.oamMessages.getMessage("OAM.Button.Select.Text"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        this.selectButton.setLayoutData((Object)gridData);
        this.selectButton.setEnabled(_enable);
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                OamProfileNameCombo.this.launchSelectDialog(t2);
            }
        });
    }

    public String getSelectedName() {
        return this.parentDialog.getTextString(this.selectedName);
    }

    public Button getSelectButton() {
        return this.selectButton;
    }

    private void launchSelectDialog(Trace t) {
        OamObject oa = this.profileTypeCombo.getOamObject(t);
        oa.setDmQueueManager(this.oamObject.getDmQueueManager());
        oa.setUiQueueManager(this.oamObject.getUiQueueManager());
        OamSelectDialog dialog = new OamSelectDialog(t, this.parentShell);
        dialog.setTitle(OamPlugin.oamMessages.getMessage("OAM.Select.Title"));
        dialog.setOamObject(oa);
        if (this.genericProfileCombo != null && this.genericProfileCombo.isGenericProfile(t)) {
            dialog.setGenericProfile(true);
            if (Trace.isTracing) {
                t.data(66, "OamProfileNameCombo.launchSelectDialog", 300, "Will display generic profiles");
            }
        } else if (Trace.isTracing) {
            t.data(66, "OamProfileNameCombo.launchSelectDialog", 300, "Will display specific profiles");
        }
        dialog.setAddOkButton(true);
        dialog.setProfileNameCombo(this);
        dialog.open(t);
    }

    public void setProfileTypeCombo(OamProfileTypeCombo ptc) {
        this.profileTypeCombo = ptc;
    }

    public void setGenericProfileCombo(OamGenericProfileCombo gpc) {
        this.genericProfileCombo = gpc;
    }

    public void setSelectedName(String name) {
        this.selectedName.setText(name);
    }

    public void setEnabled(boolean enable) {
        if (this.selectedName != null) {
            this.selectedName.setEnabled(enable);
        }
        if (this.selectButton != null) {
            this.selectButton.setEnabled(enable);
        }
    }
}

