/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.attribute;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.attribute.OamAttributeDetails;
import com.ibm.mq.explorer.oam.internal.utils.OamSortByDisplaySequence;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import java.util.ArrayList;
import java.util.Collections;

public class OamExplorerTableAttributeDetails
extends OamAttributeDetails {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/attribute/OamExplorerTableAttributeDetails.java";

    public OamExplorerTableAttributeDetails(AttrTypeEnum _attrTypeEnum) {
        super(_attrTypeEnum);
    }

    @Override
    public String getAttributeName(String objectId, int attrId) {
        Trace t = Trace.getDefault();
        String name = null;
        if (objectId.compareTo("com.ibm.mq.explorer.oam.authorityRecord") == 0) {
            name = DmAuthorityRecord.getAttributeTitle((Trace)t, (int)attrId);
        }
        return name;
    }

    @Override
    public AttributeOrderItem[] getDefaultAttributeOrder(Trace t) {
        AttributeOrderItem[] order = null;
        int sequence = 0;
        ArrayList<OamSortByDisplaySequence> sorted = new ArrayList<OamSortByDisplaySequence>();
        if (this.attrType != null) {
            int id;
            Integer[] listOfAuthorities = this.attrType.getEnumerationIds(t);
            int i = 0;
            while (i < listOfAuthorities.length) {
                id = listOfAuthorities[i];
                AttrType at = DmAuthorityRecord.getAttributeType((Trace)t, (int)id);
                if (at != null) {
                    sorted.add(new OamSortByDisplaySequence(t, id, at));
                }
                ++i;
            }
            Collections.sort(sorted);
            order = new AttributeOrderItem[listOfAuthorities.length + 1];
            order[0] = new AttributeOrderItem(t, 3068, DmAuthorityRecord.getAttributeTitle((Trace)t, (int)3068), 0);
            i = 0;
            while (i < sorted.size()) {
                id = ((OamSortByDisplaySequence)sorted.get(i)).getAttributeId();
                String title = DmAuthorityRecord.getAttributeTitle((Trace)t, (int)id);
                order[++sequence] = new AttributeOrderItem(t, id, title, sequence);
                if (Trace.isTracing) {
                    t.data(66, "OamExplorerTableAttributeDetails.getDefaultAttributeOrder", 300, "Attribute id : " + id + ", title : " + title + ", column : " + sequence);
                }
                ++i;
            }
        } else if (Trace.isTracing) {
            t.data(66, "OamExplorerTableAttributeDetails.getDefaultAttributeOrder", 900, "Unable to get attribute order - attr type not set");
        }
        return order;
    }
}

