/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.attribute;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.oam.internal.attribute.OamRecordTypeField;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.dialog.OamFindDialog;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class OamEntityTypeField {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/attribute/OamEntityTypeField.java";
    public static final int TYPE_A_USER = 0;
    public static final int TYPE_A_GROUP = 1;
    public static final int TYPE_ALL_USERS = 2;
    public static final int TYPE_ALL_GROUPS = 3;
    public static final int TYPE_A_USER_OR_GROUP = 4;
    public static final int TYPE_ALL_USERS_OR_GROUPS = -1;
    public static final int STYLE_LABEL = 1;
    public static final int STYLE_BUTTON = 2;
    public static final int STYLE_LIST = 3;
    private Button groupButton = null;
    private Button userButton = null;
    private Listener listener = null;
    private Composite buttonComposite = null;
    private Composite parentComposite = null;
    private OamFindDialog parentDialog = null;
    private boolean selectGroup = false;
    private int spanColumns = 0;
    private int style = 0;
    private boolean usersAndGroups = false;
    private Text entityTypeText = null;
    private Combo entityTypeCombo = null;
    private OamRecordTypeField recordTypeField = null;
    private boolean lastShownAll = false;

    public OamEntityTypeField(Trace t, Composite _parent, int _span, boolean _group, boolean _usersSupported, int _style) {
        this(t, null, _parent, _span, _group, _usersSupported, _style);
    }

    public OamEntityTypeField(Trace t, OamFindDialog _dialog, Composite _parent, int _span, boolean _group, boolean _usersSupported, int _style) {
        this.parentDialog = _dialog;
        this.selectGroup = _group;
        this.parentComposite = _parent;
        this.spanColumns = _span;
        this.usersAndGroups = _usersSupported;
        this.style = _style;
        if (Trace.isTracing) {
            t.data(66, "OamEntityTypeField.constructor", 300, "Span=" + _span + ", group=" + _group + ", usersSupported=" + _usersSupported + ", style=" + _style);
        }
        switch (this.style) {
            case 1: {
                this.createLabel(t);
                break;
            }
            case 2: {
                this.createRadioButtons(t);
                break;
            }
            case 3: {
                this.createComboList(t);
                break;
            }
            default: {
                this.createLabel(t);
            }
        }
    }

    private void createRadioButtons(Trace t) {
        this.createListener(t);
        this.buttonComposite = new Composite(this.parentComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        this.buttonComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = this.spanColumns;
        gridData.grabExcessHorizontalSpace = true;
        this.buttonComposite.setLayoutData((Object)gridData);
        this.groupButton = new Button(this.buttonComposite, 16);
        this.groupButton.setText(OamPlugin.oamMessages.getMessage("OAM.Group.Text"));
        this.groupButton.addListener(13, this.listener);
        this.userButton = new Button(this.buttonComposite, 16);
        this.userButton.setText(OamPlugin.oamMessages.getMessage("OAM.User.Text"));
        this.userButton.addListener(13, this.listener);
        if (this.selectGroup) {
            this.groupButton.setSelection(true);
            if (Trace.isTracing) {
                t.data(66, "OamEntityTypeField.createRadioButtons", 300, "Preselecting group button");
            }
        } else {
            this.userButton.setSelection(true);
            if (Trace.isTracing) {
                t.data(66, "OamEntityTypeField.createRadioButtons", 300, "Preselecting user button");
            }
        }
    }

    public void addRadioButtonListeners(SelectionListener sListener) {
        if (this.isInRadioButtonMode()) {
            this.userButton.addSelectionListener(sListener);
            this.groupButton.addSelectionListener(sListener);
        }
    }

    private void createComboList(Trace t) {
        this.entityTypeCombo = new Combo(this.parentComposite, 8);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = this.spanColumns;
        this.entityTypeCombo.setLayoutData((Object)gridData);
        this.entityTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                if (OamEntityTypeField.this.parentDialog != null) {
                    OamEntityTypeField.this.parentDialog.enableEntityField(t2);
                    OamEntityTypeField.this.parentDialog.enableFindButton(t2);
                }
            }
        });
    }

    private void createLabel(Trace t) {
        this.entityTypeText = new Text(this.parentComposite, 2048);
        this.entityTypeText.setText(this.getEntityTypeString(t));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = this.spanColumns;
        this.entityTypeText.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.entityTypeText, (boolean)true);
    }

    private void createListener(Trace t) {
        this.listener = new Listener(){

            public void handleEvent(Event e) {
                Control[] children = OamEntityTypeField.this.buttonComposite.getChildren();
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    if (child instanceof Button) {
                        ((Button)child).setSelection(false);
                    }
                    ++i;
                }
                ((Button)e.widget).setSelection(true);
            }
        };
    }

    private String getEntityTypeString(Trace t) {
        String entityType = null;
        if (this.selectGroup) {
            entityType = OamPlugin.oamMessages.getMessage("OAM.Group.Text");
            if (Trace.isTracing) {
                t.data(66, "OamEntityTypeField.getEntityTypeString", 300, "Entity type=group");
            }
        } else {
            entityType = OamPlugin.oamMessages.getMessage("OAM.User.Text");
            if (Trace.isTracing) {
                t.data(66, "OamEntityTypeField.getEntityTypeString", 300, "Entity type=user");
            }
        }
        return entityType;
    }

    public boolean isUserSelected(Trace t) {
        if (this.style == 3) {
            return this.entityTypeCombo != null && this.getEntityType(t) == 1;
        }
        if (this.userButton != null) {
            return this.userButton.getSelection();
        }
        return !this.selectGroup;
    }

    public boolean isGroupSelected(Trace t) {
        if (this.style == 3) {
            return this.entityTypeCombo != null && this.getEntityType(t) == 2;
        }
        if (this.userButton != null) {
            return this.groupButton.getSelection();
        }
        return this.selectGroup;
    }

    public int getEntityType(Trace t) {
        int selection = -1;
        if (this.entityTypeCombo != null) {
            int index = this.entityTypeCombo.getSelectionIndex();
            if (Trace.isTracing) {
                t.data(66, "OamEntityTypeField.getEntityType", 300, "Selected index = " + index);
            }
            String key = this.entityTypeCombo.getItem(index);
            if (Trace.isTracing) {
                t.data(66, "OamEntityTypeField.getEntityType", 300, "Selected key = " + key);
            }
            Integer value = (Integer)this.entityTypeCombo.getData(key);
            if (Trace.isTracing) {
                t.data(66, "OamEntityTypeField.getEntityType", 300, "Selected value = " + value);
            }
            switch (value) {
                case 1: 
                case 3: {
                    selection = 2;
                    break;
                }
                case 0: 
                case 2: {
                    selection = 1;
                }
            }
        } else if (Trace.isTracing) {
            t.data(66, "OamEntityTypeField.getEntityType", 900, "Combo dropdown list not defined");
        }
        return selection;
    }

    public boolean isMultiEntity(Trace t) {
        boolean multi = false;
        if (this.entityTypeCombo != null) {
            try {
                int index = this.entityTypeCombo.getSelectionIndex();
                if (Trace.isTracing) {
                    t.data(66, "OamEntityTypeField.isMultiEntity", 300, "Selected index = " + index);
                }
                String key = this.entityTypeCombo.getItem(index);
                if (Trace.isTracing) {
                    t.data(66, "OamEntityTypeField.isMultiEntity", 300, "Selected key = " + key);
                }
                Integer value = (Integer)this.entityTypeCombo.getData(key);
                if (Trace.isTracing) {
                    t.data(66, "OamEntityTypeField.isMultiEntity", 300, "Selected value = " + value);
                }
                switch (value) {
                    case 0: 
                    case 1: 
                    case 4: {
                        multi = false;
                        break;
                    }
                    default: {
                        multi = true;
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (Trace.isTracing) {
                    t.data(66, "OamEntityTypeField.isMultiEntity", 900, "Error getting item from combo dropdown list\n" + e);
                }
            }
        } else if (Trace.isTracing) {
            t.data(66, "OamEntityTypeField.isMultiEntity", 900, "Combo dropdown list not defined");
        }
        if (Trace.isTracing) {
            t.data(66, "OamEntityTypeField.isMultiEntity", 300, "Multi entity = " + multi);
        }
        return multi;
    }

    public void setRecordTypeField(OamRecordTypeField rcf) {
        this.recordTypeField = rcf;
    }

    public void populateComboList(Trace t) {
        if (this.recordTypeField != null && this.recordTypeField.isAccumulatedAuthority(t) || this.usersAndGroups) {
            if (!this.lastShownAll) {
                this.lastShownAll = true;
                this.entityTypeCombo.removeAll();
                this.entityTypeCombo.add(OamPlugin.oamMessages.getMessage("OAM.A.User"));
                this.entityTypeCombo.setData(OamPlugin.oamMessages.getMessage("OAM.A.User"), (Object)0);
                this.entityTypeCombo.add(OamPlugin.oamMessages.getMessage("OAM.A.Group"));
                this.entityTypeCombo.setData(OamPlugin.oamMessages.getMessage("OAM.A.Group"), (Object)1);
                if (this.parentDialog.getDmQueueManager().isOamUseridsSupported()) {
                    this.entityTypeCombo.add(OamPlugin.oamMessages.getMessage("OAM.A.User.Or.Group"));
                    this.entityTypeCombo.setData(OamPlugin.oamMessages.getMessage("OAM.A.User.Or.Group"), (Object)4);
                    this.entityTypeCombo.add(OamPlugin.oamMessages.getMessage("OAM.All.Users"));
                    this.entityTypeCombo.setData(OamPlugin.oamMessages.getMessage("OAM.All.Users"), (Object)2);
                }
                this.entityTypeCombo.add(OamPlugin.oamMessages.getMessage("OAM.All.Groups"));
                this.entityTypeCombo.setData(OamPlugin.oamMessages.getMessage("OAM.All.Groups"), (Object)3);
                if (this.parentDialog.getDmQueueManager().isOamUseridsSupported()) {
                    this.entityTypeCombo.add(OamPlugin.oamMessages.getMessage("OAM.All.Users.Or.Groups"));
                    this.entityTypeCombo.setData(OamPlugin.oamMessages.getMessage("OAM.All.Users.Or.Groups"), (Object)-1);
                }
                this.entityTypeCombo.select(0);
            }
        } else {
            this.lastShownAll = false;
            this.entityTypeCombo.removeAll();
            this.entityTypeCombo.add(OamPlugin.oamMessages.getMessage("OAM.A.Group"));
            this.entityTypeCombo.setData(OamPlugin.oamMessages.getMessage("OAM.A.Group"), (Object)1);
            this.entityTypeCombo.add(OamPlugin.oamMessages.getMessage("OAM.All.Groups"));
            this.entityTypeCombo.setData(OamPlugin.oamMessages.getMessage("OAM.All.Groups"), (Object)3);
            this.entityTypeCombo.select(0);
        }
        this.parentDialog.enableEntityField(t);
        this.parentDialog.enableFindButton(t);
    }

    public boolean isInRadioButtonMode() {
        return this.userButton != null;
    }
}

