/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.controls.EditFiltersComposite;
import com.ibm.mq.explorer.qmgradmin.sets.internal.controls.FiltersChangedEvent;
import com.ibm.mq.explorer.qmgradmin.sets.internal.controls.IFiltersChangedListener;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.UiQmgrAdminSet;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetNewObjectProvider;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetProvider;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.SetsWizPage;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class NewSetWizardPage3
extends SetsWizPage
implements IFiltersChangedListener {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/wizards/NewSetWizardPage3.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final int NUM_COLS = 1;
    private EditFiltersComposite editFiltersComposite = null;
    private int matchRule = 0;
    private NewObjectWiz newObjectWiz = null;
    private Message msgFile = null;
    private ArrayList<Filter> selectedFilters = null;
    private boolean isValidSelection = true;
    private boolean firstOpen = true;

    public NewSetWizardPage3(String pageId, NewObjectWiz wizard) {
        super(pageId);
        Trace t = Trace.getDefault();
        this.newObjectWiz = wizard;
        this.selectedFilters = new ArrayList();
        this.msgFile = SetsPlugin.getMessages(t);
    }

    public NewSetWizardPage3(String pageId, String title, ImageDescriptor titleImage, NewObjectWiz wizard) {
        super(pageId, title, titleImage);
        Trace t = Trace.getDefault();
        this.newObjectWiz = wizard;
        this.msgFile = SetsPlugin.getMessages(t);
    }

    public void createPageContent(Trace t, Composite parent) {
        super.setHeadings(this.msgFile.getMessage("Sets.Wizard.CreateASet"), this.msgFile.getMessage("Sets.Wizard.SelectFilters"));
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        SetNewObjectProvider setNewObjectProvider = (SetNewObjectProvider)this.newObjectWiz.getNewObjectProvider();
        this.editFiltersComposite = new EditFiltersComposite(parent, 0, setNewObjectProvider.getSetProvider());
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        this.editFiltersComposite.setLayoutData(gridData);
        this.editFiltersComposite.setMatchRule(t, this.matchRule);
        this.editFiltersComposite.setFilters(t, this.selectedFilters);
        this.editFiltersComposite.addFiltersChangedListener(t, this);
    }

    public boolean performFinish() {
        Trace t = Trace.getDefault();
        SetNewObjectProvider setNewObjectProvider = (SetNewObjectProvider)this.newObjectWiz.getNewObjectProvider();
        SetProvider setProvider = setNewObjectProvider.getSetProvider();
        UiQmgrAdminSet uiSet = setProvider.createSet(t);
        uiSet.setName(t, this.newObjectWiz.getNewObjectName());
        uiSet.setMembershipType(t, 1);
        uiSet.setMatchRule(this.editFiltersComposite.getMatchRule());
        uiSet.setFilters(this.editFiltersComposite.getFilters());
        uiSet.resetUniversalId(t);
        uiSet.setDisposition(1);
        setNewObjectProvider.setCreatedSet(uiSet);
        return true;
    }

    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        boolean enableNext = false;
        boolean enableFinish = !this.selectedFilters.isEmpty() && this.isValidSelection;
        this.setPageComplete(enableNext);
        this.newObjectWiz.setEnableFinish(enableFinish);
        this.newObjectWiz.updateButtons(t);
    }

    public void nextPressed() {
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 1);
    }

    @Override
    public void changed(FiltersChangedEvent e) {
        Trace t = Trace.getDefault();
        this.selectedFilters = e.getSelectedFilters();
        this.isValidSelection = e.isValidSelection();
        if (!this.firstOpen && this.selectedFilters.size() == 0) {
            this.setErrorMessage(SetsPlugin.getNLSString(t, "Sets.Message.No.Filters.Selected"));
        } else if (!this.isValidSelection) {
            this.setErrorMessage(SetsPlugin.getNLSString(t, "Sets.Message.Invalid.Filter.Selection"));
        } else {
            this.setErrorMessage(null);
        }
        this.checkIfEnableButtons();
        this.firstOpen = false;
    }

    @Override
    public void setActive(Trace t, boolean active) {
        if (active) {
            this.firstOpen = true;
            Button button = this.editFiltersComposite.getSelectedRadioButton(t);
            if (button != null) {
                button.setFocus();
            }
        }
        this.editFiltersComposite.setActive(t);
        this.checkIfEnableButtons();
    }
}

