/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.UiQmgrAdminSet;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetNewObjectProvider;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetProvider;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.SetsWizPage;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewSetWizardPage1
extends SetsWizPage {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/wizards/NewSetWizardPage1.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final int NUM_COLS = 1;
    private NewObjectWiz newObjectWiz = null;
    private Text textName = null;
    private Button radioManual = null;
    private Button radioAutomatic = null;
    private int setType = 0;
    private Message msgFile = null;
    private ArrayList<UiQmgrAdminSet> existingSets = null;
    private String allSetName = null;
    private boolean firstOpen = true;

    public NewSetWizardPage1(String pageId, NewObjectWiz wizard) {
        super(pageId);
        Trace t = Trace.getDefault();
        this.newObjectWiz = wizard;
        this.msgFile = SetsPlugin.getMessages(t);
        SetNewObjectProvider setNewObjectProvider = (SetNewObjectProvider)this.newObjectWiz.getNewObjectProvider();
        this.existingSets = setNewObjectProvider.getExistingSets();
        this.allSetName = SetsPlugin.getNLSString(t, "Sets.SetName.All");
    }

    public NewSetWizardPage1(String pageId, String title, ImageDescriptor titleImage, NewObjectWiz wizard) {
        super(pageId, title, titleImage);
        Trace t = Trace.getDefault();
        this.newObjectWiz = wizard;
        this.msgFile = SetsPlugin.getMessages(t);
    }

    public void createPageContent(Trace t, Composite parent) {
        super.setHeadings(this.msgFile.getMessage("Sets.Wizard.CreateASet"), this.msgFile.getMessage("Sets.Wizard.SelectNameAndType"));
        SetNewObjectProvider provider = (SetNewObjectProvider)((NewObjectWiz)this.getWizard()).getNewObjectProvider();
        int createOptions = provider.getCreateOption();
        boolean enableManual = true;
        boolean enableAutomatic = true;
        if (createOptions == 1) {
            enableAutomatic = false;
        } else if (createOptions == 2) {
            enableManual = false;
        }
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        label.setText(this.msgFile.getMessage("Sets.Wizard.Name"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.textName = new Text(parent, 2048);
        this.textName.setTextLimit(48);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.textName.setLayoutData((Object)gridData);
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSetWizardPage1.this.checkIfEnableButtons();
            }
        });
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        Group groupType = new Group(parent, 0);
        groupType.setText(this.msgFile.getMessage("Sets.Wizard.SelectType"));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        groupType.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        groupType.setLayout((Layout)gridLayout);
        this.radioManual = new Button((Composite)groupType, 16);
        this.radioManual.setText(this.msgFile.getMessage("Sets.Wizard.TypeManual"));
        if (enableManual) {
            if (enableAutomatic) {
                this.radioManual.setSelection(this.setType == 0);
            } else {
                this.radioManual.setSelection(true);
            }
        } else {
            this.radioManual.setEnabled(false);
            this.radioManual.setSelection(false);
        }
        gridData = new GridData();
        this.radioManual.setLayoutData((Object)gridData);
        this.radioManual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSetWizardPage1.this.setType = 0;
                NewSetWizardPage1.this.typeSelectionChanged(Trace.getDefault());
            }
        });
        this.radioAutomatic = new Button((Composite)groupType, 16);
        this.radioAutomatic.setText(this.msgFile.getMessage("Sets.Wizard.TypeAutomatic"));
        if (enableAutomatic) {
            if (enableManual) {
                this.radioAutomatic.setSelection(this.setType == 1);
            } else {
                this.radioAutomatic.setSelection(true);
            }
        } else {
            this.radioAutomatic.setEnabled(false);
            this.radioAutomatic.setSelection(false);
        }
        gridData = new GridData();
        this.radioAutomatic.setLayoutData((Object)gridData);
        this.radioAutomatic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSetWizardPage1.this.setType = 1;
                NewSetWizardPage1.this.typeSelectionChanged(Trace.getDefault());
            }
        });
        UiUtils.createBlankLine((Composite)parent, (int)1);
    }

    public boolean performFinish() {
        Trace t = Trace.getDefault();
        SetNewObjectProvider setNewObjectProvider = (SetNewObjectProvider)this.newObjectWiz.getNewObjectProvider();
        SetProvider setProvider = setNewObjectProvider.getSetProvider();
        UiQmgrAdminSet uiSet = setProvider.createSet(t);
        uiSet.setName(t, this.textName.getText());
        uiSet.setMembershipType(t, 0);
        uiSet.resetUniversalId(t);
        uiSet.setDisposition(1);
        SetNewObjectProvider provider = (SetNewObjectProvider)((NewObjectWiz)this.getWizard()).getNewObjectProvider();
        MQExtObject[] preselectMembers = provider.getPreselectMembers();
        if (preselectMembers != null) {
            int i = 0;
            while (i < preselectMembers.length) {
                uiSet.addObject(t, preselectMembers[i]);
                ++i;
            }
        }
        setNewObjectProvider.setCreatedSet(uiSet);
        return true;
    }

    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        boolean enableNext = false;
        boolean enableFinish = false;
        String name = this.textName.getText();
        if (name.length() > 0) {
            if (!this.isNameUnique(t)) {
                this.setErrorMessage(this.msgFile.getMessage(t, "Sets.Dialog.NameInUseMsg"));
            } else if (name.compareToIgnoreCase(this.allSetName) == 0) {
                this.setErrorMessage(this.msgFile.getMessage(t, "Sets.Dialog.NameReserved"));
            } else {
                this.setErrorMessage(null);
                this.newObjectWiz.setNewObjectName(name);
                if (this.setType == 0) {
                    enableFinish = true;
                    enableNext = true;
                } else {
                    enableFinish = false;
                    enableNext = true;
                }
            }
        } else if (!this.firstOpen) {
            this.setErrorMessage(this.msgFile.getMessage(t, "Sets.Dialog.NoNameMsg"));
        }
        this.setPageComplete(enableNext);
        this.newObjectWiz.setEnableFinish(enableFinish);
        this.newObjectWiz.updateButtons(t);
        this.firstOpen = false;
    }

    public void nextPressed() {
        this.newObjectWiz.setNewObjectName(this.textName.getText());
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 1);
    }

    protected void typeSelectionChanged(Trace t) {
        String pageId = "com.ibm.mq.explorer.qmgradmin.sets.page2";
        if (this.setType == 1) {
            pageId = "com.ibm.mq.explorer.qmgradmin.sets.page3";
        }
        ((NewObjectWiz)super.getWizard()).setNextPage(t, pageId);
        this.checkIfEnableButtons();
    }

    private boolean isNameUnique(Trace t) {
        boolean unique = true;
        String newName = this.textName.getText();
        for (UiQmgrAdminSet uiSet : this.existingSets) {
            int disposition = uiSet.getDisposition();
            if (disposition == 4 || disposition == 2 || disposition == 5 || uiSet.getName().compareToIgnoreCase(newName) != 0) continue;
            unique = false;
        }
        return unique;
    }

    @Override
    public void setActive(Trace t, boolean active) {
        if (active) {
            this.typeSelectionChanged(t);
        }
    }
}

