/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.qmgrs.ConnDetailsReconnectToQmgrs;
import com.ibm.mq.explorer.qmgradmin.sets.internal.qmgrs.ConnDetailsViewerFilter;
import com.ibm.mq.explorer.qmgradmin.sets.internal.qmgrs.UiQmgrsSet;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.ConnDetailsQmgrWiz;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.ConnDetailsQmgrWizDlg;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.SetsWizPage;
import com.ibm.mq.explorer.ui.internal.base.ObjectRegistrationManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.CheckedSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.controls.ICheckedSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.controls.SelectUiMQObject;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ConnDetailsQmgrWizPage5
extends SetsWizPage
implements ICheckedSelectionChangedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/wizards/ConnDetailsQmgrWizPage5.java";
    private static final String PROMPT_TO_DISCONNECT = "AMQ4611";
    private ConnDetailsQmgrWiz wizard = null;
    private String titleText = null;
    private String descriptionText = null;
    private Message msgFile = null;
    private SelectUiMQObject selectUiMQObject = null;
    private UiMQObject[] selectedObjects = null;
    private ConnDetailsViewerFilter viewerFilter = null;
    private ArrayList<DmQueueManager> listOfQueueManagers = new ArrayList();

    public ConnDetailsQmgrWizPage5(Trace t, String pageName) {
        super(pageName);
        this.setHeadingsInfo(t);
    }

    public ConnDetailsQmgrWizPage5(Trace t, String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setHeadingsInfo(t);
    }

    private void setHeadingsInfo(Trace t) {
        if (this.titleText == null) {
            this.msgFile = SetsPlugin.getMessages(t);
            this.titleText = this.msgFile.getMessage(t, "Sets.Conn.Details.Wizard.Page5.Title");
            this.descriptionText = this.msgFile.getMessage(t, "Sets.Conn.Details.Wizard.Page5.Desc");
        }
        super.setHeadings(this.titleText, this.descriptionText);
    }

    public void createPageContent(Trace t, Composite parent) {
        this.wizard = (ConnDetailsQmgrWiz)this.getWizard();
        this.viewerFilter = new ConnDetailsViewerFilter(t, this.getWizardDialog().getSelectedSet());
        this.selectUiMQObject = new SelectUiMQObject(t, parent, 0, 2);
        this.selectUiMQObject.setNoObjectMessage(t, 1, this.msgFile.getMessage("Sets.Dialog.NoQmgrsAvailable"));
        this.selectUiMQObject.createContent(t, null, "com.ibm.mq.explorer.queuemanagerhandle", UiPlugin.getNLSString((Trace)t, (String)"KEY_Queue Manager", (String)"UI.OBJECT.Type.QueueManager"), "com.ibm.mq.explorer.orderid.qmgrhandle", false, null, null, null, (ViewerFilter)this.viewerFilter, false, true);
        this.selectUiMQObject.listenToDataModel(t, null, 2, ObjectRegistrationManager.getUiMQObjectFactory((Trace)t, (String)"com.ibm.mq.explorer.queuemanagerhandle"), null);
        this.selectUiMQObject.addCheckedSelectionChangedListener((ICheckedSelectionChangedListener)this);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        this.selectUiMQObject.setLayoutData((Object)gridData);
    }

    public boolean performFinish() {
        Trace t = Trace.getDefault();
        if (this.checkConnectedQueueManager(t)) {
            SetsWizPage page = (SetsWizPage)this.wizard.getPage1();
            page.performFinish();
            page = (SetsWizPage)this.wizard.getPage2();
            page.performFinish();
            page = (SetsWizPage)this.wizard.getPage3();
            page.performFinish();
            page = (SetsWizPage)this.wizard.getPage4();
            page.performFinish();
            if (this.listOfQueueManagers.size() > 0) {
                UiPlugin.getDisplay().asyncExec(new Runnable(){
                    final UiQmgrsSet set;
                    {
                        this.set = ConnDetailsQmgrWizPage5.this.wizard.getWizardDialog().getSelectedSet();
                    }

                    @Override
                    public void run() {
                        Trace t1 = Trace.getDefault();
                        ConnDetailsReconnectToQmgrs dlg = new ConnDetailsReconnectToQmgrs(t1, UiPlugin.getShell(), 0);
                        dlg.setValues(t1, this.set);
                        dlg.setQms(ConnDetailsQmgrWizPage5.this.listOfQueueManagers);
                        dlg.create(t1);
                        dlg.open(t1);
                    }
                });
            }
        }
        return true;
    }

    public void checkIfEnableButtons() {
        boolean enable = false;
        if (this.selectedObjects != null && this.selectedObjects.length > 0) {
            enable = true;
        }
        this.wizard.setEnableFinish(enable);
        this.setPageComplete(false);
        this.wizard.updateButtons();
    }

    public void nextPressed() {
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 1);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public ConnDetailsQmgrWizDlg getWizardDialog() {
        return this.wizard.getWizardDialog();
    }

    @Override
    public void setActive(Trace t, boolean active) {
        if (active) {
            this.selectUiMQObject.removeAll(t);
            this.selectUiMQObject.startListening(t);
        } else {
            this.selectUiMQObject.stopListening(t);
        }
    }

    public void changed(CheckedSelectionChangedEvent e) {
        this.selectedObjects = e.getCheckedObjects();
        this.checkIfEnableButtons();
    }

    public UiMQObject[] getSelectedObjects(Trace t) {
        return this.selectedObjects;
    }

    private boolean checkConnectedQueueManager(Trace t) {
        boolean retValue = true;
        boolean anyConnected = false;
        int i = 0;
        while (i < this.selectedObjects.length) {
            DmQueueManagerHandle dmObject = (DmQueueManagerHandle)this.selectedObjects[i].getDmObject();
            if (dmObject.getQueueManager().isConnected()) {
                anyConnected = true;
                break;
            }
            ++i;
        }
        if (anyConnected && MessageBox.showYesNoMessage((Trace)t, (Shell)this.getShell(), (String)CommonServices.getSystemMessage((String)PROMPT_TO_DISCONNECT), (int)1, null) == 1) {
            retValue = false;
        }
        if (anyConnected && retValue) {
            this.disconnectQueueManagers(t);
        }
        return retValue;
    }

    private void disconnectQueueManagers(Trace t) {
        this.listOfQueueManagers.clear();
        int i = 0;
        while (i < this.selectedObjects.length) {
            DmQueueManagerHandle dmObject = (DmQueueManagerHandle)this.selectedObjects[i].getDmObject();
            if (dmObject.getQueueManager().isConnected()) {
                this.listOfQueueManagers.add(dmObject.getQueueManager());
                dmObject.getQueueManager().disconnectAsync(t, 0);
            }
            ++i;
        }
    }
}

