/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.ConnDetailsQmgrWiz;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.ConnDetailsQmgrWizDlg;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.ConnDetailsQmgrWizPage5;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.SetsWizPage;
import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsSSLOptions;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.SSLPeerNameTextWrapper;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class ConnDetailsQmgrWizPage4
extends SetsWizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/wizards/ConnDetailsQmgrWizPage4.java";
    private static final int IGNORE_RESET_COUNT = -1;
    private ConnDetailsQmgrWiz wizard = null;
    private String titleText = null;
    private String descriptionText = null;
    private Message msgFile = null;
    private SSLPeerNameTextWrapper textPeerName = null;
    private Spinner spinnerResetCount = null;
    private ExtCombo comboCipherSuites = null;
    private Button buttonEnable = null;
    private ConnectionDetailsSSLOptions sslOptionsComposite = null;
    public static final String NO_CIPHER_CHANGE_FOR_CCDT = "AMQ4633";

    public ConnDetailsQmgrWizPage4(Trace t, String pageName) {
        super(pageName);
        this.setHeadingsInfo(t);
    }

    public ConnDetailsQmgrWizPage4(Trace t, String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setHeadingsInfo(t);
    }

    private void setHeadingsInfo(Trace t) {
        if (this.titleText == null) {
            this.msgFile = SetsPlugin.getMessages(t);
            this.titleText = this.msgFile.getMessage(t, "Sets.Conn.Details.Wizard.Page4.Title");
            this.descriptionText = this.msgFile.getMessage(t, "Sets.Conn.Details.Wizard.Page4.Desc");
        }
        super.setHeadings(this.titleText, this.descriptionText);
    }

    public void createPageContent(Trace t, Composite parent) {
        this.wizard = (ConnDetailsQmgrWiz)this.getWizard();
        this.processConnDetailsWarning(t, parent, this.msgFile);
        this.sslOptionsComposite = new ConnectionDetailsSSLOptions(parent, 0, 1, false);
        this.textPeerName = this.sslOptionsComposite.getTextPeerName();
        this.comboCipherSuites = this.sslOptionsComposite.getComboCipherSuites();
        this.spinnerResetCount = this.sslOptionsComposite.getSpinnerResetCount();
        this.buttonEnable = this.sslOptionsComposite.getButtonEnable();
        this.loadCurrentSettings(t);
    }

    public boolean performFinish() {
        block10: {
            Trace t = Trace.getDefault();
            ConnDetailsQmgrWizPage5 page = (ConnDetailsQmgrWizPage5)this.wizard.getPage5();
            UiMQObject[] selectedObjects = page.getSelectedObjects(t);
            String cipher = this.getCipherSuite(t);
            String peername = this.getPeerName(t);
            int resetcount = this.getResetCount(t);
            if (cipher == null && peername == null && resetcount == -1) break block10;
            boolean hasShownCCDTWarning = false;
            int i = 0;
            while (i < selectedObjects.length) {
                block13: {
                    boolean isCCDT;
                    DmObject dmObject;
                    block11: {
                        block12: {
                            dmObject = (DmObject)selectedObjects[i].getDmObject();
                            isCCDT = false;
                            if (!(dmObject instanceof DmQueueManagerHandle)) break block11;
                            if (!((DmQueueManagerHandle)dmObject).isConnectionTypeChanDefTable(t)) break block12;
                            isCCDT = true;
                            break block11;
                        }
                        if (((DmQueueManagerHandle)dmObject).getQueueManagerHandle(t).getConnectionType() != 2) break block13;
                    }
                    Object job = dmObject.beginUpdate(t);
                    if (cipher != null && !cipher.equals(dmObject.getAttributeValue(t, 11020, 0))) {
                        if (!isCCDT) {
                            dmObject.setAttributeValue(t, job, 11020, 0, (Object)cipher, true);
                        } else if (!hasShownCCDTWarning) {
                            MessageBox.showSystemMessageById((Trace)t, (Shell)this.getShell(), (String)NO_CIPHER_CHANGE_FOR_CCDT);
                            hasShownCCDTWarning = true;
                        }
                    }
                    if (peername != null && !peername.equals(dmObject.getAttributeValue(t, 11023, 0))) {
                        dmObject.setAttributeValue(t, job, 11023, 0, (Object)peername, true);
                    }
                    if (resetcount != -1 && resetcount != Integer.parseInt(dmObject.getAttributeValue(t, 11022, 0))) {
                        dmObject.setAttributeValue(t, job, 11022, 0, (Object)resetcount, true);
                    }
                    dmObject.actionChange(t, null, job, false);
                }
                ++i;
            }
        }
        return true;
    }

    public void checkIfEnableButtons() {
        boolean enable = true;
        if (this.sslOptionsComposite.getButtonEnable().getSelection() && this.sslOptionsComposite.getComboCipherSuites().getText().equals("")) {
            enable = false;
        }
        this.setPageComplete(enable);
        this.wizard.setEnableFinish(false);
        this.wizard.updateButtons();
    }

    public void nextPressed() {
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 1);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.enableOptions(Trace.getDefault());
    }

    public IWizardPage getNextPage() {
        return this.wizard.getPage5();
    }

    public ConnDetailsQmgrWizDlg getWizardDialog() {
        return this.wizard.getWizardDialog();
    }

    private void loadCurrentSettings(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        this.textPeerName.setText(store.getString("SSLPeerName"));
        this.sslOptionsComposite.setFIPSRequired(t, store.getInt("SSLFIPSRequired"));
        this.sslOptionsComposite.setCipherSuite(t, store.getString("SSLCipherSuite"));
        this.spinnerResetCount.setSelection(store.getInt("SSLResetCount"));
        this.buttonEnable.setSelection(store.getBoolean("SSLOptionsEnabled"));
        if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage4.loadCurrentSettings", 300, "Loaded current SSL options" + Common.NEW_LINE + "cipher suite = " + this.comboCipherSuites.getText() + Common.NEW_LINE + "peer name = " + this.textPeerName.getText() + Common.NEW_LINE + "FIPS required = " + this.sslOptionsComposite.getFIPSRequired(t) + Common.NEW_LINE + "reset count = " + this.spinnerResetCount.getSelection() + Common.NEW_LINE + "button = " + this.buttonEnable.getSelection());
        }
        this.sslOptionsComposite.enableControls(t);
        this.buttonEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnDetailsQmgrWizPage4.this.checkIfEnableButtons();
            }
        });
        this.comboCipherSuites.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnDetailsQmgrWizPage4.this.checkIfEnableButtons();
            }
        });
        this.enableOptions(t);
    }

    @Override
    public void setActive(Trace t, boolean active) {
    }

    public String getCipherSuite(Trace t) {
        String name = null;
        if (this.buttonEnable.getSelection()) {
            String s = this.comboCipherSuites.getText();
            name = (String)this.comboCipherSuites.getData(s);
        } else if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage4.getCipherSuite", 900, "SSL options page disabled");
        }
        return name;
    }

    public String getPeerName(Trace t) {
        String name = null;
        if (this.buttonEnable.getSelection()) {
            name = this.textPeerName.getText();
        } else if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage4.getPeerName", 900, "SSL options page disabled");
        }
        return name;
    }

    public int getResetCount(Trace t) {
        int count = -1;
        if (this.buttonEnable.getSelection()) {
            count = this.spinnerResetCount.getSelection();
        } else if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage4.getResetCount", 900, "SSL options page disabled");
        }
        return count;
    }

    private void enableOptions(Trace t) {
        SetsWizPage page = (SetsWizPage)this.wizard.getPreviousPage((IWizardPage)this);
        if (page.isPagePropertiesEnabled(t)) {
            this.buttonEnable.setEnabled(true);
        } else {
            this.buttonEnable.setEnabled(false);
            this.buttonEnable.setSelection(false);
        }
    }
}

