/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.preferences.PreferencePagePasswords;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.ConnDetailsQmgrWiz;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.ConnDetailsQmgrWizDlg;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.ConnDetailsQmgrWizPage5;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.SetsWizPage;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsSSLStores;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.passwords.PwUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class ConnDetailsQmgrWizPage3
extends SetsWizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/wizards/ConnDetailsQmgrWizPage3.java";
    private ConnDetailsQmgrWiz wizard = null;
    private String titleText = null;
    private String descriptionText = null;
    private Message msgFile = null;
    private Text textTrustedStore = null;
    private Text textPersonalStore = null;
    private Button buttonEnable = null;
    private ConnectionDetailsSSLStores sslStoresComposite = null;
    private Text textTrustedPassword = null;
    private Text textPersonalPassword = null;
    private Link[] linkPasswordWarnings = null;

    public ConnDetailsQmgrWizPage3(Trace t, String pageName) {
        super(pageName);
        this.setHeadingsInfo(t);
    }

    public ConnDetailsQmgrWizPage3(Trace t, String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setHeadingsInfo(t);
    }

    private void setHeadingsInfo(Trace t) {
        if (this.titleText == null) {
            this.msgFile = SetsPlugin.getMessages(t);
            this.titleText = this.msgFile.getMessage(t, "Sets.Conn.Details.Wizard.Page3.Title");
            this.descriptionText = this.msgFile.getMessage(t, "Sets.Conn.Details.Wizard.Page3.Desc");
        }
        super.setHeadings(this.titleText, this.descriptionText);
    }

    public void createPageContent(Trace t, Composite parent) {
        this.wizard = (ConnDetailsQmgrWiz)this.getWizard();
        this.processConnDetailsWarning(t, parent, this.msgFile);
        this.sslStoresComposite = new ConnectionDetailsSSLStores(parent, 0, 1);
        this.sslStoresComposite.setPasswordValidation(false);
        this.textPersonalStore = this.sslStoresComposite.getTextPersonalStore();
        this.textTrustedStore = this.sslStoresComposite.getTextTrustedStore();
        this.textTrustedPassword = this.sslStoresComposite.getTextTrustedPassword();
        this.textPersonalPassword = this.sslStoresComposite.getTextPersonalPassword();
        this.buttonEnable = this.sslStoresComposite.getButtonEnable();
        this.loadCurrentSettings(t);
        Link[] linkArray = this.linkPasswordWarnings = this.sslStoresComposite.getPasswordWarningLinks();
        int n = this.linkPasswordWarnings.length;
        int n2 = 0;
        while (n2 < n) {
            Link currentLink = linkArray[n2];
            currentLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t2 = Trace.getDefault();
                    PreferencePagePasswords.openPasswordPreferencePage((Trace)t2);
                    ConnDetailsQmgrWizPage3.this.checkPasswordPreference(t2);
                }
            });
            ++n2;
        }
        this.checkPasswordPreference(t);
    }

    public boolean performFinish() {
        block26: {
            Trace t = Trace.getDefault();
            ConnDetailsQmgrWizPage5 page = (ConnDetailsQmgrWizPage5)this.wizard.getPage5();
            UiMQObject[] selectedObjects = page.getSelectedObjects(t);
            String trusted = this.getTrustedStore(t);
            String trustedpw = this.getTrustedStorePassword(t);
            String personal = this.getPersonalStore(t);
            String personalpw = this.getPersonalStorePassword(t);
            if (trusted == null && trustedpw == null && personal == null && personalpw == null) break block26;
            if (Trace.isTracing) {
                t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Security Connection Details Page3 Values Changed...");
                t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Number of Items to Change/Update: " + selectedObjects.length + ".");
            }
            String titleQM = null;
            int iRetVal = 0;
            boolean bRetVal = false;
            int i = 0;
            while (i < selectedObjects.length) {
                block28: {
                    DmObject dmObject;
                    block29: {
                        block27: {
                            iRetVal = 0;
                            bRetVal = false;
                            dmObject = (DmObject)selectedObjects[i].getDmObject();
                            if (!(dmObject instanceof DmQueueManagerHandle)) break block27;
                            if (((DmQueueManagerHandle)dmObject).getQueueManagerHandle(t).getConnectionType() != 2) break block28;
                            if (Trace.isTracing) {
                                titleQM = String.valueOf(dmObject.getTitle()) + "(" + ((DmQueueManagerHandle)dmObject).getQueueManagerHandle(t).getHostName(t) + ":" + ((DmQueueManagerHandle)dmObject).getQueueManagerHandle(t).getPortAddress(t) + ")";
                                t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Updating Item: '" + titleQM + "'");
                            }
                            break block29;
                        }
                        if (Trace.isTracing) {
                            titleQM = dmObject.getTitle();
                            t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Updating Item: '" + titleQM + "'");
                        }
                    }
                    Object job = dmObject.beginUpdate(t);
                    if (trusted != null && !trusted.equals(dmObject.getAttributeValue(t, 11027, 0))) {
                        if (Trace.isTracing) {
                            t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Updating 'SSL Trusted Store Path'");
                        }
                        bRetVal = dmObject.setAttributeValue(t, job, 11027, 0, (Object)trusted, true);
                        if (Trace.isTracing) {
                            t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Return Value for PARAM_QMGRHANDLE_SSL_TRUSTED_STORE(Create/Update): " + bRetVal);
                        }
                    }
                    if (trustedpw != null) {
                        if (Trace.isTracing) {
                            t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Updating = 'SSL Trusted Store Password'");
                        }
                        if (trustedpw.equals("")) {
                            bRetVal = dmObject.setAttributeValue(t, job, 11028, 0, (Object)trustedpw, true);
                            if (Trace.isTracing) {
                                t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Return Value PARAM_QMGRHANDLE_SSL_TRUSTED_STORE_PW(Reset): " + bRetVal);
                            }
                            iRetVal = PwUtils.removePassword((Trace)t, (IDmObject)dmObject, (String)"com.ibm.mq.explorer.addqm.conn.details.trusted.store.pw", (String)trusted, (String)trustedpw);
                            if (Trace.isTracing) {
                                t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Return Value ADD_QUEUE_MANAGER_WIZARD_TRUSTED_STORE_PW(Remove): " + iRetVal);
                            }
                        } else {
                            bRetVal = dmObject.setAttributeValue(t, job, 11028, 0, (Object)trustedpw, true);
                            if (Trace.isTracing) {
                                t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Return Value PARAM_QMGRHANDLE_SSL_TRUSTED_STORE_PW(Set/Create): " + bRetVal);
                            }
                            iRetVal = PwUtils.savePassword((Trace)t, (IDmObject)dmObject, (String)"com.ibm.mq.explorer.addqm.conn.details.trusted.store.pw", (String)trusted, (String)trustedpw);
                            if (Trace.isTracing) {
                                t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Return Value ADD_QUEUE_MANAGER_WIZARD_TRUSTED_STORE_PW(Save): " + iRetVal);
                            }
                        }
                    }
                    if (personal != null && !personal.equals(dmObject.getAttributeValue(t, 11025, 0))) {
                        if (Trace.isTracing) {
                            t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Updating 'SSL Personal Store Path'");
                        }
                        bRetVal = dmObject.setAttributeValue(t, job, 11025, 0, (Object)personal, true);
                        if (Trace.isTracing) {
                            t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Return Value PARAM_QMGRHANDLE_SSL_PERSONAL_STORE(Create/Update): " + bRetVal);
                        }
                    }
                    if (personalpw != null) {
                        if (Trace.isTracing) {
                            t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Updating 'SSL Personal Store Password'");
                        }
                        if (personalpw.equals("")) {
                            bRetVal = dmObject.setAttributeValue(t, job, 11026, 0, (Object)personalpw, true);
                            if (Trace.isTracing) {
                                t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Return Value PARAM_QMGRHANDLE_SSL_PERSONAL_STORE_PW(Reset): " + bRetVal);
                            }
                            iRetVal = PwUtils.removePassword((Trace)t, (IDmObject)dmObject, (String)"com.ibm.mq.explorer.addqm.conn.details.personal.store.pw", (String)personal, (String)personalpw);
                            if (Trace.isTracing) {
                                t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Return Value (Remove)ADD_QUEUE_MANAGER_WIZARD_PERS_STORE_PW(Remove): " + iRetVal);
                            }
                        } else {
                            bRetVal = dmObject.setAttributeValue(t, job, 11026, 0, (Object)personalpw, true);
                            if (Trace.isTracing) {
                                t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Return Value PARAM_QMGRHANDLE_SSL_PERSONAL_STORE_PW(Set/Create): " + bRetVal);
                            }
                            iRetVal = PwUtils.savePassword((Trace)t, (IDmObject)dmObject, (String)"com.ibm.mq.explorer.addqm.conn.details.personal.store.pw", (String)personal, (String)personalpw);
                            if (Trace.isTracing) {
                                t.data(66, "ConnDetailsQmgrWizPage3.performFinish()", 300, "Return Value (Save)ADD_QUEUE_MANAGER_WIZARD_PERS_STORE_PW(Save): " + iRetVal);
                            }
                        }
                    }
                    dmObject.actionChange(t, null, job, false);
                }
                ++i;
            }
        }
        return true;
    }

    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        boolean enable = true;
        if (this.sslStoresComposite.getButtonEnable().getSelection()) {
            if (this.sslStoresComposite.getTextTrustedStore().getText().equals("")) {
                enable = false;
            } else if (!this.sslStoresComposite.getTextPersonalStore().getText().equals("") && this.sslStoresComposite.getTextPersonalPassword().getText().equals("")) {
                enable = false;
            }
        }
        if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage3.checkIfEnableButtons", 300, "Next button is enabled : " + enable);
        }
        this.setPageComplete(enable);
        this.wizard.setEnableFinish(false);
        this.wizard.updateButtons();
    }

    public void nextPressed() {
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 1);
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        super.setVisible(visible);
        this.checkPasswordPreference(t);
    }

    public IWizardPage getNextPage() {
        return this.wizard.getPage4();
    }

    public ConnDetailsQmgrWizDlg getWizardDialog() {
        return this.wizard.getWizardDialog();
    }

    private void loadCurrentSettings(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        this.textTrustedStore.setText(store.getString("TrustedStoreName"));
        this.textPersonalStore.setText(store.getString("PersonalStoreName"));
        this.textTrustedPassword.setText(store.getString("PersonalStoreName"));
        this.textPersonalPassword.setText(store.getString("PersonalStoreName"));
        this.buttonEnable.setSelection(store.getBoolean("SSLStoresEnabled"));
        this.sslStoresComposite.enableControls(t);
        this.addListeners(t);
    }

    @Override
    public void setActive(Trace t, boolean active) {
    }

    public String getTrustedStore(Trace t) {
        String name = null;
        if (this.buttonEnable.getSelection()) {
            name = this.textTrustedStore.getText();
        } else if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage3.getTrustedStore", 900, "SSL stores page disabled");
        }
        return name;
    }

    public String getTrustedStorePassword(Trace t) {
        String name = null;
        if (this.buttonEnable.getSelection()) {
            name = this.sslStoresComposite.getTrustedStorePassword();
        } else if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage3.getTrustedStorePassword", 900, "SSL stores page disabled");
        }
        return name;
    }

    public String getPersonalStore(Trace t) {
        String name = null;
        if (this.buttonEnable.getSelection()) {
            name = this.textPersonalStore.getText();
        } else if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage3.getPersonalStore", 900, "SSL stores page disabled");
        }
        return name;
    }

    public String getPersonalStorePassword(Trace t) {
        String name = null;
        if (this.buttonEnable.getSelection()) {
            name = this.sslStoresComposite.getPersonalStorePassword();
        } else if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage3.getPersonalStorePassword", 900, "SSL stores page disabled");
        }
        return name;
    }

    private void addListeners(Trace t) {
        this.buttonEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnDetailsQmgrWizPage3.this.checkIfEnableButtons();
                if (ConnDetailsQmgrWizPage3.this.buttonEnable.getSelection()) {
                    ConnDetailsQmgrWizPage3.this.textTrustedStore.setFocus();
                }
            }
        });
        this.textTrustedStore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnDetailsQmgrWizPage3.this.checkIfEnableButtons();
            }
        });
        this.textTrustedPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnDetailsQmgrWizPage3.this.checkIfEnableButtons();
            }
        });
        this.textPersonalStore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ConnDetailsQmgrWizPage3.this.checkIfEnableButtons();
            }
        });
        this.textPersonalPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ConnDetailsQmgrWizPage3.this.checkIfEnableButtons();
            }
        });
    }

    @Override
    public boolean isPagePropertiesEnabled(Trace t) {
        return this.buttonEnable.getSelection();
    }

    private void checkPasswordPreference(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        boolean passwordStoreEnabled = store.getBoolean("PasswordsStoreEnabled");
        Link[] linkArray = this.linkPasswordWarnings;
        int n = this.linkPasswordWarnings.length;
        int n2 = 0;
        while (n2 < n) {
            Link curLink = linkArray[n2];
            curLink.setVisible(!passwordStoreEnabled);
            ++n2;
        }
        this.sslStoresComposite.setPasswordSaving(t, passwordStoreEnabled);
    }
}

