/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.preferences.PreferencePagePasswords;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.ConnDetailsQmgrWiz;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.ConnDetailsQmgrWizDlg;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.ConnDetailsQmgrWizPage5;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.SetsWizPage;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsUserid;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.passwords.PwUtils;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConnDetailsQmgrWizPage2
extends SetsWizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/wizards/ConnDetailsQmgrWizPage2.java";
    private ConnDetailsQmgrWiz wizard = null;
    private String titleText = null;
    private String descriptionText = null;
    private Message msgFile = null;
    private Text textUseridName = null;
    private Text textPassword = null;
    private Button buttonEnable = null;
    private Button buttonCompatMode = null;
    private ConnectionDetailsUserid useridComposite = null;
    private Link linkPasswordWarning = null;

    public ConnDetailsQmgrWizPage2(Trace t, String pageName) {
        super(pageName);
        this.setHeadingsInfo(t);
    }

    public ConnDetailsQmgrWizPage2(Trace t, String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setHeadingsInfo(t);
    }

    private void setHeadingsInfo(Trace t) {
        if (this.titleText == null) {
            this.msgFile = SetsPlugin.getMessages(t);
            this.titleText = this.msgFile.getMessage(t, "Sets.Conn.Details.Wizard.Page2.Title");
            this.descriptionText = this.msgFile.getMessage(t, "Sets.Conn.Details.Wizard.Page2.Desc");
        }
        super.setHeadings(this.titleText, this.descriptionText);
    }

    public void createPageContent(Trace t, Composite parent) {
        this.wizard = (ConnDetailsQmgrWiz)this.getWizard();
        this.useridComposite = new ConnectionDetailsUserid(parent, 0, 1, false);
        this.useridComposite.setPasswordValidation(false);
        this.textUseridName = this.useridComposite.getTextUseridName();
        this.textPassword = this.useridComposite.getTextPassword();
        this.buttonEnable = this.useridComposite.getButtonEnable();
        this.buttonCompatMode = this.useridComposite.getButtonCompatmode();
        this.loadCurrentSettings(t);
        this.linkPasswordWarning = this.useridComposite.getPasswordWarningLink();
        this.linkPasswordWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PreferencePagePasswords.openPasswordPreferencePage((Trace)t2);
                ConnDetailsQmgrWizPage2.this.checkPasswordPreference(t2);
            }
        });
    }

    public boolean performFinish() {
        Trace t = Trace.getInstance();
        ArrayList<String> qMgrWarnings = new ArrayList<String>();
        ConnDetailsQmgrWizPage5 page = (ConnDetailsQmgrWizPage5)this.wizard.getPage5();
        UiMQObject[] selectedObjects = page.getSelectedObjects(t);
        Boolean compatMode = this.getCompatMode(t);
        int passwordMode = this.getPasswordMode(t);
        String name = this.getUserid(t);
        String password = this.getUseridPassword(t);
        if (name != null || password != null || compatMode != null || passwordMode != -1) {
            int i = 0;
            while (i < selectedObjects.length) {
                DmObject dmObject = (DmObject)selectedObjects[i].getDmObject();
                if (this.isSupported(dmObject)) {
                    Object job = dmObject.beginUpdate(t);
                    dmObject.setAttributeValue(t, job, 11032, 0, (Object)1);
                    if (compatMode != null && !compatMode.equals(Integer.parseInt(dmObject.getAttributeValue(t, 11033, 0)) == 1)) {
                        dmObject.setAttributeValue(t, job, 11033, 0, (Object)(compatMode != false ? 1 : 0), true);
                    }
                    if (passwordMode != -1 && passwordMode != Integer.parseInt(dmObject.getAttributeValue(t, 11034, 0))) {
                        dmObject.setAttributeValue(t, job, 11034, 0, (Object)passwordMode, true);
                    }
                    if (name != null && !name.equals(dmObject.getAttributeValue(t, 11018, 0))) {
                        dmObject.setAttributeValue(t, job, 11018, 0, (Object)name, true);
                    }
                    if (password != null) {
                        if (dmObject.getAttribute(t, 11019, 0) == null) {
                            Attr newAttr = dmObject.createAttribute(t, job, 11019, 0, (Object)password);
                            if (newAttr != null) {
                                dmObject.setAttributeValue(t, job, 11019, 0, (Object)password);
                            }
                        } else {
                            dmObject.setAttributeValue(t, job, 11019, 0, (Object)password);
                        }
                        PwUtils.savePassword((Trace)t, (IDmObject)dmObject, (String)"com.ibm.mq.explorer.addqm.conn.details.userid.pw", (String)name, (String)password);
                    }
                    dmObject.actionChange(t, null, job, false);
                } else {
                    qMgrWarnings.add(String.valueOf(dmObject.getQueueManager().getTreeName(t)) + " ");
                }
                ++i;
            }
            if (!qMgrWarnings.isEmpty()) {
                Message commonMsgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_General");
                String title = commonMsgFile.getMessage(t, "UI.GENERAL.MQ");
                String message = this.msgFile.getMessage("Sets.Conn.Details.Wizard.Page2.Password.Prompt.NotSupported", ((Object)qMgrWarnings).toString());
                MessageDialog.openWarning((Shell)this.getShell(), (String)title, (String)message);
            }
        }
        return true;
    }

    private boolean isSupported(DmObject dmObject) {
        Trace t = Trace.getInstance();
        boolean supported = true;
        int passwordMode = this.getPasswordMode(t);
        boolean autoReconnect = dmObject.getQueueManager().getConnectionHandle().isAutoReconnect(t);
        if (passwordMode == 1 && autoReconnect) {
            supported = false;
        }
        return supported;
    }

    public void checkIfEnableButtons() {
        boolean enable = true;
        if (this.useridComposite.getButtonEnable().getSelection() && this.useridComposite.getTextUseridName().getText().equals("")) {
            enable = false;
        }
        this.setPageComplete(enable);
        this.wizard.setEnableFinish(false);
        this.wizard.updateButtons();
    }

    public void nextPressed() {
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 1);
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        super.setVisible(visible);
        this.checkPasswordPreference(t);
    }

    public IWizardPage getNextPage() {
        return this.wizard.getPage3();
    }

    public ConnDetailsQmgrWizDlg getWizardDialog() {
        return this.wizard.getWizardDialog();
    }

    private void loadCurrentSettings(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        this.textUseridName.setText(store.getString("UseridName"));
        this.textPassword.setText(store.getString("UseridPassword"));
        this.buttonEnable.setSelection(store.getBoolean("UseridEnabled"));
        this.buttonCompatMode.setSelection(store.getBoolean("UseridCompatibilityMode"));
        this.useridComposite.setPasswordModeStateSelection(store.getInt("UseridPasswordMode"));
        this.useridComposite.enableControls(t);
        this.buttonEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnDetailsQmgrWizPage2.this.checkIfEnableButtons();
                if (ConnDetailsQmgrWizPage2.this.buttonEnable.getSelection()) {
                    ConnDetailsQmgrWizPage2.this.textUseridName.setFocus();
                }
            }
        });
        this.buttonCompatMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnDetailsQmgrWizPage2.this.checkIfEnableButtons();
                if (ConnDetailsQmgrWizPage2.this.buttonEnable.getSelection()) {
                    ConnDetailsQmgrWizPage2.this.textUseridName.setFocus();
                }
            }
        });
        this.textUseridName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnDetailsQmgrWizPage2.this.checkIfEnableButtons();
            }
        });
    }

    @Override
    public void setActive(Trace t, boolean active) {
    }

    public Boolean getCompatMode(Trace t) {
        Boolean compatMode = null;
        if (this.buttonEnable.getSelection()) {
            compatMode = this.buttonCompatMode.getSelection();
        } else if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage2.getCompatMode", 900, "Userid page disabled");
        }
        return compatMode;
    }

    public int getPasswordMode(Trace t) {
        int passwordMode = -1;
        if (this.buttonEnable.getSelection()) {
            passwordMode = this.useridComposite.getPasswordModeStateSelection();
        } else if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage2.getPasswordMode", 900, "Userid page disabled");
        }
        return passwordMode;
    }

    public String getUserid(Trace t) {
        String name = null;
        if (this.buttonEnable.getSelection()) {
            name = this.textUseridName.getText();
        } else if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage2.getUserid", 900, "Userid page disabled");
        }
        return name;
    }

    public String getUseridPassword(Trace t) {
        String pw = null;
        if (this.buttonEnable.getSelection()) {
            pw = this.useridComposite.getPassword();
        } else if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage2.getUseridPassword", 300, "Userid page disabled");
        }
        return pw;
    }

    private void checkPasswordPreference(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        boolean passwordStoreEnabled = store.getBoolean("PasswordsStoreEnabled");
        this.linkPasswordWarning.setVisible(!passwordStoreEnabled);
        this.useridComposite.setPasswordSaving(t, passwordStoreEnabled);
    }
}

