/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.ConnDetailsQmgrWiz;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.ConnDetailsQmgrWizDlg;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.ConnDetailsQmgrWizPage5;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.SetsWizPage;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsSecurityExit;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ConnDetailsQmgrWizPage1
extends SetsWizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/wizards/ConnDetailsQmgrWizPage1.java";
    public static final int HORIZONTAL_INDENT = 20;
    public static final int NUM_COLUMNS = 1;
    private ConnDetailsQmgrWiz wizard = null;
    private String titleText = null;
    private String descriptionText = null;
    private Message msgFile = null;
    private Text textSecurityName = null;
    private Text textSecurityData = null;
    private Button buttonEnable = null;
    private ConnectionDetailsSecurityExit securityExitComposite = null;
    private Text textDirectoryName = null;
    private Text textJarFileName = null;
    private Button buttonDirectory = null;
    private Button buttonJarFile = null;

    public ConnDetailsQmgrWizPage1(Trace t, String pageName) {
        super(pageName);
        this.setHeadingsInfo(t);
    }

    public ConnDetailsQmgrWizPage1(Trace t, String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setHeadingsInfo(t);
    }

    private void setHeadingsInfo(Trace t) {
        if (this.titleText == null) {
            this.msgFile = SetsPlugin.getMessages(t);
            this.titleText = this.msgFile.getMessage(t, "Sets.Conn.Details.Wizard.Page1.Title");
            this.descriptionText = this.msgFile.getMessage(t, "Sets.Conn.Details.Wizard.Page1.Desc");
        }
        super.setHeadings(this.titleText, this.descriptionText);
    }

    public void createPageContent(Trace t, Composite parent) {
        this.wizard = (ConnDetailsQmgrWiz)this.getWizard();
        this.processConnDetailsWarning(t, parent, this.msgFile);
        this.securityExitComposite = new ConnectionDetailsSecurityExit(parent, 0, 1);
        this.textSecurityName = this.securityExitComposite.getTextSecurityName();
        this.textSecurityData = this.securityExitComposite.getTextSecurityData();
        this.buttonEnable = this.securityExitComposite.getButtonEnable();
        this.textDirectoryName = this.securityExitComposite.getTextDirectoryName();
        this.textJarFileName = this.securityExitComposite.getTextJarFileName();
        this.buttonDirectory = this.securityExitComposite.getButtonDirectory();
        this.buttonJarFile = this.securityExitComposite.getButtonJarFile();
        this.loadCurrentSettings(t);
    }

    public boolean performFinish() {
        Trace t = Trace.getDefault();
        ConnDetailsQmgrWizPage5 page = (ConnDetailsQmgrWizPage5)this.wizard.getPage5();
        UiMQObject[] selectedObjects = page.getSelectedObjects(t);
        String secName = this.getSecurityName(t);
        String secLocation = this.getSecurityExitLocation(t);
        String secData = this.getSecurityData(t);
        if (secName != null || secLocation != null || secData != null) {
            int i = 0;
            while (i < selectedObjects.length) {
                DmObject dmObject = (DmObject)selectedObjects[i].getDmObject();
                if (!(dmObject instanceof DmQueueManagerHandle) || ((DmQueueManagerHandle)dmObject).getQueueManagerHandle(t).getConnectionType() == 2) {
                    Object job = dmObject.beginUpdate(t);
                    if (secName != null && !secName.equals(dmObject.getAttributeValue(t, 11016, 0))) {
                        dmObject.setAttributeValue(t, job, 11016, 0, (Object)secName, true);
                    }
                    if (secLocation != null && !secLocation.equals(dmObject.getAttributeValue(t, 11024, 0))) {
                        dmObject.setAttributeValue(t, job, 11024, 0, (Object)secLocation, true);
                    }
                    if (secData != null && !secData.equals(dmObject.getAttributeValue(t, 11017, 0))) {
                        dmObject.setAttributeValue(t, job, 11017, 0, (Object)secData, true);
                    }
                    dmObject.actionChange(t, null, job, false);
                }
                ++i;
            }
        }
        return true;
    }

    public void checkIfEnableButtons() {
        boolean enable = true;
        if (this.securityExitComposite.getButtonEnable().getSelection()) {
            if (this.securityExitComposite.getTextSecurityName().getText().equals("")) {
                enable = false;
            } else if (this.securityExitComposite.getButtonDirectory().getSelection() && this.securityExitComposite.getTextDirectoryName().getText().equals("")) {
                enable = false;
            } else if (this.securityExitComposite.getButtonJarFile().getSelection() && this.securityExitComposite.getTextJarFileName().getText().equals("")) {
                enable = false;
            }
        }
        this.setPageComplete(enable);
        this.wizard.setEnableFinish(false);
        this.wizard.updateButtons();
    }

    public void nextPressed() {
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 1);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public IWizardPage getNextPage() {
        return this.wizard.getPage2();
    }

    public ConnDetailsQmgrWizDlg getWizardDialog() {
        return this.wizard.getWizardDialog();
    }

    private void loadCurrentSettings(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        this.textSecurityName.setText(store.getString("SecurityExitName"));
        this.textSecurityData.setText(store.getString("SecurityExitData"));
        this.buttonEnable.setSelection(store.getBoolean("SecurityExitEnabled"));
        this.textDirectoryName.setText(store.getString("SecurityExitDirName"));
        this.textJarFileName.setText(store.getString("SecurityExitJarName"));
        this.buttonDirectory.setSelection(store.getBoolean("SecurityExitDirEnabled"));
        this.buttonJarFile.setSelection(store.getBoolean("SecurityExitJarEnabled"));
        this.securityExitComposite.enableControls(t);
        this.addListeners(t);
    }

    @Override
    public void setActive(Trace t, boolean active) {
    }

    public String getSecurityName(Trace t) {
        String name = null;
        if (this.buttonEnable.getSelection()) {
            name = this.textSecurityName.getText();
        } else if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage1.getSecurityName", 900, "Security exit page disabled");
        }
        return name;
    }

    public String getSecurityData(Trace t) {
        String name = null;
        if (this.buttonEnable.getSelection()) {
            name = this.textSecurityData.getText();
        } else if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage1.getSecurityData", 900, "Security exit page disabled");
        }
        return name;
    }

    public String getSecurityExitLocation(Trace t) {
        String name = null;
        if (this.buttonEnable.getSelection()) {
            if (this.buttonDirectory.getSelection()) {
                name = this.textDirectoryName.getText();
                if (!name.equals("") && !name.endsWith(File.separator)) {
                    name = String.valueOf(name) + File.separator;
                }
            } else if (this.buttonJarFile.getSelection()) {
                name = this.textJarFileName.getText();
            }
        } else if (Trace.isTracing) {
            t.data(66, "ConnDetailsQmgrWizPage1.getSecurityExitLocation", 900, "Security exit page disabled");
        }
        return name;
    }

    private void addListeners(Trace t) {
        this.buttonEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnDetailsQmgrWizPage1.this.checkIfEnableButtons();
                if (ConnDetailsQmgrWizPage1.this.buttonEnable.getSelection()) {
                    ConnDetailsQmgrWizPage1.this.textSecurityName.setFocus();
                }
            }
        });
        this.textSecurityName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnDetailsQmgrWizPage1.this.checkIfEnableButtons();
            }
        });
        this.buttonDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnDetailsQmgrWizPage1.this.checkIfEnableButtons();
                if (ConnDetailsQmgrWizPage1.this.buttonDirectory.getSelection()) {
                    ConnDetailsQmgrWizPage1.this.textDirectoryName.setFocus();
                }
            }
        });
        this.buttonJarFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnDetailsQmgrWizPage1.this.checkIfEnableButtons();
                if (ConnDetailsQmgrWizPage1.this.buttonJarFile.getSelection()) {
                    ConnDetailsQmgrWizPage1.this.textJarFileName.setFocus();
                }
            }
        });
        this.textDirectoryName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ConnDetailsQmgrWizPage1.this.checkIfEnableButtons();
            }
        });
        this.textJarFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ConnDetailsQmgrWizPage1.this.checkIfEnableButtons();
            }
        });
    }
}

