/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.QmgrsContentPage;
import com.ibm.mq.explorer.qmgradmin.sets.extensions.MQQmgrSetExtObject;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.UiQmgrAdminSet;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.ISetChangedListener;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetChangedEvent;
import com.ibm.mq.explorer.qmgradmin.sets.internal.qmgrs.QueueManagerViewerFilter;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.ObjectRegistrationManager;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTable;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.Arrays;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class QmgrsSetContentPage
extends QmgrsContentPage
implements ISetChangedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/qmgrs/QmgrsSetContentPage.java";
    private static final String SELCAT_CONNECTION_DETAILS = "selcat.connection.details";
    private static final String SELCAT_SET_MEMBERSHIP = "selcat.set.membership";
    private static final String[] selCatIds = new String[]{"selcat.connection.details", "selcat.set.membership"};
    private Message msgFile = null;
    private Label labelConnDetails = null;
    private ObjectTable objtabConnDetails = null;
    private Label labelSetMembers = null;
    private Table tableSetMembers = null;
    private TableColumn[] tabcolSetMembers = null;
    private QueueManagerViewerFilter explorerTableViewerFilter = null;
    private UiQmgrAdminSet uiQmgrAdminSet = null;
    private UiMQObject selectedUiMQObject = null;

    public QmgrsSetContentPage(Composite parent, int style) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.msgFile = SetsPlugin.getMessages(t);
    }

    public void init() {
        final Trace t = Trace.getDefault();
        super.init();
        this.explorerTableViewerFilter = new QueueManagerViewerFilter();
        super.addExplorerTableViewerFilter(t, (ViewerFilter)this.explorerTableViewerFilter);
        final QmgrsSetContentPage listener = this;
        SetsPlugin.getSetManager().addChangedListener(t, listener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SetsPlugin.getSetManager().removeChangedListener(t, listener);
            }
        });
    }

    public void setObject(MQExtObject mqExtObject) {
        Trace t = Trace.getDefault();
        super.setObject(mqExtObject);
        this.uiQmgrAdminSet = (UiQmgrAdminSet)mqExtObject.getInternalObject();
        this.explorerTableViewerFilter.setQueueManagersToInclude(t, this.uiQmgrAdminSet.getObjectsInSet());
    }

    public void setActive(boolean isActive) {
        Trace t = Trace.getDefault();
        super.setActive(isActive);
        if (!this.tableSetMembers.isDisposed()) {
            this.selectionChanged(t, null);
        }
    }

    public String getPageTitle(Trace t, Object obj) {
        String setName = "";
        if (obj != null) {
            setName = obj.toString();
        }
        String setType = "";
        if (obj instanceof MQQmgrSetExtObject) {
            UiQmgrAdminSet uiSet = (UiQmgrAdminSet)((MQQmgrSetExtObject)((Object)obj)).getInternalObject();
            setType = uiSet.getTreeSuffix(t);
        }
        return Message.format((String)this.msgFile.getMessage("Sets.ContentPage.Title.QueueManagersSet"), (String)setName, (String)setType);
    }

    public String getPageId() {
        return "com.ibm.mq.explorer.contentpage.set.qmgrs";
    }

    public IUiMQObjectFactory getUiMQObjectFactory(Trace t, MQExtObject mqExtObject) {
        return ObjectRegistrationManager.getUiMQObjectFactory((Trace)t, (String)"com.ibm.mq.explorer.queuemanager");
    }

    public boolean showSelectionObjectTable(Trace t) {
        return false;
    }

    public String[] getSelectionCategoryIds(Trace t) {
        return selCatIds;
    }

    public String getSelectionCategoryName(Trace t, String selectionCategoryId) {
        String name = "";
        if (selectionCategoryId.compareTo(SELCAT_CONNECTION_DETAILS) == 0) {
            name = this.msgFile.getMessage("Sets.ContentPage.TabText.ConnectionDetails");
        } else if (selectionCategoryId.compareTo(SELCAT_SET_MEMBERSHIP) == 0) {
            name = this.msgFile.getMessage("Sets.ContentPage.TabText.SetMembership");
        }
        return name;
    }

    public void createSelectionCategoryContent(Trace t, String selectionCategoryId, Composite composite) {
        if (selectionCategoryId.compareTo(SELCAT_CONNECTION_DETAILS) == 0) {
            this.createConnectionDetailsContent(t, composite);
        } else if (selectionCategoryId.compareTo(SELCAT_SET_MEMBERSHIP) == 0) {
            this.createSetMembershipContent(t, composite);
        }
    }

    public void selectionChanged(Trace t, UiMQObject selUiMQObject) {
        this.selectedUiMQObject = selUiMQObject;
        if (this.objtabConnDetails != null) {
            if (selUiMQObject != null) {
                UiMQObject objtabObject = this.getObjectForSelectionObjectTable(t, selUiMQObject);
                this.objtabConnDetails.setEnabled(true);
                this.objtabConnDetails.removeAll(t);
                this.objtabConnDetails.setEnabled(true);
                this.objtabConnDetails.setObject(t, objtabObject);
            } else {
                this.objtabConnDetails.setEnabled(false);
                this.objtabConnDetails.removeAll(t);
            }
        }
        if (this.labelConnDetails != null) {
            this.labelConnDetails.setText(this.getTextForSelectionObjectTable(t, selUiMQObject));
        }
        if (this.tableSetMembers != null) {
            if (selUiMQObject != null) {
                Object[] sets = SetsPlugin.getSetManager().getSetsForWhichObjectIsMember(t, "com.ibm.mq.explorer.qmgrs", selUiMQObject);
                this.tableSetMembers.setEnabled(true);
                this.tableSetMembers.removeAll();
                Arrays.sort(sets);
                int i = 0;
                while (i < sets.length) {
                    TableItem tableItem = new TableItem(this.tableSetMembers, 0);
                    tableItem.setText(0, ((UiQmgrAdminSet)sets[i]).getName());
                    tableItem.setText(1, ((UiQmgrAdminSet)sets[i]).getType(t));
                    ++i;
                }
            } else {
                this.tableSetMembers.setEnabled(false);
                this.tableSetMembers.removeAll();
            }
        }
        if (this.labelSetMembers != null) {
            this.labelSetMembers.setText(this.getTextForSetMembershipTable(t, selUiMQObject));
        }
    }

    private void createConnectionDetailsContent(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.labelConnDetails = new Label(composite, 16384);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.labelConnDetails.setLayoutData((Object)gridData);
        this.labelConnDetails.setText(super.getTextForSelectionObjectTable(t, null));
        Label label = new Label(composite, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.objtabConnDetails = new ObjectTable(t, composite, 0, false, false, false);
        String attrOrderId = this.getAttributeOrderIdForSelectionObjectTable(t);
        this.objtabConnDetails.setAttributeOrderId(t, attrOrderId);
        this.objtabConnDetails.setObjectId(t, this.getObjectIdForSelectionObjectTable(t));
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.objtabConnDetails.setLayoutData((Object)gridData);
        this.objtabConnDetails.setEnabled(false);
    }

    private void createSetMembershipContent(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.labelSetMembers = new Label(composite, 16384);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.labelSetMembers.setLayoutData((Object)gridData);
        this.labelSetMembers.setText(this.getTextForSetMembershipTable(t, null));
        Label label = new Label(composite, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.tableSetMembers = new Table(composite, 68356);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.tableSetMembers.setLayoutData((Object)gridData);
        this.tableSetMembers.setHeaderVisible(true);
        this.tableSetMembers.setLinesVisible(true);
        this.tabcolSetMembers = new TableColumn[2];
        this.tabcolSetMembers[0] = new TableColumn(this.tableSetMembers, 0);
        this.tabcolSetMembers[0].setText(this.msgFile.getMessage("Sets.ContentPage.TitleText.Name"));
        this.tabcolSetMembers[1] = new TableColumn(this.tableSetMembers, 0);
        this.tabcolSetMembers[1].setText(this.msgFile.getMessage("Sets.ContentPage.TitleText.Type"));
        this.tableSetMembers.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                QmgrsSetContentPage.this.resizeTableColumns(Trace.getDefault());
            }
        });
        this.tableSetMembers.setEnabled(false);
    }

    protected void resizeTableColumns(Trace t) {
        Point tableSize = this.tableSetMembers.getSize();
        int widthCol = (tableSize.x - UiUtils.getVScrollBarWidth((Trace)t, (Table)this.tableSetMembers) - 5 * this.tableSetMembers.getGridLineWidth()) / 2;
        this.tabcolSetMembers[0].setWidth(widthCol);
        this.tabcolSetMembers[1].setWidth(widthCol);
    }

    public String getObjectId() {
        return "com.ibm.mq.explorer.set.qmgrs";
    }

    public void refresh() {
        Trace t = Trace.getDefault();
        if (this.uiQmgrAdminSet != null) {
            this.explorerTableViewerFilter.setQueueManagersToInclude(t, this.uiQmgrAdminSet.getObjectsInSet());
        }
        super.updatePage();
        super.refresh();
        this.selectionChanged(t, this.selectedUiMQObject);
    }

    public void repaint() {
        this.refresh();
    }

    @Override
    public void changed(SetChangedEvent e) {
        Trace t = Trace.getDefault();
        if (e.getObjectId().compareTo("com.ibm.mq.explorer.qmgrs") == 0) {
            if (this.uiQmgrAdminSet != null) {
                this.explorerTableViewerFilter.setQueueManagersToInclude(t, this.uiQmgrAdminSet.getObjectsInSet());
            }
            super.refreshTableViewer();
        }
    }

    private String getTextForSetMembershipTable(Trace t, UiMQObject selUiMQObject) {
        String text = "";
        text = selUiMQObject != null ? Message.format((String)this.msgFile.getMessage("Sets.ContentPage.TableText.SetMembership"), (String)selUiMQObject.toFormattedString()) : this.msgFile.getMessage("Sets.ContentPage.TableText.ShowSetMembership");
        return text;
    }

    public void updatePage() {
        super.updatePage();
        this.resizeTableColumns(Trace.getDefault());
    }

    public String getFilterId() {
        return null;
    }

    public boolean isClientFiltering() {
        return false;
    }
}

