/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.management;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.core.internal.utils.PersistQueueManagerHandles;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandleList;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.SetTreeNode;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.UiQmgrAdminSet;
import com.ibm.mq.explorer.ui.internal.base.ObjectRegistrationManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterManager;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class SetPersistence {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/management/SetPersistence.java";
    private static String setsFilename = "";
    private XMLMemento rootRead = null;
    public static final String SETS_KEY = "Sets";
    private static final String VERSION_KEY = "FileVersion";
    private static final String THIS_VERSION = "1.0.1";
    private static final String VERSION_100 = "1.0.0";
    private static final String SET_COLLECTION_COUNT_KEY = "CollectionCount";
    private static final String SET_COLLECTION_KEY_PREFIX = "Collection_";
    private static final String SET_COLLECTION_KEY_KEY = "Key";
    private static final String SETS_ENABLED_KEY = "SetsEnabled";
    private static final String SET_COUNT_KEY = "SetCount";
    private static final String SET_KEY_PREFIX = "Set_";
    private static final String SET_NAME_KEY = "Name";
    private static final String SET_OBJECT_TYPE_KEY = "ObjectType";
    private static final String SET_UID_KEY = "UniversalId";
    private static final String SET_MEMBERSHIP_TYPE_KEY = "MembershipType";
    private static final String SET_COUNT_MEMBERSHIP_LIST = "MembershipListCount";
    private static final String SET_MEMBERSHIP_LIST_KEY_PREFIX = "MembershipList_";
    private static final String SET_FILTER_MATCH_RULE = "FilterMatchRule";
    private static final String SET_COUNT_FILTERS = "FilterCount";
    private static final String SET_FILTER_ID_KEY_PREFIX = "FilterCondFilterId_";
    private static final String SET_FILTER_UNIVERSAL_ID_KEY_PREFIX = "FilterCondFilterUniversalId_";
    private static final String SET_FILTER_NAME_KEY_PREFIX = "FilterCondFilterName_";
    private FilterManager filterManager = null;
    private IUiMQObjectFactory objectFactory = null;
    private static final String KEY_SEPARATOR = "_@_";

    public SetPersistence(Trace t, File workingDir) {
        setsFilename = workingDir + File.separator + "WMQ_Sets.xml";
        this.filterManager = UiPlugin.getFilterManager();
        this.objectFactory = ObjectRegistrationManager.getUiMQObjectFactory((Trace)t, (String)"com.ibm.mq.explorer.set.qmgrs");
    }

    public boolean loadSetsHashtables(Trace t, Map<String, Boolean> setsEnabled, Map<String, ArrayList<UiQmgrAdminSet>> setArrays) {
        boolean result = true;
        InputStreamReader reader = null;
        try {
            try {
                File file = new File(setsFilename);
                if (file.length() > 0L) {
                    FileInputStream input = new FileInputStream(file);
                    reader = new InputStreamReader(input);
                    this.rootRead = XMLMemento.createReadRoot((Reader)reader);
                    String fileVersion = this.rootRead.getString(VERSION_KEY);
                    if (fileVersion != null && fileVersion.compareTo(THIS_VERSION) == 0) {
                        result = this.loadSetsHashtablesV100(t, setsEnabled, setArrays);
                    } else if (fileVersion != null && fileVersion.compareTo(VERSION_100) == 0) {
                        result = this.loadSetsHashtablesV100(t, setsEnabled, setArrays);
                        this.migrateMemebershipList(t, setArrays);
                    } else {
                        result = false;
                    }
                }
            }
            catch (FileNotFoundException e) {
                if (Trace.isTracing) {
                    t.data(66, "SetPersistence.loadSetsHashtables", 300, e.getMessage());
                }
                result = false;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(66, "SetPersistence.loadSetsHashtables", 10, -1, 0, 0, e1.getMessage(), null, null);
                    result = false;
                }
            }
            catch (WorkbenchException e) {
                if (Trace.isTracing) {
                    t.data(66, "SetPersistence.loadSetsHashtables", 300, e.getMessage());
                }
                String backupFile = UiUtils.createBackupFile((Trace)t, (String)setsFilename);
                String msgId = "AMQ4476";
                String messageWarning = CommonServices.getSystemMessage((String)msgId, (String)backupFile);
                Message msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_General");
                MessageDialog.openWarning((Shell)UiPlugin.getShell(), (String)msgFile.getMessage(t, "UI.GENERAL.MQ"), (String)messageWarning);
                result = false;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(66, "SetPersistence.loadSetsHashtables", 10, -1, 0, 0, e1.getMessage(), null, null);
                    result = false;
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e1) {
                t.FFST(66, "SetPersistence.loadSetsHashtables", 10, -1, 0, 0, e1.getMessage(), null, null);
                result = false;
            }
        }
        return result;
    }

    private boolean loadSetsHashtablesV100(Trace t, Map<String, Boolean> setsEnabled, Map<String, ArrayList<UiQmgrAdminSet>> setArrays) {
        boolean result = true;
        Integer intCount = this.rootRead.getInteger(SET_COLLECTION_COUNT_KEY);
        if (intCount != null) {
            int i = 0;
            while (i < intCount) {
                if (!this.loadSetCollection(t, i, setsEnabled, setArrays)) {
                    result = false;
                    if (Trace.isTracing) {
                        t.data(66, "SetPersistence.loadSetsHashtablesV100", 900, "Failed to load Set collection, index = " + i);
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private void migrateMemebershipList(Trace t, Map<String, ArrayList<UiQmgrAdminSet>> setArrays) {
        HashMap<String, String> treeNameLookup = new HashMap<String, String>();
        QueueManagerHandleList qmHandleList = PersistQueueManagerHandles.getHandleList((Trace)t);
        if (qmHandleList != null) {
            int handleIndex = 0;
            while (handleIndex < qmHandleList.size(t)) {
                QueueManagerHandle qmh = qmHandleList.getHandle(t, handleIndex, false);
                String treeName = this.getTreeName(t, qmh, treeNameLookup);
                treeNameLookup.put(KEY_SEPARATOR + treeName, qmh.getUniqueId(t));
                ++handleIndex;
            }
        }
        for (String key : setArrays.keySet()) {
            ArrayList<UiQmgrAdminSet> setCollection = setArrays.get(key);
            int i = 0;
            while (i < setCollection.size()) {
                UiQmgrAdminSet uiSet = setCollection.get(i);
                ArrayList<String> oldMembershipList = uiSet.getSetMembershipList();
                if (oldMembershipList != null && oldMembershipList.size() > 0) {
                    ArrayList<String> newMembershipList = new ArrayList<String>();
                    int x = 0;
                    while (x < oldMembershipList.size()) {
                        String oldKeyTreeName;
                        String nextOldKey = oldMembershipList.get(x);
                        int index = nextOldKey.indexOf(KEY_SEPARATOR);
                        if (index != -1 && treeNameLookup.containsKey(oldKeyTreeName = nextOldKey.substring(index))) {
                            String newMemebershipKey = (String)treeNameLookup.get(oldKeyTreeName);
                            newMembershipList.add(newMemebershipKey);
                        }
                        ++x;
                    }
                    uiSet.setSetMembershipList(newMembershipList);
                }
                ++i;
            }
        }
    }

    private boolean loadSetCollection(Trace t, int index, Map<String, Boolean> setsEnabled, Map<String, ArrayList<UiQmgrAdminSet>> setArrays) {
        boolean result = false;
        InputStreamReader reader = null;
        try {
            try {
                String key;
                File file = new File(setsFilename);
                FileInputStream input = new FileInputStream(file);
                reader = new InputStreamReader(input);
                IMemento child = this.rootRead.getChild(SET_COLLECTION_KEY_PREFIX + index);
                if (child != null && (key = child.getString(SET_COLLECTION_KEY_KEY)) != null && key.length() > 0) {
                    boolean isEnabled = false;
                    Integer enabled = child.getInteger(SETS_ENABLED_KEY);
                    if (enabled != null) {
                        isEnabled = enabled != 0;
                    }
                    setsEnabled.put(key, isEnabled);
                    Integer intCount = child.getInteger(SET_COUNT_KEY);
                    if (intCount != null) {
                        ArrayList<UiQmgrAdminSet> oldSetCollection = setArrays.get(key);
                        ArrayList<UiQmgrAdminSet> set = new ArrayList<UiQmgrAdminSet>();
                        int i = 0;
                        while (i < intCount) {
                            UiQmgrAdminSet uiSet;
                            IMemento setChild = child.getChild(SET_KEY_PREFIX + i);
                            if (setChild != null && (uiSet = this.loadSet(t, setChild)) != null) {
                                if (oldSetCollection != null) {
                                    int setIndex = this.findSetInCollection(oldSetCollection, uiSet);
                                    if (setIndex > -1) {
                                        oldSetCollection.get(setIndex).mergeSet(t, uiSet);
                                    } else {
                                        oldSetCollection.add(uiSet);
                                        SetTreeNode treeNode = SetsPlugin.getTreeNodeForSet(t, uiSet);
                                        if (treeNode != null) {
                                            uiSet.setTreeNode(treeNode);
                                        }
                                    }
                                } else {
                                    set.add(uiSet);
                                    SetTreeNode treeNode = SetsPlugin.getTreeNodeForSet(t, uiSet);
                                    if (treeNode != null) {
                                        uiSet.setTreeNode(treeNode);
                                    }
                                }
                            }
                            ++i;
                        }
                        if (oldSetCollection == null) {
                            setArrays.put(key, set);
                        }
                        result = true;
                    }
                }
            }
            catch (FileNotFoundException e) {
                if (Trace.isTracing) {
                    t.data(66, "SetPersistence.loadSetCollection", 300, e.getMessage());
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(66, "SetPersistence.loadSetCollection", 10, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e1) {
                t.FFST(66, "SetPersistence.loadSetCollection", 10, -1, 0, 0, e1.getMessage(), null, null);
            }
        }
        return result;
    }

    private int findSetInCollection(ArrayList<UiQmgrAdminSet> collection, UiQmgrAdminSet uiSet) {
        int index = -1;
        if (uiSet != null && collection != null) {
            int i = 0;
            while (i < collection.size()) {
                if (collection.get(i).getName().equals(uiSet.getName())) {
                    index = i;
                }
                ++i;
            }
        }
        return index;
    }

    private UiQmgrAdminSet loadSet(Trace t, IMemento child) {
        UiQmgrAdminSet uiSet = null;
        ArrayList<String> membershipList = new ArrayList<String>();
        ArrayList<Filter> filters = new ArrayList<Filter>();
        int matchRule = 0;
        ArrayList<String> missingFilterNames = null;
        String name = child.getString(SET_NAME_KEY);
        if (name != null && name.length() > 0) {
            Integer type;
            String uid;
            String objectType;
            if (name.length() > 48) {
                name = name.substring(0, 48);
            }
            if ((objectType = child.getString(SET_OBJECT_TYPE_KEY)) != null && objectType.length() > 0 && (uid = child.getString(SET_UID_KEY)) != null && uid.length() > 0 && (type = child.getInteger(SET_MEMBERSHIP_TYPE_KEY)) != null) {
                if (type == 0) {
                    Integer count = child.getInteger(SET_COUNT_MEMBERSHIP_LIST);
                    if (count != null) {
                        int i = 0;
                        while (i < count) {
                            String member = child.getString(SET_MEMBERSHIP_LIST_KEY_PREFIX + i);
                            if (member != null) {
                                membershipList.add(member);
                            }
                            ++i;
                        }
                    }
                } else if (type == 1) {
                    Integer count;
                    Integer matchRuleInteger = child.getInteger(SET_FILTER_MATCH_RULE);
                    if (matchRuleInteger != null) {
                        matchRule = matchRuleInteger;
                    }
                    if ((count = child.getInteger(SET_COUNT_FILTERS)) != null) {
                        int i = 0;
                        while (i < count) {
                            String filterId = child.getString(SET_FILTER_ID_KEY_PREFIX + i);
                            String filterUniversalId = child.getString(SET_FILTER_UNIVERSAL_ID_KEY_PREFIX + i);
                            String filterName = child.getString(SET_FILTER_NAME_KEY_PREFIX + i);
                            if (filterId != null && filterUniversalId != null) {
                                Filter matchingFilter = null;
                                ArrayList availFilters = this.filterManager.getAvailableFilters(t, filterId);
                                for (Filter filter : availFilters) {
                                    if (filter.getFilterUniversalId().compareTo(filterUniversalId) != 0) continue;
                                    matchingFilter = filter;
                                    break;
                                }
                                if (matchingFilter != null) {
                                    filters.add(matchingFilter);
                                } else {
                                    if (missingFilterNames == null) {
                                        missingFilterNames = new ArrayList<String>();
                                    }
                                    missingFilterNames.add(filterName);
                                }
                            }
                            ++i;
                        }
                    }
                }
                uiSet = (UiQmgrAdminSet)this.objectFactory.create(t, null, null);
                uiSet.setName(t, name);
                uiSet.setObjectType(objectType);
                uiSet.setUniversalId(uid);
                uiSet.setMembershipType(t, type);
                if (type == 0) {
                    uiSet.setSetMembershipList(membershipList);
                } else if (type == 1) {
                    uiSet.setMatchRule(matchRule);
                    uiSet.setFilters(filters);
                    uiSet.setMissingFilterNames(missingFilterNames);
                }
            }
        }
        return uiSet;
    }

    public XMLMemento exportSetsAsXMLMemento(Trace t, Map<String, Boolean> setsEnabled, Map<String, ArrayList<UiQmgrAdminSet>> setArrays) {
        XMLMemento rootWrite = XMLMemento.createWriteRoot((String)SETS_KEY);
        rootWrite.putString(VERSION_KEY, THIS_VERSION);
        int index = 0;
        for (String key : setArrays.keySet()) {
            ArrayList<UiQmgrAdminSet> setCollection = setArrays.get(key);
            boolean isSetsEnabled = false;
            Boolean value = setsEnabled.get(key);
            if (value != null) {
                isSetsEnabled = value;
            }
            this.saveSetCollection(t, index++, key, isSetsEnabled, setCollection, (IMemento)rootWrite);
        }
        rootWrite.putInteger(SET_COLLECTION_COUNT_KEY, index);
        return rootWrite;
    }

    public boolean overrideSetsXml(Trace t, Map<String, Boolean> setsEnabled, Map<String, ArrayList<UiQmgrAdminSet>> setArrays, XMLMemento xmlNode) {
        boolean result = false;
        if (xmlNode != null) {
            result = this.saveSetsHashtables(t, setsEnabled, setArrays, xmlNode);
        }
        return result;
    }

    public boolean saveSetsHashtables(Trace t, Map<String, Boolean> setsEnabled, Map<String, ArrayList<UiQmgrAdminSet>> setArrays) {
        boolean result = false;
        XMLMemento rootWrite = this.exportSetsAsXMLMemento(t, setsEnabled, setArrays);
        if (rootWrite != null) {
            result = this.saveSetsHashtables(t, setsEnabled, setArrays, rootWrite);
        }
        return result;
    }

    public boolean saveSetsHashtables(Trace t, Map<String, Boolean> setsEnabled, Map<String, ArrayList<UiQmgrAdminSet>> setArrays, XMLMemento rootWrite) {
        boolean result = false;
        if (rootWrite != null) {
            OutputStreamWriter writer = null;
            try {
                try {
                    File file = new File(setsFilename);
                    FileOutputStream output = new FileOutputStream(file);
                    writer = new OutputStreamWriter(output);
                    rootWrite.save((Writer)writer);
                    result = true;
                }
                catch (IOException e) {
                    t.FFST(66, "SetPersistence.saveSetsHashtables", 10, -1, 0, 0, e.getMessage(), null, null);
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e1) {
                        t.FFST(66, "SetPersistence.saveSetsHashtables", 20, -1, 0, 0, e1.getMessage(), null, null);
                    }
                }
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(66, "SetPersistence.saveSetsHashtables", 20, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
        }
        return result;
    }

    private boolean saveSetCollection(Trace t, int index, String key, boolean isSetsEnabled, ArrayList<UiQmgrAdminSet> sets, IMemento rootWrite) {
        boolean result = false;
        IMemento child = this.openChild(t, rootWrite, SET_COLLECTION_KEY_PREFIX + index);
        child.putString(SET_COLLECTION_KEY_KEY, key);
        int count = 0;
        int i = 0;
        while (i < sets.size()) {
            IMemento setChild;
            UiQmgrAdminSet uiSet = sets.get(i);
            int dispos = uiSet.getDisposition();
            if (dispos != 4 && dispos != 2 && dispos != 5 && (setChild = this.openChild(t, child, SET_KEY_PREFIX + count++)) != null) {
                this.saveSet(t, uiSet, setChild);
            }
            ++i;
        }
        child.putInteger(SET_COUNT_KEY, count);
        int value = 0;
        if (isSetsEnabled) {
            value = 1;
        }
        child.putInteger(SETS_ENABLED_KEY, value);
        return result;
    }

    private void saveSet(Trace t, UiQmgrAdminSet uiSet, IMemento child) {
        block3: {
            int setType;
            block2: {
                child.putString(SET_NAME_KEY, uiSet.getName());
                child.putString(SET_OBJECT_TYPE_KEY, uiSet.getObjectType());
                child.putString(SET_UID_KEY, uiSet.getUniversalId());
                setType = uiSet.getMembershipType();
                child.putInteger(SET_MEMBERSHIP_TYPE_KEY, setType);
                if (setType != 0) break block2;
                ArrayList<String> membershipList = uiSet.getSetMembershipList();
                child.putInteger(SET_COUNT_MEMBERSHIP_LIST, membershipList.size());
                int i = 0;
                while (i < membershipList.size()) {
                    child.putString(SET_MEMBERSHIP_LIST_KEY_PREFIX + i, membershipList.get(i));
                    ++i;
                }
                break block3;
            }
            if (setType != 1) break block3;
            int matchRule = uiSet.getMatchRule();
            child.putInteger(SET_FILTER_MATCH_RULE, matchRule);
            ArrayList<Filter> filters = uiSet.getFilters();
            child.putInteger(SET_COUNT_FILTERS, filters.size());
            int i = 0;
            while (i < filters.size()) {
                Filter filter = filters.get(i);
                child.putString(SET_FILTER_ID_KEY_PREFIX + i, filter.getFilterId());
                child.putString(SET_FILTER_UNIVERSAL_ID_KEY_PREFIX + i, filter.getFilterUniversalId());
                child.putString(SET_FILTER_NAME_KEY_PREFIX + i, filter.toString());
                ++i;
            }
        }
    }

    private IMemento openChild(Trace t, IMemento parent, String childName) {
        IMemento child = null;
        child = parent.getChild(childName);
        if (child == null) {
            child = parent.createChild(childName);
        }
        return child;
    }

    public static String getFilename() {
        return setsFilename;
    }

    private String getTreeName(Trace t, QueueManagerHandle qmh, Map<String, String> treeNameLookup) {
        String treeName = qmh.getQueueManagerName();
        switch (qmh.getConnectionType()) {
            case 2: 
            case 5: {
                treeName = CoreServices.message.getMessage(t, "TREENAME_ON.title", treeName, "'" + qmh.getConnectionName() + "'");
                if (!treeNameLookup.containsKey(KEY_SEPARATOR + treeName)) break;
                treeName = CoreServices.message.getMessage(t, "TREENAME_USING.title", treeName, "'" + qmh.getChannel() + "'");
                break;
            }
            case 4: {
                treeName = CoreServices.message.getMessage(t, "TREENAME_USING.title", treeName, "'" + qmh.getChannelDefTable() + "'");
                break;
            }
            case 3: {
                treeName = CoreServices.message.getMessage(t, "TREENAME_VIA.title", treeName, "'" + qmh.getViaQueueManagerName() + "'");
            }
        }
        return treeName;
    }
}

