/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.management;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.SetActionAfterMissingFiltersDialog;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.UiQmgrAdminSet;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.ISetChangedListener;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetChangedEvent;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetPersistence;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetProvider;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.XMLMemento;

public class SetManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/management/SetManager.java";
    private SetPersistence setPersistence = null;
    private Map<String, Boolean> setsEnabled = null;
    private String setsEnabledKey = this.createKey("com.ibm.mq.explorer.qmgrs", "com.ibm.mq.explorer.qmgrs");
    private Map<String, ArrayList<UiQmgrAdminSet>> setArrays = null;
    private static final String KEY_SEPARATOR = "_@_";
    private List<ISetChangedListener> changedListeners = null;
    private static Integer lock = 0;

    public SetManager(Trace t, File persistentFileLocation) {
        this.setPersistence = new SetPersistence(t, persistentFileLocation);
        this.setsEnabled = new HashMap<String, Boolean>();
        this.setArrays = new HashMap<String, ArrayList<UiQmgrAdminSet>>();
        this.changedListeners = new ArrayList<ISetChangedListener>();
        this.loadSetsHashtables(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSetsHashtables(Trace t) {
        boolean result = false;
        Integer n = lock;
        synchronized (n) {
            result = this.setPersistence.loadSetsHashtables(t, this.setsEnabled, this.setArrays);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean overrideSetsXml(Trace t, XMLMemento xmlNode) {
        boolean result = false;
        Integer n = lock;
        synchronized (n) {
            result = this.setPersistence.overrideSetsXml(t, this.setsEnabled, this.setArrays, xmlNode);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLMemento getSetsAsXMLMemento(Trace t) {
        XMLMemento xmlSets = null;
        Integer n = lock;
        synchronized (n) {
            xmlSets = this.setPersistence.exportSetsAsXMLMemento(t, this.setsEnabled, this.setArrays);
        }
        return xmlSets;
    }

    public ArrayList<UiQmgrAdminSet> getAvailableSets(Trace t, String objectId, String instanceId, SetProvider setProvider) {
        UiQmgrAdminSet allSet;
        ArrayList<UiQmgrAdminSet> sets = null;
        String key = this.createKey(objectId, instanceId);
        if (!this.setArrays.containsKey(key)) {
            ArrayList arrayList = new ArrayList();
            this.setArrays.put(key, arrayList);
        }
        if ((allSet = this.findAllSet(t, sets = this.setArrays.get(key))) == null && (allSet = this.createAllSet(t, setProvider)) != null) {
            sets.add(allSet);
            this.setArrays.put(key, sets);
        }
        if (allSet != null) {
            this.populateAllAset(t, setProvider, allSet);
        }
        return sets;
    }

    public boolean setSets(Trace t, String objectId, String instanceId, ArrayList<UiQmgrAdminSet> sets, SetProvider setProvider) {
        boolean result = true;
        ArrayList<UiQmgrAdminSet> setsToSet = new ArrayList<UiQmgrAdminSet>();
        for (UiQmgrAdminSet uiQmgrAdminSet : sets) {
            int disposition = uiQmgrAdminSet.getDisposition();
            if (disposition == 4 || disposition == 2 || disposition == 5) continue;
            setsToSet.add(uiQmgrAdminSet);
        }
        UiQmgrAdminSet allSet = this.findAllSet(t, setsToSet);
        if (allSet == null && (allSet = this.createAllSet(t, setProvider)) != null) {
            setsToSet.add(allSet);
        }
        this.setArrays.put(this.createKey(objectId, instanceId), setsToSet);
        this.triggerChangedListeners(t, objectId, instanceId);
        for (UiQmgrAdminSet uiSet : setsToSet) {
            int disposition = uiSet.getDisposition();
            if (disposition == 1 || disposition == 3) {
                uiSet.setDisposition(0);
                continue;
            }
            if (disposition != 2) continue;
            uiSet.setDisposition(5);
        }
        return result;
    }

    public void saveSets(Trace t) {
        this.saveSetsHashtables(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveSetsHashtables(Trace t) {
        boolean result = false;
        Integer n = lock;
        synchronized (n) {
            result = this.setPersistence.saveSetsHashtables(t, this.setsEnabled, this.setArrays);
        }
        return result;
    }

    public void addChangedListener(Trace t, ISetChangedListener listener) {
        this.changedListeners.add(listener);
    }

    public void removeChangedListener(Trace t, ISetChangedListener listener) {
        this.changedListeners.remove(listener);
    }

    public void triggerChangedListeners(Trace t, String objectId, String instanceId) {
        SetChangedEvent selEvent = new SetChangedEvent(this, objectId, instanceId);
        for (ISetChangedListener listener : this.changedListeners) {
            listener.changed(selEvent);
        }
    }

    private String createKey(String objectId, String instanceId) {
        return String.valueOf(objectId) + KEY_SEPARATOR + instanceId;
    }

    private String getObjectIdFromKey(Trace t, String key) {
        String objectId = "";
        int pos = key.indexOf(KEY_SEPARATOR);
        if (pos > 0) {
            objectId = key.substring(0, pos);
        }
        return objectId;
    }

    private String getInstanceIdFromKey(Trace t, String key) {
        String instanceId = "";
        int pos = key.indexOf(KEY_SEPARATOR);
        if (pos > 0) {
            instanceId = key.substring(pos + KEY_SEPARATOR.length());
        }
        return instanceId;
    }

    public ArrayList<UiQmgrAdminSet> getAvailableSetsForAllInstances(Trace t, String objectId) {
        ArrayList<UiQmgrAdminSet> allSets = new ArrayList<UiQmgrAdminSet>();
        String partialKey = String.valueOf(objectId) + KEY_SEPARATOR;
        for (String key : this.setArrays.keySet()) {
            if (!key.startsWith(partialKey)) continue;
            ArrayList<UiQmgrAdminSet> instanceSets = this.setArrays.get(key);
            for (UiQmgrAdminSet uiQmgrAdminSet : instanceSets) {
                if (allSets.contains(uiQmgrAdminSet)) continue;
                allSets.add(uiQmgrAdminSet);
            }
        }
        return allSets;
    }

    private UiQmgrAdminSet findAllSet(Trace t, ArrayList<UiQmgrAdminSet> sets) {
        UiQmgrAdminSet allSet = null;
        for (UiQmgrAdminSet uiQmgrAdminSet : sets) {
            if (!uiQmgrAdminSet.isAllSet().booleanValue()) continue;
            allSet = uiQmgrAdminSet;
            break;
        }
        return allSet;
    }

    private UiQmgrAdminSet createAllSet(Trace t, SetProvider setProvider) {
        UiQmgrAdminSet allSet = setProvider.createSet(t);
        if (allSet != null) {
            allSet.setName(t, SetsPlugin.getNLSString(t, "Sets.SetName.All"));
            allSet.resetUniversalId(t);
            allSet.setMembershipType(t, 2);
            allSet.setDisposition(1);
        } else {
            t.data(66, "SetManager.createAllSet", 900, "failed to create the All Set");
            t.FFST(66, "SetManager.createAllSet", 10, 50036, 0, 0, "Failed to create the All Set", null, null);
        }
        return allSet;
    }

    private void populateAllAset(Trace t, SetProvider setProvider, UiQmgrAdminSet allSet) {
        if (allSet.isAllSet().booleanValue()) {
            ArrayList<MQExtObject> objects = SetsPlugin.getKnownObjectsForAllSet(t, setProvider.getObjectId());
            for (MQExtObject mqExtObject : objects) {
                allSet.addObject(t, (UiMQObject)mqExtObject.getInternalObject());
            }
        }
    }

    public UiQmgrAdminSet[] getSetsForWhichObjectIsMember(Trace t, String objectId, UiMQObject uiMQObject) {
        ArrayList<UiQmgrAdminSet> sets = new ArrayList<UiQmgrAdminSet>();
        ArrayList<UiQmgrAdminSet> availSets = this.getAvailableSetsForAllInstances(t, objectId);
        for (UiQmgrAdminSet uiQmgrAdminSet : availSets) {
            if (!uiQmgrAdminSet.isObjectInSet(t, uiMQObject)) continue;
            sets.add(uiQmgrAdminSet);
        }
        return sets.toArray(new UiQmgrAdminSet[sets.size()]);
    }

    public void setSetsEnabled(Trace t, String objectId, String instanceId, boolean enabled) {
        String key = this.setsEnabledKey;
        this.setsEnabled.put(key, enabled);
        if (!this.setArrays.containsKey(key)) {
            this.setArrays.put(key, new ArrayList());
        }
        this.saveSetsHashtables(t);
    }

    public boolean isSetsEnabled(Trace t, String objectId, String instanceId) {
        Boolean value;
        boolean result = false;
        String key = this.setsEnabledKey;
        if (instanceId != null && !instanceId.equals("com.ibm.mq.explorer.treenode.qmgrs")) {
            key = this.createKey(objectId, instanceId);
        }
        if ((value = this.setsEnabled.get(key)) != null) {
            result = value;
        }
        return result;
    }

    public ArrayList<UiQmgrAdminSet> getSetsUsingFilter(Trace t, Filter filter) {
        ArrayList<UiQmgrAdminSet> setsArray = new ArrayList<UiQmgrAdminSet>();
        for (ArrayList<UiQmgrAdminSet> array : this.setArrays.values()) {
            for (UiQmgrAdminSet uiQmgrAdminSet : array) {
                ArrayList<Filter> filters;
                if (!uiQmgrAdminSet.isAutomaticSet().booleanValue() || !(filters = uiQmgrAdminSet.getFilters()).contains(filter)) continue;
                setsArray.add(uiQmgrAdminSet);
            }
        }
        return setsArray;
    }

    public void deleteSet(Trace t, UiQmgrAdminSet uiQmgrAdminSet) {
        for (String key : this.setArrays.keySet()) {
            List array = this.setArrays.get(key);
            if (!array.contains(uiQmgrAdminSet)) continue;
            SetsPlugin.removeTreeNode(uiQmgrAdminSet.getTreeNode());
            array.remove(uiQmgrAdminSet);
            uiQmgrAdminSet.setDisposition(2);
            this.triggerChangedListeners(t, this.getObjectIdFromKey(t, key), this.getInstanceIdFromKey(t, key));
            return;
        }
    }

    public void setChanged(Trace t, UiQmgrAdminSet uiQmgrAdminSet) {
        this.setChanged(t, uiQmgrAdminSet, false);
    }

    public void setChanged(Trace t, UiQmgrAdminSet uiQmgrAdminSet, boolean refreshManualSets) {
        for (String key : this.setArrays.keySet()) {
            List array = this.setArrays.get(key);
            if (!array.contains(uiQmgrAdminSet)) continue;
            uiQmgrAdminSet.setDisposition(3);
            if (uiQmgrAdminSet.isAutomaticSet().booleanValue()) {
                this.repopulateSet(t, uiQmgrAdminSet, this.getObjectIdFromKey(t, key));
            } else if (refreshManualSets && uiQmgrAdminSet.isManualSet().booleanValue()) {
                this.repopulateSet(t, uiQmgrAdminSet, this.getObjectIdFromKey(t, key));
            }
            this.triggerChangedListeners(t, this.getObjectIdFromKey(t, key), this.getInstanceIdFromKey(t, key));
            uiQmgrAdminSet.setDisposition(0);
            return;
        }
    }

    private void repopulateSet(Trace t, UiQmgrAdminSet uiQmgrAdminSet, String objectId) {
        if (uiQmgrAdminSet.isAutomaticSet().booleanValue()) {
            uiQmgrAdminSet.removeAllMembers(t);
            ArrayList<MQExtObject> objects = SetsPlugin.getKnownObjectsForAutomaticSet(t, uiQmgrAdminSet, objectId);
            for (MQExtObject mqExtObject : objects) {
                uiQmgrAdminSet.addObject(t, mqExtObject);
            }
        } else if (uiQmgrAdminSet.isManualSet().booleanValue()) {
            MQQmgrExtObject[] qManagers = UiPlugin.getKnownQueueManagers((Trace)t);
            if (qManagers != null) {
                MQQmgrExtObject[] mQQmgrExtObjectArray = qManagers;
                int n = qManagers.length;
                int n2 = 0;
                while (n2 < n) {
                    MQQmgrExtObject qManager = mQQmgrExtObjectArray[n2];
                    uiQmgrAdminSet.addObjectIfValidMember(t, (UiMQObject)qManager.getInternalObject());
                    ++n2;
                }
            }
            uiQmgrAdminSet.repopulateSetMembershipList(t);
        }
    }

    public void checkForMissingFilters(Trace t) {
        for (String key : this.setArrays.keySet()) {
            ArrayList<UiQmgrAdminSet> array = this.setArrays.get(key);
            for (UiQmgrAdminSet uiQmgrAdminSet : array) {
                uiQmgrAdminSet.checkForMissingFilters(t);
            }
        }
        this.handleMissingFilters(t);
    }

    public void handleMissingFilters(Trace t) {
        final HashMap<UiQmgrAdminSet, String> setsWithMissingFilters = new HashMap<UiQmgrAdminSet, String>();
        for (String key : this.setArrays.keySet()) {
            ArrayList<UiQmgrAdminSet> array = this.setArrays.get(key);
            for (UiQmgrAdminSet uiQmgrAdminSet : array) {
                ArrayList<String> missingFilterNames = uiQmgrAdminSet.getMissingFilterNames();
                if (missingFilterNames == null || missingFilterNames.size() <= 0) continue;
                setsWithMissingFilters.put(uiQmgrAdminSet, this.getObjectIdFromKey(t, key));
            }
        }
        if (setsWithMissingFilters.size() > 0 && !UiPlugin.isShutdownInProgress()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell parent = UiPlugin.getShell();
                    Trace tr = Trace.getDefault();
                    for (UiQmgrAdminSet uiQmgrAdminSet : setsWithMissingFilters.keySet()) {
                        boolean resolved = false;
                        while (!resolved) {
                            SetActionAfterMissingFiltersDialog dlg = new SetActionAfterMissingFiltersDialog(tr, parent, 0);
                            dlg.setValues(tr, uiQmgrAdminSet.getMissingFilterNames(), uiQmgrAdminSet);
                            dlg.create(tr, true);
                            if (!dlg.open(tr)) continue;
                            resolved = true;
                        }
                        if (uiQmgrAdminSet.getDisposition() == 2 || uiQmgrAdminSet.getDisposition() == 5) continue;
                        uiQmgrAdminSet.setMissingFilterNames(null);
                        SetManager.this.repopulateSet(tr, uiQmgrAdminSet, (String)setsWithMissingFilters.get(uiQmgrAdminSet));
                    }
                    SetManager.this.saveSets(tr);
                    UiPlugin.refreshNavigatorViews((Trace)tr, (boolean)true);
                }
            });
        }
    }

    public SetPersistence getSetPersistence() {
        return this.setPersistence;
    }
}

