/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.management;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.SetActionAfterFilterDeleteDialog;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.UiQmgrAdminSet;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetManager;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetProvider;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ObjectNameViewerSorter;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterNotifyEvent;
import com.ibm.mq.explorer.ui.internal.filters.IFilterNotify;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.widgets.Shell;

public class FilterListener
implements IFilterNotify {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/management/FilterListener.java";

    public void filterAdded(FilterNotifyEvent event) {
        Trace t = Trace.getDefault();
        this.trace(t, "FilterListener.filterAdded", 300, "filterAdded: " + event.getObject().toString());
    }

    public void filterChanged(FilterNotifyEvent event) {
        Trace t = Trace.getDefault();
        this.trace(t, "FilterListener.filterChanged", 300, "filterChanged: " + event.getObject().toString());
        Object object = event.getObject();
        if (object instanceof Filter) {
            Filter filter = (Filter)object;
            SetManager setManager = SetsPlugin.getSetManager();
            ArrayList<UiQmgrAdminSet> setsUsingFilter = setManager.getSetsUsingFilter(t, filter);
            if (setsUsingFilter.size() > 0) {
                for (UiQmgrAdminSet uiQmgrAdminSet : setsUsingFilter) {
                    uiQmgrAdminSet.removeAllMembers(t);
                    SetProvider setProvider = SetsPlugin.getSetProvider(t, uiQmgrAdminSet);
                    ArrayList<MQExtObject> objects = SetsPlugin.getKnownObjectsForAutomaticSet(t, uiQmgrAdminSet, setProvider.getObjectId());
                    for (MQExtObject mqExtObject : objects) {
                        uiQmgrAdminSet.addObject(t, mqExtObject);
                    }
                }
            }
            UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
        }
    }

    public boolean isPreventFilterDelete(FilterNotifyEvent event) {
        Trace t = Trace.getDefault();
        this.trace(t, "FilterListener.isPreventFilterDelete", 300, "isPreventFilterDelete: " + event.getObject().toString());
        boolean preventDelete = false;
        Object object = event.getObject();
        if (object instanceof Filter) {
            Filter filter = (Filter)object;
            SetManager setManager = SetsPlugin.getSetManager();
            ArrayList<UiQmgrAdminSet> setsUsingFilter = setManager.getSetsUsingFilter(t, filter);
            if (setsUsingFilter.size() > 0) {
                UiQmgrAdminSet[] sets = setsUsingFilter.toArray(new UiQmgrAdminSet[setsUsingFilter.size()]);
                Arrays.sort(sets, new ObjectNameViewerSorter());
                String msgId = "AMQ4468";
                String setNames = "\n";
                int i = 0;
                while (i < sets.length) {
                    setNames = String.valueOf(setNames) + "       " + sets[i].getName() + "\n";
                    ++i;
                }
                setNames = String.valueOf(setNames) + "\n\n";
                String msgText = Message.format((String)CommonServices.getSystemMessage((Trace)t, (String)msgId), (String)filter.getFilterName(), (String)setNames);
                int button = MessageBox.showDeleteCancelMessage((Trace)t, (Shell)UiPlugin.getShell(), (String)msgText, (int)1, (String)msgId);
                preventDelete = button == 1;
            }
        }
        return preventDelete;
    }

    public void filterDeleted(FilterNotifyEvent event) {
        Trace t = Trace.getDefault();
        this.trace(t, "FilterListener.filterDeleted", 300, "filterDeleted: " + event.getObject().toString());
        Object object = event.getObject();
        if (object instanceof Filter) {
            Filter filter = (Filter)object;
            SetManager setManager = SetsPlugin.getSetManager();
            ArrayList<UiQmgrAdminSet> setsUsingFilter = setManager.getSetsUsingFilter(t, filter);
            if (setsUsingFilter.size() > 0) {
                for (UiQmgrAdminSet uiQmgrAdminSet : setsUsingFilter) {
                    ArrayList<Filter> setFilters = uiQmgrAdminSet.getFilters();
                    setFilters.remove(filter);
                    uiQmgrAdminSet.setFilters(setFilters);
                    boolean resolved = false;
                    while (!resolved) {
                        SetActionAfterFilterDeleteDialog dlg = new SetActionAfterFilterDeleteDialog(t, UiPlugin.getShell(), 0);
                        dlg.setValues(t, filter.getFilterName(), uiQmgrAdminSet);
                        dlg.create(t);
                        if (!dlg.open(t)) continue;
                        resolved = true;
                    }
                }
                setManager.saveSets(t);
                UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
            }
        }
    }

    private void trace(Trace t, String fid, int detail, String string) {
        if (Trace.isTracing) {
            t.data(66, fid, detail, string);
        }
    }
}

