/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.generic;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.SetTreeNode;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterManager;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objects.UiSet;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.swt.widgets.Composite;

public abstract class UiQmgrAdminSet
extends UiSet
implements Comparable<UiQmgrAdminSet> {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/generic/UiQmgrAdminSet.java";
    public static final int DISPOSITION_NONE = 0;
    public static final int DISPOSITION_ADDED = 1;
    public static final int DISPOSITION_DELETED = 2;
    public static final int DISPOSITION_CHANGED = 3;
    public static final int DISPOSITION_IGNORE = 4;
    public static final int DISPOSITION_DELETEDONE = 5;
    private int disposition = 0;
    public static final int TYPE_MANUAL = 0;
    public static final int TYPE_AUTOMATIC = 1;
    public static final int TYPE_ALL = 2;
    public static final int MATCHRULE_ALL = 0;
    public static final int MATCHRULE_ANY = 1;
    private int setType = 0;
    private int matchRule = 0;
    private String name = "";
    private String objectType = "";
    private ArrayList<String> setMembershipList = null;
    private ArrayList<UiMQObject> setObjects = null;
    private String universalId = "";
    private ArrayList<Filter> filters = null;
    private ArrayList<String> missingFilterNames = null;

    public UiQmgrAdminSet() {
    }

    public UiQmgrAdminSet(Trace t, IDmObject dmObj, UiMQObject parent) {
        super(t, dmObj);
        this.setMembershipList = new ArrayList();
        this.setObjects = new ArrayList();
        this.setUniversalId(t);
    }

    public void copyFrom(Trace t, UiQmgrAdminSet sourceUiSet) {
        this.name = new String(sourceUiSet.name);
        this.getExternalObject().setName(sourceUiSet.name);
        this.setMembershipType(t, sourceUiSet.setType);
        this.resetUniversalId(t);
        if (sourceUiSet.isAutomaticSet().booleanValue()) {
            this.matchRule = sourceUiSet.matchRule;
            this.filters = new ArrayList<Filter>(sourceUiSet.filters);
        }
        this.setMembershipList = new ArrayList<String>(sourceUiSet.setMembershipList);
        this.setObjects = new ArrayList<UiMQObject>(sourceUiSet.setObjects);
        this.objectType = new String(sourceUiSet.objectType);
        super.setTreeNode(sourceUiSet.getTreeNode());
    }

    public boolean attrValueChangedOnPropertyPage(Trace t, Attr attr, Object newValue) {
        return false;
    }

    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite parent, int style, Attr attr, boolean readonly) {
        return null;
    }

    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        return null;
    }

    public String getAttributeName(Trace t, int attrId) {
        return null;
    }

    public String getAttributeValue(Trace t, int attrId) {
        return null;
    }

    public String getCharacterSetIdForByteArray(Trace t, int attrId) {
        return null;
    }

    public int getDataModelObjectType(Trace t) {
        return -1;
    }

    public String getNLSResourceFileKey() {
        return null;
    }

    public void setObjectType(String type) {
        this.objectType = type;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public boolean isAllowApplyProperties() {
        return false;
    }

    public boolean isAllowProperties() {
        return false;
    }

    public boolean isChangeProperties(Trace t) {
        return false;
    }

    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        return false;
    }

    public boolean isCustomItem(Trace t, Attr attr) {
        return false;
    }

    public boolean isDefaultDataModeEbcdic(Trace t) {
        return false;
    }

    public boolean isNotifyChangedOnPropertyPage(Attr attr) {
        return false;
    }

    public boolean isSupportDelete() {
        return false;
    }

    public String getId() {
        return "com.ibm.mq.explorer.set";
    }

    public String toString() {
        return this.name;
    }

    public void updateIcon() {
    }

    public void setName(Trace t, String _name) {
        boolean resetUniversalId = false;
        if (!this.name.equals(_name)) {
            resetUniversalId = true;
        }
        this.name = _name;
        this.getExternalObject().setName(this.name);
        if (resetUniversalId) {
            this.resetUniversalId(t);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getUniversalId() {
        return this.universalId;
    }

    public void setUniversalId(String id) {
        this.universalId = id;
    }

    private void setUniversalId(Trace t) {
        Date date = new Date();
        this.universalId = String.valueOf(this.name) + "_" + date.toString();
    }

    public void resetUniversalId(Trace t) {
        this.setUniversalId(t);
        if (this.getTreeNode() != null && this.getTreeNode() instanceof SetTreeNode) {
            SetTreeNode setTreeNode = (SetTreeNode)this.getTreeNode();
            setTreeNode.resetTreeNodeId();
        }
    }

    public int getDisposition() {
        return this.disposition;
    }

    public void setDisposition(int dispos) {
        this.disposition = dispos;
    }

    public Boolean isManualSet() {
        if (this.setType == 0) {
            return true;
        }
        return false;
    }

    public Boolean isAutomaticSet() {
        if (this.setType == 1) {
            return true;
        }
        return false;
    }

    public Boolean isAllSet() {
        if (this.setType == 2) {
            return true;
        }
        return false;
    }

    public void setMembershipType(Trace t, int type) {
        this.setType = type;
        if (type == 0) {
            this.setImage(Icons.get((String)"com.ibm.mq.explorer.qmgradmin.sets.iconkey.manualSet"));
        } else if (type == 2) {
            this.setImage(Icons.get((String)"com.ibm.mq.explorer.qmgradmin.sets.iconkey.allSet"));
        } else {
            this.setImage(Icons.get((String)"com.ibm.mq.explorer.qmgradmin.sets.iconkey.autoSet"));
        }
    }

    public int getMembershipType() {
        return this.setType;
    }

    public void setMatchRule(int rule) {
        this.matchRule = rule;
    }

    public int getMatchRule() {
        return this.matchRule;
    }

    public boolean isValidMember(Trace t, MQExtObject mqExtObject) {
        return this.isValidMember(t, (UiMQObject)mqExtObject.getInternalObject());
    }

    public boolean isValidMember(Trace t, UiMQObject uiMQObject) {
        boolean result = false;
        block0 : switch (this.setType) {
            case 2: {
                result = true;
                break;
            }
            case 0: {
                result = this.isObjectInSet(t, uiMQObject);
                break;
            }
            case 1: {
                if (this.missingFilterNames != null && this.missingFilterNames.size() > 0) {
                    result = false;
                    break;
                }
                if (this.matchRule == 0) {
                    result = true;
                    for (Filter filter : this.filters) {
                        if (filter.doesObjectMatch(t, uiMQObject)) continue;
                        result = false;
                        break block0;
                    }
                } else {
                    result = false;
                    for (Filter filter : this.filters) {
                        if (!filter.doesObjectMatch(t, uiMQObject)) continue;
                        result = true;
                        break block0;
                    }
                }
                break;
            }
        }
        return result;
    }

    public boolean addObject(Trace t, MQExtObject mqExtObject) {
        return this.addObject(t, (UiMQObject)mqExtObject.getInternalObject());
    }

    public boolean addObject(Trace t, UiMQObject uiMQObject) {
        boolean result = false;
        String membershipKey = this.getMembershipKey(t, uiMQObject);
        if (!this.setMembershipList.contains(membershipKey) && membershipKey != null) {
            this.setMembershipList.add(membershipKey);
            result = true;
        }
        if (!this.setObjects.contains(uiMQObject) && this.setObjects != null) {
            this.setObjects.add(uiMQObject);
            result = true;
        }
        return result;
    }

    public boolean isObjectInSet(Trace t, UiMQObject uiMQObject) {
        String key;
        boolean result = this.setObjects.contains(uiMQObject);
        if (!result && (key = this.getMembershipKey(t, uiMQObject)) != null) {
            int i = 0;
            while (i < this.setMembershipList.size() && !result) {
                String nextKey = this.setMembershipList.get(i);
                if (nextKey != null) {
                    result = nextKey.equals(key);
                }
                ++i;
            }
        }
        return result;
    }

    public boolean isObjectInSet(Trace t, MQExtObject mqExtObject) {
        return this.isObjectInSet(t, (UiMQObject)mqExtObject.getInternalObject());
    }

    public boolean addObjectIfValidMember(Trace t, MQExtObject mqExtObject) {
        return this.addObjectIfValidMember(t, (UiMQObject)mqExtObject.getInternalObject());
    }

    public boolean addObjectIfValidMember(Trace t, UiMQObject uiMQObject) {
        boolean result = false;
        if (this.isValidMember(t, uiMQObject)) {
            boolean alreadyContains = false;
            int i = 0;
            while (i < this.setObjects.size()) {
                IDmObject nextDmObject = this.setObjects.get(i).getDmObject();
                if (nextDmObject instanceof DmQueueManager && nextDmObject.equals((Object)uiMQObject.getDmObject())) {
                    alreadyContains = true;
                }
                ++i;
            }
            if (!alreadyContains) {
                result = this.addObject(t, uiMQObject);
            }
        } else {
            String membershipKey = this.getMembershipKey(t, uiMQObject);
            this.setMembershipList.remove(membershipKey);
            this.setObjects.remove(uiMQObject);
        }
        return result;
    }

    public void removeAllMembers(Trace t) {
        this.setMembershipList.clear();
        this.setObjects.clear();
    }

    public boolean removeObjectIfMember(Trace t, UiMQObject uiMQObject) {
        boolean result = false;
        String membershipKey = this.getMembershipKey(t, uiMQObject);
        if (this.setMembershipList.contains(membershipKey)) {
            this.setMembershipList.remove(membershipKey);
        }
        if (uiMQObject instanceof UiQueueManager) {
            UiQueueManager matchingUiQueueManager = null;
            int i = 0;
            while (i < this.setObjects.size()) {
                UiQueueManager nextUiQueueManager = (UiQueueManager)this.setObjects.get(i);
                IDmObject nextDmObject = nextUiQueueManager.getDmObject();
                if (nextDmObject instanceof DmQueueManager && nextDmObject.equals((Object)uiMQObject.getDmObject())) {
                    matchingUiQueueManager = nextUiQueueManager;
                }
                ++i;
            }
            if (matchingUiQueueManager != null) {
                this.setObjects.remove(matchingUiQueueManager);
                result = true;
            }
        }
        return result;
    }

    public boolean removeObjectIfMember(Trace t, MQExtObject mqExtObject) {
        return this.removeObjectIfMember(t, (UiMQObject)mqExtObject.getInternalObject());
    }

    public void mergeSet(Trace t, UiQmgrAdminSet uiSet) {
        for (UiMQObject newObj : uiSet.setObjects) {
            if (newObj == null) continue;
            this.addObject(t, newObj);
        }
        for (String key : uiSet.setMembershipList) {
            if (this.setMembershipList.contains(key) || key == null) continue;
            this.setMembershipList.add(key);
        }
    }

    public MQExtObject[] getObjectsInSet() {
        ArrayList<UiMQObject> allObjects = new ArrayList<UiMQObject>();
        for (UiMQObject obj : this.setObjects) {
            if (allObjects.contains(obj)) continue;
            allObjects.add(obj);
        }
        MQExtObject[] mqExtObjects = new MQExtObject[allObjects.size()];
        int i = 0;
        while (i < allObjects.size()) {
            mqExtObjects[i] = ((UiMQObject)allObjects.get(i)).getExternalObject();
            ++i;
        }
        return mqExtObjects;
    }

    public abstract String getMembershipKey(Trace var1, UiMQObject var2);

    public abstract String getObjectId();

    public ArrayList<String> getSetMembershipList() {
        return this.setMembershipList;
    }

    public void setSetMembershipList(ArrayList<String> list) {
        if (this.setType == 0) {
            this.setMembershipList = list;
        }
    }

    public void repopulateSetMembershipList(Trace t) {
        Iterator<String> iterator = this.setMembershipList.iterator();
        while (iterator.hasNext()) {
            String membershipKey = iterator.next();
            boolean found = false;
            for (UiMQObject uiMQObject : this.setObjects) {
                String uiMqObjectMemKey = this.getMembershipKey(t, uiMQObject);
                if (!uiMqObjectMemKey.equals(membershipKey)) continue;
                found = true;
                break;
            }
            if (found) continue;
            iterator.remove();
        }
    }

    public ArrayList<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(ArrayList<Filter> filts) {
        if (this.setType == 1) {
            this.filters = filts;
        }
    }

    public void checkForMissingFilters(Trace t) {
        if (this.filters != null) {
            FilterManager filterManager = UiPlugin.getFilterManager();
            int i = 0;
            while (i < this.filters.size()) {
                String filterId = this.filters.get(i).getFilterId();
                String filterUniversalId = this.filters.get(i).getFilterUniversalId();
                String filterName = this.filters.get(i).getFilterName();
                if (filterId != null && filterUniversalId != null) {
                    boolean foundFilter = false;
                    ArrayList availFilters = filterManager.getAvailableFilters(t, filterId);
                    for (Filter filter : availFilters) {
                        if (filter.getFilterUniversalId().compareTo(filterUniversalId) != 0) continue;
                        foundFilter = true;
                        break;
                    }
                    if (!foundFilter) {
                        if (this.missingFilterNames == null) {
                            this.missingFilterNames = new ArrayList();
                        }
                        this.missingFilterNames.add(filterName);
                    }
                }
                ++i;
            }
        }
    }

    public String getType(Trace t) {
        String type = "";
        switch (this.setType) {
            case 2: {
                type = SetsPlugin.getNLSString(t, "Sets.Wizard.TypeAll");
                break;
            }
            case 1: {
                type = SetsPlugin.getNLSString(t, "Sets.Wizard.TypeAutomatic");
                break;
            }
            case 0: {
                type = SetsPlugin.getNLSString(t, "Sets.Wizard.TypeManual");
            }
        }
        return type;
    }

    public String getTreeSuffix(Trace t) {
        String treeSuffix = "";
        switch (this.setType) {
            case 2: {
                treeSuffix = SetsPlugin.getNLSString(t, "Sets.AllSet");
                break;
            }
            case 1: {
                treeSuffix = SetsPlugin.getNLSString(t, "Sets.AutomaticSet");
                break;
            }
            case 0: {
                treeSuffix = SetsPlugin.getNLSString(t, "Sets.ManualSet");
            }
        }
        return "[" + treeSuffix + "]";
    }

    public ArrayList<String> getMissingFilterNames() {
        return this.missingFilterNames;
    }

    public void setMissingFilterNames(ArrayList<String> missingFilterNames) {
        this.missingFilterNames = missingFilterNames;
    }
}

