/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.generic;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.qmgradmin.sets.extensions.MQQmgrSetExtObject;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.CopyToSetDialog;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.EditSetDialog;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.UiQmgrAdminSet;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetManager;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetProvider;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public abstract class SetTreeNode
extends TreeNode {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/generic/SetTreeNode.java";
    protected UiQmgrAdminSet uiQmgrAdminSet = null;
    private SetProvider setProvider = null;
    private Action actionSetMembership = null;
    private Action actionEditSet = null;
    private Action actionCopyToSet = null;
    private Action actionDelete = null;
    private Message msgFile = null;

    public SetTreeNode(TreeNode parent, MQExtObject object, String plugin_id) {
        super(parent, object, plugin_id);
        Trace t = Trace.getDefault();
        this.msgFile = SetsPlugin.getMessages(t);
        this.uiQmgrAdminSet = (UiQmgrAdminSet)object.getInternalObject();
    }

    public void appendToContextMenu(Shell shell, IMenuManager manager) {
        final Trace t = Trace.getDefault();
        manager.add((IContributionItem)new Separator("com.ibm.mq.explorer.sets.setactions"));
        manager.add((IContributionItem)new Separator());
        if (this.uiQmgrAdminSet.isManualSet().booleanValue()) {
            if (this.actionSetMembership == null) {
                this.actionSetMembership = new Action(){

                    public void run() {
                        SetTreeNode.this.showSetMembershipDialog(t);
                    }
                };
                this.actionSetMembership.setText(this.msgFile.getMessage("Sets.MenuItem.SetMembership"));
            }
            manager.add((IAction)this.actionSetMembership);
        }
        if (!this.uiQmgrAdminSet.isAllSet().booleanValue()) {
            if (this.actionEditSet == null) {
                this.actionEditSet = new Action(){

                    public void run() {
                        SetTreeNode.this.editSet(t);
                    }
                };
                this.actionEditSet.setText(SetsPlugin.getNLSString(t, "Sets.MenuItem.EditSet"));
            }
            manager.add((IAction)this.actionEditSet);
        }
        if (this.uiQmgrAdminSet.isManualSet().booleanValue() && this.uiQmgrAdminSet.getObjectsInSet().length > 0) {
            ArrayList<UiQmgrAdminSet> sets = SetsPlugin.getSetManager().getAvailableSets(t, this.setProvider.getObjectId(), SetsPlugin.getInstanceId(t, this), this.setProvider);
            Iterator<UiQmgrAdminSet> iter = sets.iterator();
            boolean isTargetSet = false;
            while (iter.hasNext() && !isTargetSet) {
                UiQmgrAdminSet set = iter.next();
                if (!set.isManualSet().booleanValue() || set == this.uiQmgrAdminSet) continue;
                isTargetSet = true;
            }
            if (isTargetSet) {
                if (this.actionCopyToSet == null) {
                    this.actionCopyToSet = new Action(){

                        public void run() {
                            SetTreeNode.this.showCopyToSetDialog(t);
                        }
                    };
                    this.actionCopyToSet.setText(this.msgFile.getMessage("Sets.MenuItem.CopyToSet"));
                }
                manager.add((IAction)this.actionCopyToSet);
            }
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("com.ibm.mq.explorer.sets.setadditions"));
        manager.add((IContributionItem)new Separator());
        if (!this.uiQmgrAdminSet.isAllSet().booleanValue()) {
            if (this.actionDelete == null) {
                this.actionDelete = new Action(){

                    public void run() {
                        SetTreeNode.this.deleteSet(t);
                    }
                };
                this.actionDelete.setText(UiPlugin.getNLSString((Trace)t, (String)"KEY_General", (String)"UI.GENERAL.DELETE"));
            }
            manager.add((IAction)this.actionDelete);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    public int compare(TreeNode child1, TreeNode child2) {
        return TreeNode.compareByName((TreeNode)child1, (TreeNode)child2);
    }

    public String getContentPageId() {
        String pageId = "com.ibm.mq.explorer.contentpage.set";
        if (this.setProvider != null) {
            pageId = this.setProvider.getContentPageId();
        }
        return pageId;
    }

    public String getHelpId() {
        return "com.ibm.mq.explorer.qmgradmin.sets.infopop.UI_SetContentPage";
    }

    public UiQmgrAdminSet getUiQmgrSet() {
        return this.uiQmgrAdminSet;
    }

    public Image getIcon() {
        Image image = null;
        if (this.uiQmgrAdminSet != null) {
            image = this.uiQmgrAdminSet.getImage();
        }
        return image;
    }

    public String getId() {
        return "com.ibm.mq.explorer.treenode.set." + this.getUniqueIdentifier(Trace.getDefault());
    }

    public String getSequence() {
        return "100.10";
    }

    public boolean isAddChildrenWhenExpanded() {
        return false;
    }

    public boolean isContextMenuFromUiObject() {
        return false;
    }

    public String toString() {
        String text = "";
        if (this.uiQmgrAdminSet != null) {
            text = this.uiQmgrAdminSet.getName();
            if (UiPlugin.isShowObjectStatus()) {
                text = String.valueOf(text) + " " + this.uiQmgrAdminSet.getTreeSuffix(Trace.getDefault());
            }
        }
        return text;
    }

    public void setSetProvider(SetProvider setProv) {
        this.setProvider = setProv;
    }

    public boolean testAttribute(Object target, String name, String value) {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(66, "SetTreeNode.testAttribute", 300, "testing object '" + target.toString() + "'");
            t.data(66, "SetTreeNode.testAttribute", 300, "checking attribute '" + name + "'");
            t.data(66, "SetTreeNode.testAttribute", 300, "for value '" + value + "'");
        }
        boolean result = false;
        if (name.compareTo("SetType") == 0) {
            if (value.compareTo("All") == 0) {
                result = this.uiQmgrAdminSet.isAllSet();
            } else if (value.compareTo("Automatic") == 0) {
                result = this.uiQmgrAdminSet.isAutomaticSet();
            } else if (value.compareTo("Manual") == 0) {
                result = this.uiQmgrAdminSet.isManualSet();
            }
        } else if (name.compareTo("SetMembership") == 0) {
            if (value.compareTo("NotEmpty") == 0) {
                result = !this.uiQmgrAdminSet.getSetMembershipList().isEmpty();
            } else if (value.compareTo("Empty") == 0) {
                result = this.uiQmgrAdminSet.getSetMembershipList().isEmpty();
            }
        } else if (name.compareTo("SetObjectId") == 0) {
            MQQmgrSetExtObject mqQmgrSetExtObject = (MQQmgrSetExtObject)((Object)this.getObject());
            UiQmgrAdminSet uiSet = (UiQmgrAdminSet)mqQmgrSetExtObject.getInternalObject();
            if (uiSet.getObjectId().compareTo(value) == 0) {
                result = true;
            }
        } else {
            result = super.testAttribute(target, name, value);
        }
        if (Trace.isTracing) {
            t.data(66, "SetTreeNode.testAttribute", 300, "result = " + result);
        }
        return result;
    }

    protected abstract void showSetMembershipDialog(Trace var1);

    protected void editSet(Trace t) {
        EditSetDialog editSetDialog = new EditSetDialog(t, UiPlugin.getShell());
        String instanceId = SetsPlugin.getInstanceId(t, this);
        if (this.setProvider == null) {
            this.setProvider = SetsPlugin.getSetProvider(t, this);
        }
        editSetDialog.setValues(t, this.uiQmgrAdminSet, true, instanceId, this.setProvider);
        if (editSetDialog.open() == 0) {
            int disposition = this.uiQmgrAdminSet.getDisposition();
            if (disposition == 0) {
                this.uiQmgrAdminSet.setDisposition(3);
            }
            SetManager setManager = SetsPlugin.getSetManager();
            setManager.setChanged(t, this.uiQmgrAdminSet);
            setManager.saveSets(t);
            UiPlugin.refreshAllViews((Trace)t, (String)"com.ibm.mq.explorer.set.qmgrs", (boolean)true);
        }
    }

    protected void showCopyToSetDialog(Trace t) {
        CopyToSetDialog copyToSetDialog = new CopyToSetDialog(UiPlugin.getShell());
        copyToSetDialog.setValues(t, this.uiQmgrAdminSet, SetsPlugin.getInstanceId(t, this), SetsPlugin.getSetProvider(t, this));
        copyToSetDialog.setNoObjectMessage(t, 1, this.msgFile.getMessage("Sets.Dialog.NoSetsAvailable"));
        if (copyToSetDialog.open() == 0) {
            UiQmgrAdminSet[] selectedSets = copyToSetDialog.getSelectedSets();
            boolean setsChanged = false;
            ArrayList<UiQmgrAdminSet> changedSets = new ArrayList<UiQmgrAdminSet>();
            if (selectedSets != null) {
                MQExtObject[] mqExtObjects = this.uiQmgrAdminSet.getObjectsInSet();
                int iObj = 0;
                while (iObj < mqExtObjects.length) {
                    int iSet = 0;
                    while (iSet < selectedSets.length) {
                        if (!selectedSets[iSet].isObjectInSet(t, mqExtObjects[iObj])) {
                            selectedSets[iSet].addObject(t, mqExtObjects[iObj]);
                            int disposition = selectedSets[iSet].getDisposition();
                            if (disposition == 0) {
                                selectedSets[iSet].setDisposition(3);
                            }
                            if (!changedSets.contains(selectedSets[iSet])) {
                                changedSets.add(selectedSets[iSet]);
                            }
                            setsChanged = true;
                        }
                        ++iSet;
                    }
                    ++iObj;
                }
            }
            if (setsChanged) {
                SetManager setManager = SetsPlugin.getSetManager();
                Iterator iter = changedSets.iterator();
                while (iter.hasNext()) {
                    setManager.setChanged(t, (UiQmgrAdminSet)iter.next());
                }
                setManager.saveSets(t);
                UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
            }
        }
    }

    protected void deleteSet(Trace t) {
        String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4471", (String)this.uiQmgrAdminSet.getName());
        int rc = MessageBox.showDeleteCancelMessage((Trace)t, (Shell)UiPlugin.getShell(), (String)msg, (int)1, (String)"AMQ4471");
        if (rc == 0) {
            SetManager setManager = SetsPlugin.getSetManager();
            setManager.deleteSet(t, this.uiQmgrAdminSet);
            setManager.saveSets(t);
            UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
        }
    }

    public String getUniqueIdentifier(Trace t) {
        String identifier = this.uiQmgrAdminSet != null ? this.uiQmgrAdminSet.getUniversalId() : super.getUniqueIdentifier(t);
        return identifier;
    }
}

