/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.qmgrs;

import com.ibm.mq.commonservices.internal.command.EndQueueManager;
import com.ibm.mq.commonservices.internal.console.IConsoleCommandListener;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.qmgrs.StartStopLocalQmgrsInSetDialog;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.queuemanager.SelectStopQmgrModeDialog;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Shell;

public class StopLocalQmgrsInSetDialog
extends StartStopLocalQmgrsInSetDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/dialogs/qmgrs/StopLocalQmgrsInSetDialog.java";
    private boolean immediate = false;
    private boolean standbyInstance = false;
    private boolean switchOver = false;
    private boolean clientReconnect = false;

    public StopLocalQmgrsInSetDialog(Trace t, Shell parent, int style) {
        super(t, parent, style);
    }

    @Override
    public boolean displayInitialDialog(Trace t) {
        boolean showMainDialog = true;
        SelectStopQmgrModeDialog dlg = new SelectStopQmgrModeDialog(t, UiPlugin.getShell());
        dlg.setStandbyPermitted(this.getStartedWithPermitFailover(t));
        dlg.setMessage(t, Message.format((String)SetsPlugin.getNLSString(t, "Sets.Dialog.Warning.AllQmgrsStopped"), (String)this.uiQmgrsSet.getName()), 1);
        String title = Message.format((String)SetsPlugin.getNLSString(t, "Sets.Dialog.StopLocalQueueManagersInSet"), (String)this.uiQmgrsSet.getName());
        dlg.setTitle(t, title);
        if (dlg.open() == 0) {
            if (dlg.getModeSelected() == 1) {
                this.immediate = true;
            }
            this.switchOver = dlg.isSwitchOverSelected();
            this.clientReconnect = dlg.isClientReconnectSelected();
        } else {
            showMainDialog = false;
        }
        return showMainDialog;
    }

    @Override
    public boolean isActionComplete(Trace t, UiQueueManager uiQueueManager) {
        boolean complete = false;
        if (this.isQueueManagerStopped(t, uiQueueManager)) {
            complete = true;
        }
        return complete;
    }

    @Override
    public void startAction(Trace t, UiQueueManager uiQueueManager) {
        if (!this.isQueueManagerStopped(t, uiQueueManager)) {
            this.standbyInstance = uiQueueManager.isRunningAsStandby() && !this.switchOver && !this.clientReconnect;
            EndQueueManager endQueueManager = new EndQueueManager(t, (Object)uiQueueManager, (IConsoleCommandListener)this, uiQueueManager.toString(), this.immediate, this.standbyInstance, this.switchOver, this.clientReconnect);
            this.setActionState(t, uiQueueManager, 1);
            endQueueManager.start(t);
        } else {
            if (Trace.isTracing) {
                this.trace(t, "StopLocalQmgrsInSetDialog.startAction", 300, "Queue manager " + uiQueueManager + " is already stopped");
            }
            this.setActionState(t, uiQueueManager, 2);
        }
    }

    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.qmgradmin.sets.infopop.UI_StopLocalQueueManagersInSet";
    }

    public String getTitle(Trace t) {
        String insert = this.msgFile.getMessage("Sets.Dialog.StopLocalQueueManagers");
        return Message.format((String)this.msgFile.getMessage(t, "Sets.Dialog.Title.ActionDialog"), (String)insert);
    }

    @Override
    public boolean isShowDetailsTable() {
        return true;
    }

    @Override
    public String getAllCompletionMessage() {
        return this.msgFile.getMessage("Sets.Dialog.ActionProgress.Stop.AllComplete");
    }

    @Override
    public String getSomeCompletionMessage() {
        return this.msgFile.getMessage("Sets.Dialog.ActionProgress.Stop.SomeComplete");
    }

    @Override
    public String getProgressMessage() {
        return this.msgFile.getMessage("Sets.Dialog.ActionProgress.Stop");
    }

    @Override
    public String[] getExceptionsToIgnore() {
        return new String[]{"AMQ4059", "AMQ4177", "AMQ4044", "AMQ4591"};
    }

    @Override
    public String getStatus(Trace t, UiQueueManager uiQueueManager) {
        String status = "";
        if (!uiQueueManager.isRunning() && this.isTaskComplete(t, uiQueueManager)) {
            status = this.msgFile.getMessage("Sets.Dialog.Status.Stopped");
        } else {
            int actionState = this.getActionState(t, uiQueueManager);
            switch (actionState) {
                case 1: {
                    status = this.msgFile.getMessage("Sets.Dialog.Status.Stopping");
                    break;
                }
                case 0: {
                    status = this.msgFile.getMessage("Sets.Dialog.Status.Started");
                    break;
                }
                case 3: {
                    status = this.msgFile.getMessage("Sets.Dialog.Status.Failed");
                    break;
                }
                case 2: {
                    status = this.msgFile.getMessage("Sets.Dialog.Status.Stopping");
                }
            }
        }
        return status;
    }

    private boolean isQueueManagerStopped(Trace t, UiQueueManager uiQueueManager) {
        boolean result = false;
        if (!NativeCalls.isQueueManagerRunning((Trace)t, (String)uiQueueManager.toString())) {
            result = true;
        }
        return result;
    }

    private boolean getStartedWithPermitFailover(Trace t) {
        boolean result = false;
        ArrayList<UiQueueManager> list = this.getQueueManagersForTable(t);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                if (list.get(i).isStandbyPermitted()) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }
}

