/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.qmgrs;

import com.ibm.mq.commonservices.internal.command.StartQueueManager;
import com.ibm.mq.commonservices.internal.console.IConsoleCommandListener;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.qmgrs.StartStopLocalQmgrsInSetDialog;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.queuemanager.SelectStartQmgrModeDialog;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.swt.widgets.Shell;

public class StartLocalQmgrsInSetDialog
extends StartStopLocalQmgrsInSetDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/dialogs/qmgrs/StartLocalQmgrsInSetDialog.java";
    private boolean failover = false;
    private int startMode = 2;

    public StartLocalQmgrsInSetDialog(Trace t, Shell parent, int style) {
        super(t, parent, style);
    }

    @Override
    public boolean isActionComplete(Trace t, UiQueueManager uiQueueManager) {
        boolean complete = false;
        if (this.isQueueManagerRunning(t, uiQueueManager)) {
            complete = true;
        }
        return complete;
    }

    @Override
    public void startAction(Trace t, UiQueueManager uiQueueManager) {
        if (!this.isQueueManagerRunning(t, uiQueueManager)) {
            if (Trace.isTracing) {
                this.trace(t, "StartLocalQmgrsInSetDialog.startAction", 300, "Starting queue manager " + uiQueueManager);
            }
            StartQueueManager startQueueManager = new StartQueueManager(t, (Object)uiQueueManager, (IConsoleCommandListener)this, uiQueueManager.toString(), this.startMode, this.failover);
            this.setActionState(t, uiQueueManager, 1);
            startQueueManager.start(t);
        } else {
            if (Trace.isTracing) {
                this.trace(t, "StartLocalQmgrsInSetDialog.startAction", 300, "Queue manager " + uiQueueManager + " is already running");
            }
            this.setActionState(t, uiQueueManager, 2);
        }
    }

    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.qmgradmin.sets.infopop.UI_StartLocalQueueManagersInSet";
    }

    public String getTitle(Trace t) {
        String insert = this.msgFile.getMessage("Sets.Dialog.StartLocalQueueManagers");
        return Message.format((String)this.msgFile.getMessage(t, "Sets.Dialog.Title.ActionDialog"), (String)insert);
    }

    @Override
    public boolean isShowDetailsTable() {
        return true;
    }

    @Override
    public String getAllCompletionMessage() {
        return this.msgFile.getMessage("Sets.Dialog.ActionProgress.Start.AllComplete");
    }

    @Override
    public String getSomeCompletionMessage() {
        return this.msgFile.getMessage("Sets.Dialog.ActionProgress.Start.SomeComplete");
    }

    @Override
    public String getProgressMessage() {
        return this.msgFile.getMessage("Sets.Dialog.ActionProgress.Start");
    }

    @Override
    public String[] getExceptionsToIgnore() {
        return null;
    }

    @Override
    public String getStatus(Trace t, UiQueueManager uiQueueManager) {
        String status = "";
        if ((uiQueueManager.isRunning() || uiQueueManager.isRunningAsStandby()) && this.isTaskComplete(t, uiQueueManager)) {
            status = this.msgFile.getMessage("Sets.Dialog.Status.Started");
        } else {
            int actionState = this.getActionState(t, uiQueueManager);
            switch (actionState) {
                case 1: {
                    status = this.msgFile.getMessage("Sets.Dialog.Status.Starting");
                    break;
                }
                case 0: {
                    status = this.msgFile.getMessage("Sets.Dialog.Status.Stopped");
                    break;
                }
                case 3: {
                    status = this.msgFile.getMessage("Sets.Dialog.Status.Failed");
                    break;
                }
                case 2: {
                    status = this.msgFile.getMessage("Sets.Dialog.Status.Starting");
                }
            }
        }
        return status;
    }

    private boolean isQueueManagerRunning(Trace t, UiQueueManager uiQueueManager) {
        boolean result = false;
        if (NativeCalls.isQueueManagerRunning((Trace)t, (String)uiQueueManager.toString())) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean displayInitialDialog(Trace t) {
        boolean showMainDialog = true;
        String title = Message.format((String)SetsPlugin.getNLSString(t, "Sets.Dialog.StartLocalQueueManagersInSet"), (String)this.uiQmgrsSet.getName());
        String msg = Message.format((String)SetsPlugin.getNLSString(t, "Sets.Dialog.Warning.AllQmgrsStarted"), (String)this.uiQmgrsSet.getName());
        SelectStartQmgrModeDialog dlg = new SelectStartQmgrModeDialog(t, UiPlugin.getShell());
        dlg.setTitle(t, title);
        dlg.setMessage(t, msg, 1);
        if (dlg.open() == 0) {
            this.failover = dlg.isPermitStandbySelected();
            this.startMode = dlg.getStartMode();
        } else {
            showMainDialog = false;
        }
        return showMainDialog;
    }
}

