/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.qmgrs;

import com.ibm.mq.commonservices.internal.console.IConsoleCommandListener;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.qmgrs.UiQmgrsSet;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.filters.ValuePair;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class QmgrsActionDialog
extends ExtDialog
implements DmQueueManagerListener,
IConsoleCommandListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/dialogs/qmgrs/QmgrsActionDialog.java";
    protected static final int ACTION_DELAY = 1000;
    protected static final int MONITOR_INTERVAL = 2000;
    protected static final int ACTION_STATE_READY = 0;
    protected static final int ACTION_STATE_INPROGRESS = 1;
    protected static final int ACTION_STATE_COMPLETED = 2;
    protected static final int ACTION_STATE_FAILED = 3;
    private static final int ACTION_DETAIL_STDOUT = 0;
    private static final int ACTION_DETAIL_STDERR = 1;
    private static final int RC_UNKNOWN = -1;
    private static final int MINSIZE_X = 500;
    private static final int MINSIZE_Y = 400;
    private static final int HORIZONTAL_INDENT = 20;
    private static final int NUM_COLS = 4;
    private static final int TABLEMAIN_COLS = 2;
    private static final int TABLEMAIN_COL_QMGRNAME = 0;
    private static final int TABLEMAIN_COL_STATUS = 1;
    private Label labelMessage = null;
    private Table tableMain = null;
    private Label labelDetails = null;
    private Table tableDetails = null;
    private ProgressBar progress = null;
    protected Message msgFile = null;
    private Point preferredSize = null;
    protected UiQmgrsSet uiQmgrsSet = null;
    private Hashtable<UiQueueManager, TableItem> tableItems = null;
    private Hashtable<UiQueueManager, Integer> actionStates = null;
    private Hashtable<UiQueueManager, ArrayList<ValuePair>> actionDetails = null;
    private Hashtable<UiQueueManager, Boolean> commandCompleteTable = null;
    private Hashtable<DmQueueManager, UiQueueManager> queueManagersInTable = null;
    private boolean listenerActive = false;
    private String inProgressMsg = null;
    private String allCompleted = null;
    private String someCompleted = null;
    private String statusFailed = null;
    private boolean isCloseActive = false;
    private UiQueueManager selectedUiQueueManager = null;
    private int countTotal = 0;
    private boolean closeButtonEnabled = false;
    private Thread refreshThread = null;

    public QmgrsActionDialog(Trace t, Shell parent, int style) {
        super(parent, style, 1);
        this.msgFile = SetsPlugin.getMessages(t);
        this.tableItems = new Hashtable();
        this.actionStates = new Hashtable();
        if (this.isShowDetailsTable()) {
            this.actionDetails = new Hashtable();
        }
        this.commandCompleteTable = new Hashtable();
        this.queueManagersInTable = new Hashtable();
        this.inProgressMsg = this.getProgressMessage();
        this.allCompleted = this.getAllCompletionMessage();
        this.someCompleted = this.getSomeCompletionMessage();
        this.statusFailed = this.msgFile.getMessage("Sets.Dialog.Status.Failed");
    }

    public void setValues(Trace t, UiQmgrsSet uiSet) {
        this.uiQmgrsSet = uiSet;
    }

    public Image getImage(Trace t) {
        return Icons.get((String)Icons.iconkeyExplorerSmall);
    }

    public boolean isPackDialog(Trace t) {
        return false;
    }

    public void packDialog(Trace t) {
    }

    public void createContent(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        composite.setLayout((Layout)gridLayout);
        this.labelMessage = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.labelMessage.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.tableMain = new Table(composite, 68356);
        this.tableMain.setLinesVisible(true);
        this.tableMain.setHeaderVisible(true);
        String[] colTitles = new String[]{this.msgFile.getMessage(t, "Sets.Dialog.ColumnTitle.QmgrName"), this.msgFile.getMessage(t, "Sets.Dialog.ColumnTitle.Status")};
        int i = 0;
        while (i < 2) {
            TableColumn column = new TableColumn(this.tableMain, 0);
            column.setText(colTitles[i]);
            ++i;
        }
        composite.getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Trace tr = Trace.getDefault();
                QmgrsActionDialog.this.resizeMainTableColumns(tr);
                if (QmgrsActionDialog.this.isShowDetailsTable()) {
                    QmgrsActionDialog.this.resizeDetailsTableColumn(tr);
                }
            }
        });
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        this.tableMain.setLayoutData((Object)gridData);
        if (this.isShowDetailsTable()) {
            this.tableMain.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    QmgrsActionDialog.this.tableMainSelectionChanged(Trace.getDefault());
                }
            });
            UiUtils.createBlankLine((Composite)composite, (int)4);
            this.labelDetails = new Label(composite, 0);
            this.labelDetails.setText(this.msgFile.getMessage("Sets.Dialog.Text.SelectQmgrToSeeActionDetails"));
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            this.labelDetails.setLayoutData((Object)gridData);
            label = new Label(composite, 0);
            gridData = new GridData();
            gridData.widthHint = 20;
            label.setLayoutData((Object)gridData);
            this.tableDetails = new Table(composite, 68356);
            this.tableDetails.setLinesVisible(true);
            this.tableDetails.setHeaderVisible(true);
            this.tableDetails.setEnabled(false);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            this.tableDetails.setLayoutData((Object)gridData);
            TableColumn tabcol = new TableColumn(this.tableDetails, 0);
            tabcol.setText(this.msgFile.getMessage(t, "Sets.Dialog.ColumnTitle.Details"));
            label = new Label(composite, 0);
            gridData = new GridData();
            gridData.widthHint = 20;
            label.setLayoutData((Object)gridData);
            UiUtils.createBlankLine((Composite)composite, (int)4);
        }
        composite.pack();
        this.preferredSize = composite.getSize();
        if (this.preferredSize.x < 500) {
            this.preferredSize.x = 500;
        }
        if (this.preferredSize.y < 400) {
            this.preferredSize.y = 400;
        }
        composite.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                QmgrsActionDialog.this.isCloseActive = true;
                QmgrsActionDialog.this.stopListeningForChanges(Trace.getDefault());
            }
        });
        this.enableClose(t, false);
    }

    public boolean open(Trace t) {
        boolean result = false;
        if (this.displayInitialDialog(t)) {
            this.populateMainTable(t);
            this.startListeningForChanges(t);
            this.startActions(t);
            result = super.open(t);
        }
        return result;
    }

    private void enableClose(Trace t) {
        this.closeButtonEnabled = true;
        CoreServices.refreshDmMonitor((Trace)t);
        if (this.refreshThread == null) {
            this.startRefreshMonitor(t);
        }
        this.updateProgressMessage(t);
        this.progress.setVisible(false);
        this.enableClose(t, true);
    }

    protected void resizeMainTableColumns(Trace t) {
        Point tableSize = this.tableMain.getSize();
        TableColumn tabcol0 = this.tableMain.getColumn(0);
        TableColumn tabcol1 = this.tableMain.getColumn(1);
        int available = tableSize.x - UiUtils.getVScrollBarWidth((Trace)t, (Table)this.tableMain) - 5 * this.tableMain.getGridLineWidth();
        int widthCol1 = available / 3;
        tabcol1.setWidth(widthCol1);
        int widthCol0 = available * 2 / 3;
        tabcol0.setWidth(widthCol0);
    }

    protected void resizeDetailsTableColumn(Trace t) {
        int availableWidth;
        Point tableSize = this.tableDetails.getSize();
        TableColumn tabcol0 = this.tableDetails.getColumn(0);
        tabcol0.pack();
        int packWidth = tabcol0.getWidth();
        int colWidth = availableWidth = tableSize.x - UiUtils.getVScrollBarWidth((Trace)t, (Table)this.tableDetails) - 5 * this.tableMain.getGridLineWidth();
        if (packWidth > colWidth) {
            colWidth = packWidth;
        }
        tabcol0.setWidth(colWidth);
    }

    public boolean isUserButtons(Trace t) {
        return true;
    }

    public void createUserButtons(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.progress = new ProgressBar(composite, 65794);
        this.progress.setVisible(UiPlugin.isShowAnimations());
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 3;
        this.progress.setLayoutData((Object)gridData);
    }

    public boolean okPressed(Trace t) {
        return true;
    }

    public void cancelPressed(Trace t) {
    }

    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    public boolean isEnableOK(Trace t) {
        return false;
    }

    public boolean isEnableClose(Trace t) {
        return this.getCompletedCount(t) + this.getFailedCount(t) == this.countTotal;
    }

    private void populateMainTable(Trace t) {
        ArrayList<UiQueueManager> uiQueueManagers = this.getQueueManagersForTable(t);
        ArrayList<UiQueueManager> uiQmgrs = this.removeDuplicateQueueManagers(t, uiQueueManagers);
        for (UiQueueManager uiQueueManager : uiQmgrs) {
            this.commandCompleteTable.put(uiQueueManager, false);
        }
        this.countTotal = uiQmgrs.size();
        int i = 0;
        while (i < this.countTotal) {
            UiQueueManager uiQueueManager = uiQmgrs.get(i);
            TableItem tableItem = new TableItem(this.tableMain, 0);
            tableItem.setImage(0, uiQueueManager.getImage());
            tableItem.setText(0, uiQueueManager.toFormattedString());
            boolean completed = this.isActionComplete(t, uiQueueManager);
            if (completed) {
                this.commandCompleteTable.put(uiQueueManager, true);
                if (!uiQueueManager.isShowingPrompt()) {
                    this.setActionState(t, uiQueueManager, 2);
                    this.addActionDetail(t, uiQueueManager, 0, this.getStatus(t, uiQueueManager));
                }
            } else {
                this.setActionState(t, uiQueueManager, 0);
            }
            this.showStatusForQueueManager(t, uiQueueManager, tableItem, 1);
            tableItem.setData((Object)uiQueueManager);
            this.tableItems.put(uiQueueManager, tableItem);
            this.queueManagersInTable.put(uiQueueManager.getDmQueueManagerObject(), uiQueueManager);
            ++i;
        }
        this.updateProgressMessage(t);
    }

    private void startActions(final Trace t) {
        int count = this.tableMain.getItemCount();
        final UiQueueManager[] uiQmgrs = new UiQueueManager[count];
        int i = 0;
        while (i < count) {
            TableItem tableItem = this.tableMain.getItem(i);
            uiQmgrs[i] = (UiQueueManager)tableItem.getData();
            ++i;
        }
        Thread thread = new Thread("IBM MQ - QmgrActions start actions"){

            @Override
            public void run() {
                int i = 0;
                while (i < uiQmgrs.length) {
                    UiQueueManager uiQueueManager = uiQmgrs[i];
                    if (!QmgrsActionDialog.this.isActionStartedUsingCommand()) {
                        QmgrsActionDialog.this.commandCompleteTable.put(uiQueueManager, true);
                    }
                    QmgrsActionDialog.this.startAction(t, uiQueueManager);
                    long timeToSleep = 1000L;
                    if (timeToSleep > 0L) {
                        try {
                            4.sleep(timeToSleep);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    ++i;
                }
            }
        };
        thread.start();
    }

    public boolean displayInitialDialog(Trace t) {
        return true;
    }

    public abstract String getStatus(Trace var1, UiQueueManager var2);

    public abstract boolean isActionStartedUsingCommand();

    public abstract boolean isActionComplete(Trace var1, UiQueueManager var2);

    public abstract ArrayList<UiQueueManager> getQueueManagersForTable(Trace var1);

    public abstract void startAction(Trace var1, UiQueueManager var2);

    public boolean isCloseDialog(Trace t) {
        boolean close = true;
        Enumeration<UiQueueManager> keys = this.commandCompleteTable.keys();
        while (keys.hasMoreElements()) {
            Boolean b = this.commandCompleteTable.get(keys.nextElement());
            if (b.booleanValue()) continue;
            close = false;
            break;
        }
        return close;
    }

    public abstract boolean isShowDetailsTable();

    public abstract String[] getExceptionsToIgnore();

    protected String getConnectionStatus(Trace t, UiQueueManager uiQueueManager) {
        String status = "";
        status = uiQueueManager.isLocal() && !uiQueueManager.getDmQueueManagerObject().isRunning() ? this.msgFile.getMessage("Sets.Dialog.Status.Stopped") : (uiQueueManager.getDmQueueManagerObject().isConnected() ? this.msgFile.getMessage("Sets.Dialog.Status.Connected") : (uiQueueManager.getDmQueueManagerObject().isConnecting() ? this.msgFile.getMessage("Sets.Dialog.Status.Connecting") : this.msgFile.getMessage("Sets.Dialog.Status.Disconnected")));
        return status;
    }

    public void startListeningForChanges(Trace t) {
        if (!this.listenerActive) {
            this.listenerActive = true;
            boolean res = UiPlugin.getTheDataModel().addObserver(t, (DmObjectListener)this, null);
            if (!res) {
                this.listenerActive = false;
                if (Trace.isTracing) {
                    t.data(66, "QmgrsActionDialog.startListeningForChanges", 900, "DataModel.addQueueManagerListener failed");
                }
            }
        }
    }

    public void stopListeningForChanges(Trace t) {
        if (this.listenerActive) {
            this.listenerActive = false;
            UiPlugin.getTheDataModel().deleteObserver(t, (DmObjectListener)this);
        }
        if (this.refreshThread != null) {
            this.refreshThread.interrupt();
        }
    }

    private synchronized void statusChanged(final Trace t, final DmQueueManager dmQueueManager, final DmCoreException exception, final int rc) {
        if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UiQueueManager uiQueueManager = (UiQueueManager)QmgrsActionDialog.this.queueManagersInTable.get(dmQueueManager);
                    if (uiQueueManager != null) {
                        if (QmgrsActionDialog.this.actionStates.containsKey(uiQueueManager)) {
                            QmgrsActionDialog.this.updateQueueManagerStatus(t, uiQueueManager, exception, rc);
                            QmgrsActionDialog.this.updateProgressMessage(t);
                        }
                    } else {
                        t.data(66, "QmgrsActionDialog.statusChanged", 900, "failed to find UiQueueManager for DmQueueManager '" + dmQueueManager.getTreeName(t) + "'");
                    }
                }
            });
        }
    }

    protected void updateQueueManagerStatus(Trace t, UiQueueManager uiQueueManager, DmCoreException exception, int retcode) {
        int rc = retcode;
        if (rc == -1 && exception != null) {
            rc = exception.getReasonCode();
        }
        if (!this.isCloseActive && this.tableItems.containsKey(uiQueueManager)) {
            boolean completed;
            TableItem tableItem = this.tableItems.get(uiQueueManager);
            if (exception != null) {
                if (!this.isIgnoreException(t, exception)) {
                    String message = null;
                    int reasonCode = exception.getReasonCode();
                    if (reasonCode == 50059 || reasonCode == 50058) {
                        message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4617", (String)uiQueueManager.toString());
                        this.setActionState(t, uiQueueManager, 1);
                    } else if (reasonCode == 2546) {
                        message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4618", (String)uiQueueManager.toString());
                        this.setActionState(t, uiQueueManager, 1);
                    } else {
                        this.setActionState(t, uiQueueManager, 3);
                        message = exception.getLocalizedMessage();
                    }
                    this.addActionDetail(t, uiQueueManager, 1, message);
                    if (uiQueueManager == this.selectedUiQueueManager) {
                        this.addItemToDetailsTable(t, 1, message);
                    }
                } else {
                    rc = -1;
                }
            } else if (rc != -1 && rc != 0) {
                this.setActionState(t, uiQueueManager, 3);
            }
            boolean bl = completed = this.isTaskComplete(t, uiQueueManager) && !uiQueueManager.isShowingPrompt();
            if (completed) {
                if (!this.commandCompleteTable.get(uiQueueManager).booleanValue() && !this.actionDetails.containsKey(uiQueueManager)) {
                    this.addActionDetail(t, uiQueueManager, 0, this.getStatus(t, uiQueueManager));
                }
                this.commandCompleteTable.put(uiQueueManager, true);
                if (this.isActionComplete(t, uiQueueManager)) {
                    this.setActionState(t, uiQueueManager, 2);
                } else {
                    this.setActionState(t, uiQueueManager, 3);
                }
            }
            this.showStatusForQueueManager(t, uiQueueManager, tableItem, 1);
            uiQueueManager.updateIcon();
            tableItem.setImage(0, uiQueueManager.getImage());
            if (this.isCloseDialog(t) && !this.isCloseActive && !this.closeButtonEnabled) {
                this.enableClose(t);
            }
        }
    }

    private void showStatusForQueueManager(Trace t, UiQueueManager uiQueueManager, TableItem tableItem, int tableColumn) {
        if (!this.isCloseActive) {
            tableItem.setText(tableColumn, this.getStatusTextForQueueManager(t, uiQueueManager));
            if (this.getActionState(t, uiQueueManager) == 3 && !uiQueueManager.isShowingPrompt()) {
                tableItem.setForeground(tableColumn, UiPlugin.getConsoleStderrColor());
                tableItem.setBackground(tableColumn, UiPlugin.getConsoleBackgroundColor());
            } else {
                tableItem.setForeground(tableColumn, UiPlugin.getConsoleStdoutColor());
                tableItem.setBackground(tableColumn, UiPlugin.getConsoleBackgroundColor());
            }
        }
    }

    private String getStatusTextForQueueManager(Trace t, UiQueueManager uiQueueManager) {
        String status = "";
        status = this.getActionState(t, uiQueueManager) == 3 && !uiQueueManager.isShowingPrompt() ? this.statusFailed : this.getStatus(t, uiQueueManager);
        return status;
    }

    protected void tableMainSelectionChanged(Trace t) {
        TableItem tableItem;
        Object object;
        this.selectedUiQueueManager = null;
        int index = this.tableMain.getSelectionIndex();
        if (index != -1 && (object = (tableItem = this.tableMain.getItem(index)).getData()) instanceof UiQueueManager) {
            this.selectedUiQueueManager = (UiQueueManager)object;
        }
        this.tableDetails.setEnabled(true);
        this.populateDetailsTable(t, this.selectedUiQueueManager);
    }

    protected void setActionState(Trace t, UiQueueManager uiQueueManager, int state) {
        this.actionStates.put(uiQueueManager, state);
        if (Trace.isTracing) {
            this.trace(t, "QmgrsActionDialog.setActionState", 300, "setActionState: state for " + uiQueueManager + " now " + state);
        }
    }

    protected int getActionState(Trace t, UiQueueManager uiQueueManager) {
        int state = 0;
        if (this.actionStates.containsKey(uiQueueManager)) {
            state = this.actionStates.get(uiQueueManager);
        }
        return state;
    }

    protected boolean isTaskComplete(Trace t, UiQueueManager uiQueueManager) {
        boolean result = false;
        if (this.commandCompleteTable.containsKey(uiQueueManager)) {
            result = this.commandCompleteTable.get(uiQueueManager) != false && !uiQueueManager.isShowingPrompt();
        }
        return result;
    }

    protected void addActionDetail(Trace t, UiQueueManager uiQueueManager, int type, String detail) {
        ArrayList<Object> details;
        if (!this.actionDetails.containsKey(uiQueueManager)) {
            details = new ArrayList();
            this.actionDetails.put(uiQueueManager, details);
        }
        if (this.actionDetails.containsKey(uiQueueManager)) {
            details = this.actionDetails.get(uiQueueManager);
            details.add(new ValuePair(type, detail));
        }
    }

    private void populateDetailsTable(Trace t, UiQueueManager uiQueueManager) {
        if (!this.tableDetails.isDisposed()) {
            this.tableDetails.removeAll();
            if (uiQueueManager != null) {
                ArrayList<ValuePair> details = this.actionDetails.get(uiQueueManager);
                if (details != null) {
                    for (ValuePair detail : details) {
                        this.addItemToDetailsTable(t, detail.getValue(), detail.toString());
                    }
                }
                this.resizeDetailsTableColumn(t);
                this.labelDetails.setText(Message.format((String)this.msgFile.getMessage("Sets.Dialog.Text.QmgrActionDetails"), (String)uiQueueManager.toFormattedString()));
            }
        }
    }

    private void addItemToDetailsTable(Trace t, int type, String text) {
        TableItem tableItem = new TableItem(this.tableDetails, 0);
        tableItem.setText(text);
        if (type == 0) {
            tableItem.setForeground(UiPlugin.getConsoleStdoutColor());
            tableItem.setBackground(UiPlugin.getConsoleBackgroundColor());
        } else {
            tableItem.setForeground(UiPlugin.getConsoleStderrColor());
            tableItem.setBackground(UiPlugin.getConsoleBackgroundColor());
        }
        this.resizeDetailsTableColumn(t);
    }

    private int getCompletedCount(Trace t) {
        int count = 0;
        Enumeration<Integer> states = this.actionStates.elements();
        while (states.hasMoreElements()) {
            if (states.nextElement() != 2) continue;
            ++count;
        }
        if (Trace.isTracing) {
            this.trace(t, "QmgrsActionDialog.getCompletedCount", 300, "getCompletedCount: count now " + count);
        }
        return count;
    }

    private int getFailedCount(Trace t) {
        int count = 0;
        Enumeration<Integer> states = this.actionStates.elements();
        while (states.hasMoreElements()) {
            if (states.nextElement() != 3) continue;
            ++count;
        }
        if (Trace.isTracing) {
            this.trace(t, "QmgrsActionDialog.getFailedCount", 300, "getFailedCount: count now " + count);
        }
        return count;
    }

    private void updateProgressMessage(Trace t) {
        if (!this.labelMessage.isDisposed()) {
            int countFailed;
            int countCompleted = this.getCompletedCount(t);
            if (countCompleted + (countFailed = this.getFailedCount(t)) == this.countTotal) {
                if (countFailed == 0) {
                    this.labelMessage.setText(this.allCompleted);
                } else {
                    this.labelMessage.setText(Message.format((String)this.someCompleted, (String)("" + countCompleted), (String)("" + this.countTotal)));
                }
            } else {
                String incompleteString = "" + countCompleted;
                String totalString = "" + this.countTotal;
                this.labelMessage.setText(Message.format((String)this.inProgressMsg, (String)incompleteString, (String)totalString));
            }
        }
    }

    public void dmQueueManagerConnected(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmQueueManager dmQueueManager = (DmQueueManager)event.getSource();
        if (Trace.isTracing) {
            if (event.getException() != null) {
                this.trace(t, "QmgrsActionDialog.dmQueueManagerConnected", 900, "dmObjectConnected for " + dmQueueManager.getDmTitle() + ", exception = " + event.getException().getLocalizedMessage());
            } else {
                this.trace(t, "QmgrsActionDialog.dmQueueManagerConnected", 300, "dmObjectConnected for " + dmQueueManager.getDmTitle());
            }
        }
        this.statusChanged(t, dmQueueManager, event.getException(), -1);
    }

    public void dmQueueManagerConnecting(DmObjectEvent event) {
    }

    public void dmQueueManagerDisconnected(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmQueueManager dmQueueManager = (DmQueueManager)event.getSource();
        if (Trace.isTracing) {
            if (event.getException() != null) {
                this.trace(t, "QmgrsActionDialog.dmQueueManagerDisconnected", 900, "dmObjectDisconnected for " + dmQueueManager.getDmTitle() + ", exception = " + event.getException().getLocalizedMessage());
            } else {
                this.trace(t, "QmgrsActionDialog.dmQueueManagerDisconnected", 300, "dmObjectDisconnected for " + dmQueueManager.getDmTitle());
            }
        }
        this.statusChanged(t, dmQueueManager, event.getException(), -1);
    }

    public void dmQueueManagerHidden(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmQueueManager dmQueueManager = (DmQueueManager)event.getSource();
        if (Trace.isTracing) {
            if (event.getException() != null) {
                this.trace(t, "QmgrsActionDialog.dmQueueManagerHidden", 900, "dmObjectHidden for " + dmQueueManager.getDmTitle() + ", exception = " + event.getException().getLocalizedMessage());
            } else {
                this.trace(t, "QmgrsActionDialog.dmQueueManagerHidden", 300, "dmObjectHidden for " + dmQueueManager.getDmTitle());
            }
        }
        this.statusChanged(t, dmQueueManager, event.getException(), -1);
    }

    public void dmQueueManagerShown(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmQueueManager dmQueueManager = (DmQueueManager)event.getSource();
        if (Trace.isTracing) {
            if (event.getException() != null) {
                this.trace(t, "QmgrsActionDialog.dmQueueManagerShown", 900, "dmObjectShown for " + dmQueueManager.getDmTitle() + ", exception = " + event.getException().getLocalizedMessage());
            } else {
                this.trace(t, "QmgrsActionDialog.dmQueueManagerShown", 300, "dmObjectShown for " + dmQueueManager.getDmTitle());
            }
        }
        this.statusChanged(t, dmQueueManager, event.getException(), -1);
    }

    public void dmObjectAdded(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmQueueManager dmQueueManager = (DmQueueManager)event.getSource();
        if (Trace.isTracing) {
            if (event.getException() != null) {
                this.trace(t, "QmgrsActionDialog.dmObjectAdded", 900, "dmObjectAdded for " + dmQueueManager.getDmTitle() + ", exception = " + event.getException().getLocalizedMessage());
            } else {
                this.trace(t, "QmgrsActionDialog.dmObjectAdded", 300, "dmObjectAdded for " + dmQueueManager.getDmTitle());
            }
        }
        this.statusChanged(t, dmQueueManager, event.getException(), -1);
    }

    public void dmObjectChanged(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmQueueManager dmQueueManager = (DmQueueManager)event.getSource();
        if (Trace.isTracing) {
            if (event.getException() != null) {
                this.trace(t, "QmgrsActionDialog.dmObjectChanged", 900, "dmObjectChanged for " + dmQueueManager.getDmTitle() + ", exception = " + event.getException().getLocalizedMessage());
            } else {
                this.trace(t, "QmgrsActionDialog.dmObjectChanged", 300, "dmObjectChanged for " + dmQueueManager.getDmTitle());
            }
        }
        this.statusChanged(t, dmQueueManager, event.getException(), -1);
    }

    public void dmObjectDeleted(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmQueueManager dmQueueManager = (DmQueueManager)event.getSource();
        if (Trace.isTracing) {
            if (event.getException() != null) {
                this.trace(t, "QmgrsActionDialog.dmObjectDeleted", 900, "dmObjectDeleted for " + dmQueueManager.getDmTitle() + ", exception = " + event.getException().getLocalizedMessage());
            } else {
                this.trace(t, "QmgrsActionDialog.dmObjectDeleted", 300, "dmObjectDeleted for " + dmQueueManager.getDmTitle());
            }
        }
        this.statusChanged(t, dmQueueManager, event.getException(), -1);
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    public void finish(Trace t, Object id, int exitValue) {
        if (Trace.isTracing) {
            this.trace(t, "QmgrsActionDialog.finish", 300, "finish for " + id.toString() + ", exitValue = " + exitValue);
        }
        String msg = this.msgFile.getMessage("Sets.ExitValue.Text", new String[]{String.valueOf(exitValue)});
        this.stdout(t, id, msg);
        if (id instanceof UiQueueManager) {
            UiQueueManager uiQueueManager = (UiQueueManager)id;
            this.commandCompleteTable.put(uiQueueManager, true);
            this.statusChanged(t, uiQueueManager.getDmQueueManagerObject(), null, exitValue);
        }
    }

    public void stderr(final Trace t, final Object id, final String text) {
        if (id instanceof UiQueueManager && !this.getShell().isDisposed()) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UiQueueManager uiQueueManager = (UiQueueManager)id;
                    QmgrsActionDialog.this.addActionDetail(t, uiQueueManager, 1, text);
                    if (uiQueueManager == QmgrsActionDialog.this.selectedUiQueueManager) {
                        QmgrsActionDialog.this.addItemToDetailsTable(t, 1, text);
                    }
                }
            });
        }
    }

    public void stdout(final Trace t, final Object id, final String text) {
        if (id instanceof UiQueueManager && !this.getShell().isDisposed()) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UiQueueManager uiQueueManager = (UiQueueManager)id;
                    QmgrsActionDialog.this.addActionDetail(t, uiQueueManager, 0, text);
                    if (uiQueueManager == QmgrsActionDialog.this.selectedUiQueueManager) {
                        QmgrsActionDialog.this.addItemToDetailsTable(t, 0, text);
                    }
                }
            });
        }
    }

    public void shellActivated(ShellEvent e) {
        Trace t = Trace.getDefault();
        this.resizeMainTableColumns(t);
        if (this.isShowDetailsTable()) {
            this.resizeDetailsTableColumn(t);
        }
    }

    public abstract String getProgressMessage();

    public abstract String getAllCompletionMessage();

    public abstract String getSomeCompletionMessage();

    protected void trace(Trace t, String fid, int detail, String string) {
        if (Trace.isTracing) {
            t.data(66, fid, detail, string);
        }
    }

    private ArrayList<UiQueueManager> removeDuplicateQueueManagers(Trace t, ArrayList<UiQueueManager> uiQmgrs) {
        ArrayList<UiQueueManager> returnArray = new ArrayList<UiQueueManager>();
        ArrayList<DmQueueManager> dmQueueManagersAdded = new ArrayList<DmQueueManager>();
        for (UiQueueManager uiQueueManager : uiQmgrs) {
            DmQueueManager dmQueueManager = uiQueueManager.getDmQueueManagerObject();
            if (dmQueueManager != null) {
                if (dmQueueManagersAdded.contains(dmQueueManager)) continue;
                returnArray.add(uiQueueManager);
                dmQueueManagersAdded.add(dmQueueManager);
                continue;
            }
            returnArray.add(uiQueueManager);
        }
        return returnArray;
    }

    private boolean isIgnoreException(Trace t, DmCoreException exception) {
        boolean ignore = false;
        String[] ignoreExceptions = this.getExceptionsToIgnore();
        if (ignoreExceptions != null) {
            int i = 0;
            while (i < ignoreExceptions.length && !ignore) {
                if (ignoreExceptions[i].compareTo(exception.getMessageID()) == 0) {
                    if (Trace.isTracing) {
                        t.data(66, "QmgrsActionDialog.isIgnoreException", 300, "Ignoring exception " + exception.getMessageID());
                    }
                    ignore = true;
                }
                ++i;
            }
        }
        if (!ignore && exception.getMessageID().compareTo("AMQ4999") == 0 && exception.getReasonCode() == 0) {
            ignore = true;
            if (Trace.isTracing) {
                t.data(66, "QmgrsActionDialog.isIgnoreException", 300, "Ignoring exception AMQ4999 with reason code 0");
            }
        }
        return ignore;
    }

    private void startRefreshMonitor(Trace t) {
        this.refreshThread = new Thread("IBM MQ - QmgrActions monitor"){
            boolean open;
            {
                this.open = true;
            }

            @Override
            public void run() {
                while (this.open) {
                    try {
                        8.sleep(2000L);
                        Display.getDefault().asyncExec(new Runnable(){
                            Trace t2 = Trace.getDefault();

                            @Override
                            public void run() {
                                if (!QmgrsActionDialog.this.isCloseActive) {
                                    Enumeration qmgrs = QmgrsActionDialog.this.tableItems.keys();
                                    while (qmgrs.hasMoreElements()) {
                                        UiQueueManager uiQueueManager = (UiQueueManager)qmgrs.nextElement();
                                        TableItem tableItem = (TableItem)QmgrsActionDialog.this.tableItems.get(uiQueueManager);
                                        QmgrsActionDialog.this.showStatusForQueueManager(this.t2, uiQueueManager, tableItem, 1);
                                        uiQueueManager.updateIcon();
                                        tableItem.setImage(0, uiQueueManager.getImage());
                                    }
                                }
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        this.open = false;
                    }
                }
            }
        };
        this.refreshThread.start();
    }
}

