/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.qmgrs.ConnectDisconnectQmgrsInSetDialog;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.swt.widgets.Shell;

public class DisconnectFromQmgrsInSetDialog
extends ConnectDisconnectQmgrsInSetDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/dialogs/qmgrs/DisconnectFromQmgrsInSetDialog.java";

    public DisconnectFromQmgrsInSetDialog(Trace t, Shell parent, int style) {
        super(t, parent, style);
    }

    @Override
    public boolean isActionComplete(Trace t, UiQueueManager uiQueueManager) {
        boolean complete = false;
        if (!uiQueueManager.isConnected() && !uiQueueManager.isConnecting()) {
            complete = true;
        }
        return complete;
    }

    @Override
    public void startAction(Trace t, UiQueueManager uiQueueManager) {
        boolean isDisconnect = false;
        if (uiQueueManager.isConnected()) {
            isDisconnect = true;
        }
        if (isDisconnect) {
            if (Trace.isTracing) {
                this.trace(t, "DisconnectFromQmgrsInSetDialog.startAction", 300, "Disconnecting from queue manager " + uiQueueManager);
            }
            this.setActionState(t, uiQueueManager, 1);
            uiQueueManager.getDmQueueManagerObject().disconnect(t);
        } else {
            if (Trace.isTracing) {
                this.trace(t, "DisconnectFromQmgrsInSetDialog.startAction", 300, "Queue manager " + uiQueueManager + "is already disconnected");
            }
            this.setActionState(t, uiQueueManager, 2);
        }
    }

    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.qmgradmin.sets.infopop.UI_DisconnectFromQueueManagersInSet";
    }

    public String getTitle(Trace t) {
        String insert = this.msgFile.getMessage("Sets.Dialog.DisconnectFromQueueManagers");
        return Message.format((String)this.msgFile.getMessage(t, "Sets.Dialog.Title.ActionDialog"), (String)insert);
    }

    @Override
    public boolean isShowDetailsTable() {
        return true;
    }

    @Override
    public String getAllCompletionMessage() {
        return this.msgFile.getMessage("Sets.Dialog.ActionProgress.Disconnect.AllComplete");
    }

    @Override
    public String getSomeCompletionMessage() {
        return this.msgFile.getMessage("Sets.Dialog.ActionProgress.Disconnect.SomeComplete");
    }

    @Override
    public String getProgressMessage() {
        return this.msgFile.getMessage("Sets.Dialog.ActionProgress.Disconnect");
    }

    @Override
    public String[] getExceptionsToIgnore() {
        return new String[]{"AMQ4059"};
    }
}

