/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.event.DmMonitor;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.qmgrs.ConnectDisconnectQmgrsInSetDialog;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.Hashtable;
import org.eclipse.swt.widgets.Shell;

public class ConnectToQmgrsInSetDialog
extends ConnectDisconnectQmgrsInSetDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/dialogs/qmgrs/ConnectToQmgrsInSetDialog.java";
    private Hashtable<UiQueueManager, Object> listeners = new Hashtable();

    public ConnectToQmgrsInSetDialog(Trace t, Shell parent, int style) {
        super(t, parent, style);
    }

    @Override
    public boolean isActionComplete(Trace t, UiQueueManager uiQueueManager) {
        boolean complete = false;
        if (!uiQueueManager.isShowingPrompt() && uiQueueManager.isConnected()) {
            complete = true;
        }
        return complete;
    }

    @Override
    public void startAction(Trace t, UiQueueManager uiQueueManager) {
        if (!uiQueueManager.isConnected() && !uiQueueManager.isConnecting()) {
            if (Trace.isTracing) {
                this.trace(t, "ConnectToQmgrsInSetDialog.startAction", 300, "Connecting to queue manager " + uiQueueManager);
            }
            if (this.isOperationSupported(uiQueueManager)) {
                this.setActionState(t, uiQueueManager, 1);
                Object listenerKey = DmMonitor.addQueueManagerListener((Trace)t, (DmQueueManagerListener)uiQueueManager, (boolean)true);
                this.listeners.put(uiQueueManager, listenerKey);
                uiQueueManager.getDmQueueManagerObject().connectAsynchronously(t);
            }
        } else {
            if (Trace.isTracing) {
                this.trace(t, "ConnectToQmgrsInSetDialog.startAction", 300, "Queue manager " + uiQueueManager + "is already connected");
            }
            this.setActionState(t, uiQueueManager, 2);
        }
    }

    boolean isOperationSupported(final UiQueueManager uiQueueManager) {
        final Trace t = Trace.getInstance();
        boolean supported = true;
        DmQueueManager dmQMgr = uiQueueManager.getDmQueueManagerObject();
        if (dmQMgr.getConnectionHandle().isPromptPassword()) {
            supported = false;
            if (!this.getShell().isDisposed()) {
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String message = ConnectToQmgrsInSetDialog.this.msgFile.getMessage("Sets.Dialog.Action.Connect.Password.Prompt.NotSupported");
                        ConnectToQmgrsInSetDialog.this.setActionState(t, uiQueueManager, 3);
                        ConnectToQmgrsInSetDialog.this.addActionDetail(t, uiQueueManager, 3, message);
                        ConnectToQmgrsInSetDialog.this.updateQueueManagerStatus(t, uiQueueManager, null, -1);
                    }
                });
            }
        }
        return supported;
    }

    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.qmgradmin.sets.infopop.UI_ConnectToQueueManagersInSet";
    }

    public String getTitle(Trace t) {
        String insert = this.msgFile.getMessage("Sets.Dialog.ConnectToQueueManagers");
        return Message.format((String)this.msgFile.getMessage(t, "Sets.Dialog.Title.ActionDialog"), (String)insert);
    }

    @Override
    public boolean isShowDetailsTable() {
        return true;
    }

    @Override
    public String getAllCompletionMessage() {
        return this.msgFile.getMessage("Sets.Dialog.ActionProgress.Connect.AllComplete");
    }

    @Override
    public String getSomeCompletionMessage() {
        return this.msgFile.getMessage("Sets.Dialog.ActionProgress.Connect.SomeComplete");
    }

    @Override
    public String getProgressMessage() {
        return this.msgFile.getMessage("Sets.Dialog.ActionProgress.Connect");
    }

    @Override
    public String[] getExceptionsToIgnore() {
        return null;
    }

    @Override
    public void stopListeningForChanges(Trace t) {
        for (UiQueueManager uiQueueManager : this.listeners.keySet()) {
            DmMonitor.removeQueueManagerListener((Trace)t, (DmQueueManagerListener)uiQueueManager, (Object)this.listeners.get(uiQueueManager));
        }
        super.stopListeningForChanges(t);
    }
}

