/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.ManageSetsDialog;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.UiQmgrAdminSet;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetManager;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetProvider;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class SetSelectionDialog
extends TrayDialog
implements ICheckStateListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/dialogs/SetSelectionDialog.java";
    public static final int ICON_INFO = 0;
    public static final int ICON_WARNING = 1;
    public static final int ICON_ERROR = 2;
    private static final int NUM_COLS = 4;
    private static final int TABLE_WIDTH_HINT = 400;
    private static final int TABLE_ROWS_HINT = 8;
    private String noObjectMessage = null;
    private int noObjectIcon = 1;
    private Composite compositeMsgBar = null;
    private Label labelMsgBarIcon = null;
    private Label labelMsgBarMessage = null;
    private Table tableSets = null;
    private CheckboxTableViewer viewer = null;
    private TableColumn tableColumn = null;
    private Composite compositeSelectButtons = null;
    private Button buttonSelectAll = null;
    private Button buttonSelectNone = null;
    private ArrayList<UiQmgrAdminSet> setsAvailable = null;
    private ArrayList<UiQmgrAdminSet> setsSelected = null;
    private ArrayList<UiQmgrAdminSet> setsUnselected = null;
    private Message msgFile = null;
    protected SetManager setManager = null;
    private Composite compositeControls = null;
    private Button buttonManageSets = null;

    public SetSelectionDialog(Shell parent) {
        super(parent);
        Trace t = Trace.getDefault();
        this.msgFile = SetsPlugin.getMessages(t);
        this.setManager = SetsPlugin.getSetManager();
        this.setsSelected = new ArrayList();
        this.setsUnselected = new ArrayList();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                SetSelectionDialog.this.resizeTableColumns(Trace.getDefault());
            }
        });
    }

    private void populateSetList(Trace t) {
        this.tableSets.removeAll();
        this.setsSelected.clear();
        this.setsUnselected.clear();
        SetProvider setProvider = this.getSetProvider(t);
        this.setsAvailable = this.setManager.getAvailableSets(t, setProvider.getObjectId(), this.getInstanceId(t), setProvider);
        int i = 0;
        while (i < this.setsAvailable.size()) {
            int disposition;
            UiQmgrAdminSet uiSet = this.setsAvailable.get(i);
            if (this.isIncludeSet(t, uiSet) && (disposition = uiSet.getDisposition()) != 2) {
                TableItem tableItem = new TableItem(this.tableSets, 0);
                tableItem.setText(0, uiSet.getName());
                tableItem.setData((Object)uiSet);
                boolean check = this.isInitiallyCheckSet(t, uiSet);
                this.viewer.setChecked((Object)uiSet, check);
                if (check) {
                    this.setsSelected.add(uiSet);
                } else {
                    this.setsUnselected.add(uiSet);
                }
            }
            ++i;
        }
        if (this.tableSets.getItemCount() == 0 && this.noObjectMessage != null && !this.labelMsgBarMessage.isDisposed()) {
            this.labelMsgBarMessage.setText(this.noObjectMessage);
            this.labelMsgBarMessage.setVisible(true);
            this.labelMsgBarIcon.setVisible(true);
            this.setMessageIcon(t, this.noObjectIcon);
            this.compositeMsgBar.layout();
            this.compositeControls.layout();
            this.compositeControls.update();
        } else if (this.compositeMsgBar != null) {
            this.labelMsgBarMessage.setVisible(false);
            this.labelMsgBarIcon.setVisible(false);
        }
    }

    private void setMessageIcon(Trace t, int iconId) {
        switch (iconId) {
            case 2: {
                this.labelMsgBarIcon.setImage(Dialog.getImage((String)"dialog_message_error_image"));
                break;
            }
            case 0: {
                this.labelMsgBarIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                break;
            }
            default: {
                this.labelMsgBarIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
            }
        }
    }

    public Control createDialogArea(Composite parent) {
        Composite composite;
        Trace t = Trace.getDefault();
        this.compositeControls = composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(this.getPromptText(t));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        if (this.noObjectMessage != null) {
            this.compositeMsgBar = new Composite(composite, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.makeColumnsEqualWidth = false;
            this.compositeMsgBar.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.compositeMsgBar.setLayoutData((Object)gridData);
            this.labelMsgBarIcon = new Label(this.compositeMsgBar, 0);
            this.labelMsgBarIcon.setVisible(false);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            this.labelMsgBarIcon.setLayoutData((Object)gridData);
            this.labelMsgBarMessage = new Label(this.compositeMsgBar, 0);
            this.labelMsgBarMessage.setText("");
            this.labelMsgBarMessage.setVisible(false);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            this.labelMsgBarMessage.setLayoutData((Object)gridData);
        } else {
            label = new Label(composite, 0);
            label.setVisible(false);
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            label.setLayoutData((Object)gridData);
        }
        this.tableSets = new Table(composite, 2848);
        this.tableSets.setLinesVisible(true);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        gridData.widthHint = 400;
        gridData.heightHint = this.tableSets.getItemHeight() * 8;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.tableSets.setLayoutData((Object)gridData);
        this.viewer = new CheckboxTableViewer(this.tableSets);
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        this.tableColumn = new TableColumn(this.tableSets, 0);
        composite.getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SetSelectionDialog.this.resizeTableColumns(Trace.getDefault());
            }
        });
        this.compositeSelectButtons = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeSelectButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.compositeSelectButtons.setLayoutData((Object)gridData);
        this.buttonSelectAll = new Button(this.compositeSelectButtons, 8);
        this.buttonSelectAll.setText(UiPlugin.getNLSString((Trace)t, (String)"KEY_General", (String)"UI.GENERAL.SELECT.ALL"));
        gridData = new GridData();
        this.buttonSelectAll.setLayoutData((Object)gridData);
        this.buttonSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SetSelectionDialog.this.selectAll(Trace.getDefault());
            }
        });
        this.buttonSelectNone = new Button(this.compositeSelectButtons, 8);
        this.buttonSelectNone.setText(UiPlugin.getNLSString((Trace)t, (String)"KEY_General", (String)"UI.GENERAL.SELECT.NONE"));
        gridData = new GridData();
        this.buttonSelectNone.setLayoutData((Object)gridData);
        this.buttonSelectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SetSelectionDialog.this.selectNone(Trace.getDefault());
            }
        });
        label = new Label(this.compositeSelectButtons, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        ButtonTools.makeEqualWidthGridData((Trace)t, (Composite)this.compositeSelectButtons);
        this.buttonManageSets = new Button(this.compositeSelectButtons, 8);
        this.buttonManageSets.setText(this.msgFile.getMessage("Sets.Manage.Sets.MenuItem"));
        gridData = new GridData();
        this.buttonManageSets.setLayoutData((Object)gridData);
        this.buttonManageSets.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                SetSelectionDialog.this.manageSets(tr);
            }
        });
        this.compositeControls.layout();
        this.populateSetList(t);
        return composite;
    }

    public UiQmgrAdminSet[] getSelectedSets() {
        return this.setsSelected.toArray(new UiQmgrAdminSet[this.setsSelected.size()]);
    }

    public UiQmgrAdminSet[] getUnselectedSets() {
        return this.setsUnselected.toArray(new UiQmgrAdminSet[this.setsUnselected.size()]);
    }

    public void setNoObjectMessage(Trace t, int iconId, String msg) {
        this.noObjectMessage = msg;
        this.noObjectIcon = iconId;
    }

    public void displayErrorMessage(Trace t, int iconId, String msg, boolean disableControls) {
        this.setMessageIcon(t, iconId);
        this.labelMsgBarIcon.setVisible(true);
        this.labelMsgBarMessage.setText(msg);
        this.labelMsgBarMessage.setVisible(true);
        this.compositeMsgBar.layout();
        this.compositeMsgBar.redraw();
        if (disableControls) {
            this.tableSets.setEnabled(false);
            this.buttonSelectAll.setEnabled(false);
            this.buttonSelectNone.setEnabled(false);
            this.buttonManageSets.setEnabled(false);
        }
    }

    protected void manageSets(Trace t) {
        ManageSetsDialog manageDialog = new ManageSetsDialog(this.getShell());
        manageDialog.setValues(t, this.getInstanceId(t), this.getSetProvider(t));
        if (manageDialog.open() == 0) {
            this.populateSetList(t);
            UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
        }
    }

    protected void resizeTableColumns(Trace t) {
        Point tableSize = this.tableSets.getSize();
        int widthCol0 = tableSize.x - UiUtils.getVScrollBarWidth((Trace)t, (Table)this.tableSets) - 5 * this.tableSets.getGridLineWidth();
        this.tableColumn.setWidth(widthCol0);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        UiQmgrAdminSet uiQmgrAdminSet = null;
        Object obj = event.getElement();
        if (obj instanceof UiQmgrAdminSet) {
            uiQmgrAdminSet = (UiQmgrAdminSet)obj;
        }
        if (uiQmgrAdminSet != null) {
            boolean state = event.getChecked();
            if (state) {
                this.setsSelected.add(uiQmgrAdminSet);
                if (this.setsUnselected.contains(uiQmgrAdminSet)) {
                    this.setsUnselected.remove(uiQmgrAdminSet);
                }
            } else {
                this.setsUnselected.add(uiQmgrAdminSet);
                if (this.setsSelected.contains(uiQmgrAdminSet)) {
                    this.setsSelected.remove(uiQmgrAdminSet);
                }
            }
        }
    }

    protected void selectAll(Trace t) {
        this.viewer.setAllChecked(true);
        this.setsSelected.clear();
        Iterator<UiQmgrAdminSet> iterator = this.setsAvailable.iterator();
        while (iterator.hasNext()) {
            this.setsSelected.add(iterator.next());
        }
        this.setsUnselected.clear();
    }

    protected void selectNone(Trace t) {
        this.viewer.setAllChecked(false);
        this.setsSelected.clear();
        this.setsUnselected.clear();
        Iterator<UiQmgrAdminSet> iterator = this.setsAvailable.iterator();
        while (iterator.hasNext()) {
            this.setsUnselected.add(iterator.next());
        }
    }

    public abstract boolean isIncludeSet(Trace var1, UiQmgrAdminSet var2);

    public abstract boolean isInitiallyCheckSet(Trace var1, UiQmgrAdminSet var2);

    public abstract String getPromptText(Trace var1);

    public abstract String getInstanceId(Trace var1);

    public abstract SetProvider getSetProvider(Trace var1);
}

