/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NameSetDialog
extends TrayDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/dialogs/NameSetDialog.java";
    private Label labelName = null;
    private Text textName = null;
    private String name = "";
    private String[] existingNames = null;
    private String dlgTitle = null;
    private Label labelIcon = null;
    private Label labelMsg = null;
    private static final int NUM_COLS = 6;
    private Message msgFile = null;

    public NameSetDialog(Shell parent) {
        super(parent);
        Trace t = Trace.getDefault();
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.msgFile = SetsPlugin.getMessages(t);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        UiPlugin.getHelpSystem().setHelp((Control)newShell, "com.ibm.mq.explorer.qmgradmin.sets.infopop.UI_SetCopyAsDialog");
        newShell.setText(this.dlgTitle);
    }

    public void setValues(Trace t, String title, String[] existNames) {
        this.existingNames = existNames;
        this.dlgTitle = title;
    }

    private void checkIfEnableOK(Trace t) {
        boolean enabled = this.isEnableOK(t);
        Button b = this.getButton(0);
        if (b != null) {
            b.setEnabled(enabled);
        }
    }

    public String getName() {
        return this.name;
    }

    public Control createDialogArea(Composite parent) {
        Trace t = Trace.getDefault();
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setVisible(false);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        label.setLayoutData((Object)gridData);
        this.labelName = new Label(composite, 0);
        this.labelName.setText(this.msgFile.getMessage(t, "Sets.Dialog.NewSetName"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.labelName.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.textName = new Text(composite, 2048);
        this.textName.setText(this.name);
        this.textName.setTextLimit(48);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.grabExcessHorizontalSpace = true;
        this.textName.setLayoutData((Object)gridData);
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                NameSetDialog.this.checkIfEnableOK(tr);
            }
        });
        this.labelIcon = new Label(composite, 1);
        this.labelIcon.setImage(Dialog.getImage((String)"dialog_message_error_image"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.labelIcon.setLayoutData((Object)gridData);
        this.labelMsg = new Label(composite, 0);
        this.labelMsg.setText(this.msgFile.getMessage(t, "Sets.Dialog.NameInUseMsg"));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 5;
        this.labelMsg.setLayoutData((Object)gridData);
        composite.pack();
        this.checkIfEnableOK(t);
        return composite;
    }

    private boolean isEnableOK(Trace t) {
        boolean alreadyExists = false;
        boolean enableOK = false;
        this.name = this.textName.getText();
        int i = 0;
        while (i < this.existingNames.length) {
            if (this.existingNames[i].compareToIgnoreCase(this.name) == 0) {
                alreadyExists = true;
            }
            ++i;
        }
        this.labelIcon.setVisible(alreadyExists);
        this.labelMsg.setVisible(alreadyExists);
        enableOK = !alreadyExists && this.name.length() > 0;
        return enableOK;
    }
}

