/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.EditSetDialog;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.NameSetDialog;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.UiQmgrAdminSet;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetManager;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetNewObjectProvider;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetProvider;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.SetsWizDlg;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ObjectNameViewerSorter;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ManageSetsDialog
extends TrayDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/dialogs/ManageSetsDialog.java";
    private static final int COL_NAME = 0;
    private static final int COL_TYPE = 1;
    private Composite compositeACERButtons = null;
    private static final int NUM_COLS = 4;
    private static final int TABLE_WIDTH_HINT = 400;
    private static final int TABLE_ROWS_HINT = 10;
    private Table tableSets = null;
    private TableViewer tableviewerSets = null;
    private TableColumn tabcolName = null;
    private TableColumn tabcolType = null;
    private Button buttonAdd = null;
    private Button buttonCopyAs = null;
    private Button buttonEdit = null;
    private Button buttonRemove = null;
    private GridData gridDataAdd = null;
    private GridData gridDataCopyAs = null;
    private GridData gridDataEdit = null;
    private GridData gridDataRemove = null;
    private ArrayList<UiQmgrAdminSet> setsArray = null;
    private UiQmgrAdminSet selectedSet = null;
    private SetProvider setProvider = null;
    private Message msgFile = null;
    boolean isChanged = false;
    private String objectId = null;
    private String instanceId = null;
    private SetManager setManager = null;
    private UiQmgrAdminSet lastChangedSet = null;
    private ArrayList<Filter> availableFilters = null;

    public ManageSetsDialog(Shell parent) {
        super(parent);
        Trace t = Trace.getDefault();
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.msgFile = SetsPlugin.getMessages(t);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        UiPlugin.getHelpSystem().setHelp((Control)newShell, "com.ibm.mq.explorer.qmgradmin.sets.infopop.UI_SetManageDialog");
        newShell.setText(this.msgFile.getMessage(Trace.getDefault(), "Sets.Dialog.ManageSetsTitle"));
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                ManageSetsDialog.this.populateSetTable(Trace.getDefault());
                ManageSetsDialog.this.resizeTableColumns(Trace.getDefault());
            }
        });
    }

    public void setValues(Trace t, String instId, SetProvider setProv) {
        this.setProvider = setProv;
        this.objectId = this.setProvider.getObjectId();
        this.instanceId = instId;
        this.setManager = SetsPlugin.getSetManager();
        this.setsArray = new ArrayList<UiQmgrAdminSet>(this.setManager.getAvailableSets(t, this.objectId, this.instanceId, this.setProvider));
        this.availableFilters = UiPlugin.getFilterManager().getAvailableFilters(t, this.setProvider.getFilterId());
    }

    private void setSelectionChanged(Trace t) {
        boolean enableEditButton = false;
        boolean enableRemoveButton = false;
        boolean enableCopyAsButton = false;
        int selectedIndex = this.tableSets.getSelectionIndex();
        this.selectedSet = selectedIndex != -1 ? (UiQmgrAdminSet)this.tableSets.getItem(selectedIndex).getData() : null;
        if (this.selectedSet != null) {
            enableEditButton = true;
            enableRemoveButton = true;
            enableCopyAsButton = true;
        }
        this.buttonEdit.setEnabled(enableEditButton);
        this.buttonRemove.setEnabled(enableRemoveButton);
        this.buttonCopyAs.setEnabled(enableCopyAsButton);
    }

    private void populateSetTable(Trace t) {
        this.tableviewerSets.refresh();
        if (this.tableSets.getItemCount() > 0) {
            this.tableSets.select(0);
            this.tableSets.showSelection();
        }
        this.setSelectionChanged(t);
    }

    private void addSet(Trace t) {
        UiQmgrAdminSet newUiSet;
        SetNewObjectProvider setNewObjectProvider = new SetNewObjectProvider(t, 0, null);
        setNewObjectProvider.setExistingSets(this.setsArray);
        setNewObjectProvider.setSetProvider(this.setProvider);
        setNewObjectProvider.setAvailableFilters(this.availableFilters);
        NewObjectWiz newObjectWiz = new NewObjectWiz(t, (NewObjectProvider)setNewObjectProvider, this.objectId);
        SetsWizDlg setsWizDlg = new SetsWizDlg(this.getShell(), (IWizard)newObjectWiz);
        setsWizDlg.create();
        if (setsWizDlg.open() != 1 && (newUiSet = setNewObjectProvider.getCreatedSet()) != null) {
            if (newUiSet.isAutomaticSet().booleanValue()) {
                ArrayList<MQExtObject> objects = SetsPlugin.getKnownObjectsForAutomaticSet(t, newUiSet, this.objectId);
                for (MQExtObject mqExtObject : objects) {
                    newUiSet.addObject(t, mqExtObject);
                }
            }
            this.setsArray.add(newUiSet);
            this.populateSetTable(t);
            this.selectSetInTable(t, newUiSet);
            this.tableSets.showSelection();
            this.setSelectionChanged(t);
            this.isChanged = true;
            this.lastChangedSet = newUiSet;
        }
    }

    private void editSet(Trace t) {
        int index = this.tableSets.getSelectionIndex();
        UiQmgrAdminSet uiSet = (UiQmgrAdminSet)this.tableSets.getItem(index).getData();
        UiQmgrAdminSet editUiSet = this.setProvider.createSet(t);
        if (editUiSet != null) {
            editUiSet.copyFrom(t, uiSet);
            EditSetDialog editSetDialog = new EditSetDialog(t, this.getShell());
            boolean editName = true;
            editSetDialog.setValues(t, editUiSet, editName, this.instanceId, this.setProvider);
            if (editSetDialog.open() == 0) {
                if (editUiSet.isAutomaticSet().booleanValue()) {
                    editUiSet.removeAllMembers(t);
                    ArrayList<MQExtObject> objects = SetsPlugin.getKnownObjectsForAutomaticSet(t, editUiSet, this.objectId);
                    for (MQExtObject mqExtObject : objects) {
                        editUiSet.addObject(t, mqExtObject);
                    }
                }
                uiSet.copyFrom(t, editUiSet);
                int disposition = uiSet.getDisposition();
                if (disposition == 0) {
                    uiSet.setDisposition(3);
                }
                this.populateSetTable(t);
                this.selectSetInTable(t, uiSet);
                this.tableSets.showSelection();
                this.setSelectionChanged(t);
                this.isChanged = true;
                this.lastChangedSet = uiSet;
            }
        }
    }

    private void removeSet(Trace t) {
        int index = this.tableSets.getSelectionIndex();
        UiQmgrAdminSet uiSet = (UiQmgrAdminSet)this.tableSets.getItem(index).getData();
        String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4471", (String)uiSet.getName());
        int rc = MessageBox.showDeleteCancelMessage((Trace)t, (Shell)this.getShell(), (String)msg, (int)1, (String)"AMQ4471");
        if (rc == 0) {
            int disposition = uiSet.getDisposition();
            if (disposition == 1) {
                uiSet.setDisposition(4);
            } else {
                uiSet.setDisposition(2);
            }
            if (this.setManager == null) {
                this.setManager = SetsPlugin.getSetManager();
            }
            this.setManager.deleteSet(t, uiSet);
            this.setManager.saveSets(t);
            UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
            this.populateSetTable(t);
            this.isChanged = true;
        }
    }

    private void copySet(Trace t) {
        UiQmgrAdminSet newUiSet;
        int index = this.tableSets.getSelectionIndex();
        UiQmgrAdminSet uiSet = (UiQmgrAdminSet)this.tableSets.getItem(index).getData();
        String dlgTitle = this.msgFile.getMessage(t, "Sets.Dialog.CopySetTitle");
        NameSetDialog nameDlg = new NameSetDialog(this.getShell());
        ArrayList<String> existingNames = new ArrayList<String>();
        for (UiQmgrAdminSet uiQmgrAdminSet : this.setsArray) {
            if (uiQmgrAdminSet.getDisposition() == 4 || uiQmgrAdminSet.getDisposition() == 2 || uiQmgrAdminSet.getDisposition() == 5) continue;
            existingNames.add(uiQmgrAdminSet.getName());
        }
        nameDlg.setValues(t, dlgTitle, existingNames.toArray(new String[existingNames.size()]));
        if (nameDlg.open() == 0 && (newUiSet = this.setProvider.createSet(t)) != null) {
            newUiSet.copyFrom(t, uiSet);
            String newName = nameDlg.getName();
            newUiSet.setName(t, newName);
            newUiSet.resetUniversalId(t);
            newUiSet.setTreeNode(null);
            newUiSet.setDisposition(1);
            this.setsArray.add(newUiSet);
            this.populateSetTable(t);
            this.selectSetInTable(t, newUiSet);
            this.tableSets.showSelection();
            this.setSelectionChanged(t);
            this.isChanged = true;
            this.lastChangedSet = newUiSet;
        }
    }

    private void saveSets(Trace t) {
        this.setManager.setSets(t, this.objectId, this.instanceId, this.setsArray, this.setProvider);
        UiPlugin.showBusyCursor((Trace)t, (Shell)this.getShell(), (boolean)true);
        this.setManager.saveSets(t);
        UiPlugin.showBusyCursor((Trace)t, (Shell)this.getShell(), (boolean)false);
    }

    public Control createDialogArea(Composite parent) {
        Trace t = Trace.getDefault();
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setVisible(false);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(this.msgFile.getMessage(t, "Sets.Dialog.Set"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.tableSets = new Table(composite, 68352);
        this.tableSets.setHeaderVisible(true);
        this.tableSets.setLinesVisible(true);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        gridData.widthHint = 400;
        gridData.heightHint = this.tableSets.getItemHeight() * 10;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.tableSets.setLayoutData((Object)gridData);
        this.tableSets.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageSetsDialog.this.setSelectionChanged(tr);
            }
        });
        this.tableviewerSets = new TableViewer(this.tableSets);
        this.tableviewerSets.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            ArrayList<?> elementArray = null;

            public Object[] getElements(Object inputElement) {
                ArrayList<UiQmgrAdminSet> elements = new ArrayList<UiQmgrAdminSet>();
                for (Object object : this.elementArray) {
                    UiQmgrAdminSet uiQmgrAdminSet;
                    if (!(object instanceof UiQmgrAdminSet) || (uiQmgrAdminSet = (UiQmgrAdminSet)object).isAllSet().booleanValue() || uiQmgrAdminSet.getDisposition() == 4 || uiQmgrAdminSet.getDisposition() == 2 || uiQmgrAdminSet.getDisposition() == 5) continue;
                    elements.add(uiQmgrAdminSet);
                }
                return elements.toArray(new UiQmgrAdminSet[elements.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof ArrayList) {
                    this.elementArray = (ArrayList)newInput;
                }
            }
        });
        this.tableviewerSets.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                Image colImage = null;
                if (element instanceof UiQmgrAdminSet && columnIndex == 0) {
                    colImage = ((UiQmgrAdminSet)element).getImage();
                }
                return colImage;
            }

            public String getColumnText(Object element, int columnIndex) {
                String colText = "";
                if (element instanceof UiQmgrAdminSet) {
                    UiQmgrAdminSet uiQmgrAdminSet = (UiQmgrAdminSet)element;
                    if (columnIndex == 0) {
                        colText = uiQmgrAdminSet.getName();
                    } else if (columnIndex == 1) {
                        colText = uiQmgrAdminSet.getType(Trace.getDefault());
                    }
                }
                return colText;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        ObjectNameViewerSorter viewerSorter = new ObjectNameViewerSorter();
        this.tableviewerSets.setSorter((ViewerSorter)viewerSorter);
        this.tabcolName = new TableColumn(this.tableSets, 0);
        this.tabcolName.setText(this.msgFile.getMessage("Sets.ContentPage.TitleText.Name"));
        this.tabcolType = new TableColumn(this.tableSets, 0);
        this.tabcolType.setText(this.msgFile.getMessage("Sets.ContentPage.TitleText.Type"));
        composite.getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ManageSetsDialog.this.resizeTableColumns(Trace.getDefault());
            }
        });
        this.compositeACERButtons = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeACERButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.compositeACERButtons.setLayoutData((Object)gridData);
        this.buttonAdd = new Button(this.compositeACERButtons, 8);
        this.buttonAdd.setText(this.msgFile.getMessage(t, "Sets.Dialog.AddSetButton"));
        this.gridDataAdd = new GridData();
        this.buttonAdd.setLayoutData((Object)this.gridDataAdd);
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageSetsDialog.this.addSet(tr);
            }
        });
        this.buttonCopyAs = new Button(this.compositeACERButtons, 8);
        this.buttonCopyAs.setText(this.msgFile.getMessage(t, "Sets.Dialog.CopySetButton"));
        this.gridDataCopyAs = new GridData();
        this.buttonCopyAs.setLayoutData((Object)this.gridDataCopyAs);
        this.buttonCopyAs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageSetsDialog.this.copySet(tr);
            }
        });
        this.buttonEdit = new Button(this.compositeACERButtons, 8);
        this.buttonEdit.setText(this.msgFile.getMessage(t, "Sets.Dialog.EditSetButton"));
        this.gridDataEdit = new GridData();
        this.buttonEdit.setLayoutData((Object)this.gridDataEdit);
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageSetsDialog.this.editSet(tr);
            }
        });
        this.buttonRemove = new Button(this.compositeACERButtons, 8);
        this.buttonRemove.setText(this.msgFile.getMessage(t, "Sets.Dialog.RemoveSetButton"));
        this.gridDataRemove = new GridData();
        this.buttonRemove.setLayoutData((Object)this.gridDataRemove);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageSetsDialog.this.removeSet(tr);
            }
        });
        label = new Label(this.compositeACERButtons, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        int maxWidth = 0;
        Point sizeAdd = this.buttonAdd.computeSize(-1, -1);
        Point sizeCopyAs = this.buttonCopyAs.computeSize(-1, -1);
        Point sizeEdit = this.buttonEdit.computeSize(-1, -1);
        Point sizeRemove = this.buttonRemove.computeSize(-1, -1);
        if (sizeAdd.x > maxWidth) {
            maxWidth = sizeAdd.x;
        }
        if (sizeCopyAs.x > maxWidth) {
            maxWidth = sizeCopyAs.x;
        }
        if (sizeEdit.x > maxWidth) {
            maxWidth = sizeEdit.x;
        }
        if (sizeRemove.x > maxWidth) {
            maxWidth = sizeRemove.x;
        }
        this.gridDataAdd.widthHint = maxWidth;
        this.gridDataCopyAs.widthHint = maxWidth;
        this.gridDataEdit.widthHint = maxWidth;
        this.gridDataRemove.widthHint = maxWidth;
        this.tableviewerSets.setInput(this.setsArray);
        this.setSelectionChanged(t);
        return composite;
    }

    protected void okPressed() {
        Trace t = Trace.getDefault();
        if (this.isChanged) {
            this.saveSets(t);
        }
        super.okPressed();
    }

    public UiQmgrAdminSet getLastChangedSet() {
        return this.lastChangedSet;
    }

    protected void resizeTableColumns(Trace t) {
        Point tableSize = this.tableSets.getSize();
        int widthColName = tableSize.x / 2;
        this.tabcolName.setWidth(widthColName);
        int widthColType = tableSize.x - UiUtils.getVScrollBarWidth((Trace)t, (Table)this.tableSets) - widthColName - 5 * this.tableSets.getGridLineWidth();
        this.tabcolType.setWidth(widthColType);
    }

    private void selectSetInTable(Trace t, UiQmgrAdminSet uiQmgrAdminSet) {
        TableItem[] tableItems = this.tableSets.getItems();
        int i = 0;
        while (i < tableItems.length) {
            if (tableItems[i].getData() == uiQmgrAdminSet) {
                this.tableSets.setSelection(tableItems[i]);
                break;
            }
            ++i;
        }
    }
}

