/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.controls.EditFiltersComposite;
import com.ibm.mq.explorer.qmgradmin.sets.internal.controls.FiltersChangedEvent;
import com.ibm.mq.explorer.qmgradmin.sets.internal.controls.IFiltersChangedListener;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.UiQmgrAdminSet;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetProvider;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditSetDialog
extends TrayDialog
implements IFiltersChangedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/dialogs/EditSetDialog.java";
    private static final int NUM_COLS = 4;
    public static final int MINSIZE_X = 400;
    public static final int MINSIZE_Y = 200;
    private Composite compMsg = null;
    private Label labelIcon = null;
    private Label labelMsg = null;
    private Message msgFile = null;
    private UiQmgrAdminSet editUiSet = null;
    private SetProvider setProvider = null;
    private ArrayList<UiQmgrAdminSet> allSets = null;
    private boolean isEditName = false;
    private String originalName = null;
    private String instanceId = null;
    private Label labelSetName = null;
    private Text textSetName = null;
    private EditFiltersComposite editFiltersComposite = null;
    private Point preferredSize = null;
    private ArrayList<Filter> selectedFilters = null;
    private boolean isValidSelection = true;

    public EditSetDialog(Trace t, Shell parent) {
        super(parent);
        this.msgFile = SetsPlugin.getMessages(t);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String helpId = this.editUiSet.isManualSet() != false ? "com.ibm.mq.explorer.qmgradmin.sets.infopop.UI_ManualSetEditDialog" : "com.ibm.mq.explorer.qmgradmin.sets.infopop.UI_AutoSetEditDialog";
        UiPlugin.getHelpSystem().setHelp((Control)newShell, helpId);
        newShell.setText(this.msgFile.getMessage(Trace.getDefault(), "Sets.Dialog.EditSetTitle"));
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                if (EditSetDialog.this.editFiltersComposite != null) {
                    EditSetDialog.this.editFiltersComposite.setActive(Trace.getDefault());
                }
            }
        });
    }

    public void setValues(Trace t, UiQmgrAdminSet uiExpGroup, boolean editName, String instId, SetProvider setProv) {
        this.editUiSet = uiExpGroup;
        this.isEditName = editName;
        this.instanceId = instId;
        this.setProvider = setProv;
        this.originalName = new String(this.editUiSet.getName());
        this.allSets = SetsPlugin.getSetManager().getAvailableSets(t, setProv.getObjectId(), this.instanceId, this.setProvider);
    }

    protected void checkIfEnableOK(Trace t) {
        boolean enabled = this.isEnableOK(t);
        Button b = this.getButton(0);
        if (b != null) {
            b.setEnabled(enabled);
        }
    }

    public Control createDialogArea(Composite parent) {
        Trace t = Trace.getDefault();
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        composite.setLayout((Layout)gridLayout);
        this.compMsg = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        this.compMsg.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.compMsg.setLayoutData((Object)gridData);
        this.labelIcon = new Label(this.compMsg, 1);
        this.labelIcon.setImage(Dialog.getImage((String)"dialog_message_error_image"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.labelIcon.setLayoutData((Object)gridData);
        this.labelMsg = new Label(this.compMsg, 0);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.labelMsg.setLayoutData((Object)gridData);
        this.labelSetName = new Label(composite, 0);
        this.labelSetName.setText(this.msgFile.getMessage(t, "Sets.Dialog.SetName"));
        gridData = new GridData();
        this.labelSetName.setLayoutData((Object)gridData);
        this.textSetName = new Text(composite, 2048);
        this.textSetName.setText(this.editUiSet.getName());
        this.textSetName.setTextLimit(48);
        if (!this.isEditName) {
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.textSetName, (boolean)true);
        } else {
            this.textSetName.setSelection(this.textSetName.getText().length());
        }
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        this.textSetName.setLayoutData((Object)gridData);
        this.textSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                EditSetDialog.this.checkIfEnableOK(tr);
            }
        });
        Label label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(this.msgFile.getMessage("Sets.Dialog.SetType"));
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        Text textSetType = new Text(composite, 2048);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)textSetType, (boolean)true);
        String setTypeName = this.editUiSet.getType(t);
        textSetType.setText(setTypeName);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        textSetType.setLayoutData((Object)gridData);
        if (this.editUiSet.isAutomaticSet().booleanValue()) {
            label = new Label(composite, 0);
            label.setVisible(false);
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            label.setLayoutData((Object)gridData);
            this.editFiltersComposite = new EditFiltersComposite(composite, 0, this.setProvider);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 4;
            this.editFiltersComposite.setLayoutData(gridData);
            this.editFiltersComposite.setMatchRule(t, this.editUiSet.getMatchRule());
            this.editFiltersComposite.setFilters(t, this.editUiSet.getFilters());
            this.editFiltersComposite.addFiltersChangedListener(t, this);
        }
        composite.pack();
        this.preferredSize = composite.getSize();
        if (this.preferredSize.x < 400) {
            this.preferredSize.x = 400;
        }
        if (this.preferredSize.y < 200) {
            this.preferredSize.y = 200;
        }
        this.checkIfEnableOK(t);
        return composite;
    }

    protected void okPressed() {
        Trace t = Trace.getDefault();
        this.saveName(t);
        if (this.editUiSet.getMembershipType() == 1) {
            this.editUiSet.setMatchRule(this.editFiltersComposite.getMatchRule());
            this.editUiSet.setFilters(this.editFiltersComposite.getFilters());
        }
        super.okPressed();
    }

    private void saveName(Trace t) {
        if (this.isEditName) {
            this.editUiSet.setName(t, this.textSetName.getText());
        }
    }

    private boolean isEnableOK(Trace t) {
        boolean isError = false;
        String errorMsg = "";
        boolean enableOK = false;
        boolean lengthOK = false;
        String expGroupName = this.textSetName.getText();
        if (this.isEditName) {
            boolean bl = lengthOK = expGroupName.length() > 0;
            if (lengthOK) {
                if (expGroupName.compareTo(this.originalName) != 0) {
                    for (UiQmgrAdminSet uiSet : this.allSets) {
                        int disposition = uiSet.getDisposition();
                        if (disposition == 2 || disposition == 5 || uiSet.getName().compareTo(expGroupName) != 0) continue;
                        isError = true;
                        errorMsg = this.msgFile.getMessage(t, "Sets.Dialog.NameInUseMsg");
                    }
                }
            } else {
                isError = true;
                errorMsg = this.msgFile.getMessage(t, "Sets.Dialog.NoNameMsg");
            }
        }
        if (!isError && this.editUiSet.getMembershipType() == 1) {
            if (this.selectedFilters == null || this.selectedFilters.size() == 0) {
                isError = true;
                errorMsg = this.msgFile.getMessage(t, "Sets.Message.No.Filters.Selected");
            } else if (!this.isValidSelection) {
                isError = true;
                errorMsg = this.msgFile.getMessage(t, "Sets.Message.Invalid.Filter.Selection");
            }
        }
        this.labelIcon.setVisible(isError);
        this.labelMsg.setText(errorMsg);
        this.labelMsg.setVisible(isError);
        enableOK = !isError;
        return enableOK;
    }

    @Override
    public void changed(FiltersChangedEvent e) {
        Trace t = Trace.getDefault();
        this.selectedFilters = e.getSelectedFilters();
        this.isValidSelection = e.isValidSelection();
        boolean enabled = this.isEnableOK(t);
        Button b = this.getButton(0);
        if (b != null) {
            b.setEnabled(enabled);
        }
    }
}

