/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.controls;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.controls.SeparatorObject;
import com.ibm.mq.explorer.ui.internal.filters.CompareFilterNames;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SelectedFiltersContentProvider
implements IStructuredContentProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/controls/SelectedFiltersContentProvider.java";
    public static int SEPARATOR_TYPE_NONE = 0;
    public static int SEPARATOR_TYPE_AND = 1;
    public static int SEPARATOR_TYPE_OR = 2;
    private int separatorType = SEPARATOR_TYPE_NONE;
    private ArrayList<?> objectArray = null;
    private SeparatorObject separatorObject = null;
    private SeparatorObject separatorAnd = null;
    private SeparatorObject separatorOr = null;

    public SelectedFiltersContentProvider(Trace t) {
        this.separatorAnd = new SeparatorObject("    " + SetsPlugin.getNLSString(t, "Sets.Wizard.Separator.And") + "    ");
        this.separatorOr = new SeparatorObject("    " + SetsPlugin.getNLSString(t, "Sets.Wizard.Separator.Or") + "    ");
    }

    public Object[] getElements(Object inputElement) {
        Trace t = Trace.getDefault();
        this.setSeparatorObject(t);
        Object[] objects = null;
        if (this.objectArray == null || this.objectArray.size() == 0) {
            objects = new Object[]{};
        } else if (this.objectArray.size() == 1 || this.separatorObject == null) {
            int size = this.objectArray.size();
            objects = new Object[size];
            int i = 0;
            while (i < size) {
                objects[i] = this.objectArray.get(i);
                ++i;
            }
        } else {
            try {
                Filter[] filters = this.objectArray.toArray(new Filter[this.objectArray.size()]);
                Arrays.sort(filters, new CompareFilterNames());
                int size = (filters.length - 1) * 2 + 1;
                objects = new Object[size];
                objects[0] = filters[0];
                int i = 1;
                while (i < filters.length) {
                    objects[2 * i - 1] = this.separatorObject;
                    objects[2 * i] = filters[i];
                    ++i;
                }
            }
            catch (ArrayStoreException arrayStoreException) {
                objects = new Object[]{};
            }
        }
        return objects;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ArrayList) {
            this.objectArray = (ArrayList)newInput;
        }
    }

    public void setSeparatorType(Trace t, int type) {
        this.separatorType = type;
        this.setSeparatorObject(t);
    }

    private void setSeparatorObject(Trace t) {
        this.separatorObject = this.separatorType == SEPARATOR_TYPE_AND ? this.separatorAnd : (this.separatorType == SEPARATOR_TYPE_OR ? this.separatorOr : null);
    }
}

