/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.controls;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.controls.FiltersChangedEvent;
import com.ibm.mq.explorer.qmgradmin.sets.internal.controls.IFiltersChangedListener;
import com.ibm.mq.explorer.qmgradmin.sets.internal.controls.SelectedFiltersContentProvider;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetProvider;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ObjectContentProvider;
import com.ibm.mq.explorer.ui.internal.controls.ObjectNameViewerSorter;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.ManageFiltersDialog;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class EditFiltersComposite
extends Composite {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/controls/EditFiltersComposite.java";
    private static final int NUM_COLS = 3;
    private static final int TABLE_WIDTH_HINT = 200;
    private static final int TABLE_HEIGHT_HINT = 250;
    private Message msgFile = null;
    private SetProvider setProvider = null;
    private Button radioMatchAll = null;
    private Button radioMatchAny = null;
    private Table tableAvailable = null;
    private TableViewer tableViewerAvailable = null;
    private TableColumn tabcolAvailable = null;
    private ObjectContentProvider contentProviderAvailable = null;
    private Table tableSelected = null;
    private TableViewer tableViewerSelected = null;
    private TableColumn tabcolSelected = null;
    private SelectedFiltersContentProvider contentProviderSelected = null;
    Text textLabel = null;
    private Label labelAvailFilters = null;
    private Label labelSelFilters = null;
    private Composite compositeAddRemButtons = null;
    private Button buttonAdd = null;
    private Button buttonRemove = null;
    private Button buttonManage = null;
    private Filter selAvailableFilter = null;
    private Filter selSelectedFilter = null;
    private Filter selMostRecentFilter = null;
    private int matchRule = 0;
    private ArrayList<Filter> availFilters = null;
    private ArrayList<Filter> selFilters = null;
    private Vector<IFiltersChangedListener> filtersChangedListeners = null;

    public EditFiltersComposite(Composite parent, int style, SetProvider setProv) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.setProvider = setProv;
        this.filtersChangedListeners = new Vector();
        this.availFilters = UiPlugin.getFilterManager().getAvailableFilters(t, this.setProvider.getFilterId());
        this.msgFile = SetsPlugin.getMessages(t);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.makeColumnsEqualWidth = false;
        this.setLayout((Layout)gridLayout);
        Composite compMatch = new Composite((Composite)this, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.makeColumnsEqualWidth = false;
        compMatch.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1, 1, true, false);
        gridData.horizontalSpan = 3;
        compMatch.setLayoutData((Object)gridData);
        this.textLabel = new Text(compMatch, 0);
        this.textLabel.setText(this.msgFile.getMessage("Sets.Wizard.MatchPrompt"));
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.textLabel, (boolean)true);
        gridData = new GridData(1, 1, false, false);
        this.textLabel.setLayoutData((Object)gridData);
        Composite compRadios = new Composite(compMatch, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.makeColumnsEqualWidth = false;
        compRadios.setLayout((Layout)gridLayout);
        gridData = new GridData(1, 1, true, false);
        compRadios.setLayoutData((Object)gridData);
        this.radioMatchAll = new Button(compRadios, 16);
        this.radioMatchAll.setText(this.msgFile.getMessage("Sets.Wizard.MatchAll"));
        this.radioMatchAll.setSelection(this.matchRule == 0);
        this.radioMatchAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                EditFiltersComposite.this.matchRule = 0;
                EditFiltersComposite.this.contentProviderSelected.setSeparatorType(tr, SelectedFiltersContentProvider.SEPARATOR_TYPE_AND);
                EditFiltersComposite.this.updateSelectedFilterList(tr);
            }
        });
        this.radioMatchAny = new Button(compRadios, 16);
        this.radioMatchAny.setText(this.msgFile.getMessage("Sets.Wizard.MatchAny"));
        this.radioMatchAny.setSelection(this.matchRule == 1);
        this.radioMatchAny.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                EditFiltersComposite.this.matchRule = 1;
                EditFiltersComposite.this.contentProviderSelected.setSeparatorType(tr, SelectedFiltersContentProvider.SEPARATOR_TYPE_OR);
                EditFiltersComposite.this.updateSelectedFilterList(tr);
            }
        });
        Label label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        Composite left = new Composite((Composite)this, 0);
        gridData = new GridData(1808);
        left.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        left.setLayout((Layout)gridLayout);
        Composite middle = new Composite((Composite)this, 0);
        gridLayout = new GridLayout();
        middle.setLayout((Layout)gridLayout);
        Composite right = new Composite((Composite)this, 0);
        gridData = new GridData(1808);
        right.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        right.setLayout((Layout)gridLayout);
        this.labelAvailFilters = new Label(left, 0);
        this.labelAvailFilters.setText(SetsPlugin.getNLSString(t, "Sets.Wizard.AvailableFilters"));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.labelAvailFilters.setLayoutData((Object)gridData);
        this.labelSelFilters = new Label(right, 0);
        this.labelSelFilters.setText(SetsPlugin.getNLSString(t, "Sets.Wizard.SelectedFilters"));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.labelSelFilters.setLayoutData((Object)gridData);
        this.tableAvailable = new Table(left, 68352);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 200;
        gridData.heightHint = 250;
        this.tableAvailable.setLayoutData((Object)gridData);
        this.tableAvailable.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (EditFiltersComposite.this.tableAvailable.getSelectionIndices().length == 0 && EditFiltersComposite.this.tableAvailable.getItems().length > 0) {
                    EditFiltersComposite.this.tableAvailable.setSelection(EditFiltersComposite.this.tableAvailable.getTopIndex());
                    EditFiltersComposite.this.availFilterSelectionChanged(Trace.getDefault());
                }
            }
        });
        this.tableAvailable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditFiltersComposite.this.availFilterSelectionChanged(tr);
            }
        });
        this.tableAvailable.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = String.valueOf(EditFiltersComposite.this.labelAvailFilters.getText()) + " " + e.result;
            }
        });
        this.tabcolAvailable = new TableColumn(this.tableAvailable, 0);
        this.tableViewerAvailable = new TableViewer(this.tableAvailable);
        ObjectNameViewerSorter viewerSorter = new ObjectNameViewerSorter();
        this.tableViewerAvailable.setSorter((ViewerSorter)viewerSorter);
        this.contentProviderAvailable = new ObjectContentProvider();
        this.tableViewerAvailable.setContentProvider((IContentProvider)this.contentProviderAvailable);
        this.compositeAddRemButtons = new Composite(middle, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeAddRemButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(1040);
        gridData.grabExcessVerticalSpace = true;
        this.compositeAddRemButtons.setLayoutData((Object)gridData);
        label = new Label(this.compositeAddRemButtons, 0);
        gridData = new GridData(1040);
        label.setLayoutData((Object)gridData);
        this.buttonAdd = new Button(this.compositeAddRemButtons, 8);
        this.buttonAdd.setText(this.msgFile.getMessage(t, "Sets.Wizard.Add"));
        gridData = new GridData();
        this.buttonAdd.setLayoutData((Object)gridData);
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditFiltersComposite.this.addFilter(tr);
            }
        });
        label = new Label(this.compositeAddRemButtons, 0);
        gridData = new GridData(1040);
        label.setLayoutData((Object)gridData);
        this.buttonRemove = new Button(this.compositeAddRemButtons, 8);
        this.buttonRemove.setText(this.msgFile.getMessage(t, "Sets.Wizard.Remove"));
        this.buttonRemove.setEnabled(false);
        gridData = new GridData();
        this.buttonRemove.setLayoutData((Object)gridData);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditFiltersComposite.this.removeFilter(tr);
            }
        });
        label = new Label(this.compositeAddRemButtons, 0);
        gridData = new GridData(1040);
        label.setLayoutData((Object)gridData);
        ButtonTools.makeEqualWidthGridData((Trace)t, (Composite)this.compositeAddRemButtons);
        this.tableSelected = new Table(right, 68352);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 200;
        gridData.heightHint = 250;
        this.tableSelected.setLayoutData((Object)gridData);
        this.tableSelected.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (EditFiltersComposite.this.tableSelected.getSelectionIndices().length == 0 && EditFiltersComposite.this.tableSelected.getItems().length > 0) {
                    EditFiltersComposite.this.tableSelected.setSelection(EditFiltersComposite.this.tableSelected.getTopIndex());
                    EditFiltersComposite.this.selFilterSelectionChanged(Trace.getDefault());
                }
            }
        });
        this.tableSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditFiltersComposite.this.selFilterSelectionChanged(tr);
            }
        });
        this.tableSelected.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = String.valueOf(EditFiltersComposite.this.labelSelFilters.getText()) + " " + e.result;
            }
        });
        this.tabcolSelected = new TableColumn(this.tableSelected, 0);
        this.tableViewerSelected = new TableViewer(this.tableSelected);
        this.contentProviderSelected = new SelectedFiltersContentProvider(t);
        this.tableViewerSelected.setContentProvider((IContentProvider)this.contentProviderSelected);
        label = new Label((Composite)this, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.buttonManage = new Button((Composite)this, 8);
        this.buttonManage.setText(UiPlugin.getNLSString((Trace)t, (String)"KEY_Filters", (String)"UI.FILTERS.Dialog.ManageFilters"));
        gridData = new GridData();
        this.buttonManage.setLayoutData((Object)gridData);
        this.buttonManage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditFiltersComposite.this.manageFilters(tr);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                EditFiltersComposite.this.resizeTableColumns(Trace.getDefault());
            }
        });
        this.tableViewerAvailable.setInput(this.availFilters);
        this.tableViewerSelected.setInput(this.selFilters);
    }

    public void setActive(Trace t) {
        this.resizeTableColumns(Trace.getDefault());
        this.triggerFiltersChangedListeners(t);
        if (this.textLabel != null) {
            this.textLabel.setFocus();
        }
    }

    public void setMatchRule(Trace t, int rule) {
        this.matchRule = rule;
        this.radioMatchAny.setSelection(this.matchRule == 1);
        this.radioMatchAll.setSelection(this.matchRule == 0);
        if (this.matchRule == 0) {
            this.contentProviderSelected.setSeparatorType(t, SelectedFiltersContentProvider.SEPARATOR_TYPE_AND);
        } else {
            this.contentProviderSelected.setSeparatorType(t, SelectedFiltersContentProvider.SEPARATOR_TYPE_OR);
        }
    }

    public int getMatchRule() {
        return this.matchRule;
    }

    public Button getSelectedRadioButton(Trace t) {
        Button b = this.radioMatchAll;
        if (this.radioMatchAny.getSelection()) {
            b = this.radioMatchAny;
        }
        return b;
    }

    public void setFilters(Trace t, ArrayList<Filter> filts) {
        this.selFilters = filts;
        this.tableViewerSelected.setInput(this.selFilters);
        this.updateSelectedFilterList(t);
        for (Filter filter : this.selFilters) {
            if (!this.availFilters.contains(filter)) continue;
            this.availFilters.remove(filter);
        }
        this.updateAvailableFilterList(t);
    }

    private void updateAvailableFilterList(Trace t) {
        this.tableViewerAvailable.refresh();
        this.buttonAdd.setEnabled(this.tableAvailable.getSelectionIndex() != -1);
    }

    private void updateSelectedFilterList(Trace t) {
        this.tableViewerSelected.refresh();
        this.buttonRemove.setEnabled(this.tableSelected.getSelectionIndex() != -1);
        this.triggerFiltersChangedListeners(t);
    }

    public ArrayList<Filter> getFilters() {
        return this.selFilters;
    }

    public void addFiltersChangedListener(Trace t, IFiltersChangedListener listener) {
        this.filtersChangedListeners.add(listener);
    }

    public void removeFiltersChangedListener(Trace t, IFiltersChangedListener listener) {
        if (this.filtersChangedListeners.contains(listener)) {
            this.filtersChangedListeners.remove(listener);
        }
    }

    private void triggerFiltersChangedListeners(Trace t) {
        boolean validSelection = this.isSelectedFiltersValid(t);
        FiltersChangedEvent event = new FiltersChangedEvent((Object)this, this.selFilters, validSelection);
        int i = 0;
        while (i < this.filtersChangedListeners.size()) {
            IFiltersChangedListener listener = this.filtersChangedListeners.elementAt(i);
            listener.changed(event);
            ++i;
        }
    }

    private void availFilterSelectionChanged(Trace t) {
        int selectedIndex = this.tableAvailable.getSelectionIndex();
        if (selectedIndex != -1) {
            this.selAvailableFilter = (Filter)this.tableAvailable.getItem(selectedIndex).getData();
            this.buttonAdd.setEnabled(true);
            this.selMostRecentFilter = this.selAvailableFilter;
        } else {
            this.selAvailableFilter = null;
            this.buttonAdd.setEnabled(false);
        }
    }

    private void selFilterSelectionChanged(Trace t) {
        int selectedIndex = this.tableSelected.getSelectionIndex();
        if (selectedIndex != -1) {
            Object selObject = this.tableSelected.getItem(selectedIndex).getData();
            if (selObject instanceof Filter) {
                this.selSelectedFilter = (Filter)selObject;
                this.buttonRemove.setEnabled(true);
                this.selMostRecentFilter = this.selSelectedFilter;
            } else {
                this.selSelectedFilter = null;
                this.buttonRemove.setEnabled(false);
            }
        } else {
            this.selSelectedFilter = null;
            this.buttonRemove.setEnabled(false);
        }
    }

    private void addFilter(Trace t) {
        Filter addFilter = this.selAvailableFilter;
        this.selFilters.add(addFilter);
        this.availFilters.remove(addFilter);
        this.updateAvailableFilterList(t);
        this.updateSelectedFilterList(t);
        this.tableSelected.setFocus();
        TableItem[] items = this.tableSelected.getItems();
        int ind = -1;
        int i = 0;
        while (ind < 0 && i < items.length) {
            if (addFilter.getFilterName().equals(items[i].getText())) {
                ind = i;
            }
            ++i;
        }
        if (ind >= 0) {
            this.tableSelected.setSelection(ind);
            this.selFilterSelectionChanged(t);
        }
    }

    private void removeFilter(Trace t) {
        Filter remFilter = this.selSelectedFilter;
        this.selFilters.remove(remFilter);
        this.availFilters.add(remFilter);
        this.updateAvailableFilterList(t);
        this.updateSelectedFilterList(t);
        this.tableAvailable.setFocus();
        TableItem[] items = this.tableAvailable.getItems();
        int ind = -1;
        int i = 0;
        while (ind < 0 && i < items.length) {
            if (remFilter.getFilterName().equals(items[i].getText())) {
                ind = i;
            }
            ++i;
        }
        if (ind >= 0) {
            this.tableAvailable.setSelection(ind);
            this.availFilterSelectionChanged(t);
        }
    }

    private void manageFilters(Trace t) {
        ManageFiltersDialog manageFiltersDlg = new ManageFiltersDialog(this.getShell(), 0);
        if (this.selMostRecentFilter != null) {
            manageFiltersDlg.setSelectedFilter(this.selMostRecentFilter);
        }
        manageFiltersDlg.setValues(t, this.setProvider.getFilterProvider(), this.setProvider.getFilterId(), null);
        manageFiltersDlg.create(t);
        if (manageFiltersDlg.open(t)) {
            this.availFilters = UiPlugin.getFilterManager().getAvailableFilters(t, this.setProvider.getFilterId());
            Filter[] filters = this.selFilters.toArray(new Filter[this.selFilters.size()]);
            int i = 0;
            while (i < filters.length) {
                Filter filter = filters[i];
                if (this.availFilters.contains(filter)) {
                    this.availFilters.remove(filter);
                } else {
                    this.selFilters.remove(filter);
                }
                ++i;
            }
            this.tableViewerAvailable.setInput(this.availFilters);
            this.updateAvailableFilterList(t);
            this.updateSelectedFilterList(t);
        }
    }

    public void resizeTableColumns(Trace t) {
        if (this.tabcolAvailable != null) {
            Point tableSizeAvailable = this.tableAvailable.getSize();
            this.tabcolAvailable.setWidth(tableSizeAvailable.x - UiUtils.getVScrollBarWidth((Trace)t, (Table)this.tableAvailable) - 5 * this.tableAvailable.getGridLineWidth());
        }
        if (this.tableSelected != null) {
            Point tableSizeSelected = this.tableAvailable.getSize();
            this.tabcolSelected.setWidth(tableSizeSelected.x - UiUtils.getVScrollBarWidth((Trace)t, (Table)this.tableSelected) - 5 * this.tableSelected.getGridLineWidth());
        }
    }

    private boolean isSelectedFiltersValid(Trace t) {
        boolean result = true;
        if (this.matchRule == 0 && this.selFilters.size() > 1) {
            int count = this.selFilters.size();
            int[] attrIds = new int[count];
            int i = 0;
            while (i < count && result) {
                Filter filter = this.selFilters.get(i);
                if (filter.isUsingWhere(t)) {
                    int attrId;
                    attrIds[i] = attrId = filter.getWhereAttrId(t);
                    int j = 0;
                    while (j < i) {
                        if (attrIds[j] == attrId) {
                            result = false;
                            break;
                        }
                        ++j;
                    }
                } else {
                    attrIds[i] = -1;
                }
                ++i;
            }
        }
        return result;
    }
}

