/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.importexport.internal.IExplorerRuntimeImportNotify;
import com.ibm.mq.explorer.importexport.internal.ImportManager;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.UiQmgrs;
import com.ibm.mq.explorer.qmgradmin.sets.extensions.MQQmgrSetExtObject;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.SetTreeNode;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.SetsTreeNodeComparator;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.UiQmgrAdminSet;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetManager;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetProvider;
import com.ibm.mq.explorer.qmgradmin.sets.internal.qmgrs.QmgrsSetProvider;
import com.ibm.mq.explorer.qmgradmin.sets.internal.qmgrs.QmgrsSetTreeNode;
import com.ibm.mq.explorer.qmgradmin.sets.internal.qmgrs.UiQmgrsSet;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.navigator.ITreeNodeComparator;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SetsPlugin
extends AbstractUIPlugin
implements IExplorerRuntimeImportNotify {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/base/SetsPlugin.java";
    public static final String PLUGIN_ID = "com.ibm.mq.explorer.qmgradmin.sets";
    private static SetsPlugin plugin;
    private static SetManager setManager;
    private static QmgrsSetProvider qmgrsSetProvider;
    private static Message generalMessages;
    private static boolean isExplorerInitialisationComplete;
    private static boolean isSetsPluginEnabled;
    private static boolean isSetsPluginDisabledEventReceived;
    private static ArrayList<TreeNode> parentTreeNodes;
    private static ArrayList<SetTreeNode> setTreeNodes;
    private static ArrayList<MQQmgrExtObject> queueManagers;
    private static SetsTreeNodeComparator setsTreeNodeComparator;

    static {
        setManager = null;
        qmgrsSetProvider = null;
        generalMessages = null;
        isExplorerInitialisationComplete = false;
        isSetsPluginEnabled = false;
        isSetsPluginDisabledEventReceived = false;
        parentTreeNodes = null;
        setTreeNodes = null;
        queueManagers = null;
        setsTreeNodeComparator = null;
    }

    public SetsPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Trace t = Trace.getDefault();
        parentTreeNodes = new ArrayList();
        setTreeNodes = new ArrayList();
        queueManagers = new ArrayList();
        setsTreeNodeComparator = new SetsTreeNodeComparator();
        ImportManager.addListener((IExplorerRuntimeImportNotify)this);
        try {
            generalMessages = new Message(t, "com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsStrings", ((Object)((Object)plugin)).getClass().getClassLoader());
        }
        catch (Throwable e) {
            if (Trace.isTracing) {
                t.data(66, "SetsPlugin.start", 900, "Error loading messages : " + e.toString());
            }
            t.FFST(66, "SetsPlugin.start", 10, 50036, 0, 0, "Failed to load general message resources", null, null);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static SetsPlugin getDefault() {
        return plugin;
    }

    public static Message getMessages(Trace t) {
        return generalMessages;
    }

    public static String getNLSString(Trace t, String textKey) {
        String text = generalMessages.getMessage(textKey);
        return text;
    }

    public static SetManager getSetManager() {
        return setManager;
    }

    public static SetProvider getSetProvider(Trace t, TreeNode treeNode) {
        QmgrsSetProvider setProvider = null;
        String treeNodeId = treeNode.getTreeNodeId();
        if (treeNodeId.compareTo("com.ibm.mq.explorer.treenode.qmgrs") == 0 || treeNodeId.startsWith("com.ibm.mq.explorer.treenode.qm.")) {
            setProvider = qmgrsSetProvider;
        } else {
            String objectId;
            UiMQObject uiMQObject;
            Object object = treeNode.getObject();
            if (object instanceof MQExtObject && ((MQExtObject)object).getInternalObject() instanceof UiMQObject && (uiMQObject = (UiMQObject)((MQExtObject)object).getInternalObject()) instanceof UiQmgrAdminSet && (objectId = ((UiQmgrAdminSet)uiMQObject).getObjectId()).compareTo("com.ibm.mq.explorer.queuemanager") == 0) {
                setProvider = qmgrsSetProvider;
            }
        }
        return setProvider;
    }

    public static SetProvider getSetProvider(Trace t, MQExtObject mqExtObject) {
        QmgrsSetProvider setProvider = null;
        if (mqExtObject.getObjectId().compareTo("com.ibm.mq.explorer.queuemanager") == 0) {
            setProvider = qmgrsSetProvider;
        }
        return setProvider;
    }

    public static SetProvider getSetProvider(Trace t, UiQmgrAdminSet uiQmgrAdminSet) {
        QmgrsSetProvider setProvider = null;
        if (uiQmgrAdminSet instanceof UiQmgrsSet) {
            setProvider = qmgrsSetProvider;
        }
        return setProvider;
    }

    public static String getInstanceId(Trace t, MQExtObject mqExtObject) {
        String instanceId = null;
        if (mqExtObject.getObjectId().compareTo("com.ibm.mq.explorer.queuemanager") == 0) {
            instanceId = "com.ibm.mq.explorer.treenode.qmgrs";
        }
        return instanceId;
    }

    public static String getInstanceId(Trace t, TreeNode treeNode) {
        String instanceId = null;
        Object object = treeNode.getObject();
        if (object instanceof MQExtObject) {
            String objectId;
            UiMQObject uiMQObject = (UiMQObject)((MQExtObject)object).getInternalObject();
            if (uiMQObject instanceof UiQmgrs) {
                instanceId = "com.ibm.mq.explorer.treenode.qmgrs";
            } else if (uiMQObject instanceof UiQueueManager) {
                instanceId = "com.ibm.mq.explorer.treenode.qmgrs";
            } else if (uiMQObject instanceof UiQmgrAdminSet && (objectId = ((UiQmgrAdminSet)uiMQObject).getObjectId()).compareTo("com.ibm.mq.explorer.queuemanager") == 0) {
                instanceId = "com.ibm.mq.explorer.treenode.qmgrs";
            }
        }
        return instanceId;
    }

    public static String getInstanceId(Trace t, UiQmgrAdminSet uiQmgrAdminSet) {
        String instanceId = null;
        if (uiQmgrAdminSet instanceof UiQmgrsSet) {
            instanceId = "com.ibm.mq.explorer.treenode.qmgrs";
        }
        return instanceId;
    }

    public static void explorerInitialised() {
        Trace t = Trace.getDefault();
        if (!isExplorerInitialisationComplete) {
            isExplorerInitialisationComplete = true;
            setManager = new SetManager(t, UiPlugin.getPersistentFileLocation());
            qmgrsSetProvider = new QmgrsSetProvider();
        }
        setManager.handleMissingFilters(t);
    }

    public static void explorerClosing() {
        Trace t = Trace.getDefault();
        if (isExplorerInitialisationComplete && UiPlugin.isPersistOnShutdown()) {
            setManager.saveSets(t);
        }
    }

    public static void mqNaviatorViewOpened() {
    }

    public static void mqNaviatorViewClosed() {
        parentTreeNodes.clear();
        setTreeNodes.clear();
    }

    public static void setsPluginEnabled() {
        isSetsPluginEnabled = true;
        if (isSetsPluginDisabledEventReceived) {
            SetsPlugin.explorerInitialised();
        }
        if (isExplorerInitialisationComplete) {
            for (TreeNode parent : parentTreeNodes) {
                TreeNode[] children = parent.getChildren();
                int i = 0;
                while (i < children.length) {
                    String id = children[i].getId();
                    if (id.startsWith("com.ibm.mq.explorer.treenode.qm.")) {
                        children[i].setVisible(false);
                    } else if (id.startsWith("com.ibm.mq.explorer.treenode.set.")) {
                        children[i].setVisible(true);
                    }
                    ++i;
                }
                parent.refresh();
            }
        }
    }

    public static void setsPluginDisabled() {
        isSetsPluginEnabled = false;
        if (isExplorerInitialisationComplete) {
            for (TreeNode parent : parentTreeNodes) {
                TreeNode[] children = parent.getChildren();
                int i = 0;
                while (i < children.length) {
                    String id = children[i].getId();
                    if (id.startsWith("com.ibm.mq.explorer.treenode.qm.")) {
                        children[i].setVisible(true);
                    } else if (id.startsWith("com.ibm.mq.explorer.treenode.set.")) {
                        children[i].setVisible(false);
                    }
                    ++i;
                }
                parent.refresh();
            }
        } else {
            isSetsPluginDisabledEventReceived = true;
        }
    }

    public static void queueManagerAdded(MQQmgrExtObject mqQmgrExtObject) {
        Trace t = Trace.getDefault();
        if (!queueManagers.contains(mqQmgrExtObject)) {
            queueManagers.add(mqQmgrExtObject);
        }
        ArrayList<UiQmgrAdminSet> sets = setManager.getAvailableSetsForAllInstances(t, qmgrsSetProvider.getObjectId());
        boolean refresh = false;
        UiQueueManager uiQueueManager = (UiQueueManager)mqQmgrExtObject.getInternalObject();
        for (UiQmgrAdminSet uiQmgrAdminSet : sets) {
            boolean added = uiQmgrAdminSet.addObjectIfValidMember(t, (UiMQObject)uiQueueManager);
            if (!added) continue;
            setManager.setChanged(t, uiQmgrAdminSet);
            refresh = true;
        }
        if (refresh) {
            setManager.saveSets(t);
            UiPlugin.refreshAllViews((Trace)t, (String)"com.ibm.mq.explorer.set.qmgrs", (boolean)true);
        }
    }

    public static void queueManagerChanged(MQQmgrExtObject mqQmgrExtObject) {
        Trace t = Trace.getDefault();
        if (!queueManagers.contains(mqQmgrExtObject)) {
            queueManagers.add(mqQmgrExtObject);
        }
        ArrayList<UiQmgrAdminSet> sets = setManager.getAvailableSetsForAllInstances(t, qmgrsSetProvider.getObjectId());
        boolean refresh = false;
        UiQueueManager uiQueueManager = (UiQueueManager)mqQmgrExtObject.getInternalObject();
        for (UiQmgrAdminSet uiQmgrAdminSet : sets) {
            boolean exists = uiQmgrAdminSet.isObjectInSet(t, (UiMQObject)uiQueueManager);
            if (!exists) continue;
            setManager.setChanged(t, uiQmgrAdminSet);
            refresh = true;
        }
        if (refresh) {
            setManager.saveSets(t);
            UiPlugin.refreshAllViews((Trace)t, (String)"com.ibm.mq.explorer.set.qmgrs", (boolean)true);
        }
    }

    public static void queueManagerDeleted(MQQmgrExtObject mqQmgrExtObject) {
        Trace t = Trace.getDefault();
        queueManagers.remove(mqQmgrExtObject);
        ArrayList<UiQmgrAdminSet> sets = setManager.getAvailableSetsForAllInstances(t, qmgrsSetProvider.getObjectId());
        boolean refresh = false;
        UiQueueManager uiQueueManager = (UiQueueManager)mqQmgrExtObject.getInternalObject();
        for (UiQmgrAdminSet uiQmgrAdminSet : sets) {
            boolean removed = uiQmgrAdminSet.removeObjectIfMember(t, (UiMQObject)uiQueueManager);
            if (!removed) continue;
            setManager.setChanged(t, uiQmgrAdminSet);
            refresh = true;
        }
        if (refresh) {
            setManager.saveSets(t);
            UiPlugin.refreshAllViews((Trace)t, (String)"com.ibm.mq.explorer.set.qmgrs", (boolean)true);
        }
    }

    public static void queueManagerHidden(MQQmgrExtObject mqQmgrExtObject) {
    }

    public static void queueManagerShown(MQQmgrExtObject mqQmgrExtObject) {
    }

    public static boolean isExplorerInitialisationComplete() {
        return isExplorerInitialisationComplete;
    }

    public static boolean isSetsPluginEnabled() {
        return isSetsPluginEnabled;
    }

    public static void refreshSetTreeNodes(Trace t) {
        ArrayList<UiQmgrAdminSet> sets = setManager.getAvailableSetsForAllInstances(t, qmgrsSetProvider.getObjectId());
        for (UiQmgrAdminSet uiQmgrAdminSet : sets) {
            setManager.setChanged(t, uiQmgrAdminSet, true);
        }
    }

    public static void manageSetsTreeNodes(Trace t, TreeNode parent) {
        block15: {
            if (setManager == null) {
                return;
            }
            SetProvider setProvider = SetsPlugin.getSetProvider(t, parent);
            if (setProvider == null) break block15;
            if (!parentTreeNodes.contains(parent)) {
                parentTreeNodes.add(parent);
            }
            parent.setTreeNodeComparator((ITreeNodeComparator)setsTreeNodeComparator);
            boolean showSets = setManager.isSetsEnabled(t, setProvider.getObjectId(), parent.getId());
            if (showSets) {
                TreeNode[] children;
                SetsPlugin.removeDeletedSetsFromTreeNode(t, parent);
                ArrayList<UiQmgrAdminSet> sets = setManager.getAvailableSets(t, setProvider.getObjectId(), SetsPlugin.getInstanceId(t, parent), setProvider);
                for (UiQmgrAdminSet uiSet : sets) {
                    TreeNode treeNode = uiSet.getTreeNode();
                    if (treeNode == null) {
                        SetTreeNode setTreeNode = SetsPlugin.createTreeNodeForSet(t, parent, uiSet, setProvider);
                        setTreeNodes.add(setTreeNode);
                        treeNode = setTreeNode;
                        if (uiSet.isAllSet().booleanValue()) {
                            UiPlugin.getMQNavigatorView().expandTreeNode(t, treeNode);
                        }
                    } else {
                        treeNode.setVisible(true);
                    }
                    if (treeNode == null) continue;
                    SetsPlugin.createTreeNodesForEverySetMember(t, treeNode, uiSet, setProvider);
                    SetsPlugin.removeTreeNodeForMembersNoLongerInSet(t, treeNode, uiSet);
                }
                if (sets.size() > 0) {
                    children = parent.getChildren();
                    String setObjId = setProvider.getMemberObjectId();
                    int i = 0;
                    while (i < children.length) {
                        if (!children[i].getId().startsWith("com.ibm.mq.explorer.treenode.set.")) {
                            boolean visible = false;
                            Object obj = children[i].getObject();
                            if (obj instanceof MQExtObject && setObjId.compareTo(((MQExtObject)obj).getObjectId()) != 0) {
                                visible = true;
                            }
                            children[i].setVisible(visible);
                        }
                        ++i;
                    }
                } else {
                    children = parent.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        children[i].setVisible(!children[i].getId().startsWith("com.ibm.mq.explorer.treenode.set."));
                        ++i;
                    }
                }
            } else {
                TreeNode[] children = parent.getChildren();
                int i = 0;
                while (i < children.length) {
                    children[i].setVisible(!children[i].getId().startsWith("com.ibm.mq.explorer.treenode.set."));
                    ++i;
                }
            }
        }
    }

    private static void removeTreeNodeForMembersNoLongerInSet(Trace t, TreeNode parent, UiQmgrAdminSet uiSet) {
        TreeNode[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            UiMQObject uiMQObject;
            Object object = children[i].getObject();
            if (object instanceof MQExtObject && !uiSet.isObjectInSet(t, uiMQObject = (UiMQObject)((MQExtObject)object).getInternalObject())) {
                parent.removeChildFromNode(children[i]);
            }
            ++i;
        }
    }

    private static void createTreeNodesForEverySetMember(Trace t, TreeNode parent, UiQmgrAdminSet uiSet, SetProvider setProvider) {
        MQExtObject[] members = uiSet.getObjectsInSet();
        int i = 0;
        while (i < members.length) {
            boolean found = false;
            TreeNode[] children = parent.getChildren();
            int j = 0;
            while (j < children.length) {
                if (children[j].getObject() == members[i]) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                TreeNode memberTreeNode = setProvider.createMemberObjectTreeNode(t, parent, (UiMQObject)members[i].getInternalObject());
                parent.addChildToNode(memberTreeNode, 0);
            }
            ++i;
        }
    }

    private static void removeDeletedSetsFromTreeNode(Trace t, TreeNode parent) {
        TreeNode[] treeNodes = parent.getChildren();
        int i = 0;
        while (i < treeNodes.length) {
            SetTreeNode setTreeNode;
            MQQmgrSetExtObject mqQmgrSetExtObject;
            UiQmgrAdminSet uiQmgrAdminSet;
            if (treeNodes[i].getTreeNodeId().startsWith("com.ibm.mq.explorer.treenode.set.") && ((uiQmgrAdminSet = (UiQmgrAdminSet)(mqQmgrSetExtObject = (MQQmgrSetExtObject)((Object)(setTreeNode = (SetTreeNode)treeNodes[i]).getObject())).getInternalObject()).getDisposition() == 2 || uiQmgrAdminSet.getDisposition() == 5)) {
                parent.removeChildFromNode((TreeNode)setTreeNode);
            }
            ++i;
        }
    }

    private static SetTreeNode createTreeNodeForSet(Trace t, TreeNode parent, UiQmgrAdminSet uiSet, SetProvider setProvider) {
        QmgrsSetTreeNode setTreeNode = null;
        if (uiSet.getObjectId().compareTo("com.ibm.mq.explorer.queuemanager") == 0) {
            setTreeNode = new QmgrsSetTreeNode(parent, uiSet.getExternalObject(), "com.ibm.mq.explorer.ui");
            setTreeNode.setSetProvider(setProvider);
            uiSet.setTreeNode(setTreeNode);
            parent.addChildToNode((TreeNode)setTreeNode, 0);
        } else {
            t.FFST(66, "SetsPlugin.createTreeNodeForSet", 10, 50999, 0, 0, "Trying to create a TreeNode for a Set with an unsupported object id", "ObjectId = '" + uiSet.getObjectId() + "'", null);
        }
        return setTreeNode;
    }

    public static void removeTreeNode(TreeNode treeNode) {
        if (treeNode instanceof SetTreeNode && setTreeNodes.contains(treeNode)) {
            setTreeNodes.remove(treeNode);
        }
    }

    public static SetTreeNode getTreeNodeForSet(Trace t, UiQmgrAdminSet uiSet) {
        SetTreeNode setTreeNode = null;
        for (SetTreeNode treeNode : setTreeNodes) {
            if (!treeNode.getUiQmgrSet().getUniversalId().equals(uiSet.getUniversalId())) continue;
            setTreeNode = treeNode;
        }
        return setTreeNode;
    }

    public static ArrayList<MQExtObject> getKnownObjectsForAutomaticSet(Trace t, UiQmgrAdminSet uiQmgrAdminSet, String objectId) {
        ArrayList<MQExtObject> objects = new ArrayList<MQExtObject>();
        if (objectId.compareTo("com.ibm.mq.explorer.qmgrs") == 0) {
            for (MQQmgrExtObject mqQmgrExtObject : queueManagers) {
                if (!uiQmgrAdminSet.isValidMember(t, (MQExtObject)mqQmgrExtObject)) continue;
                objects.add((MQExtObject)mqQmgrExtObject);
            }
        }
        return objects;
    }

    public static ArrayList<MQExtObject> getKnownObjectsForAllSet(Trace t, String objectId) {
        ArrayList<MQExtObject> objects = new ArrayList<MQExtObject>();
        if (objectId.compareTo("com.ibm.mq.explorer.qmgrs") == 0) {
            Iterator<MQQmgrExtObject> iterator = queueManagers.iterator();
            while (iterator.hasNext()) {
                objects.add((MQExtObject)iterator.next());
            }
        }
        return objects;
    }

    public static void setSetsEnabled(Trace t, boolean enabled) {
        setManager.setSetsEnabled(t, "com.ibm.mq.explorer.qmgrs", "com.ibm.mq.explorer.treenode.qmgrs", enabled);
        UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
    }

    public static boolean isSetsEnabled(Trace t, TreeNode treeNode) {
        boolean enabled = false;
        if (treeNode != null) {
            String treeNodeId = treeNode.getId();
            if (treeNodeId.compareTo("com.ibm.mq.explorer.treenode.qmgrs") == 0 || treeNodeId.startsWith("com.ibm.mq.explorer.treenode.qm.")) {
                enabled = setManager.isSetsEnabled(t, "com.ibm.mq.explorer.qmgrs", null);
            } else if (treeNodeId.startsWith("com.ibm.mq.explorer.treenode.set.") && treeNode.getObject() instanceof MQQmgrSetExtObject) {
                enabled = setManager.isSetsEnabled(t, "com.ibm.mq.explorer.qmgrs", null);
            }
        }
        return enabled;
    }

    public static boolean isSetsEnabled(Trace t, MQExtObject mqExtObject) {
        boolean enabled = false;
        if (mqExtObject != null && mqExtObject.getObjectId().compareTo("com.ibm.mq.explorer.queuemanager") == 0) {
            enabled = setManager.isSetsEnabled(t, "com.ibm.mq.explorer.qmgrs", null);
        }
        return enabled;
    }

    public void notifyImportComplete(List<String> subcategories) {
        Trace t = Trace.getDefault();
        if (setManager != null) {
            setManager.checkForMissingFilters(t);
            if (subcategories.contains("com.ibm.mq.explorer.ui.category.sets.qmgrs")) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Trace t1 = Trace.getDefault();
                        SetsPlugin.refreshSetTreeNodes(t1);
                        UiPlugin.refreshAllViews((Trace)t1, (String)"com.ibm.mq.explorer.set.qmgrs", (boolean)true);
                        SetsPlugin.getSetManager().saveSets(t1);
                    }
                });
            }
        }
    }

    public void notifyImportFailed(List<String> failedSubcategories) {
        this.notifyImportComplete(null);
    }
}

