/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.sets.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.UiQueueManagerHandle;
import com.ibm.mq.explorer.qmgradmin.sets.extensions.MQQmgrSetExtObject;
import com.ibm.mq.explorer.qmgradmin.sets.internal.base.SetsPlugin;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.ManageSetsDialog;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.SetMembershipDialog;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.qmgrs.ConnectToQmgrsInSetDialog;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.qmgrs.DisconnectFromQmgrsInSetDialog;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.qmgrs.StartLocalQmgrsInSetDialog;
import com.ibm.mq.explorer.qmgradmin.sets.internal.dialogs.qmgrs.StopLocalQmgrsInSetDialog;
import com.ibm.mq.explorer.qmgradmin.sets.internal.generic.UiQmgrAdminSet;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetManager;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetNewObjectProvider;
import com.ibm.mq.explorer.qmgradmin.sets.internal.management.SetProvider;
import com.ibm.mq.explorer.qmgradmin.sets.internal.qmgrs.UiQmgrsSet;
import com.ibm.mq.explorer.qmgradmin.sets.internal.wizards.SetsWizDlg;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.ObjectRegistrationManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IActionDelegate;

public class SetsMenuActions
implements IActionDelegate {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.sets/src/com/ibm/mq/explorer/qmgradmin/sets/internal/actions/SetsMenuActions.java";
    private ISelection currentSelection = null;
    private ArrayList<TreeNode> selectedTreeNodes = null;
    private ArrayList<MQExtObject> selectedMQExtObjects = null;
    private Message msgFile = null;

    public SetsMenuActions() {
        Trace t = Trace.getDefault();
        this.selectedMQExtObjects = new ArrayList();
        this.selectedTreeNodes = new ArrayList();
        this.msgFile = SetsPlugin.getMessages(t);
    }

    public void run(IAction action) {
        Trace t = Trace.getDefault();
        String id = action.getId();
        this.getSelectedObjects(t);
        TreeNode firstSelTreeNode = null;
        if (this.selectedTreeNodes.size() > 0) {
            firstSelTreeNode = this.selectedTreeNodes.get(0);
        }
        MQExtObject firstSelMQExtObject = null;
        if (this.selectedMQExtObjects.size() > 0) {
            firstSelMQExtObject = this.selectedMQExtObjects.get(0);
        }
        if (id.compareTo("com.ibm.mq.explorer.qmgradmin.sets.action.showsets") == 0) {
            this.showSets(Trace.getDefault(), true);
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.sets.action.hidesets") == 0) {
            this.showSets(Trace.getDefault(), false);
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.sets.action.newset") == 0) {
            SetProvider setProvider = SetsPlugin.getSetProvider(t, firstSelTreeNode);
            String instanceId = SetsPlugin.getInstanceId(t, firstSelTreeNode);
            this.createSet(Trace.getDefault(), 0, null, setProvider, instanceId);
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.sets.action.managesets") == 0) {
            this.manageSets(Trace.getDefault());
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.sets.action.setmembership.mqextobject") == 0) {
            this.setMembership(Trace.getDefault(), firstSelMQExtObject);
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.sets.action.setmembership.treenode") == 0) {
            this.setMembership(Trace.getDefault(), (MQExtObject)firstSelTreeNode.getObject());
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.sets.action.newset.mqextobject") == 0) {
            SetProvider setProvider = SetsPlugin.getSetProvider(t, firstSelMQExtObject);
            String instanceId = SetsPlugin.getInstanceId(t, firstSelMQExtObject);
            MQExtObject[] selMQExtObjects = null;
            if (this.selectedMQExtObjects.size() > 0) {
                selMQExtObjects = this.selectedMQExtObjects.toArray(new MQExtObject[this.selectedMQExtObjects.size()]);
            }
            this.createSet(Trace.getDefault(), 1, selMQExtObjects, setProvider, instanceId);
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.sets.action.newset.treenode") == 0) {
            SetProvider setProvider = SetsPlugin.getSetProvider(t, firstSelTreeNode);
            String instanceId = SetsPlugin.getInstanceId(t, firstSelTreeNode);
            MQExtObject[] selMQExtObjects = null;
            if (this.selectedMQExtObjects.size() > 0) {
                selMQExtObjects = this.selectedMQExtObjects.toArray(new MQExtObject[this.selectedMQExtObjects.size()]);
            }
            this.createSet(Trace.getDefault(), 1, selMQExtObjects, setProvider, instanceId);
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.sets.action.startlocalqmgrs") == 0) {
            this.startLocalQmgrsInSet(Trace.getDefault(), (MQExtObject)firstSelTreeNode.getObject());
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.sets.action.stoplocalqmgrs") == 0) {
            this.stopLocalQmgrsInSet(Trace.getDefault(), (MQExtObject)firstSelTreeNode.getObject());
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.sets.action.connectqmgrs") == 0) {
            this.connectToQmgrsInSet(Trace.getDefault(), (MQExtObject)firstSelTreeNode.getObject());
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.sets.action.disconnectqmgrs") == 0) {
            this.disconnectFromQmgrsInSet(Trace.getDefault(), (MQExtObject)firstSelTreeNode.getObject());
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.sets.action.showallqmgrs") == 0) {
            this.showAllQmgrsInSet(Trace.getDefault(), (MQExtObject)firstSelTreeNode.getObject());
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.sets.action.hideallqmgrs") == 0) {
            this.hideAllQmgrsInSet(Trace.getDefault(), (MQExtObject)firstSelTreeNode.getObject());
        }
    }

    private void showSets(Trace t, boolean show) {
        SetsPlugin.setSetsEnabled(t, show);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }

    private void getSelectedObjects(Trace t) {
        block2: {
            IStructuredSelection structuredSelection;
            Object firstObj;
            block3: {
                this.selectedMQExtObjects.clear();
                this.selectedTreeNodes.clear();
                if (this.currentSelection == null || !(this.currentSelection instanceof IStructuredSelection) || (firstObj = (structuredSelection = (IStructuredSelection)this.currentSelection).getFirstElement()) == null) break block2;
                if (!(firstObj instanceof TreeNode)) break block3;
                for (Object obj : structuredSelection.toList()) {
                    Object treeNodeObj;
                    if (!(obj instanceof TreeNode)) continue;
                    TreeNode selTreeNode = (TreeNode)obj;
                    this.selectedTreeNodes.add(selTreeNode);
                    if (!selTreeNode.getId().startsWith("com.ibm.mq.explorer.treenode.qm.") || !((treeNodeObj = selTreeNode.getObject()) instanceof MQExtObject)) continue;
                    this.selectedMQExtObjects.add((MQExtObject)treeNodeObj);
                }
                break block2;
            }
            if (!(firstObj instanceof MQExtObject)) break block2;
            for (Object obj : structuredSelection.toList()) {
                if (!(obj instanceof MQExtObject)) continue;
                this.selectedMQExtObjects.add((MQExtObject)obj);
            }
        }
    }

    private void createSet(Trace t, int option, MQExtObject[] mqExtObjects, SetProvider setProvider, String instanceId) {
        UiQmgrAdminSet newUiSet;
        String objectId = setProvider.getObjectId();
        SetManager setManager = SetsPlugin.getSetManager();
        ArrayList<UiQmgrAdminSet> setsArray = new ArrayList<UiQmgrAdminSet>(setManager.getAvailableSets(t, objectId, instanceId, setProvider));
        ArrayList availableFilters = UiPlugin.getFilterManager().getAvailableFilters(t, setProvider.getFilterId());
        SetNewObjectProvider setNewObjectProvider = new SetNewObjectProvider(t, option, mqExtObjects);
        setNewObjectProvider.setExistingSets(setsArray);
        setNewObjectProvider.setSetProvider(setProvider);
        setNewObjectProvider.setAvailableFilters(availableFilters);
        NewObjectWiz newObjectWiz = new NewObjectWiz(t, (NewObjectProvider)setNewObjectProvider, objectId);
        SetsWizDlg setsWizDlg = new SetsWizDlg(UiPlugin.getShell(), (IWizard)newObjectWiz);
        setsWizDlg.create();
        if (setsWizDlg.open() != 1 && (newUiSet = setNewObjectProvider.getCreatedSet()) != null) {
            UiPlugin.showBusyCursor((Trace)t, (boolean)true);
            if (newUiSet.isAutomaticSet().booleanValue()) {
                ArrayList<MQExtObject> objects = SetsPlugin.getKnownObjectsForAutomaticSet(t, newUiSet, objectId);
                for (MQExtObject mqExtObj : objects) {
                    newUiSet.addObject(t, mqExtObj);
                }
            }
            setsArray.add(newUiSet);
            setManager.setSets(t, objectId, instanceId, setsArray, setProvider);
            setManager.saveSets(t);
            UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
            SetsPlugin.setSetsEnabled(t, true);
            UiPlugin.showBusyCursor((Trace)t, (boolean)false);
        }
    }

    private void manageSets(Trace t) {
        TreeNode firstSelTreeNode = this.selectedTreeNodes.get(0);
        if (firstSelTreeNode != null) {
            ManageSetsDialog manageDialog = new ManageSetsDialog(UiPlugin.getShell());
            manageDialog.setValues(t, SetsPlugin.getInstanceId(t, firstSelTreeNode), SetsPlugin.getSetProvider(t, firstSelTreeNode));
            if (manageDialog.open() == 0) {
                UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
            }
        }
    }

    private void setMembership(Trace t, MQExtObject mqExtObject) {
        if (mqExtObject != null) {
            SetMembershipDialog setMembershipDlg = new SetMembershipDialog(UiPlugin.getShell());
            setMembershipDlg.setValues(t, mqExtObject, SetsPlugin.getInstanceId(t, mqExtObject), SetsPlugin.getSetProvider(t, mqExtObject));
            setMembershipDlg.setNoObjectMessage(t, 1, this.msgFile.getMessage("Sets.Dialog.NoSetsAvailable"));
            if (setMembershipDlg.open() == 0) {
                int i;
                UiQmgrAdminSet[] selectedSets = setMembershipDlg.getSelectedSets();
                UiQmgrAdminSet[] unselectedSets = setMembershipDlg.getUnselectedSets();
                boolean setsChanged = false;
                if (selectedSets != null) {
                    i = 0;
                    while (i < selectedSets.length) {
                        if (!selectedSets[i].isObjectInSet(t, mqExtObject)) {
                            selectedSets[i].addObject(t, (UiMQObject)mqExtObject.getInternalObject());
                            setsChanged = true;
                        }
                        ++i;
                    }
                }
                if (unselectedSets != null) {
                    i = 0;
                    while (i < unselectedSets.length) {
                        boolean changed = unselectedSets[i].removeObjectIfMember(t, mqExtObject);
                        if (changed) {
                            setsChanged = true;
                        }
                        ++i;
                    }
                }
                if (setsChanged) {
                    SetsPlugin.getSetManager().saveSets(t);
                    UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
                }
            }
        }
    }

    private void startLocalQmgrsInSet(Trace t, MQExtObject mqExtObject) {
        if (mqExtObject != null && mqExtObject instanceof MQQmgrSetExtObject) {
            UiQmgrsSet uiQmgrsSet = (UiQmgrsSet)mqExtObject.getInternalObject();
            StartLocalQmgrsInSetDialog dlg = new StartLocalQmgrsInSetDialog(t, UiPlugin.getShell(), 0);
            dlg.setValues(t, uiQmgrsSet);
            dlg.create(t);
            dlg.open(t);
        }
    }

    private void stopLocalQmgrsInSet(Trace t, MQExtObject mqExtObject) {
        if (mqExtObject != null && mqExtObject instanceof MQQmgrSetExtObject) {
            UiQmgrsSet uiQmgrsSet = (UiQmgrsSet)mqExtObject.getInternalObject();
            StopLocalQmgrsInSetDialog dlg = new StopLocalQmgrsInSetDialog(t, UiPlugin.getShell(), 0);
            dlg.setValues(t, uiQmgrsSet);
            dlg.create(t);
            dlg.open(t);
        }
    }

    private void connectToQmgrsInSet(Trace t, MQExtObject mqExtObject) {
        if (mqExtObject != null && mqExtObject instanceof MQQmgrSetExtObject) {
            UiQmgrsSet uiQmgrsSet = (UiQmgrsSet)mqExtObject.getInternalObject();
            ConnectToQmgrsInSetDialog dlg = new ConnectToQmgrsInSetDialog(t, UiPlugin.getShell(), 0);
            dlg.setValues(t, uiQmgrsSet);
            dlg.create(t);
            dlg.open(t);
        }
    }

    private void disconnectFromQmgrsInSet(Trace t, MQExtObject mqExtObject) {
        if (mqExtObject != null && mqExtObject instanceof MQQmgrSetExtObject) {
            UiQmgrsSet uiQmgrsSet = (UiQmgrsSet)mqExtObject.getInternalObject();
            DisconnectFromQmgrsInSetDialog dlg = new DisconnectFromQmgrsInSetDialog(t, UiPlugin.getShell(), 0);
            dlg.setValues(t, uiQmgrsSet);
            dlg.create(t);
            dlg.open(t);
        }
    }

    private void showAllQmgrsInSet(Trace t, MQExtObject mqExtObject) {
        if (mqExtObject != null && mqExtObject instanceof MQQmgrSetExtObject) {
            UiQmgrsSet uiQmgrsSet = (UiQmgrsSet)mqExtObject.getInternalObject();
            UiQueueManager[] uiQmgrs = uiQmgrsSet.getQueueManagersInSet(t, true);
            IUiMQObjectFactory factory = ObjectRegistrationManager.getUiMQObjectFactory((Trace)t, (String)"com.ibm.mq.explorer.queuemanagerhandle");
            if (factory != null) {
                int i = 0;
                while (i < uiQmgrs.length) {
                    if (!uiQmgrs[i].isVisible(t)) {
                        DmQueueManagerHandle dmQueueManagerHandle = uiQmgrs[i].getDmQueueManagerObject().getConnectionHandle();
                        UiQueueManagerHandle uiQueueManagerHandle = (UiQueueManagerHandle)factory.create(t, (IDmObject)dmQueueManagerHandle, (UiMQObject)uiQmgrs[i]);
                        uiQueueManagerHandle.setVisible(t, 1);
                    }
                    ++i;
                }
            }
        }
    }

    private void hideAllQmgrsInSet(Trace t, MQExtObject mqExtObject) {
        if (mqExtObject != null && mqExtObject instanceof MQQmgrSetExtObject) {
            UiQmgrsSet uiQmgrsSet = (UiQmgrsSet)mqExtObject.getInternalObject();
            UiQueueManager[] uiQmgrs = uiQmgrsSet.getQueueManagersInSet(t, false);
            IUiMQObjectFactory factory = ObjectRegistrationManager.getUiMQObjectFactory((Trace)t, (String)"com.ibm.mq.explorer.queuemanagerhandle");
            if (factory != null) {
                int i = 0;
                while (i < uiQmgrs.length) {
                    DmQueueManagerHandle dmQueueManagerHandle = uiQmgrs[i].getDmQueueManagerObject().getConnectionHandle();
                    UiQueueManagerHandle uiQueueManagerHandle = (UiQueueManagerHandle)factory.create(t, (IDmObject)dmQueueManagerHandle, (UiMQObject)uiQmgrs[i]);
                    uiQueueManagerHandle.setVisible(t, 0);
                    ++i;
                }
            }
        }
    }
}

