/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal.ui.preferences;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.messageplugin.internal.MessagePlugin;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePageMessages
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.messageplugin.internal/src/com/ibm/mq/explorer/messageplugin/internal/ui/preferences/PreferencePageMessages.java";
    public static final int MAX_Q_DEPTH = 5000;
    public static final int MAX_MSG_LENGTH = 16384;
    public static int HORIZONTAL_INDENT = 20;
    private Composite composite = null;
    private boolean isCurrentSettingsLoaded = false;
    private Label labelMsgCount = null;
    private Spinner spinnerMsgCount = null;
    private Label labelMsgByteCount = null;
    private Spinner spinnerMsgByteCount = null;
    private Button noPropertiesCheckbox = null;
    private Button propertiesInHandleButton = null;
    private Button forceRFH2Button = null;
    private Button compatRFH2Button = null;
    private Composite buttonComposite = null;

    protected Control createContents(Composite parent) {
        Trace t = Trace.getDefault();
        Message msgFile = MessagePlugin.getPluginMessages(t);
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        this.composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.composite.setLayoutData((Object)gridData);
        UiPlugin.getHelpSystem().setHelp((Control)this.composite, "com.ibm.mq.explorer.ui.infopop.UI_PreferencesPageMessages");
        UiPlugin.getHelpSystem().setHelp(this.getControl(), "com.ibm.mq.explorer.ui.infopop.UI_PreferencesPageMessages");
        Group limitsGroup = new Group(this.composite, 0);
        limitsGroup.setText(msgFile.getMessage(t, "MSG.Preferences.BrowsingLimitsGroup"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        limitsGroup.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        limitsGroup.setLayoutData((Object)gridData);
        this.labelMsgCount = new Label((Composite)limitsGroup, 0);
        this.labelMsgCount.setText(msgFile.getMessage(t, "MSG.Preferences.MaxMessageCount"));
        gridData = new GridData(32);
        this.labelMsgCount.setLayoutData((Object)gridData);
        this.spinnerMsgCount = new Spinner((Composite)limitsGroup, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.spinnerMsgCount.setLayoutData((Object)gridData);
        this.spinnerMsgCount.setMaximum(5000);
        this.spinnerMsgCount.setMinimum(1);
        UiUtils.limitSpinner((Trace)t, (Spinner)this.spinnerMsgCount);
        this.labelMsgByteCount = new Label((Composite)limitsGroup, 0);
        this.labelMsgByteCount.setText(msgFile.getMessage(t, "MSG.Preferences.MaxMessageBytesCount"));
        gridData = new GridData(32);
        this.labelMsgByteCount.setLayoutData((Object)gridData);
        this.spinnerMsgByteCount = new Spinner((Composite)limitsGroup, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.spinnerMsgByteCount.setLayoutData((Object)gridData);
        this.spinnerMsgByteCount.setMaximum(16384);
        this.spinnerMsgByteCount.setMinimum(0);
        UiUtils.limitSpinner((Trace)t, (Spinner)this.spinnerMsgByteCount);
        Group propertiesGroup = new Group(this.composite, 0);
        propertiesGroup.setText(msgFile.getMessage(t, "MSG.Preferences.PropertyHandlingGroup"));
        gridLayout = new GridLayout();
        propertiesGroup.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        propertiesGroup.setLayoutData((Object)gridData);
        this.buttonComposite = new Composite((Composite)propertiesGroup, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        this.buttonComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.buttonComposite.setLayoutData((Object)gridData);
        this.noPropertiesCheckbox = new Button(this.buttonComposite, 32);
        this.noPropertiesCheckbox.setText(msgFile.getMessage(t, "MSG.Preferences.PropertiesNone"));
        gridData = new GridData(768);
        this.noPropertiesCheckbox.setLayoutData((Object)gridData);
        this.noPropertiesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean checked = PreferencePageMessages.this.noPropertiesCheckbox.getSelection();
                if (checked) {
                    boolean rf = PreferencePageMessages.this.forceRFH2Button.getSelection();
                    boolean rc = PreferencePageMessages.this.compatRFH2Button.getSelection();
                    if (!rf && !rc) {
                        PreferencePageMessages.this.propertiesInHandleButton.setSelection(true);
                    }
                }
                PreferencePageMessages.this.propertiesInHandleButton.setEnabled(checked);
                PreferencePageMessages.this.forceRFH2Button.setEnabled(checked);
                PreferencePageMessages.this.compatRFH2Button.setEnabled(checked);
            }
        });
        Composite radioComposite = new Composite(this.buttonComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        radioComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.buttonComposite.setLayoutData((Object)gridData);
        this.propertiesInHandleButton = new Button(radioComposite, 16);
        this.propertiesInHandleButton.setText(msgFile.getMessage(t, "MSG.Preferences.PropertiesInHandle"));
        gridData = new GridData(32);
        gridData.horizontalIndent = HORIZONTAL_INDENT;
        this.propertiesInHandleButton.setLayoutData((Object)gridData);
        this.forceRFH2Button = new Button(radioComposite, 16);
        this.forceRFH2Button.setText(msgFile.getMessage(t, "MSG.Preferences.PropertiesForceMQRFH2"));
        gridData = new GridData(32);
        gridData.horizontalIndent = HORIZONTAL_INDENT;
        this.forceRFH2Button.setLayoutData((Object)gridData);
        this.compatRFH2Button = new Button(radioComposite, 16);
        this.compatRFH2Button.setText(msgFile.getMessage(t, "MSG.Preferences.PropertiesCompatMQRFH2"));
        gridData = new GridData(32);
        gridData.horizontalIndent = HORIZONTAL_INDENT;
        this.compatRFH2Button.setLayoutData((Object)gridData);
        return this.composite;
    }

    public void init(IWorkbench workbench) {
        UiPlugin uiPlugin = UiPlugin.getDefault();
        this.setPreferenceStore(uiPlugin.getPreferenceStore());
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        super.setVisible(visible);
        if (visible && !this.isCurrentSettingsLoaded) {
            this.loadCurrentSettings(t);
            this.isCurrentSettingsLoaded = true;
        }
    }

    private void loadCurrentSettings(Trace t) {
        IPreferenceStore store = this.getPreferenceStore();
        int maxMsgCount = store.getInt("max_message_count");
        this.spinnerMsgCount.setSelection(maxMsgCount);
        int maxMsgBytesCount = store.getInt("max_message_bytes_count");
        this.spinnerMsgByteCount.setSelection(maxMsgBytesCount);
        int propertyOption = store.getInt("property_option_on_get");
        if (propertyOption == 0) {
            propertyOption = 0x8000000;
        }
        this.noPropertiesCheckbox.setSelection(propertyOption != 0x4000000);
        this.propertiesInHandleButton.setSelection(propertyOption == 0x8000000);
        this.forceRFH2Button.setSelection(propertyOption == 0x2000000);
        this.compatRFH2Button.setSelection(propertyOption == 0x10000000);
        boolean checked = this.noPropertiesCheckbox.getSelection();
        this.propertiesInHandleButton.setEnabled(checked);
        this.forceRFH2Button.setEnabled(checked);
        this.compatRFH2Button.setEnabled(checked);
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = this.getPreferenceStore();
        int maxMsgCount = store.getDefaultInt("max_message_count");
        this.spinnerMsgCount.setSelection(maxMsgCount);
        int maxMsgByteCount = store.getDefaultInt("max_message_bytes_count");
        this.spinnerMsgByteCount.setSelection(maxMsgByteCount);
        int propertyOption = store.getDefaultInt("property_option_on_get");
        this.noPropertiesCheckbox.setSelection(propertyOption != 0x4000000);
        this.propertiesInHandleButton.setSelection(propertyOption == 0x8000000);
        this.forceRFH2Button.setSelection(propertyOption == 0x2000000);
        this.compatRFH2Button.setSelection(propertyOption == 0x10000000);
        boolean checked = this.noPropertiesCheckbox.getSelection();
        this.propertiesInHandleButton.setEnabled(checked);
        this.forceRFH2Button.setEnabled(checked);
        this.compatRFH2Button.setEnabled(checked);
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("max_message_count", this.spinnerMsgCount.getSelection());
        store.setValue("max_message_bytes_count", this.spinnerMsgByteCount.getSelection());
        int propertyOption = 0;
        if (!this.noPropertiesCheckbox.getSelection()) {
            propertyOption = 0x4000000;
        } else if (this.propertiesInHandleButton.getSelection()) {
            propertyOption = 0x8000000;
        } else if (this.forceRFH2Button.getSelection()) {
            propertyOption = 0x2000000;
        } else if (this.compatRFH2Button.getSelection()) {
            propertyOption = 0x10000000;
        }
        store.setValue("property_option_on_get", propertyOption);
        return super.performOk();
    }

    protected void performApply() {
        super.performApply();
    }

    public boolean performCancel() {
        return super.performCancel();
    }
}

