/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal.ui.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.messageplugin.internal.MessagePlugin;
import com.ibm.mq.explorer.messageplugin.internal.datamodel.DmBrowse;
import com.ibm.mq.explorer.messageplugin.internal.ui.dialogs.MsgRFH2PropsLabelProvider;
import com.ibm.mq.explorer.messageplugin.internal.ui.dialogs.MsgRFH2PropsViewContentProvider;
import com.ibm.mq.explorer.ui.internal.clipboard.ITabularTextProvider;
import com.ibm.mq.explorer.ui.internal.clipboard.TablularCopyAction;
import com.ibm.mq.explorer.ui.internal.clipboard.TreeTextProvider;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.headers.MQRFH2;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class MsgRFH2PropertyPage
extends CustomPropertyPage {
    protected static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.messageplugin.internal/src/com/ibm/mq/explorer/messageplugin/internal/ui/dialogs/MsgRFH2PropertyPage.java";
    protected static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    protected Message msgFile = null;
    private UiMQObject uiMQObject = null;
    private IDmObject dmObject = null;
    private Button showDetailsButton = null;
    private TreeViewer viewer;
    private Clipboard fClipboard;
    private IAction copyAction;
    protected static final int NAME_COLUMN_INDEX = 0;
    protected static final int VALUE_COLUMN_INDEX = 1;
    private static final int COLUMN_INITIAL_WIDTH = 150;
    private static final String CLIPBOARD_PADDING_STRING = "  ";

    public MsgRFH2PropertyPage(Trace t, Composite parent, int style, UiMQObject uiMQObject_, UiDisplayGroup uiDispGroup, boolean readonly) {
        super(t, parent, style, uiMQObject_, uiDispGroup, readonly);
        this.uiMQObject = uiMQObject_;
        this.msgFile = MessagePlugin.getPluginMessages(t);
    }

    public boolean apply(Trace t, Object job) {
        return false;
    }

    public void changesApplied(Trace t) {
    }

    void setInput(MQRFH2.Element[] elements) {
        try {
            this.viewer.setInput((Object)elements);
        }
        catch (Exception e) {
            Trace t = Trace.getDefault();
            String errorMessage = e.getMessage();
            t.FFST(66, "MsgRFH2PropertyPage.setInput", 1, 0, errorMessage);
        }
    }

    public void init(Trace t) {
        this.dmObject = this.uiMQObject.getDmObject();
        DmBrowse msg = (DmBrowse)this.dmObject;
        GridLayout grid = new GridLayout();
        this.setLayout((Layout)grid);
        this.showDetailsButton = new Button((Composite)this, 32);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.showDetailsButton.setLayoutData((Object)gridData);
        String showDetailsButtonText = this.msgFile.getMessage(t, "MSG.SHOW_PROPERTIES_DETAILS");
        this.showDetailsButton.setText(showDetailsButtonText);
        this.showDetailsButton.setSelection(true);
        this.showDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                MsgRFH2PropertyPage.this.showPropertyDetails(t1);
            }
        });
        this.viewer = new TreeViewer((Composite)this, 101122);
        this.viewer.setLabelProvider((IBaseLabelProvider)new MsgRFH2PropsLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new MsgRFH2PropsViewContentProvider());
        this.viewer.setAutoExpandLevel(2);
        this.viewer.setInput((Object)"");
        this.viewer.setComparator(new ViewerComparator());
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gridData);
        final Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setLinesVisible(true);
        TreeColumn nameColumn = new TreeColumn(tree, 16384);
        nameColumn.setText(this.msgFile.getMessage(t, "MSG.PROPERTIES_COLUMN_NAME_TITLE"));
        TreeColumn valueColumn = new TreeColumn(tree, 16384);
        valueColumn.setText(this.msgFile.getMessage(t, "MSG.PROPERTIES_COLUMN_VALUE_TITLE"));
        tree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                int nameColumnWidth = tree.getColumn(0).getWidth();
                int clientWidth = tree.getClientArea().width;
                tree.getColumn(1).setWidth(clientWidth - nameColumnWidth);
                tree.removeControlListener((ControlListener)this);
            }
        });
        this.fClipboard = new Clipboard(tree.getDisplay());
        MenuManager popupMenu = new MenuManager();
        this.copyAction = new TablularCopyAction((ITabularTextProvider)new TreeTextProvider(tree, CLIPBOARD_PADDING_STRING), this.fClipboard);
        popupMenu.add(this.copyAction);
        Menu menu = popupMenu.createContextMenu((Control)tree);
        tree.setMenu(menu);
        int i = 0;
        while (i < msg.headers.length) {
            if (msg.headers[i] != null && "MQRFH2".compareTo(msg.headers[i].type()) == 0) {
                MQRFH2 rfh = (MQRFH2)msg.headers[i];
                MQRFH2.Element[] folders = null;
                try {
                    folders = rfh.getFolders();
                    this.setInput(folders);
                    tree.setTopItem(this.viewer.getTree().getItem(0));
                }
                catch (Exception exception) {}
                break;
            }
            ++i;
        }
        nameColumn.setWidth(150);
        valueColumn.setWidth(150);
    }

    public boolean isAnyControlEnabled(Trace t) {
        return false;
    }

    public void restoreDefaults(Trace t) {
    }

    protected void showPropertyDetails(Trace t) {
        if (this.viewer != null) {
            Tree t1 = this.viewer.getTree();
            if (this.showDetailsButton.getSelection()) {
                this.viewer.expandAll();
            } else {
                this.viewer.collapseAll();
            }
            t1.setTopItem(t1.getItem(0));
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
    }
}

