/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal.ui.dialogs;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.MQHeader;
import com.ibm.mq.headers.internal.HexString;
import com.ibm.mq.pcf.PCFConstants;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class MsgHeaderLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final int NAME_COLUMN_INDEX = 0;
    private static final int VALUE_COLUMN_INDEX = 1;

    MsgHeaderLabelProvider() {
    }

    public String getColumnText(Object input, int index) {
        if (input instanceof MQHeader) {
            MQHeader header = (MQHeader)input;
            switch (index) {
                case 0: {
                    return header.type();
                }
            }
            return "";
        }
        if (input instanceof MQHeader.Field) {
            MQHeader.Field field = (MQHeader.Field)input;
            switch (index) {
                case 0: {
                    return field.getName();
                }
                case 1: {
                    return this.getStringRepresentation(field);
                }
            }
            return String.valueOf(index);
        }
        return "";
    }

    public Image getColumnImage(Object input, int index) {
        return null;
    }

    private String getStringRepresentation(MQHeader.Field field) {
        Object value = field.getValue();
        if (value instanceof Integer) {
            int v = (Integer)value;
            String strValue = Integer.toString(v);
            String name = field.getName();
            String lookupValue = null;
            if ("Parameter".compareTo(name) == 0) {
                lookupValue = PCFConstants.lookupParameter((int)v);
            } else if ("Command".compareTo(name) == 0) {
                lookupValue = MQConstants.lookup((int)v, (String)"MQCMD_.*");
            } else if ("PutApplType".compareTo(name) == 0) {
                lookupValue = MQConstants.lookup((int)v, (String)"MQAT_.*");
            }
            if (lookupValue != null) {
                strValue = String.valueOf(strValue) + " (" + lookupValue + ")";
            }
            return strValue;
        }
        if (value instanceof String) {
            return String.valueOf('\"') + (String)value + '\"';
        }
        if (value instanceof byte[]) {
            String strValue = null;
            strValue = "0x" + HexString.hexString((byte[])((byte[])value));
            return strValue;
        }
        if (value instanceof int[]) {
            StringBuffer inner = new StringBuffer();
            inner.append('{');
            int[] array = (int[])value;
            int i = 0;
            while (i < array.length) {
                inner.append(Integer.toString(array[i]));
                inner.append(", ");
                ++i;
            }
            if (array.length > 0) {
                inner.setLength(inner.length() - ", ".length());
            }
            inner.append('}');
            return new String(inner);
        }
        if (value instanceof long[]) {
            StringBuffer inner = new StringBuffer();
            inner.append('{');
            long[] array = (long[])value;
            int i = 0;
            while (i < array.length) {
                inner.append(Long.toString(array[i]));
                inner.append(", ");
                ++i;
            }
            if (array.length > 0) {
                inner.setLength(inner.length() - ", ".length());
            }
            inner.append('}');
            return new String(inner);
        }
        if (value instanceof String[]) {
            StringBuffer inner = new StringBuffer();
            inner.append('{');
            String[] array = (String[])value;
            int i = 0;
            while (i < array.length) {
                inner.append('\"');
                inner.append(array[i]);
                inner.append('\"');
                inner.append(", ");
                ++i;
            }
            if (array.length > 0) {
                inner.setLength(inner.length() - ", ".length());
            }
            inner.append('}');
            return new String(inner);
        }
        return field.toString();
    }
}

