/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal.pubsub;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSubscription;
import com.ibm.mq.MQTopic;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.messageplugin.internal.ProcessResponse;
import com.ibm.mq.explorer.messageplugin.internal.pubsub.GetMessages;
import com.ibm.mq.explorer.messageplugin.internal.pubsub.TestPubSubCommon;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.dialogs.SubscribeDialogBase;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SubscribeDialog
extends SubscribeDialogBase {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.messageplugin.internal/src/com/ibm/mq/explorer/messageplugin/internal/pubsub/SubscribeDialog.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private DmQueueManager dmQm;
    private MQQueueManager queueManager = null;
    private MQTopic topic = null;
    private GetMessages getMessages = null;
    private static final String ERROR_GETTING_PUBLICATION = "AMQ4482";
    private static final String ERROR_GETTING_TOPIC_STRING = "AMQ4484";
    private static final String ERROR_UNSUBSCRIBING = "AMQ4481";
    private boolean closeDialog = false;

    public SubscribeDialog(Trace t, Shell parent, DmQueueManager qmgr) {
        super(t, parent);
        this.dmQm = qmgr;
    }

    protected void drawStreamBox(Trace t, Composite group, String stream) {
    }

    protected void subscribe(Trace t) {
        block7: {
            String topicName = this.topicText.getText();
            if (this.queueManager == null) {
                this.queueManager = TestPubSubCommon.openQueueManager(t, this.dmQm);
            }
            if (this.queueManager == null) {
                Vector<String> msgString = ProcessResponse.Getinsert(t, 2059);
                MessageBox.showMessageFailure((Trace)t, (Shell)this.myShell, (String)msgString.elementAt(0), (String)msgString.elementAt(1));
            } else {
                try {
                    this.topic = this.accessTopic(t, this.queueManager, topicName);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss", locale);
                    String dateString = dateFormat.format(new Date());
                    this.setStatus(Trace.getDefault(), this.msgFile.getMessage("Ui.Last.Subscribed", dateString));
                    this.enableSubscribe(t);
                    if (this.getMessages == null) {
                        this.getMessages = new GetMessages(this.topic, 1000, this);
                        this.getMessages.setDaemon(true);
                        this.getMessages.start();
                    } else {
                        this.getMessages.setMQTopic(this.topic);
                        this.getMessages.setUnsubscribed(false);
                        this.getMessages.wakeUp();
                    }
                }
                catch (MQException mqe) {
                    Vector<String> msgString = ProcessResponse.Getinsert(t, mqe.reasonCode);
                    MessageBox.showMessageFailure((Trace)t, (Shell)this.myShell, (String)msgString.elementAt(0), (String)msgString.elementAt(1));
                    if (!TestPubSubCommon.isConnectionError(mqe.reasonCode)) break block7;
                    this.queueManager = null;
                }
            }
        }
    }

    protected void drawWildcardCombo(Trace t, Composite composite) {
        Label wildcardLabel = new Label(composite, 0);
        wildcardLabel.setText(this.msgFile.getMessage(t, "Ui.Wildcard.Title"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        wildcardLabel.setLayoutData((Object)gridData);
        this.wildcardCombo = new ExtCombo(composite, 2060);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        this.wildcardCombo.setLayoutData((Object)gridData);
        this.wildcardCombo.add(this.msgFile.getMessage(t, "Ui.Topic.Level.Wildcard"));
        this.wildcardCombo.add(this.msgFile.getMessage(t, "Ui.Char.Level.Wildcard"));
        this.wildcardCombo.select(0);
    }

    private MQTopic accessTopic(Trace t, MQQueueManager mqQmgr, String topicName) throws MQException {
        int options = 8226;
        options = this.wildcardCombo.getText().equals(this.msgFile.getMessage(t, "Ui.Char.Level.Wildcard")) ? (options |= 0x100000) : (options |= 0x200000);
        MQTopic mqTopic = TestPubSubCommon.accessTopic(t, mqQmgr, topicName, options, 1);
        return mqTopic;
    }

    protected void unsubscribe(Trace t) {
        try {
            try {
                if (this.topic != null) {
                    MQSubscription mqSubscription = this.topic.getSubscriptionReference();
                    mqSubscription.setCloseOptions(8);
                    this.topic.close();
                }
            }
            catch (MQException mqe) {
                String insert = Integer.toString(mqe.reasonCode);
                String messageString = CommonServices.getSystemMessage((Trace)t, (String)ERROR_UNSUBSCRIBING, (String)insert);
                MessageBox.showMessageFailure((Trace)t, (Shell)this.myShell, (String)messageString, (String)ERROR_UNSUBSCRIBING);
                if (TestPubSubCommon.isConnectionError(mqe.reasonCode)) {
                    this.queueManager = null;
                }
                this.topic = null;
                this.enableSubscribe(t);
                this.getMessages.setUnsubscribed(true);
                SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss", locale);
                String dateString = dateFormat.format(new Date());
                this.setStatus(Trace.getDefault(), this.msgFile.getMessage("Ui.Last.Unsubscribed", dateString));
            }
        }
        finally {
            this.topic = null;
            this.enableSubscribe(t);
            this.getMessages.setUnsubscribed(true);
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss", locale);
            String dateString = dateFormat.format(new Date());
            this.setStatus(Trace.getDefault(), this.msgFile.getMessage("Ui.Last.Unsubscribed", dateString));
        }
    }

    public void messageReceived(Trace t, MQMessage message, MQException ex) {
        if (ex != null) {
            Object msgString;
            String messageString = "";
            String insert = "";
            if (TestPubSubCommon.isConnectionError(ex.reasonCode)) {
                msgString = ProcessResponse.Getinsert(t, 2059);
                messageString = ((Vector)msgString).elementAt(0);
                insert = ((Vector)msgString).elementAt(1);
                this.topic = null;
                this.queueManager = null;
                this.closeDialog = true;
            } else {
                insert = Integer.toString(ex.reasonCode);
                messageString = CommonServices.getSystemMessage((Trace)t, (String)ERROR_GETTING_PUBLICATION, (String)insert);
            }
            msgString = messageString;
            String helpID = insert;
            this.myShell.getDisplay().asyncExec(new Runnable((String)msgString, helpID){
                private final /* synthetic */ String val$msgString;
                private final /* synthetic */ String val$helpID;
                {
                    this.val$msgString = string;
                    this.val$helpID = string2;
                }

                @Override
                public void run() {
                    Trace t2 = Trace.getDefault();
                    MessageBox.showMessageFailure((Trace)t2, (Shell)SubscribeDialog.this.myShell, (String)this.val$msgString, (String)this.val$helpID);
                    if (SubscribeDialog.this.closeDialog) {
                        SubscribeDialog.this.myShell.close();
                    } else {
                        SubscribeDialog.this.unsubscribe(t2);
                        SubscribeDialog.this.getMessages.setExceptionReceived(false);
                    }
                }
            });
        } else if (message != null) {
            String subscribeMessage = "";
            try {
                String msg = message.readLine();
                while (msg != null && !msg.equals("")) {
                    subscribeMessage = String.valueOf(subscribeMessage) + msg;
                    msg = message.readLine();
                }
            }
            catch (IOException ie) {
                t.FFST(66, "SubscribeDialog.messageReceived", 0, 0, "IO exception occurred attempting to read the message : " + ie.toString());
            }
            final String subscribeString = this.msgFile.getMessage("Ui.Subscribe.Message", subscribeMessage);
            String topicString = null;
            try {
                topicString = message.getStringProperty("mqps.Top");
            }
            catch (MQException mqe) {
                topicString = TOPIC_STRING_NOT_FOUND;
                this.getMessages.setExceptionReceived(true);
                String insert = Integer.toString(mqe.reasonCode);
                final String messageString = CommonServices.getSystemMessage((Trace)t, (String)ERROR_GETTING_TOPIC_STRING, (String)insert);
                this.myShell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Trace t2 = Trace.getDefault();
                        MessageBox.showMessageFailure((Trace)t2, (Shell)SubscribeDialog.this.myShell, (String)messageString, (String)SubscribeDialog.ERROR_GETTING_TOPIC_STRING);
                        SubscribeDialog.this.unsubscribe(t2);
                        SubscribeDialog.this.getMessages.setExceptionReceived(false);
                    }
                });
            }
            if (topicString == null) {
                topicString = TOPIC_STRING_NOT_FOUND;
            }
            final String topicStr = this.msgFile.getMessage("Ui.Subscribe.Topic.String", topicString);
            if (subscribeString != null && topicStr != null) {
                this.myShell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss", locale);
                        String dateString = SubscribeDialog.this.msgFile.getMessage("Ui.Subscribe.Time", dateFormat.format(new Date()));
                        if (SubscribeDialog.this.containsMessages) {
                            SubscribeDialog.this.messageText.append(String.valueOf(dateString) + LINE_SEPARATOR + topicStr + LINE_SEPARATOR + subscribeString);
                        } else {
                            SubscribeDialog.this.messageText.setText(String.valueOf(dateString) + LINE_SEPARATOR + topicStr + LINE_SEPARATOR + subscribeString);
                            SubscribeDialog.this.containsMessages = true;
                        }
                        SubscribeDialog.this.messageText.append(String.valueOf(LINE_SEPARATOR) + "---------------------------------------------------------------------------------------" + LINE_SEPARATOR);
                        SubscribeDialog.this.buttonClear.setEnabled(true);
                    }
                });
            }
        } else if (Trace.isTracing) {
            t.data(66, "SubscribeDialog.messageReceived", 300, "No message on the topic");
        }
    }

    public void performCloseCleanup(Trace t) {
        if (this.topic != null) {
            this.unsubscribe(t);
        }
        if (this.queueManager != null) {
            try {
                this.queueManager.disconnect();
                this.queueManager = null;
            }
            catch (MQException mQException) {
                this.queueManager = null;
            }
        }
    }

    protected boolean isSubscribed() {
        return this.topic != null;
    }

    protected void closePressed(Trace t) {
        if (this.getMessages != null) {
            this.getMessages.setClosed(true);
            if (!this.isSubscribed()) {
                this.getMessages.wakeUp();
            }
            try {
                this.getMessages.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.performCloseCleanup(t);
    }
}

