/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal.pubsub;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQTopic;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.messageplugin.internal.ProcessResponse;
import com.ibm.mq.explorer.messageplugin.internal.pubsub.TestPubSubCommon;
import com.ibm.mq.explorer.ui.internal.dialogs.PublishDialogBase;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class PublishDialog
extends PublishDialogBase {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.messageplugin.internal/src/com/ibm/mq/explorer/messageplugin/internal/pubsub/PublishDialog.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private DmQueueManager dmQm;
    private MQQueueManager queueManager = null;
    private MQTopic topic = null;
    private String topicString = "";
    private static final String ERROR_PUBLISHING = "AMQ4483";

    public PublishDialog(Trace t, Shell parent, DmQueueManager qmgr) {
        super(t, parent);
        this.dmQm = qmgr;
    }

    protected void drawStreamBox(Trace t, Composite group, String stream) {
    }

    public void publish(Trace t) {
        if (!this.topicString.equals(this.topicText.getText())) {
            this.topicString = this.topicText.getText();
            if (this.topic != null) {
                block14: {
                    try {
                        this.topic.close();
                    }
                    catch (MQException mqe) {
                        if (!Trace.isTracing) break block14;
                        t.data(66, "PublishDialog.publish", 900, "MQException " + mqe.toString());
                    }
                }
                this.topic = null;
            }
        }
        String messageData = this.messageText.getText();
        if (this.queueManager == null) {
            this.queueManager = TestPubSubCommon.openQueueManager(t, this.dmQm);
        }
        if (this.queueManager == null) {
            Vector<String> msgString = ProcessResponse.Getinsert(t, 2059);
            MessageBox.showMessageFailure((Trace)t, (Shell)this.myShell, (String)msgString.elementAt(0), (String)msgString.elementAt(1));
            this.myShell.close();
        } else {
            try {
                if (this.topic == null) {
                    this.topic = this.accessTopic(t, this.queueManager, this.topicString);
                }
                this.publish(t, messageData);
                this.messageText.setText("");
                this.messageText.setFocus();
            }
            catch (MQException mqe) {
                if (TestPubSubCommon.isConnectionError(mqe.reasonCode)) {
                    Vector<String> msgString = ProcessResponse.Getinsert(t, 2059);
                    MessageBox.showMessageFailure((Trace)t, (Shell)this.myShell, (String)msgString.elementAt(0), (String)msgString.elementAt(1));
                    this.topic = null;
                    this.queueManager = null;
                    this.myShell.close();
                }
                switch (mqe.reasonCode) {
                    case 2531: {
                        Vector<String> msgString = ProcessResponse.Getinsert(t, 2531);
                        MessageBox.showMessageFailure((Trace)t, (Shell)this.myShell, (String)msgString.elementAt(0), (String)msgString.elementAt(1));
                        break;
                    }
                    default: {
                        String messageString = CommonServices.getSystemMessage((Trace)t, (String)ERROR_PUBLISHING, (String)Integer.toString(mqe.reasonCode));
                        MessageBox.showMessageFailure((Trace)t, (Shell)this.myShell, (String)messageString, (String)ERROR_PUBLISHING);
                    }
                }
            }
        }
    }

    private void publish(Trace t, String data) throws MQException {
        block3: {
            MQMessage message = new MQMessage();
            MQPutMessageOptions pmo = new MQPutMessageOptions();
            if (this.retained) {
                pmo.options = 0x200000;
            }
            try {
                message.format = "MQSTR   ";
                message.characterSet = 1208;
                message.writeString(data);
                this.topic.put(message, pmo);
                SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss", locale);
                String dateString = dateFormat.format(new Date());
                this.setStatus(Trace.getDefault(), this.msgFile.getMessage("Ui.Last.Published", dateString));
            }
            catch (IOException e) {
                if (!Trace.isTracing) break block3;
                t.data(66, "PublishDialog.publish", e.toString());
            }
        }
    }

    private MQTopic accessTopic(Trace t, MQQueueManager mqQmgr, String topicName) throws MQException {
        int options = 8208;
        MQTopic mqTopic = TestPubSubCommon.accessTopic(t, mqQmgr, topicName, options, 2);
        return mqTopic;
    }

    protected void closePressed(Trace t) {
        block9: {
            block8: {
                if (this.topic != null) {
                    try {
                        this.topic.close();
                    }
                    catch (MQException mqe) {
                        if (!Trace.isTracing) break block8;
                        t.data(66, "PublishDialog.closePressed", 900, "MQException " + mqe.toString());
                    }
                }
            }
            if (this.queueManager != null) {
                try {
                    this.queueManager.disconnect();
                    this.queueManager = null;
                }
                catch (MQException e) {
                    this.queueManager = null;
                    if (Trace.isTracing) {
                        t.data(66, "PublishDialog.closePressed", e.toString());
                    }
                }
                catch (Exception e2) {
                    this.queueManager = null;
                    if (!Trace.isTracing) break block9;
                    t.data(66, "PublishDialog.closePressed", e2.toString());
                }
            }
        }
    }
}

